/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.tubesock;

import com.google.common.base.Preconditions;
import com.google.firebase.database.tubesock.WebSocket;
import com.google.firebase.database.tubesock.WebSocketException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

class WebSocketWriter {
    private final Random random = new Random();
    private final String threadName;
    private Thread innerThread;
    private BlockingQueue<ByteBuffer> pendingBuffers;
    private volatile boolean stop = false;
    private boolean closeSent = false;
    private WebSocket websocket;
    private WritableByteChannel channel;

    WebSocketWriter(WebSocket websocket, String threadBaseName, int clientId) {
        this.websocket = websocket;
        this.threadName = threadBaseName + "Writer-" + clientId;
        this.pendingBuffers = new LinkedBlockingQueue<ByteBuffer>();
    }

    void setOutput(OutputStream output) {
        this.channel = Channels.newChannel(output);
    }

    private ByteBuffer frameInBuffer(byte opcode, boolean masking, byte[] data) throws IOException {
        int lengthField;
        int length;
        int headerLength = 2;
        if (masking) {
            headerLength += 4;
        }
        if ((length = data.length) >= 126) {
            headerLength = length <= 65535 ? (headerLength += 2) : (headerLength += 8);
        }
        ByteBuffer frame = ByteBuffer.allocate(data.length + headerLength);
        int fin = -128;
        byte startByte = (byte)(fin | opcode);
        frame.put(startByte);
        if (length < 126) {
            if (masking) {
                length = 0x80 | length;
            }
            frame.put((byte)length);
        } else if (length <= 65535) {
            lengthField = 126;
            if (masking) {
                lengthField = 0x80 | lengthField;
            }
            frame.put((byte)lengthField);
            frame.putShort((short)length);
        } else {
            lengthField = 127;
            if (masking) {
                lengthField = 0x80 | lengthField;
            }
            frame.put((byte)lengthField);
            frame.putInt(0);
            frame.putInt(length);
        }
        if (masking) {
            byte[] mask = this.generateMask();
            frame.put(mask);
            for (int i = 0; i < data.length; ++i) {
                frame.put((byte)(data[i] ^ mask[i % 4]));
            }
        }
        frame.flip();
        return frame;
    }

    private byte[] generateMask() {
        byte[] mask = new byte[4];
        this.random.nextBytes(mask);
        return mask;
    }

    synchronized void send(byte opcode, boolean masking, byte[] data) throws IOException {
        ByteBuffer frame = this.frameInBuffer(opcode, masking, data);
        if (this.stop && (this.closeSent || opcode != 8)) {
            throw new WebSocketException("Shouldn't be sending");
        }
        if (opcode == 8) {
            this.closeSent = true;
        }
        this.pendingBuffers.add(frame);
    }

    private void writeMessage() throws InterruptedException, IOException {
        ByteBuffer msg = this.pendingBuffers.take();
        this.channel.write(msg);
    }

    void stopIt() {
        this.stop = true;
    }

    private void handleError(WebSocketException e) {
        this.websocket.handleReceiverError(e);
    }

    private void runWriter() {
        try {
            while (!this.stop && !Thread.interrupted()) {
                this.writeMessage();
            }
            for (int i = 0; i < this.pendingBuffers.size(); ++i) {
                this.writeMessage();
            }
        }
        catch (IOException e) {
            this.handleError(new WebSocketException("IO Exception", e));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void start() {
        Preconditions.checkState((this.innerThread == null ? 1 : 0) != 0, (Object)"Inner thread already started");
        this.innerThread = WebSocket.getThreadFactory().newThread(new Runnable(){

            @Override
            public void run() {
                WebSocketWriter.this.runWriter();
            }
        });
        WebSocket.getIntializer().setName(this.innerThread, this.threadName);
        this.innerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForTermination() throws InterruptedException {
        Thread thread;
        WebSocketWriter webSocketWriter = this;
        synchronized (webSocketWriter) {
            if (this.innerThread == null) {
                return;
            }
            thread = this.innerThread;
        }
        thread.join();
    }
}

