/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.Clock;
import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.auth.FirebaseCredentials;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.internal.FirebaseTokenFactory;
import com.google.firebase.auth.internal.FirebaseTokenVerifier;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.Tasks;
import java.util.HashMap;
import java.util.Map;

public class FirebaseAuth {
    private static Map<String, FirebaseAuth> authInstances = new HashMap<String, FirebaseAuth>();
    private static JsonFactory jsonFactory = new GsonFactory();
    private final FirebaseApp firebaseApp;
    private final GooglePublicKeysManager googlePublicKeysManager;
    private final Clock clock;

    public static FirebaseAuth getInstance() {
        return FirebaseAuth.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseAuth getInstance(FirebaseApp app) {
        if (!authInstances.containsKey(app.getName())) {
            authInstances.put(app.getName(), new FirebaseAuth(app));
        }
        return authInstances.get(app.getName());
    }

    private FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseTokenVerifier.DEFAULT_KEY_MANAGER, Clock.SYSTEM);
    }

    @VisibleForTesting
    FirebaseAuth(FirebaseApp firebaseApp, GooglePublicKeysManager googlePublicKeysManager, Clock clock) {
        this.firebaseApp = firebaseApp;
        this.googlePublicKeysManager = googlePublicKeysManager;
        this.clock = clock;
    }

    public Task<String> createCustomToken(String uid) {
        return this.createCustomToken(uid, null);
    }

    public Task<String> createCustomToken(final String uid, final Map<String, Object> developerClaims) {
        FirebaseCredential credential = ImplFirebaseTrampolines.getCredential(this.firebaseApp);
        if (!(credential instanceof FirebaseCredentials.CertCredential)) {
            return Tasks.forException(new FirebaseException("Must initialize FirebaseApp with a certificate credential to call createCustomToken()"));
        }
        return ((FirebaseCredentials.CertCredential)credential).getCertificate(false).continueWith(new Continuation<GoogleCredential, String>(this){

            @Override
            public String then(@NonNull Task<GoogleCredential> task) throws Exception {
                GoogleCredential baseCredential = task.getResult();
                FirebaseTokenFactory tokenFactory = FirebaseTokenFactory.getInstance();
                return tokenFactory.createSignedCustomAuthTokenForUser(uid, developerClaims, baseCredential.getServiceAccountId(), baseCredential.getServiceAccountPrivateKey());
            }
        });
    }

    public Task<FirebaseToken> verifyIdToken(final String token) {
        FirebaseCredential credential = ImplFirebaseTrampolines.getCredential(this.firebaseApp);
        if (!(credential instanceof FirebaseCredentials.CertCredential)) {
            return Tasks.forException(new FirebaseException("Must initialize FirebaseApp with a certificate credential to call verifyIdToken()"));
        }
        return ((FirebaseCredentials.CertCredential)credential).getProjectId(false).continueWith(new Continuation<String, FirebaseToken>(){

            @Override
            public FirebaseToken then(@NonNull Task<String> task) throws Exception {
                FirebaseTokenVerifier firebaseTokenVerifier = new FirebaseTokenVerifier.Builder().setProjectId(task.getResult()).setPublicKeysManager(FirebaseAuth.this.googlePublicKeysManager).setClock(FirebaseAuth.this.clock).build();
                FirebaseToken firebaseToken = FirebaseToken.parse(jsonFactory, token);
                firebaseTokenVerifier.verifyTokenAndSignature(firebaseToken.getToken());
                return firebaseToken;
            }
        });
    }
}

