/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.connection.ConnectionAuthTokenProvider;
import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.PersistentConnection;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.GaePlatform;
import com.google.firebase.database.core.JvmPlatform;
import com.google.firebase.database.core.Platform;
import com.google.firebase.database.core.RunLoop;
import com.google.firebase.database.core.persistence.NoopPersistenceManager;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.logging.LogWrapper;
import com.google.firebase.database.logging.Logger;
import com.google.firebase.database.utilities.DefaultRunLoop;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class Context {
    private static final long DEFAULT_CACHE_SIZE = 0xA00000L;
    protected Logger logger;
    protected EventTarget eventTarget;
    protected AuthTokenProvider authTokenProvider;
    protected RunLoop runLoop;
    protected String persistenceKey;
    protected List<String> loggedComponents;
    protected String userAgent;
    protected Logger.Level logLevel = Logger.Level.INFO;
    protected boolean persistenceEnabled;
    protected long cacheSize = 0xA00000L;
    protected FirebaseApp firebaseApp;
    private PersistenceManager forcedPersistenceManager;
    private boolean frozen = false;
    private boolean stopped = false;
    private Platform platform;

    private Platform getPlatform() {
        if (this.platform == null) {
            if (GaePlatform.isActive()) {
                GaePlatform gaePlatform = new GaePlatform(this.firebaseApp);
                gaePlatform.initialize();
                this.platform = gaePlatform;
            } else {
                this.platform = new JvmPlatform(this.firebaseApp);
            }
        }
        return this.platform;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    synchronized void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            this.initServices();
        }
    }

    public void requireStarted() {
        if (this.stopped) {
            this.restartServices();
            this.stopped = false;
        }
    }

    private void initServices() {
        this.ensureLogger();
        this.getPlatform();
        this.ensureUserAgent();
        this.ensureEventTarget();
        this.ensureRunLoop();
        this.ensureSessionIdentifier();
        this.ensureAuthTokenProvider();
    }

    private void restartServices() {
        this.eventTarget.restart();
        this.runLoop.restart();
    }

    void stop() {
        this.stopped = true;
        this.eventTarget.shutdown();
        this.runLoop.shutdown();
    }

    protected void assertUnfrozen() {
        if (this.isFrozen()) {
            throw new DatabaseException("Modifications to DatabaseConfig objects must occur before they are in use");
        }
    }

    public List<String> getOptDebugLogComponents() {
        return this.loggedComponents;
    }

    public Logger.Level getLogLevel() {
        return this.logLevel;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LogWrapper getLogger(String component) {
        return new LogWrapper(this.logger, component);
    }

    public LogWrapper getLogger(String component, String prefix) {
        return new LogWrapper(this.logger, component, prefix);
    }

    public ConnectionContext getConnectionContext() {
        return new ConnectionContext(this.getLogger(), Context.wrapAuthTokenProvider(this.getAuthTokenProvider()), this.getExecutorService(), this.isPersistenceEnabled(), FirebaseDatabase.getSdkVersion(), this.getUserAgent());
    }

    PersistenceManager getPersistenceManager(String firebaseId) {
        if (this.forcedPersistenceManager != null) {
            return this.forcedPersistenceManager;
        }
        if (this.persistenceEnabled) {
            PersistenceManager cache = this.platform.createPersistenceManager(this, firebaseId);
            if (cache == null) {
                throw new IllegalArgumentException("You have enabled persistence, but persistence is not supported on this platform.");
            }
            return cache;
        }
        return new NoopPersistenceManager();
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public long getPersistenceCacheSizeBytes() {
        return this.cacheSize;
    }

    void forcePersistenceManager(PersistenceManager persistenceManager) {
        this.forcedPersistenceManager = persistenceManager;
    }

    public EventTarget getEventTarget() {
        return this.eventTarget;
    }

    public RunLoop getRunLoop() {
        return this.runLoop;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getPlatformVersion() {
        return this.getPlatform().getPlatformVersion();
    }

    public String getSessionPersistenceKey() {
        return this.persistenceKey;
    }

    public AuthTokenProvider getAuthTokenProvider() {
        return this.authTokenProvider;
    }

    public PersistentConnection newPersistentConnection(HostInfo info, PersistentConnection.Delegate delegate) {
        return this.getPlatform().newPersistentConnection(this, this.getConnectionContext(), info, delegate);
    }

    private ScheduledExecutorService getExecutorService() {
        RunLoop loop = this.getRunLoop();
        if (!(loop instanceof DefaultRunLoop)) {
            throw new RuntimeException("Custom run loops are not supported!");
        }
        return ((DefaultRunLoop)loop).getExecutorService();
    }

    private void ensureLogger() {
        if (this.logger == null) {
            this.logger = this.getPlatform().newLogger(this, this.logLevel, this.loggedComponents);
        }
    }

    private void ensureRunLoop() {
        if (this.runLoop == null) {
            this.runLoop = this.platform.newRunLoop(this);
        }
    }

    private void ensureEventTarget() {
        if (this.eventTarget == null) {
            this.eventTarget = this.getPlatform().newEventTarget(this);
        }
    }

    private void ensureUserAgent() {
        if (this.userAgent == null) {
            this.userAgent = this.buildUserAgent(this.getPlatform().getUserAgent(this));
        }
    }

    private void ensureAuthTokenProvider() {
        if (this.authTokenProvider == null) {
            this.authTokenProvider = this.getPlatform().newAuthTokenProvider(this.getExecutorService());
        }
    }

    private void ensureSessionIdentifier() {
        if (this.persistenceKey == null) {
            this.persistenceKey = "default";
        }
    }

    private String buildUserAgent(String platformAgent) {
        StringBuilder sb = new StringBuilder().append("Firebase/").append("5").append("/").append(FirebaseDatabase.getSdkVersion()).append("/").append(platformAgent);
        return sb.toString();
    }

    private static ConnectionAuthTokenProvider wrapAuthTokenProvider(final AuthTokenProvider provider) {
        return new ConnectionAuthTokenProvider(){

            @Override
            public void getToken(boolean forceRefresh, final ConnectionAuthTokenProvider.GetTokenCallback callback) {
                provider.getToken(forceRefresh, new AuthTokenProvider.GetTokenCompletionListener(this){

                    @Override
                    public void onSuccess(String token) {
                        callback.onSuccess(token);
                    }

                    @Override
                    public void onError(String error) {
                        callback.onError(error);
                    }
                });
            }
        };
    }
}

