/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import java.net.URI;

public class RepoInfo {
    private static final String VERSION_PARAM = "v";
    private static final String LAST_SESSION_ID_PARAM = "ls";
    public String host;
    public boolean secure;
    public String namespace;
    public String internalHost;

    public String toString() {
        String string = this.secure ? "s" : "";
        String string2 = this.host;
        return new StringBuilder(7 + String.valueOf(string).length() + String.valueOf(string2).length()).append("http").append(string).append("://").append(string2).toString();
    }

    public String toDebugString() {
        String string = this.host;
        boolean bl = this.secure;
        String string2 = this.namespace;
        String string3 = this.internalHost;
        return new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("(host=").append(string).append(", secure=").append(bl).append(", ns=").append(string2).append(" internal=").append(string3).append(")").toString();
    }

    public URI getConnectionURL(String optLastSessionId) {
        String scheme = this.secure ? "wss" : "ws";
        String string = this.internalHost;
        String string2 = this.namespace;
        String string3 = String.valueOf(VERSION_PARAM);
        String string4 = String.valueOf("5");
        String url = new StringBuilder(13 + String.valueOf(scheme).length() + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(scheme).append("://").append(string).append("/.ws?ns=").append(string2).append("&").append(string3).append("=").append(string4).toString();
        if (optLastSessionId != null) {
            string = String.valueOf(url);
            string2 = String.valueOf("&ls=");
            url = new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(optLastSessionId).length()).append(string).append(string2).append(optLastSessionId).toString();
        }
        return URI.create(url);
    }

    public boolean isCacheableHost() {
        return this.internalHost.startsWith("s-");
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isDemoHost() {
        return this.host.contains(".firebaseio-demo.com");
    }

    public boolean isCustomHost() {
        return !this.host.contains(".firebaseio.com") && !this.host.contains(".firebaseio-demo.com");
    }
}

