/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.PriorityIndex;
import com.google.firebase.database.snapshot.PriorityUtilities;
import com.google.firebase.database.utilities.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ChildrenNode
implements Node {
    public static Comparator<ChildKey> NAME_ONLY_COMPARATOR = new Comparator<ChildKey>(){

        @Override
        public int compare(ChildKey o1, ChildKey o2) {
            return o1.compareTo(o2);
        }
    };
    private final ImmutableSortedMap<ChildKey, Node> children;
    private final Node priority;
    private String lazyHash = null;

    protected ChildrenNode() {
        this.children = ImmutableSortedMap.Builder.emptyMap(NAME_ONLY_COMPARATOR);
        this.priority = PriorityUtilities.NullPriority();
    }

    protected ChildrenNode(ImmutableSortedMap<ChildKey, Node> children, Node priority) {
        if (children.isEmpty() && !priority.isEmpty()) {
            throw new IllegalArgumentException("Can't create empty ChildrenNode with priority!");
        }
        this.priority = priority;
        this.children = children;
    }

    @Override
    public boolean hasChild(ChildKey name) {
        return !this.getImmediateChild(name).isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Object getValue() {
        return this.getValue(false);
    }

    @Override
    public Object getValue(boolean useExportFormat) {
        if (this.isEmpty()) {
            return null;
        }
        int numKeys = 0;
        int maxKey = 0;
        boolean allIntegerKeys = true;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : this.children) {
            String key = ((ChildKey)entry.getKey()).asString();
            result.put(key, ((Node)entry.getValue()).getValue(useExportFormat));
            ++numKeys;
            if (!allIntegerKeys) continue;
            if (key.length() > 1 && key.charAt(0) == '0') {
                allIntegerKeys = false;
                continue;
            }
            Integer keyAsInt = Utilities.tryParseInt(key);
            if (keyAsInt != null && keyAsInt >= 0) {
                if (keyAsInt <= maxKey) continue;
                maxKey = keyAsInt;
                continue;
            }
            allIntegerKeys = false;
        }
        if (!useExportFormat && allIntegerKeys && maxKey < 2 * numKeys) {
            ArrayList arrayResult = new ArrayList(maxKey + 1);
            int i = 0;
            while (i <= maxKey) {
                int n = i++;
                arrayResult.add(result.get(new StringBuilder(11).append(n).toString()));
            }
            return arrayResult;
        }
        if (useExportFormat && !this.priority.isEmpty()) {
            result.put(".priority", this.priority.getValue());
        }
        return result;
    }

    @Override
    public ChildKey getPredecessorChildKey(ChildKey childKey) {
        return (ChildKey)this.children.getPredecessorKey((Object)childKey);
    }

    @Override
    public ChildKey getSuccessorChildKey(ChildKey childKey) {
        return (ChildKey)this.children.getSuccessorKey((Object)childKey);
    }

    @Override
    public String getHashRepresentation(Node.HashVersion version) {
        if (version != Node.HashVersion.V1) {
            throw new IllegalArgumentException("Hashes on children nodes only supported for V1");
        }
        StringBuilder toHash = new StringBuilder();
        if (!this.priority.isEmpty()) {
            toHash.append("priority:");
            toHash.append(this.priority.getHashRepresentation(Node.HashVersion.V1));
            toHash.append(":");
        }
        ArrayList<NamedNode> nodes = new ArrayList<NamedNode>();
        boolean sawPriority = false;
        for (NamedNode node : this) {
            nodes.add(node);
            sawPriority = sawPriority || !node.getNode().getPriority().isEmpty();
        }
        if (sawPriority) {
            Collections.sort(nodes, PriorityIndex.getInstance());
        }
        for (NamedNode node : nodes) {
            String hashString = node.getNode().getHash();
            if (hashString.equals("")) continue;
            toHash.append(":");
            toHash.append(node.getName().asString());
            toHash.append(":");
            toHash.append(hashString);
        }
        return toHash.toString();
    }

    @Override
    public String getHash() {
        if (this.lazyHash == null) {
            String hashString = this.getHashRepresentation(Node.HashVersion.V1);
            this.lazyHash = hashString.isEmpty() ? "" : Utilities.sha1HexDigest(hashString);
        }
        return this.lazyHash;
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    @Override
    public Node getPriority() {
        return this.priority;
    }

    @Override
    public Node updatePriority(Node priority) {
        if (this.children.isEmpty()) {
            return EmptyNode.Empty();
        }
        return new ChildrenNode(this.children, priority);
    }

    @Override
    public Node getImmediateChild(ChildKey name) {
        if (name.isPriorityChildName() && !this.priority.isEmpty()) {
            return this.priority;
        }
        if (this.children.containsKey((Object)name)) {
            return (Node)this.children.get((Object)name);
        }
        return EmptyNode.Empty();
    }

    @Override
    public Node getChild(Path path) {
        ChildKey front = path.getFront();
        if (front == null) {
            return this;
        }
        return this.getImmediateChild(front).getChild(path.popFront());
    }

    public void forEachChild(ChildVisitor visitor) {
        this.forEachChild(visitor, false);
    }

    public void forEachChild(final ChildVisitor visitor, boolean includePriority) {
        if (!includePriority || this.getPriority().isEmpty()) {
            this.children.inOrderTraversal((LLRBNode.NodeVisitor)visitor);
        } else {
            this.children.inOrderTraversal((LLRBNode.NodeVisitor)new LLRBNode.NodeVisitor<ChildKey, Node>(){
                boolean passedPriorityKey = false;

                public void visitEntry(ChildKey key, Node value) {
                    if (!this.passedPriorityKey && key.compareTo(ChildKey.getPriorityKey()) > 0) {
                        this.passedPriorityKey = true;
                        visitor.visitChild(ChildKey.getPriorityKey(), ChildrenNode.this.getPriority());
                    }
                    visitor.visitChild(key, value);
                }
            });
        }
    }

    public ChildKey getFirstChildKey() {
        return (ChildKey)this.children.getMinKey();
    }

    public ChildKey getLastChildKey() {
        return (ChildKey)this.children.getMaxKey();
    }

    @Override
    public Node updateChild(Path path, Node newChildNode) {
        ChildKey front = path.getFront();
        if (front == null) {
            return newChildNode;
        }
        if (front.isPriorityChildName()) {
            assert (PriorityUtilities.isValidPriority(newChildNode));
            return this.updatePriority(newChildNode);
        }
        Node newImmediateChild = this.getImmediateChild(front).updateChild(path.popFront(), newChildNode);
        return this.updateImmediateChild(front, newImmediateChild);
    }

    @Override
    public Iterator<NamedNode> iterator() {
        return new NamedNodeIterator(this.children.iterator());
    }

    @Override
    public Iterator<NamedNode> reverseIterator() {
        return new NamedNodeIterator(this.children.reverseIterator());
    }

    @Override
    public Node updateImmediateChild(ChildKey key, Node newChildNode) {
        if (key.isPriorityChildName()) {
            return this.updatePriority(newChildNode);
        }
        ImmutableSortedMap newChildren = this.children;
        if (newChildren.containsKey((Object)key)) {
            newChildren = newChildren.remove((Object)key);
        }
        if (!newChildNode.isEmpty()) {
            newChildren = newChildren.insert((Object)key, (Object)newChildNode);
        }
        if (newChildren.isEmpty()) {
            return EmptyNode.Empty();
        }
        return new ChildrenNode((ImmutableSortedMap<ChildKey, Node>)newChildren, this.priority);
    }

    @Override
    public int compareTo(Node o) {
        if (this.isEmpty()) {
            if (o.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (o.isLeafNode()) {
            return 1;
        }
        if (o.isEmpty()) {
            return 1;
        }
        if (o == Node.MAX_NODE) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof ChildrenNode)) {
            return false;
        }
        ChildrenNode other = (ChildrenNode)otherObj;
        if (!this.getPriority().equals(other.getPriority())) {
            return false;
        }
        if (this.children.size() != other.children.size()) {
            return false;
        }
        Iterator thisIterator = this.children.iterator();
        Iterator otherIterator = other.children.iterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            Map.Entry thisNameNode = (Map.Entry)thisIterator.next();
            Map.Entry otherNamedNode = (Map.Entry)otherIterator.next();
            if (((ChildKey)thisNameNode.getKey()).equals(otherNamedNode.getKey()) && ((Node)thisNameNode.getValue()).equals(otherNamedNode.getValue())) continue;
            return false;
        }
        if (thisIterator.hasNext() || otherIterator.hasNext()) {
            throw new IllegalStateException("Something went wrong internally.");
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (NamedNode entry : this) {
            hashCode = 31 * hashCode + entry.getName().hashCode();
            hashCode = 17 * hashCode + entry.getNode().hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, 0);
        return builder.toString();
    }

    private static void addIndentation(StringBuilder builder, int indentation) {
        for (int i = 0; i < indentation; ++i) {
            builder.append(" ");
        }
    }

    private void toString(StringBuilder builder, int indentation) {
        if (this.children.isEmpty() && this.priority.isEmpty()) {
            builder.append("{ }");
        } else {
            builder.append("{\n");
            for (Map.Entry childEntry : this.children) {
                ChildrenNode.addIndentation(builder, indentation + 2);
                builder.append(((ChildKey)childEntry.getKey()).asString());
                builder.append("=");
                if (childEntry.getValue() instanceof ChildrenNode) {
                    ChildrenNode childrenNode = (ChildrenNode)childEntry.getValue();
                    childrenNode.toString(builder, indentation + 2);
                } else {
                    builder.append(((Node)childEntry.getValue()).toString());
                }
                builder.append("\n");
            }
            if (!this.priority.isEmpty()) {
                ChildrenNode.addIndentation(builder, indentation + 2);
                builder.append(".priority=");
                builder.append(this.priority.toString());
                builder.append("\n");
            }
            ChildrenNode.addIndentation(builder, indentation);
            builder.append("}");
        }
    }

    public static abstract class ChildVisitor
    extends LLRBNode.NodeVisitor<ChildKey, Node> {
        public void visitEntry(ChildKey key, Node value) {
            this.visitChild(key, value);
        }

        public abstract void visitChild(ChildKey var1, Node var2);
    }

    private static class NamedNodeIterator
    implements Iterator<NamedNode> {
        private final Iterator<Map.Entry<ChildKey, Node>> iterator;

        public NamedNodeIterator(Iterator<Map.Entry<ChildKey, Node>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public NamedNode next() {
            Map.Entry<ChildKey, Node> entry = this.iterator.next();
            return new NamedNode(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

