/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.auth;

import com.google.api.auth.AuthTokenDecoder;
import com.google.api.auth.AuthTokenVerifier;
import com.google.api.auth.UnauthenticatedException;
import com.google.common.base.Preconditions;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class DefaultAuthTokenDecoder
implements AuthTokenDecoder {
    private final AuthTokenVerifier authTokenVerifier;
    private final JwtConsumer jwtConsumer;

    public DefaultAuthTokenDecoder(AuthTokenVerifier authTokenVerifier) {
        Preconditions.checkNotNull((Object)authTokenVerifier);
        this.authTokenVerifier = authTokenVerifier;
        this.jwtConsumer = new JwtConsumerBuilder().setDisableRequireSignature().setSkipAllValidators().setSkipSignatureVerification().build();
    }

    @Override
    public JwtClaims decode(String authToken) {
        Preconditions.checkNotNull((Object)authToken);
        try {
            JwtClaims jwtClaims = this.jwtConsumer.process(authToken).getJwtClaims();
            if (!this.authTokenVerifier.verify(authToken, jwtClaims.getIssuer())) {
                throw new UnauthenticatedException("Failed to verify the signature of the auth token");
            }
            return jwtClaims;
        }
        catch (MalformedClaimException | InvalidJwtException exception) {
            throw new UnauthenticatedException(exception);
        }
    }
}

