/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.discovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.Preconditions;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.Strings;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.config.model.ApiNamespaceConfig;
import com.google.api.server.spi.config.model.ApiParameterConfig;
import com.google.api.server.spi.config.model.FieldType;
import com.google.api.server.spi.config.model.Schema;
import com.google.api.server.spi.config.model.SchemaRepository;
import com.google.api.server.spi.config.scope.AuthScopeExpressions;
import com.google.api.server.spi.discovery.AutoValue_DiscoveryGenerator_Result;
import com.google.api.server.spi.discovery.CommonPathPrefixBuilder;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.JsonSchema;
import com.google.api.services.discovery.model.RestDescription;
import com.google.api.services.discovery.model.RestMethod;
import com.google.api.services.discovery.model.RestResource;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.reflect.TypeToken;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DiscoveryGenerator {
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    private static final ObjectMapper objectMapper = ObjectMapperUtil.createStandardObjectMapper();
    private static final RestDescription REST_SKELETON = new RestDescription().setAuth(new RestDescription.Auth().setOauth2(new RestDescription.Auth.Oauth2().setScopes(Maps.newHashMap((Map)ImmutableMap.of((Object)"https://www.googleapis.com/auth/userinfo.email", (Object)((Object)new RestDescription.Auth.Oauth2.ScopesElement().setDescription("View your email address"))))))).setBatchPath("batch").setDescription("This is an API").setDiscoveryVersion("v1").setIcons(new RestDescription.Icons().setX16("http://www.google.com/images/icons/product/search-16.gif").setX32("http://www.google.com/images/icons/product/search-32.gif")).setKind("discovery#restDescription").setParameters(DiscoveryGenerator.createStandardParameters()).setProtocol("rest");
    private final TypeLoader typeLoader;

    public DiscoveryGenerator(TypeLoader typeLoader) {
        this.typeLoader = typeLoader;
    }

    public Result writeDiscovery(Iterable<ApiConfig> configs, DiscoveryContext context) {
        return this.writeDiscovery(configs, context, new SchemaRepository(this.typeLoader));
    }

    public Result writeDiscovery(Iterable<ApiConfig> configs, DiscoveryContext context, SchemaRepository schemaRepository) {
        ImmutableListMultimap configsByKey = Multimaps.index(configs, (Function)new Function<ApiConfig, ApiKey>(){

            public ApiKey apply(ApiConfig config) {
                return config.getApiKey();
            }
        });
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableSet.Builder preferred = ImmutableSet.builder();
        for (ApiKey apiKey : configsByKey.keySet()) {
            ImmutableList apiConfigs = configsByKey.get((Object)apiKey);
            builder.put((Object)apiKey, (Object)this.writeApi(apiKey, (Iterable<ApiConfig>)apiConfigs, context, schemaRepository));
            if (!((ApiConfig)Iterables.getLast((Iterable)apiConfigs)).getIsDefaultVersion()) continue;
            preferred.add((Object)apiKey);
        }
        ImmutableMap discoveryDocs = builder.build();
        return Result.builder().setDiscoveryDocs((ImmutableMap<ApiKey, RestDescription>)discoveryDocs).setDirectory(this.generateDirectory((Map<ApiKey, RestDescription>)discoveryDocs, (ImmutableSet<ApiKey>)preferred.build(), context)).build();
    }

    private RestDescription writeApi(ApiKey apiKey, Iterable<ApiConfig> apiConfigs, DiscoveryContext context, SchemaRepository repo) {
        String servicePath = this.computeApiServicePath(apiConfigs);
        String basePath = context.basePath + "/" + servicePath;
        RestDescription doc = REST_SKELETON.clone().setBasePath(basePath).setBaseUrl(context.getApiRoot() + "/" + servicePath).setId(apiKey.getName() + ":" + apiKey.getVersion()).setName(apiKey.getName()).setRootUrl(context.getApiRoot() + "/").setServicePath(servicePath).setVersion(apiKey.getVersion());
        for (ApiConfig config : apiConfigs) {
            if (config.getDescription() != null) {
                doc.setDescription(config.getDescription());
            }
            if (config.getTitle() != null) {
                doc.setTitle(config.getTitle());
            }
            if (config.getNamespaceConfig() != null) {
                ApiNamespaceConfig namespaceConfig = config.getNamespaceConfig();
                if (!Strings.isEmptyOrWhitespace(namespaceConfig.getOwnerName())) {
                    doc.setOwnerName(namespaceConfig.getOwnerName());
                }
                if (!Strings.isEmptyOrWhitespace(namespaceConfig.getOwnerDomain())) {
                    doc.setOwnerDomain(namespaceConfig.getOwnerDomain());
                }
                if (!Strings.isEmptyOrWhitespace(namespaceConfig.getPackagePath())) {
                    doc.setPackagePath(namespaceConfig.getPackagePath());
                }
            }
            for (ApiMethodConfig methodConfig : config.getApiClassConfig().getMethods().values()) {
                if (methodConfig.isIgnored()) continue;
                this.writeApiMethod(config, servicePath, doc, methodConfig, repo);
            }
        }
        List<Schema> schemas = repo.getAllSchemaForApi(apiKey);
        if (!schemas.isEmpty()) {
            TreeMap docSchemas = Maps.newTreeMap();
            for (Schema schema : schemas) {
                docSchemas.put(schema.name(), this.convertToDiscoverySchema(schema));
            }
            doc.setSchemas(docSchemas);
        }
        return doc;
    }

    private void writeApiMethod(ApiConfig config, String servicePath, RestDescription doc, ApiMethodConfig methodConfig, SchemaRepository repo) {
        Schema schema;
        ApiParameterConfig requestParamConfig;
        List parts = DOT_SPLITTER.splitToList((CharSequence)methodConfig.getFullMethodName());
        Map<String, RestMethod> methods = this.getMethodMapFromDoc(doc, parts);
        Map<String, JsonSchema> parameters = this.convertMethodParameters(methodConfig);
        RestMethod method = new RestMethod().setDescription(methodConfig.getDescription()).setHttpMethod(methodConfig.getHttpMethod()).setId(methodConfig.getFullMethodName()).setPath(methodConfig.getCanonicalPath().substring(servicePath.length())).setScopes(AuthScopeExpressions.encodeMutable(methodConfig.getScopeExpression()));
        if (!methodConfig.getPathParameters().isEmpty()) {
            method.setParameterOrder(Lists.newArrayList(parameters.keySet()));
        }
        if (!parameters.isEmpty()) {
            method.setParameters(parameters);
        }
        if ((requestParamConfig = this.getAndCheckMethodRequestResource(methodConfig)) != null) {
            TypeToken<?> requestType = requestParamConfig.getSchemaBaseType();
            schema = repo.getOrAdd(requestType, config);
            method.setRequest(new RestMethod.Request().set$ref(schema.name()).setParameterName("resource"));
        }
        if (methodConfig.hasResourceInResponse()) {
            TypeToken<?> returnType = ApiAnnotationIntrospector.getSchemaType(methodConfig.getReturnType(), config);
            schema = repo.getOrAdd(returnType, config);
            method.setResponse(new RestMethod.Response().set$ref(schema.name()));
        }
        methods.put((String)parts.get(parts.size() - 1), method);
    }

    private JsonSchema convertToDiscoverySchema(Schema schema) {
        JsonSchema docSchema = new JsonSchema().setId(schema.name()).setType(schema.type());
        if (!schema.fields().isEmpty()) {
            LinkedHashMap fields = Maps.newLinkedHashMap();
            for (Schema.Field f : schema.fields().values()) {
                fields.put(f.name(), this.convertToDiscoverySchema(f));
            }
            docSchema.setProperties(fields);
        }
        if (!schema.enumValues().isEmpty()) {
            docSchema.setEnum(new ArrayList<String>((Collection<String>)schema.enumValues()));
            docSchema.setEnumDescriptions(new ArrayList<String>((Collection<String>)schema.enumDescriptions()));
        }
        return docSchema;
    }

    private JsonSchema convertToDiscoverySchema(Schema.Field f) {
        if (f.schemaReference() != null) {
            return new JsonSchema().set$ref(f.schemaReference().get().name());
        }
        JsonSchema fieldSchema = new JsonSchema().setType(f.type().getDiscoveryType()).setFormat(f.type().getDiscoveryFormat());
        if (f.type() == FieldType.ARRAY) {
            fieldSchema.setItems(this.convertToDiscoverySchema(f.arrayItemSchema()));
        }
        return fieldSchema;
    }

    private ApiParameterConfig getAndCheckMethodRequestResource(ApiMethodConfig methodConfig) {
        ApiParameterConfig config = null;
        for (ApiParameterConfig parameterConfig : methodConfig.getParameterConfigs()) {
            if (parameterConfig.getClassification() != ApiParameterConfig.Classification.RESOURCE) continue;
            if (config != null) {
                throw new IllegalArgumentException(String.format("Method %s can't have multiple resource parameters", methodConfig.getFullJavaName()));
            }
            config = parameterConfig;
        }
        return config;
    }

    private Map<String, RestMethod> getMethodMapFromDoc(RestDescription doc, List<String> parts) {
        if (parts.size() == 2) {
            if (doc.getMethods() == null) {
                doc.setMethods(new TreeMap<String, RestMethod>());
            }
            return doc.getMethods();
        }
        RestResource resource = null;
        Map<String, RestResource> resources = doc.getResources();
        if (resources == null) {
            resources = new TreeMap<String, RestResource>();
            doc.setResources(resources);
        }
        for (int i = 1; i < parts.size() - 1; ++i) {
            String part = parts.get(i);
            if (resources == null) {
                resources = new TreeMap<String, RestResource>();
                resource.setResources(resources);
            }
            if ((resource = resources.get(part)) == null) {
                resource = new RestResource();
                resources.put(part, resource);
            }
            resources = resource.getResources();
        }
        if (resource.getMethods() == null) {
            resource.setMethods(new TreeMap<String, RestMethod>());
        }
        return resource.getMethods();
    }

    private Map<String, JsonSchema> convertMethodParameters(ApiMethodConfig methodConfig) {
        LinkedHashMap parameters = Maps.newLinkedHashMap();
        for (ApiParameterConfig parameterConfig : methodConfig.getParameterConfigs()) {
            if (parameterConfig.getClassification() != ApiParameterConfig.Classification.API_PARAMETER) continue;
            parameters.put(parameterConfig.getName(), this.convertMethodParameter(methodConfig, parameterConfig));
        }
        return parameters;
    }

    private JsonSchema convertMethodParameter(ApiMethodConfig methodConfig, ApiParameterConfig parameterConfig) {
        String defaultValue;
        TypeToken type;
        JsonSchema schema = new JsonSchema();
        if (parameterConfig.isRepeated()) {
            schema.setRepeated(true);
            type = parameterConfig.getRepeatedItemSerializedType();
        } else {
            type = parameterConfig.getSchemaBaseType();
        }
        if (parameterConfig.isEnum()) {
            ArrayList enumValues = Lists.newArrayList();
            ArrayList enumDescriptions = Lists.newArrayList();
            for (Object enumConstant : type.getRawType().getEnumConstants()) {
                enumValues.add(enumConstant.toString());
                enumDescriptions.add("");
            }
            schema.setEnum(enumValues);
            schema.setEnumDescriptions(enumDescriptions);
            type = TypeToken.of(String.class);
        }
        schema.setType(this.typeLoader.getSchemaType(type));
        schema.setFormat(FieldType.fromType(type).getDiscoveryFormat());
        if (!parameterConfig.getNullable() && parameterConfig.getDefaultValue() == null) {
            schema.setRequired(true);
        }
        if ((defaultValue = parameterConfig.getDefaultValue()) != null) {
            Class parameterClass = type.getRawType();
            try {
                objectMapper.convertValue((Object)defaultValue, parameterClass);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid default value for type '%s'", defaultValue, type));
            }
            schema.setDefault(defaultValue);
        }
        if (methodConfig.getPathParameters().contains(parameterConfig.getName())) {
            schema.setLocation("path");
        } else {
            schema.setLocation("query");
        }
        if (parameterConfig.getDescription() != null) {
            schema.setDescription(parameterConfig.getDescription());
        }
        return schema;
    }

    private String computeApiServicePath(Iterable<ApiConfig> apiConfigs) {
        CommonPathPrefixBuilder builder = new CommonPathPrefixBuilder();
        for (ApiConfig apiConfig : apiConfigs) {
            for (ApiMethodConfig methodConfig : apiConfig.getApiClassConfig().getMethods().values()) {
                builder.addPath(methodConfig.getCanonicalPath());
            }
        }
        return builder.getCommonPrefix();
    }

    private DirectoryList generateDirectory(Map<ApiKey, RestDescription> discoveryDocs, ImmutableSet<ApiKey> preferred, DiscoveryContext context) {
        DirectoryList directory = new DirectoryList().setDiscoveryVersion("v1").setKind("discovery#directoryList");
        ArrayList items = Lists.newArrayList();
        for (Map.Entry<ApiKey, RestDescription> entry : discoveryDocs.entrySet()) {
            RestDescription doc = entry.getValue();
            String relativePath = "/apis/" + doc.getName() + "/" + doc.getVersion() + "/rest";
            items.add(new DirectoryList.Items().setDescription(doc.getDescription()).setDiscoveryLink("." + relativePath).setDiscoveryRestUrl(context.getApiRoot() + "/discovery/v1" + relativePath).setIcons(new DirectoryList.Items.Icons().setX16("http://www.google.com/images/icons/product/search-16.gif").setX32("http://www.google.com/images/icons/product/search-32.gif")).setId(doc.getName() + ":" + doc.getVersion()).setKind("discovery#directoryItem").setName(doc.getName()).setPreferred(preferred.contains((Object)entry.getKey())).setTitle(doc.getTitle()).setVersion(doc.getVersion()));
        }
        return directory.setItems(items);
    }

    private static Map<String, JsonSchema> createStandardParameters() {
        TreeMap<String, JsonSchema> params = new TreeMap<String, JsonSchema>();
        params.put("alt", new JsonSchema().setDefault("json").setDescription("Data format for the response.").setEnum(Lists.newArrayList((Object[])new String[]{"json"})).setEnumDescriptions(Lists.newArrayList((Object[])new String[]{"Responses with Content-Type of application/json"})).setLocation("query").setType("string"));
        params.put("fields", new JsonSchema().setDescription("Selector specifying which fields to include in a partial response.").setLocation("query").setType("string"));
        params.put("key", new JsonSchema().setDescription("API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.").setLocation("query").setType("string"));
        params.put("oauth_token", new JsonSchema().setDescription("OAuth 2.0 token for the current user.").setLocation("query").setType("string"));
        params.put("prettyPrint", new JsonSchema().setDefault("true").setDescription("Returns response with indentations and line breaks.").setLocation("query").setType("boolean"));
        params.put("quotaUser", new JsonSchema().setDescription("Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters. Overrides userIp if both are provided.").setLocation("query").setType("string"));
        params.put("userIp", new JsonSchema().setDescription("IP address of the site where the request originates. Use this if you want to enforce per-user limits.").setLocation("query").setType("string"));
        return params;
    }

    public static class DiscoveryContext {
        private String scheme = "https";
        private String hostname = "myapi.appspot.com";
        private String basePath = "/_ah/api";

        public String getApiRoot() {
            return this.scheme + "://" + this.hostname + this.basePath;
        }

        public DiscoveryContext setApiRoot(String apiRoot) {
            try {
                URL url = new URL(Strings.stripTrailingSlash(apiRoot));
                this.hostname = url.getHost();
                if ("http".equals(url.getProtocol()) && url.getPort() != 80 && url.getPort() != -1 || "https".equals(url.getProtocol()) && url.getPort() != 443 && url.getPort() != -1) {
                    this.hostname = this.hostname + ":" + url.getPort();
                }
                this.basePath = Strings.stripTrailingSlash(url.getPath());
                this.setScheme(url.getProtocol());
                return this;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public DiscoveryContext setScheme(String scheme) {
            Preconditions.checkArgument(("http".equals(scheme) || "https".equals(scheme) ? 1 : 0) != 0, (Object)"scheme must be http or https");
            this.scheme = scheme;
            return this;
        }

        public DiscoveryContext setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public DiscoveryContext setBasePath(String basePath) {
            this.basePath = Strings.stripTrailingSlash(basePath);
            return this;
        }
    }

    public static abstract class Result {
        public abstract DirectoryList directory();

        public abstract ImmutableMap<ApiKey, RestDescription> discoveryDocs();

        static Builder builder() {
            return new AutoValue_DiscoveryGenerator_Result.Builder();
        }

        public static abstract class Builder {
            public abstract Builder setDirectory(DirectoryList var1);

            public abstract Builder setDiscoveryDocs(ImmutableMap<ApiKey, RestDescription> var1);

            public abstract Result build();
        }
    }
}

