/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Objects;

public class ApiIssuerAudienceConfig {
    private static final String UNSPECIFIED_NAME = "_unspecified_issuer_name";
    private static final String UNSPECIFIED_AUDIENCE = "_unspecified_audience";
    public static final ApiIssuerAudienceConfig UNSPECIFIED = ApiIssuerAudienceConfig.builder().addIssuerAudiences("_unspecified_issuer_name", "_unspecified_audience").build();
    public static final ApiIssuerAudienceConfig EMPTY = ApiIssuerAudienceConfig.builder().build();
    private final ImmutableListMultimap<String, String> issuerAudiences;

    private ApiIssuerAudienceConfig(Builder builder) {
        this.issuerAudiences = builder.issuerAudiences.build();
    }

    public ImmutableMap<String, Collection<String>> asMap() {
        return this.issuerAudiences.asMap();
    }

    public boolean isSpecified() {
        return !this.equals(UNSPECIFIED);
    }

    public boolean isEmpty() {
        return this.issuerAudiences.isEmpty();
    }

    public boolean hasIssuer(String issuer) {
        return this.issuerAudiences.containsKey((Object)issuer);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof ApiIssuerAudienceConfig && Objects.equals(this.issuerAudiences, ((ApiIssuerAudienceConfig)o).issuerAudiences);
    }

    public int hashCode() {
        return this.issuerAudiences.hashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableListMultimap.Builder<String, String> issuerAudiences = ImmutableListMultimap.builder();

        public Builder addIssuerAudiences(String issuer, String ... audiences) {
            this.issuerAudiences.putAll((Object)issuer, (Object[])audiences);
            return this;
        }

        public ApiIssuerAudienceConfig build() {
            return new ApiIssuerAudienceConfig(this);
        }
    }
}

