/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, name = "DOMException", namespace = JsPackage.GLOBAL)
class DOMException__Constants {
  static int ABORT_ERR;
  static int DATA_CLONE_ERR;
  static int DOMSTRING_SIZE_ERR;
  static int HIERARCHY_REQUEST_ERR;
  static int INDEX_SIZE_ERR;
  static int INUSE_ATTRIBUTE_ERR;
  static int INVALID_ACCESS_ERR;
  static int INVALID_CHARACTER_ERR;
  static int INVALID_MODIFICATION_ERR;
  static int INVALID_NODE_TYPE_ERR;
  static int INVALID_STATE_ERR;
  static int NAMESPACE_ERR;
  static int NETWORK_ERR;
  static int NOT_FOUND_ERR;
  static int NOT_SUPPORTED_ERR;
  static int NO_DATA_ALLOWED_ERR;
  static int NO_MODIFICATION_ALLOWED_ERR;
  static int QUOTA_EXCEEDED_ERR;
  static int SECURITY_ERR;
  static int SYNTAX_ERR;
  static int TIMEOUT_ERR;
  static int TYPE_MISMATCH_ERR;
  static int URL_MISMATCH_ERR;
  static int VALIDATION_ERR;
  static int WRONG_DOCUMENT_ERR;
}
