/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp.processing.impl;

import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.symbol.FileLocation;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.Location;
import com.google.devtools.ksp.symbol.NonExistLocation;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u0015\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0006\u0010\u0016\u001a\u00020\u0010J\u001a\u0010\u0017\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/google/devtools/ksp/processing/impl/MessageCollectorBasedKSPLogger;", "Lcom/google/devtools/ksp/processing/KSPLogger;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "recordedEvents", "", "Lcom/google/devtools/ksp/processing/impl/MessageCollectorBasedKSPLogger$Event;", "getRecordedEvents", "()Ljava/util/List;", "convertMessage", "", "message", "symbol", "Lcom/google/devtools/ksp/symbol/KSNode;", "error", "", "exception", "e", "", "info", "logging", "reportAll", "warn", "Companion", "Event", "compiler-plugin"})
public final class MessageCollectorBasedKSPLogger
implements KSPLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageCollector messageCollector;
    @NotNull
    private final List<Event> recordedEvents;
    @NotNull
    public static final String PREFIX = "[ksp] ";

    public MessageCollectorBasedKSPLogger(@NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        this.messageCollector = messageCollector;
        this.recordedEvents = new ArrayList();
    }

    @NotNull
    public final List<Event> getRecordedEvents() {
        return this.recordedEvents;
    }

    private final String convertMessage(String message, KSNode symbol) {
        String string;
        Location location2;
        KSNode kSNode = symbol;
        Object object = location2 = kSNode == null ? null : kSNode.getLocation();
        if (location2 instanceof FileLocation) {
            string = PREFIX + ((FileLocation)location2).getFilePath() + ':' + ((FileLocation)location2).getLineNumber() + ": " + message;
        } else if (location2 instanceof NonExistLocation ? true : location2 == null) {
            string = Intrinsics.stringPlus((String)PREFIX, (Object)message);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public void logging(@NotNull String message, @Nullable KSNode symbol) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.recordedEvents.add(new Event(CompilerMessageSeverity.LOGGING, this.convertMessage(message, symbol)));
    }

    public void info(@NotNull String message, @Nullable KSNode symbol) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.recordedEvents.add(new Event(CompilerMessageSeverity.INFO, this.convertMessage(message, symbol)));
    }

    public void warn(@NotNull String message, @Nullable KSNode symbol) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.recordedEvents.add(new Event(CompilerMessageSeverity.WARNING, this.convertMessage(message, symbol)));
    }

    public void error(@NotNull String message, @Nullable KSNode symbol) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.recordedEvents.add(new Event(CompilerMessageSeverity.ERROR, this.convertMessage(message, symbol)));
    }

    public void exception(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        this.recordedEvents.add(new Event(CompilerMessageSeverity.EXCEPTION, string));
    }

    public final void reportAll() {
        for (Event event : this.recordedEvents) {
            MessageCollector.DefaultImpls.report$default((MessageCollector)this.messageCollector, (CompilerMessageSeverity)event.getSeverity(), (String)event.getMessage(), null, (int)4, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/google/devtools/ksp/processing/impl/MessageCollectorBasedKSPLogger$Companion;", "", "()V", "PREFIX", "", "compiler-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/google/devtools/ksp/processing/impl/MessageCollectorBasedKSPLogger$Event;", "", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "(Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "getSeverity", "()Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "compiler-plugin"})
    public static final class Event {
        @NotNull
        private final CompilerMessageSeverity severity;
        @NotNull
        private final String message;

        public Event(@NotNull CompilerMessageSeverity severity, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.severity = severity;
            this.message = message;
        }

        @NotNull
        public final CompilerMessageSeverity getSeverity() {
            return this.severity;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final CompilerMessageSeverity component1() {
            return this.severity;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final Event copy(@NotNull CompilerMessageSeverity severity, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new Event(severity, message);
        }

        public static /* synthetic */ Event copy$default(Event event, CompilerMessageSeverity compilerMessageSeverity, String string, int n, Object object) {
            if ((n & 1) != 0) {
                compilerMessageSeverity = event.severity;
            }
            if ((n & 2) != 0) {
                string = event.message;
            }
            return event.copy(compilerMessageSeverity, string);
        }

        @NotNull
        public String toString() {
            return "Event(severity=" + this.severity + ", message=" + this.message + ')';
        }

        public int hashCode() {
            int result = this.severity.hashCode();
            result = result * 31 + this.message.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            if (this.severity != event.severity) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)event.message);
        }
    }
}

