/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp.processing;

import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.symbol.FileLocation;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.Location;
import com.google.devtools.ksp.symbol.NonExistLocation;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u0015\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/google/devtools/ksp/processing/KspGradleLogger;", "Lcom/google/devtools/ksp/processing/KSPLogger;", "loglevel", "", "(I)V", "getLoglevel", "()I", "messager", "Ljava/io/PrintStream;", "kotlin.jvm.PlatformType", "decorateMessage", "", "message", "symbol", "Lcom/google/devtools/ksp/symbol/KSNode;", "error", "", "exception", "e", "", "info", "logging", "warn", "Companion", "common-deps"})
public final class KspGradleLogger
implements KSPLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int loglevel;
    private final PrintStream messager;
    public static final int LOGGING_LEVEL_LOGGING = 0;
    public static final int LOGGING_LEVEL_INFO = 1;
    public static final int LOGGING_LEVEL_WARN = 3;
    public static final int LOGGING_LEVEL_ERROR = 5;

    public KspGradleLogger(int loglevel) {
        this.loglevel = loglevel;
        this.messager = System.out;
    }

    public final int getLoglevel() {
        return this.loglevel;
    }

    private final String decorateMessage(String message, KSNode symbol) {
        String string;
        Location location;
        KSNode kSNode = symbol;
        Object object = location = kSNode != null ? kSNode.getLocation() : null;
        if (location instanceof FileLocation) {
            string = ((FileLocation)location).getFilePath() + ':' + ((FileLocation)location).getLineNumber() + ": " + message;
        } else if (location instanceof NonExistLocation ? true : location == null) {
            string = message;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public void logging(@NotNull String message, @Nullable KSNode symbol) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.loglevel <= 0) {
            this.messager.println("v: [ksp] " + this.decorateMessage(message, symbol));
        }
    }

    public void info(@NotNull String message, @Nullable KSNode symbol) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.loglevel <= 1) {
            this.messager.println("i: [ksp] " + this.decorateMessage(message, symbol));
        }
    }

    public void warn(@NotNull String message, @Nullable KSNode symbol) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.loglevel <= 3) {
            this.messager.println("w: [ksp] " + this.decorateMessage(message, symbol));
        }
    }

    public void error(@NotNull String message, @Nullable KSNode symbol) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.loglevel <= 5) {
            this.messager.println("e: [ksp] " + this.decorateMessage(message, symbol));
        }
    }

    public void exception(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.loglevel <= 5) {
            this.messager.println("e: [ksp] " + e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/google/devtools/ksp/processing/KspGradleLogger$Companion;", "", "()V", "LOGGING_LEVEL_ERROR", "", "LOGGING_LEVEL_INFO", "LOGGING_LEVEL_LOGGING", "LOGGING_LEVEL_WARN", "common-deps"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

