/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp;

import com.google.devtools.ksp.DepInvalidator;
import com.google.devtools.ksp.DualLookupTracker;
import com.google.devtools.ksp.FileToFilesMap;
import com.google.devtools.ksp.FileToSymbolsMap;
import com.google.devtools.ksp.KspOptions;
import com.google.devtools.ksp.NoSourceFile;
import com.google.devtools.ksp.PersistentMap;
import com.google.devtools.ksp.RelativeFileToPathConverter;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSVisitor;
import com.google.devtools.ksp.symbol.impl.UtilsKt;
import com.google.devtools.ksp.symbol.impl.java.KSFunctionDeclarationJavaImpl;
import com.google.devtools.ksp.symbol.impl.java.KSPropertyDeclarationJavaImpl;
import com.google.devtools.ksp.symbolCollector;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.incremental.components.ScopeKind;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020+0/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020+01J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\f\u00100\u001a\b\u0012\u0004\u0012\u00020+01H\u0002J$\u00103\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u00104\u001a\u00020\u001f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0002J\"\u00106\u001a\u0002H7\"\u0004\b\u0000\u001072\f\u00108\u001a\b\u0012\u0004\u0012\u0002H709H\u0082\b\u00a2\u0006\u0002\u0010:J\u0016\u0010;\u001a\u00020<2\f\u00100\u001a\b\u0012\u0004\u0012\u00020+0/H\u0002J\u001f\u0010=\u001a\u0014\u0012\u0004\u0012\u00020?\u0012\n\u0012\b\u0012\u0004\u0012\u00020?010>H\u0000\u00a2\u0006\u0002\b@J$\u0010A\u001a\u00020<2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020+012\f\u0010C\u001a\b\u0012\u0004\u0012\u00020+01H\u0002J\u0016\u0010D\u001a\u00020<2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00070/H\u0002J\u0016\u0010F\u001a\u00020<2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00070/H\u0002J\u0016\u0010G\u001a\u00020<2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00070/H\u0002J0\u0010H\u001a\u00020<2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00190>H\u0002J\u000e\u0010J\u001a\u00020<2\u0006\u0010K\u001a\u00020LJ\u0016\u0010M\u001a\u00020<2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020?J\u000e\u0010M\u001a\u00020<2\u0006\u0010Q\u001a\u00020RJ\u0018\u0010M\u001a\u00020<2\u0006\u0010Q\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002J\u000e\u0010V\u001a\u00020<2\u0006\u0010W\u001a\u00020XJ\u000e\u0010Y\u001a\u00020<2\u0006\u0010Z\u001a\u00020[J\"\u0010\\\u001a\u00020<2\u0006\u0010W\u001a\u00020]2\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00020U\u0012\u0004\u0012\u00020<0_J\u000e\u0010`\u001a\u00020<2\u0006\u0010W\u001a\u00020]J\u000e\u0010a\u001a\u00020<2\u0006\u0010W\u001a\u00020]J\u0010\u0010b\u001a\u00020<2\u0006\u0010c\u001a\u00020dH\u0002J\u0010\u0010e\u001a\u00020<2\u0006\u0010c\u001a\u00020fH\u0002J\u000e\u0010g\u001a\u00020<2\u0006\u0010h\u001a\u00020iJ\u0014\u0010j\u001a\u00020<2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020+0/J>\u0010l\u001a\u00020<2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00070/2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00190>H\u0002J<\u0010m\u001a\u00020<2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020+0/2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00190>J$\u0010n\u001a\u00020<2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00070/2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020\u000701H\u0002J$\u0010p\u001a\u00020<2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00070/H\u0002JL\u0010r\u001a\u00020<2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00070/2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00190>2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020\u000701H\u0002J\f\u0010s\u001a\u00020\u0007*\u00020?H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010$\u001a#\u0012\f\u0012\n &*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n &*\u0004\u0018\u00010'0'0%\u00a2\u0006\u0002\b(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010)\u001a#\u0012\f\u0012\n &*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n &*\u0004\u0018\u00010'0'0%\u00a2\u0006\u0002\b(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010*\u001a\u00020\u0007*\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006t"}, d2={"Lcom/google/devtools/ksp/IncrementalContext;", "", "options", "Lcom/google/devtools/ksp/KspOptions;", "componentProvider", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "anyChangesWildcard", "Ljava/io/File;", "(Lcom/google/devtools/ksp/KspOptions;Lorg/jetbrains/kotlin/container/ComponentProvider;Ljava/io/File;)V", "PATH_CONVERTER", "Lcom/google/devtools/ksp/RelativeFileToPathConverter;", "baseDir", "buildTime", "", "cachesUpToDateFile", "classLookupCache", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "classLookupCacheDir", "classLookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "isIncremental", "", "logsDir", "lookupTracker", "modified", "", "rebuild", "removed", "sealedMap", "Lcom/google/devtools/ksp/FileToSymbolsMap;", "sourceToOutputsMap", "Lcom/google/devtools/ksp/FileToFilesMap;", "symbolLookupCache", "symbolLookupCacheDir", "symbolLookupTracker", "symbolsMap", "updatedSealed", "Lcom/intellij/util/containers/MultiMap;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "Lorg/jetbrains/annotations/NotNull;", "updatedSymbols", "relativeFile", "Lcom/google/devtools/ksp/symbol/KSFile;", "getRelativeFile", "(Lcom/google/devtools/ksp/symbol/KSFile;)Ljava/io/File;", "calcDirtyFiles", "", "ksFiles", "", "calcDirtySetByDeps", "calcDirtySetByOutputs", "sourceToOutputs", "initialSet", "closeFilesOnException", "T", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "collectDefinedSymbols", "", "dumpLookupRecords", "", "", "dumpLookupRecords$compiler_plugin", "logDirtyFiles", "files", "allFiles", "logDirtyFilesByCP", "dirtyFiles", "logDirtyFilesByDeps", "logDirtyFilesByOutputs", "logSourceToOutputs", "outputs", "recordGetSealedSubclasses", "classDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "recordLookup", "psiFile", "Lcom/intellij/psi/PsiJavaFile;", "fqn", "ref", "Lcom/intellij/psi/PsiType;", "Lcom/intellij/psi/impl/source/PsiClassReferenceType;", "def", "Lcom/intellij/psi/PsiClass;", "recordLookupForCallableMemberDescriptor", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "recordLookupForDeclaration", "declaration", "Lcom/google/devtools/ksp/symbol/KSDeclaration;", "recordLookupForGetAll", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "doChild", "Lkotlin/Function1;", "recordLookupForGetAllFunctions", "recordLookupForGetAllProperties", "recordLookupForJavaField", "psi", "Lcom/intellij/psi/PsiField;", "recordLookupForJavaMethod", "Lcom/intellij/psi/PsiMethod;", "recordLookupWithSupertypes", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "registerGeneratedFiles", "newFiles", "updateCaches", "updateCachesAndOutputs", "updateLookupCache", "removedOutputs", "updateOutputs", "cleanOutputs", "updateSourceToOutputs", "toRelativeFile", "compiler-plugin"})
public final class IncrementalContext {
    @NotNull
    private final KspOptions options;
    @NotNull
    private final ComponentProvider componentProvider;
    @NotNull
    private final File anyChangesWildcard;
    @NotNull
    private final MultiMap<File, LookupSymbol> updatedSymbols;
    @NotNull
    private final MultiMap<File, LookupSymbol> updatedSealed;
    @NotNull
    private final FileToSymbolsMap sealedMap;
    @NotNull
    private final FileToSymbolsMap symbolsMap;
    @NotNull
    private final File cachesUpToDateFile;
    private final boolean rebuild;
    @NotNull
    private final File baseDir;
    @NotNull
    private final File logsDir;
    private final long buildTime;
    @NotNull
    private final Set<File> modified;
    @NotNull
    private final Set<File> removed;
    @NotNull
    private final LookupTracker lookupTracker;
    private final boolean isIncremental;
    @NotNull
    private final RelativeFileToPathConverter PATH_CONVERTER;
    @NotNull
    private final LookupTracker symbolLookupTracker;
    @NotNull
    private final File symbolLookupCacheDir;
    @NotNull
    private final LookupStorage symbolLookupCache;
    @NotNull
    private final LookupTracker classLookupTracker;
    @NotNull
    private final File classLookupCacheDir;
    @NotNull
    private final LookupStorage classLookupCache;
    @NotNull
    private final FileToFilesMap sourceToOutputsMap;

    /*
     * WARNING - void declaration
     */
    public IncrementalContext(@NotNull KspOptions options, @NotNull ComponentProvider componentProvider, @NotNull File anyChangesWildcard) {
        File it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$logsDir_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)componentProvider, (String)"componentProvider");
        Intrinsics.checkNotNullParameter((Object)anyChangesWildcard, (String)"anyChangesWildcard");
        this.options = options;
        this.componentProvider = componentProvider;
        this.anyChangesWildcard = anyChangesWildcard;
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet<File, LookupSymbol>()");
        this.updatedSymbols = multiMap;
        MultiMap multiMap2 = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"createSet<File, LookupSymbol>()");
        this.updatedSealed = multiMap2;
        this.sealedMap = new FileToSymbolsMap(new File(this.options.getCachesDir(), "sealed"));
        this.symbolsMap = new FileToSymbolsMap(new File(this.options.getCachesDir(), "symbols"));
        this.cachesUpToDateFile = new File(this.options.getCachesDir(), "caches.uptodate");
        this.rebuild = !this.cachesUpToDateFile.exists();
        this.baseDir = this.options.getProjectBaseDir();
        Object object = new File(this.options.getCachesDir(), "logs");
        File file = object;
        IncrementalContext incrementalContext = this;
        boolean $i$a$-apply-IncrementalContext$logsDir$22 = false;
        $this$logsDir_u24lambda_u2d0.mkdirs();
        incrementalContext.logsDir = object;
        this.buildTime = new Date().getTime();
        object = this.options.getKnownModified();
        incrementalContext = this;
        boolean $i$f$map = false;
        void $i$a$-apply-IncrementalContext$logsDir$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FilesKt.relativeTo((File)it, (File)this.baseDir));
        }
        incrementalContext.modified = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = this.options.getKnownRemoved();
        incrementalContext = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FilesKt.relativeTo((File)it, (File)this.baseDir));
        }
        incrementalContext.removed = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        ComponentProvider $this$get$iv = this.componentProvider;
        boolean $i$f$get = false;
        this.lookupTracker = (LookupTracker)DslKt.getService((ComponentProvider)$this$get$iv, LookupTracker.class);
        this.isIncremental = this.options.getIncremental() && this.lookupTracker instanceof DualLookupTracker;
        this.PATH_CONVERTER = new RelativeFileToPathConverter(this.baseDir);
        LookupTracker lookupTracker = this.lookupTracker;
        DualLookupTracker dualLookupTracker = lookupTracker instanceof DualLookupTracker ? (DualLookupTracker)lookupTracker : null;
        this.symbolLookupTracker = dualLookupTracker != null && (dualLookupTracker = dualLookupTracker.getSymbolTracker()) != null ? (LookupTracker)dualLookupTracker : (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE;
        this.symbolLookupCacheDir = new File(this.options.getCachesDir(), "symbolLookups");
        this.symbolLookupCache = new LookupStorage(this.symbolLookupCacheDir, (FileToPathConverter)this.PATH_CONVERTER, false, false, 12, null);
        lookupTracker = this.lookupTracker;
        DualLookupTracker dualLookupTracker2 = lookupTracker instanceof DualLookupTracker ? (DualLookupTracker)lookupTracker : null;
        this.classLookupTracker = dualLookupTracker2 != null && (dualLookupTracker2 = dualLookupTracker2.getClassTracker()) != null ? (LookupTracker)dualLookupTracker2 : (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE;
        this.classLookupCacheDir = new File(this.options.getCachesDir(), "classLookups");
        this.classLookupCache = new LookupStorage(this.classLookupCacheDir, (FileToPathConverter)this.PATH_CONVERTER, false, false, 12, null);
        this.sourceToOutputsMap = new FileToFilesMap(new File(this.options.getCachesDir(), "sourceToOutputs"));
    }

    private final File toRelativeFile(String $this$toRelativeFile) {
        return FilesKt.relativeTo((File)new File($this$toRelativeFile), (File)this.baseDir);
    }

    private final File getRelativeFile(KSFile $this$relativeFile) {
        return this.toRelativeFile($this$relativeFile.getFilePath());
    }

    private final void collectDefinedSymbols(Collection<? extends KSFile> ksFiles) {
        Iterable $this$forEach$iv = ksFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KSFile file = (KSFile)element$iv;
            boolean bl = false;
            file.accept((KSVisitor)symbolCollector.INSTANCE, (Object)new Function1<LookupSymbol, Unit>(this, file){
                final /* synthetic */ IncrementalContext this$0;
                final /* synthetic */ KSFile $file;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    super(1);
                }

                public final void invoke(@NotNull LookupSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    IncrementalContext.access$getUpdatedSymbols$p(this.this$0).putValue((Object)IncrementalContext.access$getRelativeFile(this.this$0, this.$file), (Object)it);
                }
            });
        }
    }

    private final void updateLookupCache(Collection<? extends File> dirtyFiles, List<? extends File> removedOutputs) {
        File it;
        Collection<File> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = removedOutputs;
        Collection collection2 = this.options.getKnownRemoved();
        Iterable iterable2 = dirtyFiles;
        LookupTracker lookupTracker = this.symbolLookupTracker;
        LookupStorage lookupStorage = this.symbolLookupCache;
        boolean $i$f$map = false;
        void var5_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAbsoluteFile());
        }
        collection = (List)destination$iv$iv;
        BuildUtilKt.update((LookupStorage)lookupStorage, (LookupTracker)lookupTracker, (Iterable)iterable2, (Iterable)CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        this.symbolLookupCache.flush(false);
        this.symbolLookupCache.close();
        $this$map$iv = removedOutputs;
        collection2 = this.options.getKnownRemoved();
        iterable2 = dirtyFiles;
        lookupTracker = this.classLookupTracker;
        lookupStorage = this.classLookupCache;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAbsoluteFile());
        }
        collection = (List)destination$iv$iv;
        BuildUtilKt.update((LookupStorage)lookupStorage, (LookupTracker)lookupTracker, (Iterable)iterable2, (Iterable)CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        this.classLookupCache.flush(false);
        this.classLookupCache.close();
    }

    private final Set<File> calcDirtySetByDeps(List<? extends KSFile> ksFiles) {
        Object element$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Object element$iv2;
        Object it;
        Object element$iv$iv2;
        Iterator $this$filterTo$iv$iv;
        Set changedSyms = new LinkedHashSet();
        Iterable $this$filter$iv = ksFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv2 = iterator.next();
            it = (KSFile)element$iv$iv2;
            boolean bl = false;
            if (!this.modified.contains(this.getRelativeFile((KSFile)it))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            KSFile file = (KSFile)element$iv2;
            boolean bl = false;
            file.accept((KSVisitor)symbolCollector.INSTANCE, (Object)new Function1<LookupSymbol, Unit>(this, file, (Set<LookupSymbol>)changedSyms){
                final /* synthetic */ IncrementalContext this$0;
                final /* synthetic */ KSFile $file;
                final /* synthetic */ Set<LookupSymbol> $changedSyms;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$changedSyms = $changedSyms;
                    super(1);
                }

                public final void invoke(@NotNull LookupSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    IncrementalContext.access$getUpdatedSymbols$p(this.this$0).putValue((Object)IncrementalContext.access$getRelativeFile(this.this$0, this.$file), (Object)it);
                    this.$changedSyms.add(it);
                }
            });
        }
        Iterable $this$flatMap$iv = this.options.getChangedClasses();
        boolean $i$f$flatMap = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        element$iv$iv2 = $this$flatMapTo$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            String it2;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            element$iv$iv = element$iv$iv2.next();
            String fqn = (String)element$iv$iv;
            boolean bl = false;
            String name2 = StringsKt.substringAfterLast$default((String)fqn, (char)'.', null, (int)2, null);
            String scope = StringsKt.substringBeforeLast((String)fqn, (char)'.', (String)"<anonymous>");
            Iterable $this$map$iv = this.classLookupCache.get(new LookupSymbol(name2, scope));
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(new File(it2));
            }
            $this$map$iv = this.symbolLookupCache.get(new LookupSymbol(name2, scope));
            collection = (List)destination$iv$iv3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv3;
                boolean bl3 = false;
                collection2.add(new File(it2));
            }
            Iterable list$iv$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv3));
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set dirtyFilesByCP = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        this.logDirtyFilesByCP(dirtyFilesByCP);
        Iterable $this$forEach$iv2 = SetsKt.plus((Set)SetsKt.plus(this.modified, (Iterable)this.removed), (Iterable)dirtyFilesByCP);
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            File file = (File)element$iv3;
            boolean bl = false;
            if (this.symbolsMap.get(file) == null) continue;
            boolean bl4 = false;
            changedSyms.addAll(it);
        }
        $this$forEach$iv2 = this.sealedMap.getKeys();
        Set set = changedSyms;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl = $this$flatMapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            File it3 = (File)element$iv$iv;
            boolean bl5 = false;
            Collection<LookupSymbol> collection = this.sealedMap.get(it3);
            Intrinsics.checkNotNull(collection);
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        set.addAll((List)destination$iv$iv2);
        DepInvalidator invalidator = new DepInvalidator(this.symbolLookupCache, this.symbolsMap, SetsKt.plus(this.modified, (Iterable)dirtyFilesByCP));
        Iterable $this$forEach$iv3 = changedSyms;
        boolean $i$f$forEach3 = false;
        for (Object element$iv4 : $this$forEach$iv3) {
            LookupSymbol it4 = (LookupSymbol)element$iv4;
            boolean bl6 = false;
            invalidator.invalidate(it4);
        }
        return invalidator.getVisitedFiles();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<File> calcDirtySetByOutputs(FileToFilesMap sourceToOutputs, Set<? extends File> initialSet) {
        void $this$mapTo$iv$iv;
        Object source;
        Map outputToSources = new LinkedHashMap();
        Iterable $this$forEach$iv = sourceToOutputs.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            source = (File)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)source, (Object)this.anyChangesWildcard)) continue;
            Collection<File> collection = sourceToOutputs.get((File)source);
            Intrinsics.checkNotNull(collection);
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                File output = (File)element$iv2;
                boolean bl2 = false;
                Map $this$getOrPut$iv = outputToSources;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(output);
                if (value$iv == null) {
                    boolean bl3 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(output, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(source);
            }
        }
        Set visited = new LinkedHashSet();
        Iterable $this$map$iv = this.options.getChangedClasses();
        boolean $i$f$map = false;
        source = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void fqn;
            Object element$iv2;
            element$iv2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toRelativeFile(new NoSourceFile(this.baseDir, (String)fqn).getFilePath()));
        }
        Set cpSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv3 = SetsKt.plus(initialSet, (Iterable)cpSet);
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            File it = (File)element$iv;
            boolean bl = false;
            IncrementalContext.calcDirtySetByOutputs$visit(visited, sourceToOutputs, outputToSources, it);
        }
        return visited;
    }

    private final void logDirtyFilesByCP(Collection<? extends File> dirtyFiles) {
        if (!this.options.getIncrementalLog()) {
            return;
        }
        File logFile = new File(this.logsDir, "kspDirtySetByCP.log");
        FilesKt.appendText$default((File)logFile, (String)("=== Build " + this.buildTime + " ===\n"), null, (int)2, null);
        FilesKt.appendText$default((File)logFile, (String)("CP_changes: " + this.options.getChangedClasses() + '\n'), null, (int)2, null);
        Iterable $this$forEach$iv = dirtyFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            FilesKt.appendText$default((File)logFile, (String)("  " + it + '\n'), null, (int)2, null);
        }
        FilesKt.appendText$default((File)logFile, (String)"\n", null, (int)2, null);
    }

    private final void logDirtyFilesByDeps(Collection<? extends File> dirtyFiles) {
        File it;
        if (!this.options.getIncrementalLog()) {
            return;
        }
        File logFile = new File(this.logsDir, "kspDirtySetByDeps.log");
        FilesKt.appendText$default((File)logFile, (String)("=== Build " + this.buildTime + " ===\n"), null, (int)2, null);
        FilesKt.appendText$default((File)logFile, (String)"Modified\n", null, (int)2, null);
        Iterable $this$forEach$iv = this.modified;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl = false;
            FilesKt.appendText$default((File)logFile, (String)("  " + it + '\n'), null, (int)2, null);
        }
        FilesKt.appendText$default((File)logFile, (String)"Removed\n", null, (int)2, null);
        $this$forEach$iv = this.removed;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl = false;
            FilesKt.appendText$default((File)logFile, (String)("  " + it + '\n'), null, (int)2, null);
        }
        FilesKt.appendText$default((File)logFile, (String)"Dirty\n", null, (int)2, null);
        $this$forEach$iv = dirtyFiles;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl = false;
            FilesKt.appendText$default((File)logFile, (String)("  " + it + '\n'), null, (int)2, null);
        }
        FilesKt.appendText$default((File)logFile, (String)"\n", null, (int)2, null);
    }

    private final void logDirtyFilesByOutputs(Collection<? extends File> dirtyFiles) {
        File it;
        if (!this.options.getIncrementalLog()) {
            return;
        }
        Set allOutputs = new LinkedHashSet();
        Set validOutputs = new LinkedHashSet();
        Iterable $this$forEach$iv = this.sourceToOutputsMap.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<File> outputs;
            File source = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(this.sourceToOutputsMap.get(source));
            if (!this.removed.contains(source)) {
                validOutputs.addAll(outputs);
            }
            allOutputs.addAll(outputs);
        }
        Set outputsToRemove = SetsKt.minus((Set)allOutputs, (Iterable)validOutputs);
        File logFile = new File(this.logsDir, "kspDirtySetByOutputs.log");
        FilesKt.appendText$default((File)logFile, (String)("=== Build " + this.buildTime + " ===\n"), null, (int)2, null);
        FilesKt.appendText$default((File)logFile, (String)"Dirty sources\n", null, (int)2, null);
        Iterable $this$forEach$iv2 = dirtyFiles;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (File)element$iv;
            boolean bl = false;
            FilesKt.appendText$default((File)logFile, (String)("  " + it + '\n'), null, (int)2, null);
        }
        FilesKt.appendText$default((File)logFile, (String)"Outputs to remove\n", null, (int)2, null);
        $this$forEach$iv2 = outputsToRemove;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (File)element$iv;
            boolean bl = false;
            FilesKt.appendText$default((File)logFile, (String)("  " + it + '\n'), null, (int)2, null);
        }
        FilesKt.appendText$default((File)logFile, (String)"\n", null, (int)2, null);
    }

    private final void logSourceToOutputs(Set<? extends File> outputs, Map<File, ? extends Set<? extends File>> sourceToOutputs) {
        boolean bl;
        Object source;
        if (!this.options.getIncrementalLog()) {
            return;
        }
        File logFile = new File(this.logsDir, "kspSourceToOutputs.log");
        FilesKt.appendText$default((File)logFile, (String)("=== Build " + this.buildTime + " ===\n"), null, (int)2, null);
        FilesKt.appendText$default((File)logFile, (String)"Accumulated source to outputs map\n", null, (int)2, null);
        Object $this$forEach$iv = this.sourceToOutputsMap.getKeys();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            source = (File)t;
            bl = false;
            FilesKt.appendText$default((File)logFile, (String)("  " + source + ":\n"), null, (int)2, null);
            Collection<File> collection = this.sourceToOutputsMap.get((File)source);
            Intrinsics.checkNotNull(collection);
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File output = (File)element$iv2;
                boolean bl2 = false;
                FilesKt.appendText$default((File)logFile, (String)("    " + output + '\n'), null, (int)2, null);
            }
        }
        FilesKt.appendText$default((File)logFile, (String)"\n", null, (int)2, null);
        FilesKt.appendText$default((File)logFile, (String)"Reprocessed sources and their outputs\n", null, (int)2, null);
        $this$forEach$iv = sourceToOutputs;
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            source = entry;
            bl = false;
            File source2 = (File)source.getKey();
            Set outputs2 = (Set)source.getValue();
            FilesKt.appendText$default((File)logFile, (String)("  " + source2 + ":\n"), null, (int)2, null);
            Iterable $this$forEach$iv3 = outputs2;
            boolean $i$f$forEach3 = false;
            for (Object element$iv4 : $this$forEach$iv3) {
                File it = (File)element$iv4;
                boolean bl3 = false;
                FilesKt.appendText$default((File)logFile, (String)("    " + it + '\n'), null, (int)2, null);
            }
        }
        FilesKt.appendText$default((File)logFile, (String)"\n", null, (int)2, null);
        FilesKt.appendText$default((File)logFile, (String)"All reprocessed outputs\n", null, (int)2, null);
        $this$forEach$iv = outputs;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            File it = (File)object;
            bl = false;
            FilesKt.appendText$default((File)logFile, (String)("  " + it + '\n'), null, (int)2, null);
        }
        FilesKt.appendText$default((File)logFile, (String)"\n", null, (int)2, null);
    }

    private final void logDirtyFiles(List<? extends KSFile> files, List<? extends KSFile> allFiles) {
        KSFile it;
        if (!this.options.getIncrementalLog()) {
            return;
        }
        File logFile = new File(this.logsDir, "kspDirtySet.log");
        FilesKt.appendText$default((File)logFile, (String)("=== Build " + this.buildTime + " ===\n"), null, (int)2, null);
        FilesKt.appendText$default((File)logFile, (String)"All Files\n", null, (int)2, null);
        Iterable $this$forEach$iv = allFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KSFile)element$iv;
            boolean bl = false;
            FilesKt.appendText$default((File)logFile, (String)("  " + this.getRelativeFile(it) + '\n'), null, (int)2, null);
        }
        FilesKt.appendText$default((File)logFile, (String)"Dirty:\n", null, (int)2, null);
        $this$forEach$iv = files;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KSFile)element$iv;
            boolean bl = false;
            FilesKt.appendText$default((File)logFile, (String)("  " + this.getRelativeFile(it) + '\n'), null, (int)2, null);
        }
        String string = "%.2f";
        Object[] objectArray = new Object[]{(double)files.size() / (double)allFiles.size() * (double)100};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        String percentage = string2;
        FilesKt.appendText$default((File)logFile, (String)("\nDirty / All: " + percentage + "%\n\n"), null, (int)2, null);
    }

    @NotNull
    public final Collection<KSFile> calcDirtyFiles(@NotNull List<? extends KSFile> ksFiles) {
        Intrinsics.checkNotNullParameter(ksFiles, (String)"ksFiles");
        IncrementalContext this_$iv = this;
        boolean $i$f$closeFilesOnException = false;
        try {
            boolean bl = false;
            if (!this.isIncremental) {
                return ksFiles;
            }
            if (!this.rebuild) {
                KSFile it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Set<File> dirtyFilesByDeps = this.calcDirtySetByDeps(ksFiles);
                this.logDirtyFilesByDeps((Collection<? extends File>)dirtyFilesByDeps);
                Set<File> dirtyFilesByOutputs = !((Collection)this.modified).isEmpty() ? this.calcDirtySetByOutputs(this.sourceToOutputsMap, SetsKt.plus((Set)SetsKt.plus(dirtyFilesByDeps, (Iterable)this.removed), (Object)this.anyChangesWildcard)) : this.calcDirtySetByOutputs(this.sourceToOutputsMap, SetsKt.plus(dirtyFilesByDeps, (Iterable)this.removed));
                this.logDirtyFilesByOutputs((Collection<? extends File>)dirtyFilesByOutputs);
                Iterable iterable = ksFiles;
                IncrementalContext incrementalContext = this;
                boolean $i$f$filter = false;
                void var10_10 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (KSFile)element$iv$iv;
                    boolean bl2 = false;
                    if (!dirtyFilesByOutputs.contains(this.getRelativeFile(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                incrementalContext.logDirtyFiles((List)destination$iv$iv, ksFiles);
                $this$filter$iv = ksFiles;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (KSFile)element$iv$iv;
                    boolean bl3 = false;
                    if (!dirtyFilesByOutputs.contains(this.getRelativeFile(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            this.collectDefinedSymbols((Collection<? extends KSFile>)ksFiles);
            this.logDirtyFiles(ksFiles, ksFiles);
            return ksFiles;
        }
        catch (Exception e$iv) {
            this_$iv.symbolsMap.close();
            this_$iv.sealedMap.close();
            this_$iv.symbolLookupCache.close();
            this_$iv.classLookupCache.close();
            this_$iv.sourceToOutputsMap.close();
            throw e$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSourceToOutputs(Collection<? extends File> dirtyFiles, Set<? extends File> outputs, Map<File, ? extends Set<? extends File>> sourceToOutputs, List<? extends File> removedOutputs) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$forEach$iv = this.removed;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.sourceToOutputsMap.remove(it);
        }
        Iterable $this$filterNot$iv = dirtyFiles;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (sourceToOutputs.containsKey(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.sourceToOutputsMap.remove(it);
        }
        $this$forEach$iv = removedOutputs;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.sourceToOutputsMap.remove(it);
        }
        sourceToOutputs.forEach((arg_0, arg_1) -> IncrementalContext.updateSourceToOutputs$lambda-43(this, arg_0, arg_1));
        this.logSourceToOutputs(outputs, sourceToOutputs);
        this.sourceToOutputsMap.flush(false);
    }

    private final void updateOutputs(Set<? extends File> outputs, Collection<? extends File> cleanOutputs) {
        File outRoot = this.options.getKspOutputDir();
        File bakRoot = new File(this.options.getCachesDir(), "backups");
        Iterable $this$forEach$iv = outputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File generated = (File)element$iv;
            boolean bl = false;
            IncrementalContext.updateOutputs$copy(IncrementalContext.updateOutputs$abs(generated, this), IncrementalContext.updateOutputs$bak(generated, bakRoot, outRoot, this), true);
        }
        $this$forEach$iv = cleanOutputs;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File dst = (File)element$iv;
            boolean bl = false;
            if (outputs.contains(dst)) continue;
            IncrementalContext.updateOutputs$copy(IncrementalContext.updateOutputs$bak(dst, bakRoot, outRoot, this), IncrementalContext.updateOutputs$abs(dst, this), false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCaches(Collection<? extends File> dirtyFiles, Set<? extends File> outputs, Map<File, ? extends Set<? extends File>> sourceToOutputs) {
        void $this$filterNotTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = dirtyFiles;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            Collection collection = this.sourceToOutputsMap.get(it);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List oldOutputs = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $this$filterNot$iv = oldOutputs;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (outputs.contains(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List removedOutputs = (List)destination$iv$iv2;
        this.updateSourceToOutputs(dirtyFiles, outputs, sourceToOutputs, removedOutputs);
        this.updateLookupCache(dirtyFiles, removedOutputs);
        if (!this.rebuild) {
            IncrementalContext.updateCaches$update(this.sealedMap, this.updatedSealed);
            IncrementalContext.updateCaches$remove(this.sealedMap, SetsKt.plus(this.removed, (Iterable)removedOutputs));
            IncrementalContext.updateCaches$update(this.symbolsMap, this.updatedSymbols);
            IncrementalContext.updateCaches$remove(this.symbolsMap, SetsKt.plus(this.removed, (Iterable)removedOutputs));
        } else {
            this.symbolsMap.clean();
            IncrementalContext.updateCaches$update(this.symbolsMap, this.updatedSymbols);
            this.sealedMap.clean();
            IncrementalContext.updateCaches$update(this.sealedMap, this.updatedSealed);
        }
        this.symbolsMap.flush(false);
        this.symbolsMap.close();
        this.sealedMap.flush(false);
        this.sealedMap.close();
    }

    public final void registerGeneratedFiles(@NotNull Collection<? extends KSFile> newFiles) {
        Intrinsics.checkNotNullParameter(newFiles, (String)"newFiles");
        IncrementalContext this_$iv = this;
        boolean $i$f$closeFilesOnException = false;
        try {
            boolean bl = false;
            if (this.isIncremental) {
                this.collectDefinedSymbols(newFiles);
            }
        }
        catch (Exception e$iv) {
            this_$iv.symbolsMap.close();
            this_$iv.sealedMap.close();
            this_$iv.symbolLookupCache.close();
            this_$iv.classLookupCache.close();
            this_$iv.sourceToOutputsMap.close();
            throw e$iv;
        }
    }

    private final <T> T closeFilesOnException(Function0<? extends T> f) {
        boolean $i$f$closeFilesOnException = false;
        try {
            return (T)f.invoke();
        }
        catch (Exception e) {
            this.symbolsMap.close();
            this.sealedMap.close();
            this.symbolLookupCache.close();
            this.classLookupCache.close();
            this.sourceToOutputsMap.close();
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCachesAndOutputs(@NotNull Collection<? extends KSFile> dirtyFiles, @NotNull Set<? extends File> outputs, @NotNull Map<File, ? extends Set<? extends File>> sourceToOutputs) {
        Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        Intrinsics.checkNotNullParameter(sourceToOutputs, (String)"sourceToOutputs");
        IncrementalContext this_$iv = this;
        boolean $i$f$closeFilesOnException = false;
        try {
            void $this$mapTo$iv$iv;
            boolean bl;
            boolean bl2 = false;
            if (!this.isIncremental) {
                return;
            }
            this.cachesUpToDateFile.delete();
            boolean bl3 = bl = !this.cachesUpToDateFile.exists();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Iterable $this$map$iv = dirtyFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KSFile kSFile = (KSFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(this.getRelativeFile((KSFile)it));
            }
            List dirtyFilePaths = (List)destination$iv$iv;
            this.updateCaches(dirtyFilePaths, outputs, sourceToOutputs);
            Set cleanOutputs = new LinkedHashSet();
            Iterable $this$forEach$iv = this.sourceToOutputsMap.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File source = (File)element$iv;
                boolean bl5 = false;
                if (dirtyFilePaths.contains(source) || Intrinsics.areEqual((Object)source, (Object)this.anyChangesWildcard)) continue;
                Collection<File> collection = this.sourceToOutputsMap.get(source);
                Intrinsics.checkNotNull(collection);
                cleanOutputs.addAll(collection);
            }
            this.sourceToOutputsMap.close();
            this.updateOutputs(outputs, cleanOutputs);
            this.cachesUpToDateFile.createNewFile();
            boolean bl6 = this.cachesUpToDateFile.exists();
            if (_Assertions.ENABLED && !bl6) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        catch (Exception e$iv) {
            this_$iv.symbolsMap.close();
            this_$iv.sealedMap.close();
            this_$iv.symbolLookupCache.close();
            this_$iv.classLookupCache.close();
            this_$iv.sourceToOutputsMap.close();
            throw e$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void recordLookup(@NotNull PsiJavaFile psiFile, @NotNull String fqn) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        String string = psiFile.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiFile.virtualFile.path");
        String path = string;
        String name2 = StringsKt.substringAfterLast$default((String)fqn, (char)'.', null, (int)2, null);
        String scope = StringsKt.substringBeforeLast((String)fqn, (char)'.', (String)"<anonymous>");
        IncrementalContext.recordLookup$record(this, path, scope, name2);
        PsiElement[] psiElementArray = psiFile.getOnDemandImports(false, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"psiFile.getOnDemandImports(false, false)");
        Object[] $this$mapNotNull$iv = psiElementArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            PsiPackage psiPackage = it instanceof PsiPackage ? (PsiPackage)it : null;
            if ((psiPackage != null ? psiPackage.getQualifiedName() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List onDemandImports = (List)destination$iv$iv;
        if (onDemandImports.contains(scope)) {
            String string2 = psiFile.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"psiFile.packageName");
            IncrementalContext.recordLookup$record(this, path, string2, name2);
            Iterable $this$forEach$iv = onDemandImports;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                IncrementalContext.recordLookup$record(this, path, it, name2);
            }
        }
    }

    private final void recordLookup(PsiClassReferenceType ref, PsiClass def) {
        block1: {
            PsiFile psiFile = ref.getReference().getContainingFile();
            PsiJavaFile psiJavaFile = psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
            if (psiJavaFile == null) {
                return;
            }
            PsiJavaFile psiFile2 = psiJavaFile;
            String string = def.getQualifiedName();
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            this.recordLookup(psiFile2, it);
        }
    }

    public final void recordLookup(@NotNull PsiType ref) {
        block4: {
            PsiType psiType;
            block5: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                    psiType = ref;
                    if (!(psiType instanceof PsiArrayType)) break block3;
                    PsiType psiType2 = ((PsiArrayType)ref).getComponentType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"ref.componentType");
                    this.recordLookup(psiType2);
                    break block4;
                }
                if (!(psiType instanceof PsiClassReferenceType)) break block5;
                PsiClass psiClass = ((PsiClassReferenceType)ref).resolve();
                if (psiClass == null) {
                    return;
                }
                PsiClass def = psiClass;
                this.recordLookup((PsiClassReferenceType)ref, def);
                Iterable iterable = ((PsiClassReferenceType)ref).typeArguments();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"ref.typeArguments()");
                Iterable $this$forEach$iv = iterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JvmType it = (JvmType)element$iv;
                    boolean bl = false;
                    if (!(it instanceof PsiType)) continue;
                    this.recordLookup((PsiType)it);
                }
                break block4;
            }
            if (!(psiType instanceof PsiWildcardType)) break block4;
            PsiType psiType3 = ((PsiWildcardType)ref).getBound();
            if (psiType3 != null) {
                PsiType it = psiType3;
                boolean bl = false;
                this.recordLookup(it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void recordLookupWithSupertypes(@NotNull KotlinType kotlinType) {
        KotlinType it;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        Iterable $this$mapNotNull$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)kotlinType), (Iterable)TypeUtilsKt.supertypes((KotlinType)kotlinType));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiClass it$iv$iv;
            PsiElement psiElement;
            PsiElement psiElement2;
            ClassifierDescriptor classifierDescriptor;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            it = (KotlinType)element$iv$iv;
            boolean bl2 = false;
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptor2, (String)"declarationDescriptor");
                psiElement2 = UtilsKt.findPsi((DeclarationDescriptor)classifierDescriptor);
            } else {
                psiElement2 = psiElement = null;
            }
            if ((psiElement instanceof PsiClass ? (PsiClass)psiElement : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiClass it2 = (PsiClass)element$iv;
            boolean bl = false;
            PsiClassType[] psiClassTypeArray = it2.getSuperTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"it.superTypes");
            Object[] $this$forEach$iv2 = psiClassTypeArray;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (PsiClassType)element$iv2;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.recordLookup((PsiType)it);
            }
        }
    }

    private final void recordLookupForJavaField(PsiField psi) {
        PsiType psiType = psi.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"psi.type");
        this.recordLookup(psiType);
    }

    /*
     * WARNING - void declaration
     */
    private final void recordLookupForJavaMethod(PsiMethod psi) {
        PsiParameter it;
        PsiParameter[] psiParameterArray = psi.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"psi.parameterList.parameters");
        Object[] $this$forEach$iv = psiParameterArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsiParameter)element$iv;
            boolean bl = false;
            PsiType psiType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"it.type");
            this.recordLookup(psiType);
        }
        PsiType psiType = psi.getReturnType();
        if (psiType != null) {
            PsiType it2 = psiType;
            boolean bl = false;
            this.recordLookup(it2);
        }
        PsiTypeParameter[] psiTypeParameterArray = psi.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"psi.typeParameters");
        $this$forEach$iv = psiTypeParameterArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$mapNotNullTo$iv$iv;
            it = (PsiTypeParameter)element$iv;
            boolean bl = false;
            JvmReferenceType[] jvmReferenceTypeArray = it.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)jvmReferenceTypeArray, (String)"it.bounds");
            Object $this$mapNotNull$iv = jvmReferenceTypeArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                PsiType it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl2 = false;
                JvmReferenceType it3 = (JvmReferenceType)element$iv$iv;
                boolean bl3 = false;
                if ((it3 instanceof PsiType ? (PsiType)it3 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiType it4 = (PsiType)element$iv2;
                boolean bl5 = false;
                this.recordLookup(it4);
            }
        }
    }

    public final void recordLookupForDeclaration(@NotNull KSDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KSDeclaration kSDeclaration = declaration2;
        if (kSDeclaration instanceof KSPropertyDeclarationJavaImpl) {
            this.recordLookupForJavaField(((KSPropertyDeclarationJavaImpl)declaration2).getPsi());
        } else if (kSDeclaration instanceof KSFunctionDeclarationJavaImpl) {
            this.recordLookupForJavaMethod(((KSFunctionDeclarationJavaImpl)declaration2).getPsi());
        }
    }

    public final void recordLookupForCallableMemberDescriptor(@NotNull CallableMemberDescriptor descriptor2) {
        PsiElement psi;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = psi = UtilsKt.findPsi((DeclarationDescriptor)descriptor2);
        if (psiElement instanceof PsiMethod) {
            this.recordLookupForJavaMethod((PsiMethod)psi);
        } else if (psiElement instanceof PsiField) {
            this.recordLookupForJavaField((PsiField)psi);
        }
    }

    public final void recordLookupForGetAllFunctions(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.recordLookupForGetAll(descriptor2, (Function1<? super PsiClass, Unit>)((Function1)new Function1<PsiClass, Unit>(this){
            final /* synthetic */ IncrementalContext this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull PsiClass it) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PsiMethod[] psiMethodArray = it.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"it.methods");
                Object[] objectArray = psiMethodArray;
                IncrementalContext incrementalContext = this.this$0;
                boolean $i$f$forEach = false;
                for (void element$iv : $this$forEach$iv) {
                    PsiMethod it2 = (PsiMethod)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    IncrementalContext.access$recordLookupForJavaMethod(incrementalContext, it2);
                }
            }
        }));
    }

    public final void recordLookupForGetAllProperties(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.recordLookupForGetAll(descriptor2, (Function1<? super PsiClass, Unit>)((Function1)new Function1<PsiClass, Unit>(this){
            final /* synthetic */ IncrementalContext this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull PsiClass it) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PsiField[] psiFieldArray = it.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"it.fields");
                Object[] objectArray = psiFieldArray;
                IncrementalContext incrementalContext = this.this$0;
                boolean $i$f$forEach = false;
                for (void element$iv : $this$forEach$iv) {
                    PsiField it2 = (PsiField)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    IncrementalContext.access$recordLookupForJavaField(incrementalContext, it2);
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void recordLookupForGetAll(@NotNull ClassDescriptor descriptor2, @NotNull Function1<? super PsiClass, Unit> doChild) {
        ClassDescriptor it;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(doChild, (String)"doChild");
        Iterable $this$mapNotNull$iv = CollectionsKt.plus((Collection)((Collection)DescriptorUtilsKt.getAllSuperclassesWithoutAny((ClassDescriptor)descriptor2)), (Object)descriptor2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiClass it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            it = (ClassDescriptor)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            PsiElement psiElement = UtilsKt.findPsi((DeclarationDescriptor)it);
            if ((psiElement instanceof PsiClass ? (PsiClass)psiElement : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiClass psiClass = (PsiClass)element$iv;
            boolean bl = false;
            PsiClassType[] psiClassTypeArray = psiClass.getSuperTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"psiClass.superTypes");
            Object[] $this$forEach$iv2 = psiClassTypeArray;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (PsiClassType)element$iv2;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.recordLookup((PsiType)it);
            }
            doChild.invoke((Object)psiClass);
        }
    }

    public final void recordGetSealedSubclasses(@NotNull KSClassDeclaration classDeclaration) {
        String string;
        String name2;
        block3: {
            block2: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
                name2 = classDeclaration.getSimpleName().asString();
                KSName kSName = classDeclaration.getQualifiedName();
                if (kSName == null || (string2 = kSName.asString()) == null) break block2;
                String it = string2;
                boolean bl = false;
                String string3 = it.substring(0, Math.max(it.length() - name2.length() - 1, 0));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = string3;
                if (string != null) break block3;
            }
            return;
        }
        String scope = string;
        KSFile kSFile = classDeclaration.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        this.updatedSealed.putValue((Object)this.getRelativeFile(kSFile), (Object)new LookupSymbol(name2, scope));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<String>> dumpLookupRecords$compiler_plugin() {
        Map map = new LinkedHashMap();
        Set set = ((LookupTrackerImpl)this.symbolLookupTracker).getLookups().entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"symbolLookupTracker as L\u2026rImpl).lookups.entrySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            Map.Entry e = (Map.Entry)element$iv;
            boolean bl = false;
            String key = ((LookupSymbol)e.getKey()).getScope() + '.' + ((LookupSymbol)e.getKey()).getName();
            Map map2 = map;
            Object v = e.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"e.value");
            Iterable $this$map$iv = (Iterable)v;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(this.PATH_CONVERTER.toFile((String)it).getPath());
            }
            List list = (List)destination$iv$iv;
            map2.put(key, list);
        }
        return map;
    }

    private static final void calcDirtySetByOutputs$visit(Set<File> visited, FileToFilesMap $sourceToOutputs, Map<File, Set<File>> outputToSources, File dirty) {
        block3: {
            if (visited.contains(dirty)) {
                return;
            }
            visited.add(dirty);
            Collection<File> collection = $sourceToOutputs.get(dirty);
            if (collection == null) break block3;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                Set<File> set = outputToSources.get(it);
                if (set == null) continue;
                Iterable $this$forEach$iv2 = set;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it2 = (File)element$iv2;
                    boolean bl2 = false;
                    IncrementalContext.calcDirtySetByOutputs$visit(visited, $sourceToOutputs, outputToSources, it2);
                }
            }
        }
    }

    private static final void updateSourceToOutputs$lambda-43(IncrementalContext this$0, File src, Set outs) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)outs, (String)"outs");
        this$0.sourceToOutputsMap.set(src, outs);
    }

    private static final File updateOutputs$abs(File $this$updateOutputs_u24abs, IncrementalContext this$0) {
        return new File(this$0.baseDir, $this$updateOutputs_u24abs.getPath());
    }

    private static final File updateOutputs$bak(File $this$updateOutputs_u24bak, File bakRoot, File outRoot, IncrementalContext this$0) {
        return new File(bakRoot, FilesKt.toRelativeString((File)IncrementalContext.updateOutputs$abs($this$updateOutputs_u24bak, this$0), (File)outRoot));
    }

    private static final void updateOutputs$copy(File src, File dst, boolean overwrite) {
        if (!dst.getParentFile().exists()) {
            File file = src.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"src.parentFile");
            File file2 = dst.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"dst.parentFile");
            IncrementalContext.updateOutputs$copy(file, file2, false);
        }
        if (overwrite) {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
            Files.copy(src.toPath(), dst.toPath(), copyOptionArray);
        } else {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
            Files.copy(src.toPath(), dst.toPath(), copyOptionArray);
        }
    }

    private static final <K extends Comparable<? super K>, V> void updateCaches$update(PersistentMap<K, Collection<V>> m, MultiMap<K, V> u) {
        Set set = u.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"u.keySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Comparable it = (Comparable)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Collection collection = u.get((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"u[it]");
            m.set(it, CollectionsKt.toSet((Iterable)collection));
        }
    }

    private static final <K extends Comparable<? super K>, V> void updateCaches$remove(PersistentMap<K, Collection<V>> m, Collection<? extends K> removedKeys) {
        Iterable $this$forEach$iv = removedKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Comparable it = (Comparable)element$iv;
            boolean bl = false;
            m.remove(it);
        }
    }

    private static final void recordLookup$record(IncrementalContext this$0, String path, String scope, String name2) {
        this$0.symbolLookupTracker.record(path, Position.Companion.getNO_POSITION(), scope, ScopeKind.PACKAGE, name2);
    }

    public static final /* synthetic */ void access$recordLookupForJavaMethod(IncrementalContext $this, PsiMethod psi) {
        $this.recordLookupForJavaMethod(psi);
    }

    public static final /* synthetic */ void access$recordLookupForJavaField(IncrementalContext $this, PsiField psi) {
        $this.recordLookupForJavaField(psi);
    }

    public static final /* synthetic */ MultiMap access$getUpdatedSymbols$p(IncrementalContext $this) {
        return $this.updatedSymbols;
    }

    public static final /* synthetic */ File access$getRelativeFile(IncrementalContext $this, KSFile $receiver) {
        return $this.getRelativeFile($receiver);
    }
}

