/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp;

import com.google.devtools.ksp.AbstractKotlinSymbolProcessingExtension;
import com.google.devtools.ksp.AnyChanges;
import com.google.devtools.ksp.IncrementalContext;
import com.google.devtools.ksp.KspOptions;
import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.processing.SymbolProcessorProvider;
import com.google.devtools.ksp.processing.impl.CodeGeneratorImpl;
import com.google.devtools.ksp.processing.impl.KSPCompilationError;
import com.google.devtools.ksp.processing.impl.MessageCollectorBasedKSPLogger;
import com.google.devtools.ksp.processing.impl.ResolverImpl;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.Origin;
import com.google.devtools.ksp.symbol.impl.KSObjectCacheManager;
import com.google.devtools.ksp.symbol.impl.UtilsKt;
import com.google.devtools.ksp.symbol.impl.java.KSFileJavaImpl;
import com.google.devtools.ksp.symbol.impl.kotlin.KSFileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.extensions.AnalysisHandlerExtension;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 `2\u00020\u0001:\u0001`B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ@\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S032\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0016J \u0010X\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020M2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZH\u0002J\u000e\u0010\\\u001a\b\u0012\u0004\u0012\u00020@0\u001aH&J\b\u0010]\u001a\u00020\u0007H\u0002J\f\u0010^\u001a\u00020\u0007*\u00020\u0005H\u0002J\f\u0010_\u001a\u00020[*\u00020\u0005H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R#\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\u0010R\u001a\u0010\"\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010$\"\u0004\b/\u0010&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R \u00102\u001a\b\u0012\u0004\u0012\u00020\f03X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R \u0010:\u001a\b\u0012\u0004\u0012\u00020\u00190\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R \u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010<\"\u0004\bB\u0010>R\u001a\u0010C\u001a\u00020DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010$\u00a8\u0006a"}, d2={"Lcom/google/devtools/ksp/AbstractKotlinSymbolProcessingExtension;", "Lorg/jetbrains/kotlin/resolve/extensions/AnalysisHandlerExtension;", "options", "Lcom/google/devtools/ksp/KspOptions;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "testMode", "", "(Lcom/google/devtools/ksp/KspOptions;Lcom/google/devtools/ksp/processing/KSPLogger;Z)V", "annotationProcessingComplete", "cleanFilenames", "", "", "getCleanFilenames", "()Ljava/util/Set;", "setCleanFilenames", "(Ljava/util/Set;)V", "codeGenerator", "Lcom/google/devtools/ksp/processing/impl/CodeGeneratorImpl;", "getCodeGenerator", "()Lcom/google/devtools/ksp/processing/impl/CodeGeneratorImpl;", "setCodeGenerator", "(Lcom/google/devtools/ksp/processing/impl/CodeGeneratorImpl;)V", "deferredSymbols", "", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "getDeferredSymbols", "()Ljava/util/Map;", "dirtyFiles", "Lcom/google/devtools/ksp/symbol/KSFile;", "getDirtyFiles", "setDirtyFiles", "finished", "getFinished", "()Z", "setFinished", "(Z)V", "incrementalContext", "Lcom/google/devtools/ksp/IncrementalContext;", "getIncrementalContext", "()Lcom/google/devtools/ksp/IncrementalContext;", "setIncrementalContext", "(Lcom/google/devtools/ksp/IncrementalContext;)V", "initialized", "getInitialized", "setInitialized", "getLogger", "()Lcom/google/devtools/ksp/processing/KSPLogger;", "newFileNames", "", "getNewFileNames", "()Ljava/util/Collection;", "setNewFileNames", "(Ljava/util/Collection;)V", "getOptions", "()Lcom/google/devtools/ksp/KspOptions;", "processors", "getProcessors", "()Ljava/util/List;", "setProcessors", "(Ljava/util/List;)V", "providers", "Lcom/google/devtools/ksp/processing/SymbolProcessorProvider;", "getProviders", "setProviders", "rounds", "", "getRounds", "()I", "setRounds", "(I)V", "getTestMode", "doAnalysis", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "projectContext", "Lorg/jetbrains/kotlin/context/ProjectContext;", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "componentProvider", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "handleException", "call", "Lkotlin/Function0;", "", "loadProviders", "setAnnotationProcessingComplete", "hasError", "reportAll", "Companion", "compiler-plugin"})
public abstract class AbstractKotlinSymbolProcessingExtension
implements AnalysisHandlerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KspOptions options;
    @NotNull
    private final KSPLogger logger;
    private final boolean testMode;
    private boolean initialized;
    private boolean finished;
    @NotNull
    private final Map<SymbolProcessor, List<KSAnnotated>> deferredSymbols;
    public List<? extends SymbolProcessorProvider> providers;
    public List<? extends SymbolProcessor> processors;
    public IncrementalContext incrementalContext;
    public Set<? extends KSFile> dirtyFiles;
    public Set<String> cleanFilenames;
    public CodeGeneratorImpl codeGenerator;
    @NotNull
    private Collection<String> newFileNames;
    private int rounds;
    private boolean annotationProcessingComplete;
    @NotNull
    private static final String KSP_PACKAGE_NAME = "com.google.devtools.ksp";
    private static final int MULTI_ROUND_THRESHOLD = 100;

    public AbstractKotlinSymbolProcessingExtension(@NotNull KspOptions options, @NotNull KSPLogger logger, boolean testMode) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.options = options;
        this.logger = logger;
        this.testMode = testMode;
        boolean bl = false;
        this.deferredSymbols = new LinkedHashMap();
        this.newFileNames = SetsKt.emptySet();
    }

    @NotNull
    public final KspOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final KSPLogger getLogger() {
        return this.logger;
    }

    public final boolean getTestMode() {
        return this.testMode;
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public final void setFinished(boolean bl) {
        this.finished = bl;
    }

    @NotNull
    public final Map<SymbolProcessor, List<KSAnnotated>> getDeferredSymbols() {
        return this.deferredSymbols;
    }

    @NotNull
    public final List<SymbolProcessorProvider> getProviders() {
        List<SymbolProcessorProvider> list = this.providers;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"providers");
        return null;
    }

    public final void setProviders(@NotNull List<? extends SymbolProcessorProvider> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.providers = list;
    }

    @NotNull
    public final List<SymbolProcessor> getProcessors() {
        List<SymbolProcessor> list = this.processors;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"processors");
        return null;
    }

    public final void setProcessors(@NotNull List<? extends SymbolProcessor> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.processors = list;
    }

    @NotNull
    public final IncrementalContext getIncrementalContext() {
        IncrementalContext incrementalContext = this.incrementalContext;
        if (incrementalContext != null) {
            return incrementalContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"incrementalContext");
        return null;
    }

    public final void setIncrementalContext(@NotNull IncrementalContext incrementalContext) {
        Intrinsics.checkNotNullParameter((Object)incrementalContext, (String)"<set-?>");
        this.incrementalContext = incrementalContext;
    }

    @NotNull
    public final Set<KSFile> getDirtyFiles() {
        Set<KSFile> set = this.dirtyFiles;
        if (set != null) {
            return set;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dirtyFiles");
        return null;
    }

    public final void setDirtyFiles(@NotNull Set<? extends KSFile> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.dirtyFiles = set;
    }

    @NotNull
    public final Set<String> getCleanFilenames() {
        Set<String> set = this.cleanFilenames;
        if (set != null) {
            return set;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cleanFilenames");
        return null;
    }

    public final void setCleanFilenames(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.cleanFilenames = set;
    }

    @NotNull
    public final CodeGeneratorImpl getCodeGenerator() {
        CodeGeneratorImpl codeGeneratorImpl = this.codeGenerator;
        if (codeGeneratorImpl != null) {
            return codeGeneratorImpl;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"codeGenerator");
        return null;
    }

    public final void setCodeGenerator(@NotNull CodeGeneratorImpl codeGeneratorImpl) {
        Intrinsics.checkNotNullParameter((Object)codeGeneratorImpl, (String)"<set-?>");
        this.codeGenerator = codeGeneratorImpl;
    }

    @NotNull
    public final Collection<String> getNewFileNames() {
        return this.newFileNames;
    }

    public final void setNewFileNames(@NotNull Collection<String> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.newFileNames = collection;
    }

    public final int getRounds() {
        return this.rounds;
    }

    public final void setRounds(int n) {
        this.rounds = n;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public AnalysisResult doAnalysis(@NotNull Project project, @NotNull ModuleDescriptor module, @NotNull ProjectContext projectContext, @NotNull Collection<? extends KtFile> files, @NotNull BindingTrace bindingTrace, @NotNull ComponentProvider componentProvider) {
        AnalysisResult analysisResult;
        BindingContext bindingContext;
        Object element$iv;
        Object $this$mapTo$iv$iv;
        Map<SymbolProcessor, List<KSAnnotated>> $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        Collection<PsiJavaFile> collection;
        KSAnnotated kSAnnotated;
        Object element$iv$iv5;
        Iterator $this$mapNotNullTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$filterTo$iv$iv22;
        AnalysisResult $this$filter$iv2;
        Object object2;
        Object object3;
        PsiJavaFile it;
        Object object4;
        Iterable $this$mapTo$iv$iv2;
        boolean bl;
        boolean bl2;
        PsiJavaFile psiJavaFile;
        PsiFile psiFile;
        Object element$iv$iv22;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv;
        Iterable $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv;
        Iterable $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)projectContext, (String)"projectContext");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkNotNullParameter((Object)componentProvider, (String)"componentProvider");
        AbstractKotlinSymbolProcessingExtension abstractKotlinSymbolProcessingExtension = this;
        int n = abstractKotlinSymbolProcessingExtension.rounds;
        abstractKotlinSymbolProcessingExtension.rounds = n + 1;
        if (this.rounds > 100) {
            KSPLogger.DefaultImpls.warn$default((KSPLogger)this.logger, (String)"Current processing rounds exceeds 100, check processors for potential infinite rounds", null, (int)2, null);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(project)");
        PsiManager psiManager2 = psiManager;
        if (this.initialized) {
            psiManager2.dropPsiCaches();
        }
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        List javaSourceRoots = this.initialized ? CollectionsKt.plus((Collection)this.options.getJavaSourceRoots(), (Object)this.options.getJavaOutputDir()) : this.options.getJavaSourceRoots();
        Iterable iterable = javaSourceRoots;
        boolean $i$f$sortedBy = false;
        boolean bl3 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                Comparable comparable = Boolean.valueOf(Files.isSymbolicLink(it.toPath()));
                it = (File)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Boolean bl3 = Files.isSymbolicLink(it.toPath());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)bl3);
            }
        });
        boolean $i$f$flatMap = false;
        void var13_15 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv3 : $this$flatMapTo$iv$iv2) {
            File root = (File)element$iv$iv3;
            boolean bl4 = false;
            Iterable list$iv$iv = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)root, null, (int)1, null)), (Function1)doAnalysis.javaFiles.2.1.INSTANCE));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$sortedBy = false;
        boolean $this$flatMapTo$iv$iv2 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                Comparable comparable = Boolean.valueOf(Files.isSymbolicLink(it.toPath()));
                it = (File)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Boolean bl3 = Files.isSymbolicLink(it.toPath());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)bl3);
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            File it2 = (File)e$iv;
            boolean bl5 = false;
            String key$iv = it2.getCanonicalPath();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$mapNotNull = false;
        set$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            PsiFile psiFile2;
            element$iv$iv22 = element$iv$iv$iv;
            boolean bl6 = false;
            File it3 = (File)element$iv$iv22;
            boolean bl7 = false;
            VirtualFile virtualFile = localFileSystem.findFileByPath(it3.getPath());
            if (virtualFile == null) {
                psiFile2 = null;
            } else {
                VirtualFile virtualFile2 = virtualFile;
                boolean bl8 = false;
                boolean bl9 = false;
                VirtualFile it4 = virtualFile2;
                boolean bl10 = false;
                psiFile2 = psiManager2.findFile(it4);
            }
            psiFile = psiFile2;
            if ((psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null) == null) continue;
            psiJavaFile = psiJavaFile;
            bl2 = false;
            bl = false;
            PsiJavaFile it$iv$iv = psiJavaFile;
            boolean bl11 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List javaFiles2 = (List)destination$iv$iv;
        AnyChanges anyChangesWildcard = new AnyChanges(this.options.getProjectBaseDir());
        Iterable $this$map$iv2 = files;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            element$iv$iv22 = (KtFile)item$iv$iv;
            object4 = destination$iv$iv2;
            boolean bl12 = false;
            object3 = KSFileImpl.Companion.getCached((KtFile)it);
            object4.add(object3);
        }
        $this$map$iv2 = javaFiles2;
        object4 = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (PsiJavaFile)item$iv$iv;
            object3 = destination$iv$iv2;
            boolean bl13 = false;
            object2 = KSFileJavaImpl.Companion.getCached(it);
            object3.add(object2);
        }
        object3 = (List)destination$iv$iv2;
        List ksFiles = CollectionsKt.plus((Collection)object4, (Iterable)((Iterable)object3));
        Ref.ObjectRef newFiles = new Ref.ObjectRef();
        Iterable $i$f$map2 = ksFiles;
        object4 = newFiles;
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv32 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv22 : $this$filterTo$iv$iv22) {
            KSFile it5 = (KSFile)element$iv$iv22;
            boolean bl14 = false;
            if (!this.getNewFileNames().contains(it5.getFilePath())) continue;
            destination$iv$iv32.add(element$iv$iv22);
        }
        ((Ref.ObjectRef)object4).element = object3 = (List)destination$iv$iv32;
        $this$filter$iv2 = this.handleException(project, (Function0<Unit>)((Function0)new Function0<Unit>(this, componentProvider, anyChangesWildcard, (List<? extends KSFile>)ksFiles, (Ref.ObjectRef<List<KSFile>>)newFiles){
            final /* synthetic */ AbstractKotlinSymbolProcessingExtension this$0;
            final /* synthetic */ ComponentProvider $componentProvider;
            final /* synthetic */ AnyChanges $anyChangesWildcard;
            final /* synthetic */ List<KSFile> $ksFiles;
            final /* synthetic */ Ref.ObjectRef<List<KSFile>> $newFiles;
            {
                this.this$0 = $receiver;
                this.$componentProvider = $componentProvider;
                this.$anyChangesWildcard = $anyChangesWildcard;
                this.$ksFiles = $ksFiles;
                this.$newFiles = $newFiles;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                if (!this.this$0.getInitialized()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$filterNotTo$iv$iv;
                    Iterable $this$filterNot$iv;
                    this.this$0.setIncrementalContext(new IncrementalContext(this.this$0.getOptions(), this.$componentProvider, FilesKt.relativeTo((File)new File(this.$anyChangesWildcard.getFilePath()), (File)this.this$0.getOptions().getProjectBaseDir())));
                    this.this$0.setDirtyFiles(CollectionsKt.toSet((Iterable)this.this$0.getIncrementalContext().calcDirtyFiles(this.$ksFiles)));
                    Iterable iterable = this.$ksFiles;
                    AbstractKotlinSymbolProcessingExtension abstractKotlinSymbolProcessingExtension = this.this$0;
                    AbstractKotlinSymbolProcessingExtension abstractKotlinSymbolProcessingExtension2 = this.this$0;
                    boolean $i$f$filterNot22 = false;
                    void var4_7 = $this$filterNot$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        KSFile it = (KSFile)element$iv$iv;
                        boolean bl = false;
                        if (abstractKotlinSymbolProcessingExtension.getDirtyFiles().contains(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Collection<String> collection = (List)destination$iv$iv;
                    $this$filterNot$iv = collection;
                    boolean $i$f$map = false;
                    void $i$f$filterNot22 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Object element$iv$iv;
                        element$iv$iv = (KSFile)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl = false;
                        String string = it.getFilePath();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv2;
                    abstractKotlinSymbolProcessingExtension2.setCleanFilenames(CollectionsKt.toSet((Iterable)collection));
                    this.$newFiles.element = CollectionsKt.toList((Iterable)this.this$0.getDirtyFiles());
                } else {
                    this.this$0.getIncrementalContext().registerGeneratedFiles((Collection)this.$newFiles.element);
                }
            }
        }));
        if ($this$filter$iv2 != null) {
            AnalysisResult $i$f$filter2 = $this$filter$iv2;
            boolean $this$filterTo$iv$iv22 = false;
            boolean destination$iv$iv32 = false;
            AnalysisResult it6 = $i$f$filter2;
            boolean bl15 = false;
            return it6;
        }
        Iterable $i$f$filter2 = ksFiles;
        object2 = module;
        boolean $i$f$filterNot2 = false;
        destination$iv$iv32 = $this$filterNot$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv4 : $this$filterNotTo$iv$iv) {
            KSFile it7 = (KSFile)element$iv$iv4;
            boolean bl16 = false;
            if (this.getCleanFilenames().contains(it7.getFilePath())) continue;
            destination$iv$iv4.add(element$iv$iv4);
        }
        List list = (List)destination$iv$iv4;
        KspOptions kspOptions = this.options;
        IncrementalContext incrementalContext = this.getIncrementalContext();
        ComponentProvider componentProvider2 = componentProvider;
        Project project2 = project;
        BindingTrace bindingTrace2 = bindingTrace;
        Map<SymbolProcessor, List<KSAnnotated>> map = this.deferredSymbols;
        Collection collection2 = (Collection)newFiles.element;
        Collection collection3 = list;
        KSFileJavaImpl kSFileJavaImpl = object2;
        ResolverImpl resolver = new ResolverImpl((ModuleDescriptor)kSFileJavaImpl, collection3, collection2, map, bindingTrace2, project2, componentProvider2, incrementalContext, kspOptions);
        List<SymbolProcessorProvider> providers = this.loadProviders();
        if (!this.initialized) {
            void $this$mapNotNull$iv2;
            this.setCodeGenerator(new CodeGeneratorImpl(this.options.getClassOutputDir(), this.options.getJavaOutputDir(), this.options.getKotlinOutputDir(), this.options.getResourceOutputDir(), this.options.getProjectBaseDir(), anyChangesWildcard, ksFiles));
            Iterable $i$f$filterNot2 = providers;
            object4 = this;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv4 = $this$mapNotNull$iv2;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator bl16 = $this$forEach$iv$iv$iv2.iterator();
            while (bl16.hasNext()) {
                PsiJavaFile psiJavaFile2;
                Object element$iv$iv$iv;
                element$iv$iv5 = element$iv$iv$iv = bl16.next();
                boolean bl17 = false;
                SymbolProcessorProvider provider = (SymbolProcessorProvider)element$iv$iv5;
                boolean bl18 = false;
                Ref.ObjectRef processor = new Ref.ObjectRef();
                psiFile = this.handleException(project, (Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef<SymbolProcessor>)processor, provider, this){
                    final /* synthetic */ Ref.ObjectRef<SymbolProcessor> $processor;
                    final /* synthetic */ SymbolProcessorProvider $provider;
                    final /* synthetic */ AbstractKotlinSymbolProcessingExtension this$0;
                    {
                        this.$processor = $processor;
                        this.$provider = $provider;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$processor.element = this.$provider.create(new SymbolProcessorEnvironment(this.this$0.getOptions().getProcessingOptions(), KotlinVersion.CURRENT, (CodeGenerator)this.this$0.getCodeGenerator(), this.this$0.getLogger()));
                    }
                }));
                if (psiFile != null) {
                    psiJavaFile = psiFile;
                    bl2 = false;
                    bl = false;
                    PsiJavaFile analysisResult2 = psiJavaFile;
                    boolean bl19 = false;
                    return analysisResult2;
                }
                if (this.hasError(this.getLogger())) {
                    psiJavaFile2 = null;
                } else {
                    psiFile = (SymbolProcessor)processor.element;
                    if (psiFile == null) {
                        psiJavaFile2 = null;
                    } else {
                        psiJavaFile = psiFile;
                        bl2 = false;
                        bl = false;
                        PsiJavaFile it8 = psiJavaFile;
                        boolean bl20 = false;
                        kSAnnotated = this.getDeferredSymbols();
                        boolean bl21 = false;
                        collection = new ArrayList();
                        boolean bl22 = false;
                        kSAnnotated.put((SymbolProcessor)it8, (List<KSAnnotated>)collection);
                        psiJavaFile2 = psiJavaFile;
                    }
                }
                if (psiJavaFile2 == null) continue;
                object = psiJavaFile2;
                boolean bl23 = false;
                boolean bl24 = false;
                PsiJavaFile it$iv$iv = object;
                boolean bl25 = false;
                destination$iv$iv5.add(it$iv$iv);
            }
            object3 = (List)destination$iv$iv5;
            ((AbstractKotlinSymbolProcessingExtension)object4).setProcessors((List<? extends SymbolProcessor>)object3);
            this.initialized = true;
        }
        if (!this.hasError(this.logger)) {
            Iterable $this$forEach$iv = this.getProcessors();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                SymbolProcessor processor = (SymbolProcessor)element$iv2;
                boolean bl26 = false;
                AnalysisResult $i$f$forEach2 = this.handleException(project, (Function0<Unit>)((Function0)new Function0<Unit>(this, processor, resolver){
                    final /* synthetic */ AbstractKotlinSymbolProcessingExtension this$0;
                    final /* synthetic */ SymbolProcessor $processor;
                    final /* synthetic */ ResolverImpl $resolver;
                    {
                        this.this$0 = $receiver;
                        this.$processor = $processor;
                        this.$resolver = $resolver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$filterTo$iv$iv;
                        Map<SymbolProcessor, List<KSAnnotated>> map = this.this$0.getDeferredSymbols();
                        SymbolProcessor symbolProcessor = this.$processor;
                        Iterable $this$filter$iv = this.$processor.process((Resolver)this.$resolver);
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            KSAnnotated it = (KSAnnotated)element$iv$iv;
                            boolean bl = false;
                            if (!(it.getOrigin() == Origin.KOTLIN || it.getOrigin() == Origin.JAVA)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List list = (List)destination$iv$iv;
                        boolean bl = false;
                        map.put(symbolProcessor, list);
                    }
                }));
                if ($i$f$forEach2 != null) {
                    AnalysisResult bl16 = $i$f$forEach2;
                    boolean element$iv$iv$iv = false;
                    boolean element$iv$iv5 = false;
                    AnalysisResult it9 = bl16;
                    boolean bl27 = false;
                    return it9;
                }
                if (this.hasError(this.getLogger())) continue;
                if (this.getDeferredSymbols().containsKey(processor)) {
                    List<KSAnnotated> list2 = this.getDeferredSymbols().get(processor);
                    Intrinsics.checkNotNull(list2);
                    if (!list2.isEmpty()) continue;
                }
                this.getDeferredSymbols().remove(processor);
            }
        }
        Object $this$forEach$iv = this.getCodeGenerator().getGeneratedFile();
        object4 = this;
        boolean $i$f$filter3 = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv6 : $this$filterTo$iv$iv) {
            File it10 = (File)element$iv$iv6;
            boolean bl28 = false;
            if (!(Intrinsics.areEqual((Object)FilesKt.getExtension((File)it10), (Object)"kt") || Intrinsics.areEqual((Object)FilesKt.getExtension((File)it10), (Object)"java"))) continue;
            destination$iv$iv6.add(element$iv$iv6);
        }
        object3 = (List)destination$iv$iv6;
        $this$filter$iv = (Iterable)object3;
        boolean $i$f$map3 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator bl26 = $this$mapTo$iv$iv.iterator();
        while (bl26.hasNext()) {
            Object item$iv$iv = bl26.next();
            File it10 = (File)item$iv$iv;
            object3 = destination$iv$iv6;
            boolean bl29 = false;
            object2 = it10.getCanonicalPath();
            object3.add(object2);
        }
        object3 = (List)destination$iv$iv6;
        ((AbstractKotlinSymbolProcessingExtension)object4).newFileNames = CollectionsKt.toSet((Iterable)((Iterable)object3));
        if (this.getCodeGenerator().getGeneratedFile().isEmpty()) {
            this.finished = true;
        }
        KSObjectCacheManager.Companion.clear();
        this.getCodeGenerator().closeFiles$compiler_plugin();
        if (this.hasError(this.logger)) {
            this.finished = true;
            $this$forEach$iv = this.getProcessors();
            $i$f$forEach = false;
            $this$mapTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                element$iv = $this$mapTo$iv$iv.next();
                SymbolProcessor processor = (SymbolProcessor)element$iv;
                boolean bl30 = false;
                AnalysisResult analysisResult3 = this.handleException(project, (Function0<Unit>)((Function0)new Function0<Unit>(processor){
                    final /* synthetic */ SymbolProcessor $processor;
                    {
                        this.$processor = $processor;
                        super(0);
                    }

                    public final void invoke() {
                        this.$processor.onError();
                    }
                }));
                if (analysisResult3 == null) continue;
                AnalysisResult analysisResult4 = analysisResult3;
                boolean bl29 = false;
                boolean element$iv$iv5 = false;
                AnalysisResult it11 = analysisResult4;
                boolean bl31 = false;
                return it11;
            }
        } else if (this.finished) {
            $this$forEach$iv = this.getProcessors();
            $i$f$forEach = false;
            $this$mapTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                element$iv = $this$mapTo$iv$iv.next();
                SymbolProcessor processor = (SymbolProcessor)element$iv;
                boolean bl32 = false;
                AnalysisResult analysisResult5 = this.handleException(project, (Function0<Unit>)((Function0)new Function0<Unit>(processor){
                    final /* synthetic */ SymbolProcessor $processor;
                    {
                        this.$processor = $processor;
                        super(0);
                    }

                    public final void invoke() {
                        this.$processor.finish();
                    }
                }));
                if (analysisResult5 == null) continue;
                AnalysisResult analysisResult6 = analysisResult5;
                boolean bl29 = false;
                boolean element$iv$iv5 = false;
                AnalysisResult it12 = analysisResult6;
                boolean bl33 = false;
                return it12;
            }
            $this$forEach$iv = this.deferredSymbols;
            $i$f$forEach = false;
            if (!$this$forEach$iv.isEmpty()) {
                $this$map$iv = this.deferredSymbols;
                $i$f$map3 = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv6 = new ArrayList($this$map$iv.size());
                $i$f$mapTo = false;
                Object object5 = $this$mapTo$iv$iv;
                boolean bl34 = false;
                for (Map.Entry item$iv$iv : object5.entrySet()) {
                    void $this$mapTo$iv$iv3;
                    void $this$map$iv3;
                    void entry;
                    element$iv$iv5 = item$iv$iv;
                    object4 = destination$iv$iv6;
                    boolean bl35 = false;
                    Iterable bl33 = (Iterable)entry.getValue();
                    StringBuilder stringBuilder = new StringBuilder().append("Unable to process:").append((Object)Reflection.getOrCreateKotlinClass(entry.getKey().getClass()).getQualifiedName()).append(":   ");
                    KSPLogger kSPLogger = this.getLogger();
                    boolean $i$f$map4 = false;
                    psiJavaFile = $this$map$iv3;
                    Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                        void it13;
                        kSAnnotated = (KSAnnotated)item$iv$iv2;
                        collection = destination$iv$iv7;
                        boolean bl36 = false;
                        object = it13.toString();
                        collection.add((PsiJavaFile)object);
                    }
                    collection = (List)destination$iv$iv7;
                    KSPLogger.DefaultImpls.warn$default((KSPLogger)kSPLogger, (String)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)";", null, null, (int)0, null, null, (int)62, null)).toString(), null, (int)2, null);
                    object3 = Unit.INSTANCE;
                    object4.add(object3);
                }
                List cfr_ignored_0 = (List)destination$iv$iv6;
            }
            if (!this.hasError(this.logger)) {
                this.getIncrementalContext().updateCachesAndOutputs((Collection<? extends KSFile>)this.getDirtyFiles(), this.getCodeGenerator().getOutputs(), this.getCodeGenerator().getSourceToOutputs());
            }
        }
        if (this.finished) {
            this.reportAll(this.logger);
        }
        if (this.finished) {
            if (this.hasError(this.logger)) {
                bindingContext = BindingContext.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"EMPTY");
                analysisResult = AnalysisResult.Companion.compilationError(bindingContext);
            } else {
                bindingContext = BindingContext.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"EMPTY");
                analysisResult = AnalysisResult.Companion.success(bindingContext, module, false);
            }
        } else {
            bindingContext = BindingContext.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"EMPTY");
            analysisResult = (AnalysisResult)new AnalysisResult.RetryWithAdditionalRoots(bindingContext, module, CollectionsKt.listOf((Object)this.options.getJavaOutputDir()), CollectionsKt.listOf((Object)this.options.getKotlinOutputDir()), CollectionsKt.listOf((Object)this.options.getClassOutputDir()), false, 32, null);
        }
        return analysisResult;
    }

    @NotNull
    public abstract List<SymbolProcessorProvider> loadProviders();

    private final boolean setAnnotationProcessingComplete() {
        if (this.annotationProcessingComplete) {
            return true;
        }
        this.annotationProcessingComplete = true;
        return false;
    }

    private final void reportAll(KSPLogger $this$reportAll) {
        ((MessageCollectorBasedKSPLogger)$this$reportAll).reportAll();
    }

    private final boolean hasError(KSPLogger $this$hasError) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = ((MessageCollectorBasedKSPLogger)$this$hasError).getRecordedEvents();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MessageCollectorBasedKSPLogger.Event it = (MessageCollectorBasedKSPLogger.Event)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == CompilerMessageSeverity.ERROR || it.getSeverity() == CompilerMessageSeverity.EXCEPTION)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final AnalysisResult handleException(Project project, Function0<Unit> call) {
        try {
            call.invoke();
        }
        catch (Exception e) {
            if (e instanceof KSPCompilationError) {
                KSPLogger.DefaultImpls.error$default((KSPLogger)this.logger, (String)(UtilsKt.findLocationString(project, ((KSPCompilationError)e).getFile(), ((KSPCompilationError)e).getOffset()) + ": " + ((KSPCompilationError)e).getMessage()), null, (int)2, null);
                this.reportAll(this.logger);
                BindingContext bindingContext = BindingContext.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"EMPTY");
                return AnalysisResult.Companion.compilationError(bindingContext);
            }
            Object object = e.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.stackTrace");
            String string = ((StackTraceElement)ArraysKt.first((Object[])object)).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.stackTrace.first().className");
            if (StringsKt.startsWith$default((String)string, (String)KSP_PACKAGE_NAME, (boolean)false, (int)2, null)) {
                string = BindingContext.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EMPTY");
                return AnalysisResult.Companion.internalError((BindingContext)string, (Throwable)e);
            }
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            object = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sw.toString()");
            KSPLogger.DefaultImpls.error$default((KSPLogger)this.logger, (String)object, null, (int)2, null);
        }
        return null;
    }

    @Nullable
    public AnalysisResult analysisCompleted(@NotNull Project project, @NotNull ModuleDescriptor module, @NotNull BindingTrace bindingTrace, @NotNull Collection<? extends KtFile> files) {
        return AnalysisHandlerExtension.DefaultImpls.analysisCompleted((AnalysisHandlerExtension)this, (Project)project, (ModuleDescriptor)module, (BindingTrace)bindingTrace, files);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/google/devtools/ksp/AbstractKotlinSymbolProcessingExtension$Companion;", "", "()V", "KSP_PACKAGE_NAME", "", "MULTI_ROUND_THRESHOLD", "", "compiler-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

