/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.scopes.jvm.SignatureUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.load.java.SpecialGenericSignatures;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirAccidentalOverrideClashChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)V", "namesPossibleForRenamedBuiltin", "", "Lorg/jetbrains/kotlin/name/Name;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirAccidentalOverrideClashChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAccidentalOverrideClashChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirAccidentalOverrideClashChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,58:1\n39#2:59\n19#2,2:60\n*S KotlinDebug\n*F\n+ 1 FirAccidentalOverrideClashChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirAccidentalOverrideClashChecker\n*L\n29#1:59\n40#1:60,2\n*E\n"})
public final class FirAccidentalOverrideClashChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirAccidentalOverrideClashChecker INSTANCE = new FirAccidentalOverrideClashChecker();
    @NotNull
    private static final Set<Name> namesPossibleForRenamedBuiltin = CollectionsKt.toSet((Iterable)SpecialGenericSignatures.Companion.getJVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP().values());

    private FirAccidentalOverrideClashChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirSimpleFunction declaration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirMemberDeclaration $this$isOverride$iv = declaration2;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        Name name2 = declaration2.getName();
        boolean mayBeRenamedBuiltIn = namesPossibleForRenamedBuiltin.contains(name2);
        boolean mayBeSameAsBuiltInWithErasedParameters = SpecialGenericSignatures.Companion.getSameAsBuiltinMethodWithErasedValueParameters(name2);
        if (!mayBeRenamedBuiltIn && !mayBeSameAsBuiltInWithErasedParameters) {
            return;
        }
        FirRegularClass firRegularClass = ResolveUtilsKt.getContainingClass(declaration2);
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass containingClass = firRegularClass;
        Ref.BooleanRef reported = new Ref.BooleanRef();
        FirHelpersKt.unsubstitutedScope(context2, containingClass).processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirAccidentalOverrideClashChecker.check$lambda$0(reported, declaration2, mayBeRenamedBuiltIn, context2, reporter, arg_0)));
    }

    private static final Unit check$lambda$0(Ref.BooleanRef $reported, FirSimpleFunction $declaration, boolean $mayBeRenamedBuiltIn, CheckerContext $context, DiagnosticReporter $reporter, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirSimpleFunction hiddenFir = (FirSimpleFunction)it.getFir();
        if (!$reported.element && Intrinsics.areEqual((Object)DeprecationUtilsKt.isHiddenToOvercomeSignatureClash(hiddenFir), (Object)true)) {
            Modality modality$iv;
            FirMemberDeclaration $this$isFinal$iv = hiddenFir;
            boolean $i$f$isFinal = false;
            Modality modality = $this$isFinal$iv.getStatus().getModality();
            if (!(modality == null ? true : (modality$iv = modality) == Modality.FINAL) && Intrinsics.areEqual((Object)SignatureUtilsKt.computeJvmDescriptor$default($declaration, null, false, null, 7, null), (Object)SignatureUtilsKt.computeJvmDescriptor$default(hiddenFir, null, false, null, 7, null))) {
                FirNamedFunctionSymbol firNamedFunctionSymbol = ClassMembersKt.getInitialSignatureAttr(hiddenFir);
                if (firNamedFunctionSymbol == null) {
                    return Unit.INSTANCE;
                }
                FirNamedFunctionSymbol regularBase = firNamedFunctionSymbol;
                String description = $mayBeRenamedBuiltIn ? "a renamed function" : "a function with erased parameters";
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)$declaration.getSource(), FirJvmErrors.INSTANCE.getACCIDENTAL_OVERRIDE_CLASH_BY_JVM_SIGNATURE(), (Object)it, (Object)description, (Object)regularBase, null, 64, null);
                $reported.element = true;
            }
        }
        return Unit.INSTANCE;
    }
}

