/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverseDirection;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwareControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.PropertyAccessType;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.UnusedVariableAssignmentCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.VariableWriteData;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CapturedByValue;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0012\u0013\u0014\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fR\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "<init>", "()V", "analyze", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;)V", "ignoreWarnings", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getIgnoreWarnings", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "Data", "AddAllWrites", "FindCapturedWrites", "FindVisibleWrites", "RemoveVisibleWrites", "checkers"})
public final class UnusedVariableAssignmentChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final UnusedVariableAssignmentChecker INSTANCE = new UnusedVariableAssignmentChecker();

    private UnusedVariableAssignmentChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void analyze(@NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, @NotNull VariableInitializationInfoData data) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Set<FirVariableSymbol<?>> set = data.getProperties();
        Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.Set<org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol>");
        Set<FirVariableSymbol<?>> properties = set;
        Data ownData = new Data(properties);
        data.getGraph().traverse(new AddAllWrites(ownData));
        if (!((Collection)ownData.getUnreadWrites()).isEmpty()) {
            Map capturedWrites = CfgTraverserKt.traverseToFixedPoint(data.getGraph(), new FindCapturedWrites(properties));
            ownData.setWritesByNode(CfgTraverserKt.traverseToFixedPoint(data.getGraph(), new FindVisibleWrites(capturedWrites, properties)));
        }
        data.getGraph().traverse(new RemoveVisibleWrites(ownData));
        Set variablesWithUnobservedWrites = new LinkedHashSet();
        for (FirStatement entry : ownData.getUnreadWrites()) {
            if (entry instanceof FirVariableAssignment) {
                Object object = ReferenceUtilsKt.getCalleeReference((FirVariableAssignment)entry);
                if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) continue;
                Object variableSymbol = object;
                variablesWithUnobservedWrites.add(variableSymbol);
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirVariableAssignment)entry).getLValue().getSource(), FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ(), null, 8, null);
                continue;
            }
            if (!(entry instanceof FirProperty) || ownData.getVariablesWithoutReads().containsKey(((FirProperty)entry).getSymbol()) || this.getIgnoreWarnings(((FirProperty)entry).getSymbol())) continue;
            FirExpression firExpression = ((FirProperty)entry).getInitializer();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null), FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT(), null, 8, null);
        }
        for (Map.Entry entry : ownData.getVariablesWithoutReads().entrySet()) {
            FirPropertySymbol symbol = (FirPropertySymbol)entry.getKey();
            FirProperty fir = (FirProperty)entry.getValue();
            if (this.getIgnoreWarnings(symbol)) continue;
            FirExpression firExpression = fir.getInitializer();
            FirFunctionCall firFunctionCall = firExpression instanceof FirFunctionCall ? (FirFunctionCall)firExpression : null;
            if ((firFunctionCall != null ? FirHelpersKt.isIterator(firFunctionCall) : false) || Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter(fir), (Object)true)) continue;
            KtDiagnosticFactory0 error = variablesWithUnobservedWrites.contains(symbol) ? FirErrors.INSTANCE.getVARIABLE_NEVER_READ() : FirErrors.INSTANCE.getUNUSED_VARIABLE();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)fir.getSource(), error, null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getIgnoreWarnings(FirPropertySymbol $this$ignoreWarnings) {
        if (Intrinsics.areEqual((Object)$this$ignoreWarnings.getName(), (Object)SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) return true;
        if ($this$ignoreWarnings.getSource() == null) return true;
        KtSourceElement ktSourceElement = $this$ignoreWarnings.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredAugmentedAssign) return true;
        KtSourceElement ktSourceElement2 = $this$ignoreWarnings.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) return true;
        KtSourceElement ktSourceElement3 = $this$ignoreWarnings.getInitializerSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement3 != null ? ktSourceElement3.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$AddAllWrites;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$Data;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$Data;)V", "visitNode", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    private static final class AddAllWrites
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Data data;

        public AddAllWrites(@NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getFir().getName().isSpecial()) {
                return;
            }
            ControlFlowGraph graph2 = FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner());
            if (node.getFir().getInitializer() != null) {
                this.data.getUnreadWrites().add(node.getFir());
            }
            this.data.getVariableScopes().put(node.getFir().getSymbol(), graph2);
            this.data.getVariablesWithoutReads().put(node.getFir().getSymbol(), node.getFir());
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Object object = ReferenceUtilsKt.getCalleeReference(node.getFir());
            if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
                return;
            }
            Object propertySymbol = object;
            if (((FirCallableSymbol)propertySymbol).getName().isSpecial()) {
                return;
            }
            if (this.data.getLocalProperties().contains(propertySymbol)) {
                this.data.getUnreadWrites().add(node.getFir());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRb\u0010\t\u001aJ\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012<\u0012:\u0012\u0004\u0012\u00020\r\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\fj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u00100\fj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u00110\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\bR\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u001d\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$Data;", "", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "<init>", "(Ljava/util/Set;)V", "getLocalProperties", "()Ljava/util/Set;", "writesByNode", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/PropertyAccessType;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWriteData;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "getWritesByNode", "()Ljava/util/Map;", "setWritesByNode", "(Ljava/util/Map;)V", "unreadWrites", "", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getUnreadWrites", "variableScopes", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "getVariableScopes", "variablesWithoutReads", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getVariablesWithoutReads", "checkers"})
    private static final class Data {
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>>> writesByNode;
        @NotNull
        private final Set<FirStatement> unreadWrites;
        @NotNull
        private final Map<FirPropertySymbol, ControlFlowGraph> variableScopes;
        @NotNull
        private final Map<FirPropertySymbol, FirProperty> variablesWithoutReads;

        public Data(@NotNull Set<? extends FirPropertySymbol> localProperties) {
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            this.localProperties = localProperties;
            this.writesByNode = MapsKt.emptyMap();
            this.unreadWrites = new LinkedHashSet();
            this.variableScopes = new HashMap();
            this.variablesWithoutReads = new LinkedHashMap();
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Map<CFGNode<?>, PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>>> getWritesByNode() {
            return this.writesByNode;
        }

        public final void setWritesByNode(@NotNull Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.writesByNode = map;
        }

        @NotNull
        public final Set<FirStatement> getUnreadWrites() {
            return this.unreadWrites;
        }

        @NotNull
        public final Map<FirPropertySymbol, ControlFlowGraph> getVariableScopes() {
            return this.variableScopes;
        }

        @NotNull
        public final Map<FirPropertySymbol, FirProperty> getVariablesWithoutReads() {
            return this.variablesWithoutReads;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJx\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b2\"\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b2\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u00a0\u0001\u0010\u0010\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0015\u001a\u00020\u00162>\u0010\u0017\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0012H\u0016J\u0098\u0001\u0010\u0018\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0012*:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u00122\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00062\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0088\u0001\u0010\u001b\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u00122\u0006\u0010\u000e\u001a\u00020\u001c2>\u0010\u0017\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0012H\u0016J\u0088\u0001\u0010\u001d\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u00122\u0006\u0010\u000e\u001a\u00020\u001e2>\u0010\u0017\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0012H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindCapturedWrites;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/PropertyAccessType;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWriteData;", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "<init>", "(Ljava/util/Set;)V", "mergeInfo", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "a", "b", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitEdge", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "from", "to", "metadata", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;", "data", "add", "type", "symbol", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedVariableAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindCapturedWrites\n+ 2 PathAwareControlFlowGraphVisitor.kt\norg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitorKt\n+ 3 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n83#2:373\n84#2:375\n85#2:379\n87#2:382\n90#2:383\n53#3:374\n53#3:384\n413#4:376\n413#4:385\n1252#5,2:377\n1255#5:381\n1252#5,4:386\n1#6:380\n1#6:390\n*S KotlinDebug\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindCapturedWrites\n*L\n174#1:373\n174#1:375\n174#1:379\n174#1:382\n190#1:383\n174#1:374\n190#1:384\n174#1:376\n190#1:385\n174#1:377,2\n174#1:381\n190#1:386,4\n174#1:380\n*E\n"})
    private static final class FindCapturedWrites
    extends PathAwareControlFlowGraphVisitor<PropertyAccessType, VariableWriteData> {
        @NotNull
        private final Set<FirPropertySymbol> properties;

        public FindCapturedWrites(@NotNull Set<? extends FirPropertySymbol> properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            super(CfgTraverseDirection.Backward);
            this.properties = properties;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PersistentMap<PropertyAccessType, VariableWriteData> mergeInfo(@NotNull PersistentMap<PropertyAccessType, VariableWriteData> a2, @NotNull PersistentMap<PropertyAccessType, VariableWriteData> b2, @NotNull CFGNode<?> node) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            void $this$merge$iv;
            Intrinsics.checkNotNullParameter(a2, (String)"a");
            Intrinsics.checkNotNullParameter(b2, (String)"b");
            Intrinsics.checkNotNullParameter(node, (String)"node");
            PersistentMap<PropertyAccessType, VariableWriteData> persistentMap = a2;
            PersistentMap<PropertyAccessType, VariableWriteData> other$iv = b2;
            boolean $i$f$merge = false;
            void $this$mutate$iv$iv = $this$merge$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = builder2;
            boolean bl2 = false;
            Map map = other$iv;
            Map destination$iv$iv = it$iv;
            boolean $i$f$mapValuesTo = false;
            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Object object;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv$iv;
                boolean bl3 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl4 = false;
                Object label$iv = entry2.getKey();
                Object rightValue$iv = entry2.getValue();
                if ($this$merge$iv.get(label$iv) != null) {
                    void p1;
                    Object leftValue$iv;
                    boolean bl5 = false;
                    PersistentMap persistentMap2 = ((VariableWriteData)rightValue$iv).unbox-impl();
                    PersistentMap p0 = ((VariableWriteData)leftValue$iv).unbox-impl();
                    boolean bl6 = false;
                    object = VariableWriteData.box-impl(VariableWriteData.plus-JgvPeUI(p0, p1));
                } else {
                    object = rightValue$iv;
                }
                Object v2 = object;
                map3.put(k2, v2);
            }
            return builder2.build();
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitEdge(@NotNull CFGNode<?> from2, @NotNull CFGNode<?> to, @NotNull Edge metadata, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            Intrinsics.checkNotNullParameter(from2, (String)"from");
            Intrinsics.checkNotNullParameter(to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (Intrinsics.areEqual((Object)metadata.getLabel(), (Object)CapturedByValue.INSTANCE)) {
                return data;
            }
            return super.visitEdge(from2, to, metadata, data);
        }

        /*
         * WARNING - void declaration
         */
        private final PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> add(PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> $this$add, PropertyAccessType type2, FirPropertySymbol symbol, CFGNode<?> node) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> $this$transformValues$iv = $this$add;
            boolean $i$f$transformValues = false;
            PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> $this$mutate$iv$iv = $this$transformValues$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = builder2;
            boolean bl2 = false;
            Map map = $this$transformValues$iv;
            Map destination$iv$iv = it$iv;
            boolean $i$f$mapValuesTo = false;
            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv$iv;
                boolean bl3 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl4 = false;
                Object values$iv = entry2.getValue();
                PersistentMap oldData = (PersistentMap)values$iv;
                boolean bl5 = false;
                VariableWriteData variableWriteData = (VariableWriteData)oldData.get((Object)type2);
                PersistentMap persistentMap = variableWriteData != null ? variableWriteData.unbox-impl() : null;
                PersistentMap<PropertyAccessType, VariableWriteData> persistentMap2 = oldData.put(type2, VariableWriteData.box-impl(persistentMap != null ? VariableWriteData.add-pnGJifQ(persistentMap, symbol, node) : VariableWriteData.constructor-impl(symbol, node)));
                map3.put(k2, persistentMap2);
            }
            return builder2.build();
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return node.getFir().getName().isSpecial() || node.getFir().getInitializer() == null ? data : this.add(data, PropertyAccessType.Captured, node.getFir().getSymbol(), node);
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            Object object;
            block5: {
                block4: {
                    Object object2;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                    if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) break block4;
                    Object it = object2 = object;
                    boolean bl2 = false;
                    object = this.properties.contains(it) ? object2 : null;
                    if (object != null) break block5;
                }
                return data;
            }
            Object symbol = object;
            if (((FirCallableSymbol)symbol).getName().isSpecial()) {
                return data;
            }
            return this.add(data, PropertyAccessType.Captured, (FirPropertySymbol)symbol, node);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001Be\u0012N\u0010\u0004\u001aJ\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012<\u0012:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJx\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t2\"\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t2\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u00a0\u0001\u0010\u0014\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\n2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0017\u001a\u00020\u00182>\u0010\u0019\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\nH\u0016J\u0088\u0001\u0010\u001a\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\n2\u0006\u0010\u0013\u001a\u00020\u001b2>\u0010\u0019\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\nH\u0016J\u0088\u0001\u0010\u001c\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\n2\u0006\u0010\u0013\u001a\u00020\u001d2>\u0010\u0019\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\nH\u0016RV\u0010\u0004\u001aJ\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012<\u0012:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindVisibleWrites;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/PropertyAccessType;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWriteData;", "futureWrites", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "<init>", "(Ljava/util/Map;Ljava/util/Set;)V", "mergeInfo", "a", "b", "node", "visitEdge", "from", "to", "metadata", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;", "data", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedVariableAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindVisibleWrites\n+ 2 PathAwareControlFlowGraphVisitor.kt\norg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitorKt\n+ 3 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n83#2:373\n84#2:375\n85#2:379\n87#2:382\n83#2:383\n84#2:385\n85#2:389\n87#2:392\n83#2:393\n84#2:395\n85#2:399\n87#2:402\n53#3:374\n53#3:384\n53#3:394\n413#4:376\n413#4:386\n413#4:396\n1252#5,2:377\n1255#5:381\n1252#5,2:387\n1255#5:391\n1252#5,2:397\n1255#5:401\n1#6:380\n1#6:390\n1#6:400\n1#6:403\n*S KotlinDebug\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindVisibleWrites\n*L\n229#1:373\n229#1:375\n229#1:379\n229#1:382\n250#1:383\n250#1:385\n250#1:389\n250#1:392\n263#1:393\n263#1:395\n263#1:399\n263#1:402\n229#1:374\n250#1:384\n263#1:394\n229#1:376\n250#1:386\n263#1:396\n229#1:377,2\n229#1:381\n250#1:387,2\n250#1:391\n263#1:397,2\n263#1:401\n229#1:380\n250#1:390\n263#1:400\n*E\n"})
    private static final class FindVisibleWrites
    extends PathAwareControlFlowGraphVisitor<PropertyAccessType, VariableWriteData> {
        @NotNull
        private final Map<CFGNode<?>, PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>>> futureWrites;
        @NotNull
        private final Set<FirPropertySymbol> properties;

        public FindVisibleWrites(@NotNull Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>>> futureWrites, @NotNull Set<? extends FirPropertySymbol> properties) {
            Intrinsics.checkNotNullParameter(futureWrites, (String)"futureWrites");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            super(null, 1, null);
            this.futureWrites = futureWrites;
            this.properties = properties;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PersistentMap<PropertyAccessType, VariableWriteData> mergeInfo(@NotNull PersistentMap<PropertyAccessType, VariableWriteData> a2, @NotNull PersistentMap<PropertyAccessType, VariableWriteData> b2, @NotNull CFGNode<?> node) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            void $this$merge$iv;
            Intrinsics.checkNotNullParameter(a2, (String)"a");
            Intrinsics.checkNotNullParameter(b2, (String)"b");
            Intrinsics.checkNotNullParameter(node, (String)"node");
            PersistentMap<PropertyAccessType, VariableWriteData> persistentMap = a2;
            PersistentMap<PropertyAccessType, VariableWriteData> other$iv = b2;
            boolean $i$f$merge = false;
            void $this$mutate$iv$iv = $this$merge$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = builder2;
            boolean bl2 = false;
            Map map = other$iv;
            Map destination$iv$iv = it$iv;
            boolean $i$f$mapValuesTo = false;
            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Object object;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv$iv;
                boolean bl3 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl4 = false;
                Object label$iv = entry2.getKey();
                Object rightValue$iv = entry2.getValue();
                if ($this$merge$iv.get(label$iv) != null) {
                    void p1;
                    Object leftValue$iv;
                    boolean bl5 = false;
                    PersistentMap persistentMap2 = ((VariableWriteData)rightValue$iv).unbox-impl();
                    PersistentMap p0 = ((VariableWriteData)leftValue$iv).unbox-impl();
                    boolean bl6 = false;
                    object = VariableWriteData.box-impl(VariableWriteData.plus-JgvPeUI(p0, p1));
                } else {
                    object = rightValue$iv;
                }
                Object v2 = object;
                map3.put(k2, v2);
            }
            return builder2.build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitEdge(@NotNull CFGNode<?> from2, @NotNull CFGNode<?> to, @NotNull Edge metadata, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> persistentMap;
            block14: {
                PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> result2;
                block15: {
                    ControlFlowGraph fromGraph;
                    block11: {
                        Intrinsics.checkNotNullParameter(from2, (String)"from");
                        Intrinsics.checkNotNullParameter(to, (String)"to");
                        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                        Intrinsics.checkNotNullParameter(data, (String)"data");
                        if (Intrinsics.areEqual((Object)metadata.getLabel(), (Object)CapturedByValue.INSTANCE)) {
                            return data;
                        }
                        result2 = super.visitEdge(from2, to, metadata, data);
                        fromGraph = FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(from2.getOwner());
                        if (Intrinsics.areEqual((Object)fromGraph, (Object)FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(to.getOwner()))) break block11;
                        PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> data2 = data;
                        for (CFGNode<?> node : CfgTraverserKt.getFollowingCfgNodes(from2)) {
                            void $this$associateByTo$iv$iv$iv;
                            void $this$mapValuesTo$iv$iv;
                            void $this$merge$iv;
                            if (!Intrinsics.areEqual((Object)fromGraph, (Object)FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner()))) continue;
                            PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> persistentMap2 = this.futureWrites.get(node);
                            if (persistentMap2 == null) continue;
                            PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> nodeData = super.visitEdge(from2, node, metadata, persistentMap2);
                            PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> persistentMap3 = data2;
                            PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> other$iv = nodeData;
                            boolean $i$f$merge = false;
                            void $this$mutate$iv$iv = $this$merge$iv;
                            boolean $i$f$mutate = false;
                            PersistentMap.Builder builder2 = $this$mutate$iv$iv.builder();
                            Map it$iv = builder2;
                            boolean bl2 = false;
                            Map map = other$iv;
                            Map destination$iv$iv = it$iv;
                            boolean $i$f$mapValuesTo = false;
                            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
                            Map destination$iv$iv$iv = destination$iv$iv;
                            boolean $i$f$associateByTo = false;
                            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                                Object object;
                                Map map2;
                                Object k2;
                                block13: {
                                    Object rightValue$iv;
                                    block12: {
                                        void b2;
                                        void it$iv$iv;
                                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                                        Map map3 = destination$iv$iv$iv;
                                        boolean bl3 = false;
                                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                                        k2 = it$iv$iv.getKey();
                                        map2 = map3;
                                        boolean bl4 = false;
                                        Object label$iv = entry2.getKey();
                                        rightValue$iv = entry2.getValue();
                                        object = $this$merge$iv.get(label$iv);
                                        if (object == null) break block12;
                                        Object leftValue$iv = object;
                                        boolean bl5 = false;
                                        PersistentMap persistentMap4 = (PersistentMap)rightValue$iv;
                                        PersistentMap a2 = (PersistentMap)leftValue$iv;
                                        boolean bl6 = false;
                                        PersistentMap<PropertyAccessType, VariableWriteData> persistentMap5 = this.mergeInfo(a2, (PersistentMap<PropertyAccessType, VariableWriteData>)b2, to);
                                        object = persistentMap5;
                                        if (persistentMap5 != null) break block13;
                                    }
                                    object = rightValue$iv;
                                }
                                Object v2 = object;
                                map2.put(k2, v2);
                            }
                            data2 = builder2.build();
                        }
                        persistentMap = data2;
                        break block14;
                    }
                    if (!(from2 instanceof CFGNodeWithSubgraphs)) break block15;
                    PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> data3 = data;
                    for (ControlFlowGraph subGraph : ((CFGNodeWithSubgraphs)from2).getSubGraphs()) {
                        void $this$associateByTo$iv$iv$iv;
                        void $this$mapValuesTo$iv$iv;
                        void $this$merge$iv;
                        if (Intrinsics.areEqual((Object)fromGraph, (Object)FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(subGraph))) continue;
                        CFGNode<?> node = subGraph.getEnterNode();
                        PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> persistentMap6 = this.futureWrites.get(node);
                        if (persistentMap6 == null) continue;
                        PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> nodeData = super.visitEdge(from2, node, metadata, persistentMap6);
                        PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> other$iv = data3;
                        PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> other$iv2 = nodeData;
                        boolean $i$f$merge = false;
                        void $this$mutate$iv$iv = $this$merge$iv;
                        boolean $i$f$mutate = false;
                        PersistentMap.Builder builder3 = $this$mutate$iv$iv.builder();
                        Map it$iv = builder3;
                        boolean bl7 = false;
                        Map destination$iv$iv = other$iv2;
                        Map destination$iv$iv2 = it$iv;
                        boolean $i$f$mapValuesTo = false;
                        Iterable destination$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                        Map destination$iv$iv$iv2 = destination$iv$iv2;
                        boolean $i$f$associateByTo = false;
                        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            Object object;
                            Map map;
                            Object k3;
                            block17: {
                                Object rightValue$iv;
                                block16: {
                                    void b3;
                                    void it$iv$iv;
                                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                                    Map map4 = destination$iv$iv$iv2;
                                    boolean bl8 = false;
                                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                                    k3 = it$iv$iv.getKey();
                                    map = map4;
                                    boolean bl9 = false;
                                    Object label$iv = entry3.getKey();
                                    rightValue$iv = entry3.getValue();
                                    object = $this$merge$iv.get(label$iv);
                                    if (object == null) break block16;
                                    Object leftValue$iv = object;
                                    boolean bl10 = false;
                                    PersistentMap a2 = (PersistentMap)rightValue$iv;
                                    PersistentMap a3 = (PersistentMap)leftValue$iv;
                                    boolean bl11 = false;
                                    PersistentMap<PropertyAccessType, VariableWriteData> persistentMap7 = this.mergeInfo(a3, (PersistentMap<PropertyAccessType, VariableWriteData>)b3, to);
                                    object = persistentMap7;
                                    if (persistentMap7 != null) break block17;
                                }
                                object = rightValue$iv;
                            }
                            Object v3 = object;
                            map.put(k3, v3);
                        }
                        data3 = builder3.build();
                    }
                    persistentMap = data3;
                    break block14;
                }
                persistentMap = result2;
            }
            return persistentMap;
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            PersistentMap persistentMap;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (node.getFir().getName().isSpecial()) {
                persistentMap = data;
            } else {
                PersistentSet<Object> persistentSet;
                FirPropertySymbol firPropertySymbol = node.getFir().getSymbol();
                if (node.getFir().getInitializer() != null) {
                    VariableDeclarationNode[] variableDeclarationNodeArray = new VariableDeclarationNode[]{node};
                    persistentSet = ExtensionsKt.persistentSetOf(variableDeclarationNodeArray);
                } else {
                    persistentSet = ExtensionsKt.persistentSetOf();
                }
                persistentMap = UnusedVariableAssignmentCheckerKt.access$overwrite(data, firPropertySymbol, persistentSet);
            }
            return persistentMap;
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            Object object;
            block5: {
                block4: {
                    Object object2;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                    if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) break block4;
                    Object it = object2 = object;
                    boolean bl2 = false;
                    object = this.properties.contains(it) ? object2 : null;
                    if (object != null) break block5;
                }
                return data;
            }
            Object symbol = object;
            if (((FirCallableSymbol)symbol).getName().isSpecial()) {
                return data;
            }
            VariableAssignmentNode[] variableAssignmentNodeArray = new VariableAssignmentNode[]{node};
            return UnusedVariableAssignmentCheckerKt.access$overwrite(data, (FirPropertySymbol)symbol, ExtensionsKt.persistentSetOf(variableAssignmentNodeArray));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u001c\u0010\u000f\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$RemoveVisibleWrites;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$Data;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$Data;)V", "visitNode", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitQualifiedAccessNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "visitFunctionCallExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallExitNode;", "visitAnnotations", "visitQualifiedAccess", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedVariableAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$RemoveVisibleWrites\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,372:1\n1#2:373\n1869#3,2:374\n1869#3,2:376\n*S KotlinDebug\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$RemoveVisibleWrites\n*L\n310#1:374,2\n328#1:376,2\n*E\n"})
    private static final class RemoveVisibleWrites
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Data data;

        public RemoveVisibleWrites(@NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            this.visitAnnotations(node);
        }

        @Override
        public void visitQualifiedAccessNode(@NotNull QualifiedAccessNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.visitAnnotations(node);
            this.visitQualifiedAccess(node, node.getFir());
        }

        @Override
        public void visitFunctionCallExitNode(@NotNull FunctionCallExitNode node) {
            block0: {
                FirQualifiedAccessExpression firQualifiedAccessExpression;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.visitAnnotations(node);
                FirFunctionCall firFunctionCall = node.getFir();
                FirImplicitInvokeCall firImplicitInvokeCall = firFunctionCall instanceof FirImplicitInvokeCall ? (FirImplicitInvokeCall)firFunctionCall : null;
                FirExpression firExpression = firImplicitInvokeCall != null ? firImplicitInvokeCall.getExplicitReceiver() : null;
                FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
                if (firQualifiedAccessExpression == null) break block0;
                FirQualifiedAccessExpression it = firQualifiedAccessExpression;
                boolean bl2 = false;
                this.visitQualifiedAccess(node, it);
            }
        }

        private final void visitAnnotations(CFGNode<?> node) {
            block1: {
                Object obj = node.getFir();
                Object object = obj instanceof FirAnnotationContainer ? (FirAnnotationContainer)obj : null;
                if (object == null || (object = object.getAnnotations()) == null) break block1;
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirAnnotation call2 = (FirAnnotation)element$iv;
                    boolean bl2 = false;
                    call2.accept(new FirVisitorVoid(this, node){
                        final /* synthetic */ RemoveVisibleWrites this$0;
                        final /* synthetic */ CFGNode<?> $node;
                        {
                            this.this$0 = $receiver;
                            this.$node = $node;
                        }

                        public void visitElement(FirElement element2) {
                            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                            if (element2 instanceof FirQualifiedAccessExpression) {
                                RemoveVisibleWrites.access$visitQualifiedAccess(this.this$0, this.$node, (FirQualifiedAccessExpression)element2);
                            }
                            element2.acceptChildren(this);
                        }
                    });
                }
            }
        }

        private final void visitQualifiedAccess(CFGNode<?> node, FirQualifiedAccessExpression fir) {
            FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(fir.getCalleeReference(), false, 1, null);
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol = firPropertySymbol;
            if (symbol.getName().isSpecial()) {
                return;
            }
            this.data.getVariablesWithoutReads().remove(symbol);
            PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> persistentMap = this.data.getWritesByNode().get(node);
            Collection collection = persistentMap != null ? (ImmutableCollection)persistentMap.values() : null;
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            for (PersistentMap visibleByLabel : collection) {
                Iterator iterator2 = ((ImmutableCollection)visibleByLabel.values()).iterator();
                while (iterator2.hasNext()) {
                    PersistentMap visible = ((VariableWriteData)iterator2.next()).unbox-impl();
                    PersistentSet<CFGNode<?>> persistentSet = VariableWriteData.get-impl(visible, symbol);
                    if (persistentSet == null) continue;
                    Iterable $this$forEach$iv = persistentSet;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CFGNode it = (CFGNode)element$iv;
                        boolean bl2 = false;
                        Collection collection2 = this.data.getUnreadWrites();
                        Object e2 = it.getFir();
                        TypeIntrinsics.asMutableCollection((Object)collection2).remove(e2);
                    }
                }
            }
        }

        public static final /* synthetic */ void access$visitQualifiedAccess(RemoveVisibleWrites $this, CFGNode node, FirQualifiedAccessExpression fir) {
            $this.visitQualifiedAccess(node, fir);
        }
    }
}

