/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptionalExpectationChecker;", "", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getOptionalExpectationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "frontend"})
public final class OptionalExpectationChecker {
    @NotNull
    public static final OptionalExpectationChecker INSTANCE = new OptionalExpectationChecker();

    private OptionalExpectationChecker() {
    }

    public final void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            if (descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect()) break block1;
            KtAnnotationEntry ktAnnotationEntry = this.getOptionalExpectationEntry(declaration2, trace);
            if (ktAnnotationEntry != null) {
                KtAnnotationEntry it = ktAnnotationEntry;
                boolean bl2 = false;
                trace.report(Errors.OPTIONAL_EXPECTATION_NOT_ON_EXPECTED.on(it));
            }
        }
    }

    private final KtAnnotationEntry getOptionalExpectationEntry(KtDeclaration declaration2, BindingTrace trace) {
        Object v2;
        block1: {
            List<KtAnnotationEntry> list = declaration2.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationEntries(...)");
            Iterable iterable = list;
            for (Object t2 : iterable) {
                AnnotationDescriptor annotationDescriptor;
                KtAnnotationEntry entry = (KtAnnotationEntry)t2;
                boolean bl2 = false;
                AnnotationDescriptor annotationDescriptor2 = annotationDescriptor = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
                if (!Intrinsics.areEqual((Object)(annotationDescriptor2 != null ? annotationDescriptor2.getFqName() : null), (Object)OptionalAnnotationUtil.INSTANCE.getOPTIONAL_EXPECTATION_FQ_NAME())) continue;
                v2 = t2;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }
}

