/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeProxy;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.ReflectionState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0004\b\u000b\u0010\u000fB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0010\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\t2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%J\u0006\u0010'\u001a\u00020%J\u0006\u0010(\u001a\u00020%J\u0006\u0010)\u001a\u00020%J\u0006\u0010*\u001a\u00020%J\u0013\u0010+\u001a\u00020%2\b\u0010,\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KPropertyState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "boundValues", "", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;Lorg/jetbrains/kotlin/ir/declarations/IrProperty;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/List;)V", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "(Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;Ljava/util/List;)V", "Lorg/jetbrains/kotlin/ir/expressions/IrRichPropertyReference;", "(Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;Lorg/jetbrains/kotlin/ir/expressions/IrRichPropertyReference;Ljava/util/List;)V", "getProperty", "()Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "_returnType", "Lkotlin/reflect/KType;", "getterState", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "getGetterState", "()Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "setterState", "getSetterState", "createAccessorState", "accessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getParameters", "Lkotlin/reflect/KParameter;", "getReturnType", "isKProperty0", "", "isKProperty1", "isKProperty2", "isKMutableProperty0", "isKMutableProperty1", "isKMutableProperty2", "equals", "other", "", "hashCode", "", "toString", "", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nKPropertyState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KPropertyState.kt\norg/jetbrains/kotlin/ir/interpreter/state/reflection/KPropertyState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class KPropertyState
extends ReflectionState {
    @NotNull
    private final IrProperty property;
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final List<State> boundValues;
    @Nullable
    private KType _returnType;
    @Nullable
    private final KFunctionState getterState;
    @Nullable
    private final KFunctionState setterState;

    public KPropertyState(@NotNull CallInterceptor callInterceptor, @NotNull IrProperty property2, @NotNull IrClass irClass, @NotNull List<? extends State> boundValues) {
        KFunctionState kFunctionState;
        KFunctionState kFunctionState2;
        IrSimpleFunction it;
        KPropertyState kPropertyState;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter(boundValues, (String)"boundValues");
        this.property = property2;
        this.irClass = irClass;
        this.boundValues = boundValues;
        KPropertyState kPropertyState2 = this;
        IrSimpleFunction irSimpleFunction = this.property.getGetter();
        if (irSimpleFunction != null) {
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
            kPropertyState = kPropertyState2;
            boolean bl2 = false;
            kFunctionState2 = this.createAccessorState(callInterceptor, it);
            kPropertyState2 = kPropertyState;
        } else {
            kFunctionState2 = null;
        }
        kPropertyState2.getterState = kFunctionState2;
        KPropertyState kPropertyState3 = this;
        IrSimpleFunction irSimpleFunction3 = this.property.getSetter();
        if (irSimpleFunction3 != null) {
            it = irSimpleFunction3;
            kPropertyState = kPropertyState3;
            boolean bl3 = false;
            kFunctionState = this.createAccessorState(callInterceptor, it);
            kPropertyState3 = kPropertyState;
        } else {
            kFunctionState = null;
        }
        kPropertyState3.setterState = kFunctionState;
    }

    public /* synthetic */ KPropertyState(CallInterceptor callInterceptor, IrProperty irProperty, IrClass irClass, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(callInterceptor, irProperty, irClass, list);
    }

    @NotNull
    public final IrProperty getProperty() {
        return this.property;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    public KPropertyState(@NotNull CallInterceptor callInterceptor, @NotNull IrPropertyReference propertyReference, @NotNull List<? extends State> boundValues) {
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        Intrinsics.checkNotNullParameter((Object)propertyReference, (String)"propertyReference");
        Intrinsics.checkNotNullParameter(boundValues, (String)"boundValues");
        IrProperty irProperty = (IrProperty)((IrPropertySymbol)propertyReference.getSymbol()).getOwner();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(propertyReference.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this(callInterceptor, irProperty, (IrClass)irClassSymbol.getOwner(), boundValues);
    }

    public KPropertyState(@NotNull CallInterceptor callInterceptor, @NotNull IrRichPropertyReference propertyReference, @NotNull List<? extends State> boundValues) {
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        Intrinsics.checkNotNullParameter((Object)propertyReference, (String)"propertyReference");
        Intrinsics.checkNotNullParameter(boundValues, (String)"boundValues");
        Object s2 = propertyReference.getReflectionTargetSymbol();
        Intrinsics.checkNotNull(s2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrPropertySymbol");
        IrProperty irProperty = (IrProperty)((IrPropertySymbol)s2).getOwner();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(propertyReference.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this(callInterceptor, irProperty, (IrClass)irClassSymbol.getOwner(), boundValues);
    }

    @Nullable
    public final KFunctionState getGetterState() {
        return this.getterState;
    }

    @Nullable
    public final KFunctionState getSetterState() {
        return this.setterState;
    }

    private final KFunctionState createAccessorState(CallInterceptor callInterceptor, IrSimpleFunction accessor) {
        IrClass irClass = callInterceptor.getIrBuiltIns().kFunctionN(accessor.getParameters().size());
        return new KFunctionState(accessor, irClass, callInterceptor.getEnvironment(), this.boundValues);
    }

    @NotNull
    public final List<KParameter> getParameters(@NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        KFunctionState kFunctionState = this.getterState;
        Intrinsics.checkNotNull((Object)kFunctionState);
        return kFunctionState.getParameters(callInterceptor);
    }

    @NotNull
    public final KType getReturnType(@NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._returnType != null) {
            KType kType = this._returnType;
            Intrinsics.checkNotNull((Object)kType);
            return kType;
        }
        IrClass kTypeIrClass = (IrClass)callInterceptor.getEnvironment().getKTypeClass$ir_interpreter().getOwner();
        IrSimpleFunction irSimpleFunction = this.property.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        KType kType = this._returnType = (KType)new KTypeProxy(new KTypeState(irSimpleFunction.getReturnType(), kTypeIrClass), callInterceptor);
        Intrinsics.checkNotNull((Object)kType);
        return kType;
    }

    public final boolean isKProperty0() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KProperty0");
    }

    public final boolean isKProperty1() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KProperty1");
    }

    public final boolean isKProperty2() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KProperty2");
    }

    public final boolean isKMutableProperty0() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KMutableProperty0");
    }

    public final boolean isKMutableProperty1() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KMutableProperty1");
    }

    public final boolean isKMutableProperty2() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KMutableProperty2");
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState");
        KPropertyState cfr_ignored_0 = (KPropertyState)object2;
        if (!Intrinsics.areEqual((Object)this.property, (Object)((KPropertyState)other).property)) {
            return false;
        }
        return Intrinsics.areEqual(this.boundValues, ((KPropertyState)other).boundValues);
    }

    public int hashCode() {
        int result2 = this.property.hashCode();
        result2 = 31 * result2 + ((Object)this.boundValues).hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.renderProperty(this.property);
    }
}

