/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphBuilderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirOverloadsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirOverloadsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverloadsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirOverloadsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1#2:55\n21#3:56\n14#4:57\n90#4:58\n23#4:62\n1761#5,3:59\n2746#5,3:63\n*S KotlinDebug\n*F\n+ 1 FirOverloadsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirOverloadsChecker\n*L\n32#1:56\n40#1:57\n42#1:58\n47#1:62\n43#1:59,3\n49#1:63,3\n*E\n"})
public final class FirOverloadsChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirOverloadsChecker INSTANCE = new FirOverloadsChecker();

    private FirOverloadsChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration2) {
        boolean bl2;
        FirAnnotation annotation;
        block19: {
            FirClassLikeSymbol<?> containingDeclaration;
            FirFunctionSymbol<FirFunction> ownerOfParametersWithDefaultValues;
            block22: {
                block21: {
                    boolean bl3;
                    block18: {
                        block20: {
                            FirFunctionSymbol<FirFunction> firFunctionSymbol;
                            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                            FirSession session = context2.getSession();
                            FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, JvmStandardClassIds.INSTANCE.getJVM_OVERLOADS_CLASS_ID(), session);
                            if (firAnnotation == null) {
                                return;
                            }
                            annotation = firAnnotation;
                            FirFunctionSymbol<FirFunction> it = firFunctionSymbol = declaration2.getSymbol();
                            boolean bl4 = false;
                            FirCallableSymbol $this$isActual$iv = it;
                            boolean $i$f$isActual = false;
                            FirFunctionSymbol<FirFunction> firFunctionSymbol2 = !$this$isActual$iv.getRawStatus().isActual() ? firFunctionSymbol : null;
                            if (firFunctionSymbol2 == null && (firFunctionSymbol2 = ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull(declaration2.getSymbol())) == null) {
                                return;
                            }
                            ownerOfParametersWithDefaultValues = firFunctionSymbol2;
                            containingDeclaration = FirHelpersKt.getContainingClassSymbol(declaration2);
                            FirClassLikeSymbol<?> firClassLikeSymbol = containingDeclaration;
                            if ((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.INTERFACE) {
                                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_INTERFACE(), null, 8, null);
                                return;
                            }
                            FirMemberDeclaration $this$isAbstract$iv = declaration2;
                            boolean $i$f$isAbstract = false;
                            if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) {
                                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_ABSTRACT(), null, 8, null);
                                return;
                            }
                            if (!(declaration2 instanceof FirSimpleFunction)) break block20;
                            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)declaration2;
                            boolean $i$f$isLocal = false;
                            if (Intrinsics.areEqual((Object)$this$isLocal$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) break block21;
                        }
                        Iterable $this$any$iv = context2.getContainingDeclarations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                FirBasedSymbol it = (FirBasedSymbol)element$iv;
                                boolean bl5 = false;
                                if (!ControlFlowGraphBuilderKt.isLocalClassOrAnonymousObject(it)) continue;
                                bl3 = true;
                                break block18;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) break block22;
                }
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_LOCAL(), null, 8, null);
                return;
            }
            if (declaration2 instanceof FirConstructor) {
                FirClassLikeSymbol<?> firClassLikeSymbol = containingDeclaration;
                if ((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.ANNOTATION_CLASS) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_ANNOTATION_CLASS_CONSTRUCTOR_ERROR(), null, 8, null);
                    return;
                }
            }
            FirMemberDeclaration $this$visibility$iv = declaration2;
            boolean $i$f$getVisibility = false;
            if (!$this$visibility$iv.getStatus().getVisibility().isPublicAPI()) {
                $this$visibility$iv = declaration2;
                $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Internal.INSTANCE)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_PRIVATE(), null, 8, null);
                    return;
                }
            }
            Iterable $this$none$iv = ownerOfParametersWithDefaultValues.getValueParameterSymbols();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl6 = false;
                    if (!it.getHasDefaultValue()) continue;
                    bl2 = false;
                    break block19;
                }
                bl2 = true;
            }
        }
        if (!bl2) return;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_WITHOUT_DEFAULT_ARGUMENTS(), null, 8, null);
    }
}

