/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructedClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ$\u0010\u0014\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J,\u0010\u001b\u001a\u00020\u000f*\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J$\u0010\u001b\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J \u0010!\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0018\u0010\u001f\u001a\u00020\u000f*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "isInsideInterface", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "isInlineWithReified", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isExportableReturn", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "currentlyProcessed", "", "isExportableTypeArguments", "isExportable", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "declarationSite", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "isPrimitiveExportableConeKotlinType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "validateDeclarationOnConsumableName", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExportDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExportDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n34#2:318\n52#2:319\n53#2:320\n52#2:321\n52#2:323\n49#2:324\n52#2:325\n67#2:326\n1#3:322\n34#4:327\n1761#5,3:328\n*S KotlinDebug\n*F\n+ 1 FirJsExportDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker\n*L\n73#1:318\n81#1:319\n94#1:320\n124#1:321\n143#1:323\n166#1:324\n184#1:325\n194#1:326\n194#1:327\n202#1:328,3\n*E\n"})
public final class FirJsExportDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsExportDeclarationChecker INSTANCE = new FirJsExportDeclarationChecker();

    private FirJsExportDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!FirJsHelpersKt.isExportedObject(declaration2.getSymbol(), context2) || !(declaration2 instanceof FirMemberDeclaration)) {
            return;
        }
        boolean hasJsName = FirAnnotationUtilsKt.hasAnnotation(declaration2, JsStandardClassIds.Annotations.JsName, context2.getSession());
        FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration2, "expect");
        }
        this.validateDeclarationOnConsumableName((FirMemberDeclaration)declaration2, context2, reporter);
        FirMemberDeclaration firMemberDeclaration = (FirMemberDeclaration)declaration2;
        if (firMemberDeclaration instanceof FirFunction) {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context2)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration2, "external function");
                return;
            }
            for (FirTypeParameterRef typeParameter : ((FirFunction)declaration2).getTypeParameters()) {
                FirJsExportDeclarationChecker.check$checkTypeParameter(context2, declaration2, reporter, typeParameter);
            }
            if (this.isInlineWithReified((FirCallableSymbol)((FirFunction)declaration2).getSymbol())) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration2, "inline function with reified type parameters");
                return;
            }
            FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getStatus().isSuspend()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration2, "suspend function");
                return;
            }
            if (declaration2 instanceof FirConstructor && !((FirConstructor)declaration2).isPrimary() && !hasJsName) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration2, "secondary constructor without @JsName");
            }
            if (declaration2 instanceof FirPropertyAccessor) {
                return;
            }
            for (FirValueParameter parameter2 : ((FirFunction)declaration2).getValueParameters()) {
                FirJsExportDeclarationChecker.check$checkValueParameter(context2, declaration2, reporter, parameter2);
            }
            ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(((FirFunction)declaration2).getReturnTypeRef());
            if (!(declaration2 instanceof FirConstructor) && !FirJsExportDeclarationChecker.isExportableReturn$default(this, returnType2, context2.getSession(), null, 2, null)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunction)declaration2).getSource(), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"return", (Object)returnType2, null, 32, null);
            }
        } else if (firMemberDeclaration instanceof FirProperty) {
            boolean bl2;
            FirClassSymbol containingClass;
            KtSourceElement ktSourceElement = ((FirProperty)declaration2).getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                return;
            }
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isExternal22 = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context2)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration2, "external property");
                return;
            }
            if (FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration2)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration2, "extension property");
                return;
            }
            FirClassLikeSymbol<?> $i$f$isExternal22 = FirHelpersKt.getContainingClassSymbol(declaration2);
            FirClassSymbol firClassSymbol = containingClass = $i$f$isExternal22 instanceof FirClassSymbol ? (FirClassSymbol)$i$f$isExternal22 : null;
            if (firClassSymbol != null) {
                FirClassSymbol firClassSymbol2 = firClassSymbol;
                FirProperty firProperty = (FirProperty)declaration2;
                FirClassSymbol p0 = firClassSymbol2;
                boolean bl3 = false;
                bl2 = UtilsKt.isEnumEntries((FirVariable)firProperty, p0);
            } else {
                bl2 = false;
            }
            boolean enumEntriesProperty = bl2;
            ConeKotlinType returnType3 = FirTypeUtilsKt.getConeType(((FirProperty)declaration2).getReturnTypeRef());
            if (!enumEntriesProperty && !FirJsExportDeclarationChecker.isExportable$default(this, returnType3, context2.getSession(), null, 2, null)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirProperty)declaration2).getSource(), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"property", (Object)returnType3, null, 32, null);
            }
        } else if (firMemberDeclaration instanceof FirClass) {
            Object wrongDeclaration;
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context2)) {
                String string;
                switch (WhenMappings.$EnumSwitchMapping$0[((FirClass)declaration2).getClassKind().ordinal()]) {
                    case 1: {
                        string = "external class";
                        break;
                    }
                    case 2: {
                        string = null;
                        break;
                    }
                    case 3: {
                        string = "external enum class";
                        break;
                    }
                    case 4: {
                        string = "external enum entry";
                        break;
                    }
                    case 5: {
                        string = "external annotation class";
                        break;
                    }
                    case 6: {
                        string = "external object";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                wrongDeclaration = string;
                if (wrongDeclaration != null) {
                    FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration2, (String)wrongDeclaration);
                    return;
                }
            }
            wrongDeclaration = ((FirClass)declaration2).getTypeParameters().iterator();
            while (wrongDeclaration.hasNext()) {
                FirTypeParameterRef typeParameter = wrongDeclaration.next();
                FirJsExportDeclarationChecker.check$checkTypeParameter(context2, declaration2, reporter, typeParameter);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((FirClass)declaration2).getClassKind().ordinal()]) {
                case 5: {
                    Object object = "annotation class";
                    break;
                }
                case 1: {
                    Object object;
                    if (this.isInsideInterface(context2)) {
                        object = "nested class inside exported interface";
                        break;
                    }
                    FirClass $this$isInlineOrValue$iv = (FirClass)declaration2;
                    boolean $i$f$isInlineOrValue = false;
                    if ($this$isInlineOrValue$iv.getStatus().isInline() || $this$isInlineOrValue$iv.getStatus().isValue()) {
                        object = "value class";
                        break;
                    }
                    object = null;
                    break;
                }
                default: {
                    Object object = wrongDeclaration = this.isInsideInterface(context2) && !((FirClass)declaration2).getStatus().isCompanion() ? "nested/inner declaration inside exported interface" : null;
                }
            }
            if (this.isInsideInterface(context2) && ((FirClass)declaration2).getStatus().isCompanion() && !Intrinsics.areEqual((Object)FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)declaration2), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirClass)declaration2).getSource(), FirJsErrors.INSTANCE.getNAMED_COMPANION_IN_EXPORTED_INTERFACE(), null, 8, null);
            }
            if (wrongDeclaration != null) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration2, (String)wrongDeclaration);
            }
        } else {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration2, "external declaration");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideInterface(CheckerContext $this$isInsideInterface) {
        Object object = CollectionsKt.lastOrNull($this$isInsideInterface.getContainingDeclarations());
        if (!(object instanceof FirClass)) return false;
        FirClass firClass = (FirClass)object;
        FirClass parent2 = firClass;
        if (parent2 == null) return false;
        FirClass $this$isInterface$iv = parent2;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        if ($this$isInterface$iv$iv != ClassKind.INTERFACE) return false;
        return true;
    }

    private final boolean isInlineWithReified(FirCallableSymbol<?> $this$isInlineWithReified) {
        boolean bl2;
        block5: {
            if ($this$isInlineWithReified instanceof FirPropertyAccessorSymbol) {
                bl2 = this.isInlineWithReified(((FirPropertyAccessorSymbol)$this$isInlineWithReified).getPropertySymbol());
            } else {
                Iterable $this$any$iv = $this$isInlineWithReified.getTypeParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                        boolean bl3 = false;
                        if (!it.isReified()) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    private final boolean isExportableReturn(ConeKotlinType $this$isExportableReturn, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        return ConeBuiltinTypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable($this$isExportableReturn, session, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, ConeKotlinType coneKotlinType, FirSession firSession, Set set, int n2, Object object) {
        if ((n2 & 2) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportableReturn(coneKotlinType, firSession, set);
    }

    private final boolean isExportableTypeArguments(ConeKotlinType $this$isExportableTypeArguments, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        if ($this$isExportableTypeArguments.getTypeArguments().length == 0) {
            return true;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol($this$isExportableTypeArguments, session);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol symbol = firRegularClassSymbol;
        int n2 = $this$isExportableTypeArguments.getTypeArguments().length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FirTypeParameterSymbol parameter2;
            if ((FirTypeParameterSymbol)CollectionsKt.getOrNull(symbol.getTypeParameterSymbols(), (int)i2) == null) {
                return false;
            }
            if (this.isExportable($this$isExportableTypeArguments.getTypeArguments()[i2], session, parameter2, currentlyProcessed)) continue;
            return false;
        }
        return true;
    }

    private final boolean isExportable(ConeTypeProjection $this$isExportable, FirSession session, FirTypeParameterSymbol declarationSite, Set<ConeKotlinType> currentlyProcessed) {
        ConeKotlinType coneKotlinType;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$isExportable.getKind().ordinal()]) {
            case 1: {
                coneKotlinType = ConeTypeProjectionKt.getType($this$isExportable);
                break;
            }
            case 2: {
                if (WhenMappings.$EnumSwitchMapping$1[declarationSite.getVariance().ordinal()] == 1) {
                    coneKotlinType = ConeTypeProjectionKt.getType($this$isExportable);
                    break;
                }
                coneKotlinType = null;
                break;
            }
            case 3: {
                if (WhenMappings.$EnumSwitchMapping$1[declarationSite.getVariance().ordinal()] == 2) {
                    coneKotlinType = ConeTypeProjectionKt.getType($this$isExportable);
                    break;
                }
                coneKotlinType = null;
                break;
            }
            case 4: {
                if (WhenMappings.$EnumSwitchMapping$1[declarationSite.getVariance().ordinal()] == 3) {
                    coneKotlinType = null;
                    break;
                }
                coneKotlinType = TypeUtilsKt.getProjectionForRawType(declarationSite, session, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (coneKotlinType == null) {
            return false;
        }
        ConeKotlinType typeFromProjection = coneKotlinType;
        return declarationSite.getVariance() == Variance.OUT_VARIANCE && ConeBuiltinTypeUtilsKt.isUnit(typeFromProjection) || this.isExportable(typeFromProjection, session, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportable$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, ConeTypeProjection coneTypeProjection, FirSession firSession, FirTypeParameterSymbol firTypeParameterSymbol, Set set, int n2, Object object) {
        if ((n2 & 4) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportable(coneTypeProjection, firSession, firTypeParameterSymbol, set);
    }

    private final boolean isExportable(ConeKotlinType $this$isExportable, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        boolean bl2;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        ConeKotlinType expandedType = TypeExpansionUtilsKt.fullyExpandedType$default($this$isExportable, session, null, 2, null);
        boolean isFunctionType = FunctionalTypeUtilsKt.isBasicFunctionType(expandedType, session);
        boolean isExportableArgs = this.isExportableTypeArguments(expandedType, session, currentlyProcessed);
        currentlyProcessed.remove($this$isExportable);
        if (isFunctionType || !isExportableArgs) {
            return isExportableArgs;
        }
        ConeKotlinType nonNullable = TypeUtilsKt.withNullability$default(expandedType, false, TypeComponentsKt.getTypeContext(session), null, false, 12, null);
        boolean isPrimitiveExportableType = ConeBuiltinTypeUtilsKt.isAny(nonNullable) || ConeBuiltinTypeUtilsKt.isNullableAny(nonNullable) || nonNullable instanceof ConeDynamicType || this.isPrimitiveExportableConeKotlinType(nonNullable);
        FirClassifierSymbol<?> symbol = ToSymbolUtilsKt.toSymbol(expandedType, session);
        if (isPrimitiveExportableType) {
            bl2 = true;
        } else {
            FirClassifierSymbol<?> firClassifierSymbol = symbol;
            bl2 = !(firClassifierSymbol != null ? FirDeclarationUtilKt.isMemberDeclaration((FirBasedSymbol)firClassifierSymbol) : false) ? false : (ConeBuiltinTypeUtilsKt.isEnum(expandedType) ? true : FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)symbol, session) || FirJsHelpersKt.isExportedObject((FirBasedSymbol)symbol, session));
        }
        return bl2;
    }

    static /* synthetic */ boolean isExportable$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, ConeKotlinType coneKotlinType, FirSession firSession, Set set, int n2, Object object) {
        if ((n2 & 2) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportable(coneKotlinType, firSession, set);
    }

    private final boolean isPrimitiveExportableConeKotlinType(ConeKotlinType $this$isPrimitiveExportableConeKotlinType) {
        return $this$isPrimitiveExportableConeKotlinType instanceof ConeTypeParameterType || ConeBuiltinTypeUtilsKt.isBoolean($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isThrowableOrNullableThrowable($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isString($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isPrimitiveNumberOrNullableType($this$isPrimitiveExportableConeKotlinType) && !ConeBuiltinTypeUtilsKt.isLong($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isNothingOrNullableNothing($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isPrimitiveArray($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isNonPrimitiveArray($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isList($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableList($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isSet($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableSet($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMap($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableMap($this$isPrimitiveExportableConeKotlinType);
    }

    private final void validateDeclarationOnConsumableName(FirMemberDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        if (!FirHelpersKt.isTopLevel(context2) || FirDeclarationUtilKt.getNameOrSpecialName(declaration2).isSpecial()) {
            return;
        }
        FirExpression jsNameArgument = FirHelpersKt.getAnnotationFirstArgument(declaration2.getSymbol(), JsStandardClassIds.Annotations.JsName, context2.getSession());
        Object object = jsNameArgument;
        if (object == null || (object = ((FirExpression)object).getSource()) == null) {
            object = declaration2.getSource();
        }
        Object reportTarget = object;
        FirLiteralExpression firLiteralExpression = jsNameArgument instanceof FirLiteralExpression ? (FirLiteralExpression)jsNameArgument : null;
        Object object2 = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        String string = object2 instanceof String ? (String)object2 : null;
        if (string == null) {
            String string2 = FirDeclarationUtilKt.getNameOrSpecialName(declaration2).asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        }
        String name2 = string;
        if (IdentifierPolicyKt.getSPECIAL_KEYWORDS().contains(name2) || !IdentifierPolicyKt.getRESERVED_KEYWORDS().contains(name2) && Intrinsics.areEqual((Object)FirJsHelpersKt.sanitizeName(name2), (Object)name2)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reportTarget, FirJsErrors.INSTANCE.getNON_CONSUMABLE_EXPORTED_IDENTIFIER(), (Object)name2, (DiagnosticContext)context2, null, 16, null);
    }

    private static final void check$checkTypeParameter(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirTypeParameterRef typeParameter) {
        if (typeParameter instanceof FirConstructedClassTypeParameterRef) {
            return;
        }
        for (FirResolvedTypeRef upperBound : typeParameter.getSymbol().getResolvedBounds()) {
            if (FirJsExportDeclarationChecker.isExportable$default(INSTANCE, upperBound.getConeType(), $context.getSession(), null, 2, null)) continue;
            KtSourceElement ktSourceElement = upperBound.getSource();
            if (ktSourceElement == null && (ktSourceElement = typeParameter.getSource()) == null) {
                ktSourceElement = ((FirMemberDeclaration)$declaration).getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"upper bound", (Object)upperBound.getConeType(), null, 32, null);
        }
    }

    private static final void check$checkValueParameter(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirValueParameter valueParameter2) {
        ConeKotlinType type2 = FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef());
        if (!FirJsExportDeclarationChecker.isExportable$default(INSTANCE, type2, $context.getSession(), null, 2, null)) {
            KtSourceElement ktSourceElement = valueParameter2.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = ((FirMemberDeclaration)$declaration).getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"parameter", (Object)type2, null, 32, null);
        }
    }

    private static final void check$reportWrongExportedDeclaration(CheckerContext $context, DiagnosticReporter $reporter, FirDeclaration $declaration, String kind) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)((FirMemberDeclaration)$declaration).getSource(), FirJsErrors.INSTANCE.getWRONG_EXPORTED_DECLARATION(), (Object)kind, null, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Variance.values().length];
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.INVARIANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

