/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.google.common.collect.ImmutableSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Severity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\t\b&\u0018\u0000 $*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0007$%&'()*B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J+\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0014J'\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\rH$\u00a2\u0006\u0002\u0010\u0019J5\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0014\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u001b\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010 J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"2\u0006\u0010\u001b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010#RD\u0010\u0005\u001a/\u0012\u0010\u0012\u000e\b\u00028\u0000\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\u0007X\u0084\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache;", "Element", "", "<init>", "()V", "suppressors", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "getSuppressors", "()Ljava/util/concurrent/ConcurrentMap;", "isSuppressed", "", "element", "rootElement", "suppressionKey", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;)Z", "request", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "getClosestAnnotatedAncestorElement", "excludeSelf", "(Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;", "isSuppressedByAnnotated", "annotated", "debugDepth", "", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Ljava/lang/Object;Ljava/lang/Object;I)Z", "getOrCreateSuppressor", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "getSuppressingStrings", "", "(Ljava/lang/Object;)Ljava/util/Set;", "Companion", "Suppressor", "EmptySuppressor", "SingularSuppressor", "MultiSuppressor", "SuppressRequest", "StringSuppressRequest", "frontend.common"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinSuppressCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinSuppressCache.kt\norg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,143:1\n384#2,7:144\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinSuppressCache.kt\norg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache\n*L\n79#1:144,7\n*E\n"})
public abstract class AbstractKotlinSuppressCache<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<Element, Suppressor<Element>> suppressors;

    public AbstractKotlinSuppressCache() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"createConcurrentWeakValueMap(...)");
        this.suppressors = concurrentMap;
    }

    @NotNull
    protected final ConcurrentMap<Element, Suppressor<Element>> getSuppressors() {
        return this.suppressors;
    }

    public final boolean isSuppressed(Element element2, Element rootElement, @NotNull String suppressionKey, @NotNull Severity severity) {
        Intrinsics.checkNotNullParameter((Object)suppressionKey, (String)"suppressionKey");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        String string = suppressionKey.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return this.isSuppressed(new StringSuppressRequest<Element>(element2, rootElement, severity, string));
    }

    protected boolean isSuppressed(@NotNull SuppressRequest<Element> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Element Element2 = this.getClosestAnnotatedAncestorElement(request.getElement(), request.getRootElement(), false);
        if (Element2 == null) {
            return false;
        }
        Element annotated = Element2;
        return this.isSuppressedByAnnotated(request.getSuppressKey(), request.getSeverity(), annotated, request.getRootElement(), 0);
    }

    @Nullable
    protected abstract Element getClosestAnnotatedAncestorElement(Element var1, Element var2, boolean var3);

    protected boolean isSuppressedByAnnotated(@NotNull String suppressionKey, @NotNull Severity severity, Element annotated, Element rootElement, int debugDepth) {
        Intrinsics.checkNotNullParameter((Object)suppressionKey, (String)"suppressionKey");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Suppressor<Element> suppressor = this.getOrCreateSuppressor(annotated);
        if (suppressor.isSuppressed(suppressionKey, severity)) {
            return true;
        }
        Element Element2 = this.getClosestAnnotatedAncestorElement(suppressor.getAnnotatedElement(), rootElement, true);
        if (Element2 == null) {
            return false;
        }
        Element annotatedAbove = Element2;
        boolean suppressed = this.isSuppressedByAnnotated(suppressionKey, severity, annotatedAbove, rootElement, debugDepth + 1);
        Suppressor suppressorAbove = (Suppressor)this.suppressors.get(annotatedAbove);
        if (suppressorAbove != null && suppressorAbove.dominates(suppressor)) {
            ((Map)this.suppressors).put(annotated, suppressorAbove);
        }
        return suppressed;
    }

    @NotNull
    protected final Suppressor<Element> getOrCreateSuppressor(Element annotated) {
        Object object;
        Map $this$getOrPut$iv = this.suppressors;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(annotated);
        if (value$iv == null) {
            Suppressor suppressor;
            boolean bl2 = false;
            Set<String> strings2 = this.getSuppressingStrings(annotated);
            switch (strings2.size()) {
                case 0: {
                    suppressor = new EmptySuppressor<Element>(annotated);
                    break;
                }
                case 1: {
                    suppressor = new SingularSuppressor<Element>(annotated, (String)CollectionsKt.first((Iterable)strings2));
                    break;
                }
                default: {
                    suppressor = new MultiSuppressor<Element>(annotated, strings2);
                }
            }
            Suppressor answer$iv = suppressor;
            $this$getOrPut$iv.put(annotated, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Suppressor)object;
    }

    @NotNull
    protected abstract Set<String> getSuppressingStrings(Element var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Companion;", "", "<init>", "()V", "isSuppressedByStrings", "", "key", "", "strings", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "frontend.common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSuppressedByStrings(String key, Set<String> strings2, Severity severity) {
            if (severity == Severity.WARNING) {
                if (strings2.contains("warnings")) return true;
            }
            String string = key.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (!strings2.contains(string)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$EmptySuppressor;", "Element", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "annotated", "<init>", "(Ljava/lang/Object;)V", "isSuppressed", "", "suppressionKey", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "dominates", "other", "frontend.common"})
    private static final class EmptySuppressor<Element>
    extends Suppressor<Element> {
        public EmptySuppressor(Element annotated) {
            super(annotated);
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter((Object)suppressionKey, (String)"suppressionKey");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return false;
        }

        @Override
        public boolean dominates(@NotNull Suppressor<Element> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return other instanceof EmptySuppressor;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$MultiSuppressor;", "Element", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "annotated", "strings", "", "", "<init>", "(Ljava/lang/Object;Ljava/util/Set;)V", "isSuppressed", "", "suppressionKey", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "dominates", "other", "frontend.common"})
    private static final class MultiSuppressor<Element>
    extends Suppressor<Element> {
        @NotNull
        private final Set<String> strings;

        public MultiSuppressor(Element annotated, @NotNull Set<String> strings2) {
            Intrinsics.checkNotNullParameter(strings2, (String)"strings");
            super(annotated);
            this.strings = strings2;
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter((Object)suppressionKey, (String)"suppressionKey");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return Companion.isSuppressedByStrings(suppressionKey, this.strings, severity);
        }

        @Override
        public boolean dominates(@NotNull Suppressor<Element> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return other instanceof EmptySuppressor;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SingularSuppressor;", "Element", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "annotated", "string", "", "<init>", "(Ljava/lang/Object;Ljava/lang/String;)V", "isSuppressed", "", "suppressionKey", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "dominates", "other", "frontend.common"})
    private static final class SingularSuppressor<Element>
    extends Suppressor<Element> {
        @NotNull
        private final String string;

        public SingularSuppressor(Element annotated, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            super(annotated);
            this.string = string;
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter((Object)suppressionKey, (String)"suppressionKey");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            ImmutableSet<String> immutableSet = ImmutableSet.of(this.string);
            Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"of(...)");
            return Companion.isSuppressedByStrings(suppressionKey, immutableSet, severity);
        }

        @Override
        public boolean dominates(@NotNull Suppressor<Element> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return other instanceof EmptySuppressor || other instanceof SingularSuppressor && Intrinsics.areEqual((Object)((SingularSuppressor)other).string, (Object)this.string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0016\u0010\u0003\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$StringSuppressRequest;", "Element", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "element", "rootElement", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressKey", "", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/jetbrains/kotlin/diagnostics/Severity;Ljava/lang/String;)V", "getElement", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getRootElement", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSuppressKey", "()Ljava/lang/String;", "frontend.common"})
    private static final class StringSuppressRequest<Element>
    implements SuppressRequest<Element> {
        private final Element element;
        private final Element rootElement;
        @NotNull
        private final Severity severity;
        @NotNull
        private final String suppressKey;

        public StringSuppressRequest(Element element2, Element rootElement, @NotNull Severity severity, @NotNull String suppressKey) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)suppressKey, (String)"suppressKey");
            this.element = element2;
            this.rootElement = rootElement;
            this.severity = severity;
            this.suppressKey = suppressKey;
        }

        @Override
        public Element getElement() {
            return this.element;
        }

        @Override
        public Element getRootElement() {
            return this.rootElement;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            return this.severity;
        }

        @Override
        @NotNull
        public String getSuppressKey() {
            return this.suppressKey;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\bd\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002R\u0012\u0010\u0003\u001a\u00028\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00028\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "Element", "", "element", "getElement", "()Ljava/lang/Object;", "rootElement", "getRootElement", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressKey", "", "getSuppressKey", "()Ljava/lang/String;", "frontend.common"})
    protected static interface SuppressRequest<Element> {
        public Element getElement();

        public Element getRootElement();

        @NotNull
        public Severity getSeverity();

        @NotNull
        public String getSuppressKey();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b$\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u0016\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H&R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "Element", "", "annotatedElement", "<init>", "(Ljava/lang/Object;)V", "getAnnotatedElement", "()Ljava/lang/Object;", "Ljava/lang/Object;", "isSuppressed", "", "suppressionKey", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "dominates", "other", "frontend.common"})
    protected static abstract class Suppressor<Element> {
        private final Element annotatedElement;

        public Suppressor(Element annotatedElement) {
            this.annotatedElement = annotatedElement;
        }

        public final Element getAnnotatedElement() {
            return this.annotatedElement;
        }

        public abstract boolean isSuppressed(@NotNull String var1, @NotNull Severity var2);

        public abstract boolean dominates(@NotNull Suppressor<Element> var1);
    }
}

