/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.kotlin.FacadeClassSource;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/FacadeClassSourceShimForFragmentCompilation;", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "Lorg/jetbrains/kotlin/load/kotlin/FacadeClassSource;", "containingFile", "Lorg/jetbrains/kotlin/resolve/source/PsiSourceFile;", "<init>", "(Lorg/jetbrains/kotlin/resolve/source/PsiSourceFile;)V", "fileClassInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "incompatibility", "Lorg/jetbrains/kotlin/serialization/deserialization/IncompatibleVersionErrorData;", "getIncompatibility", "()Lorg/jetbrains/kotlin/serialization/deserialization/IncompatibleVersionErrorData;", "isPreReleaseInvisible", "", "()Z", "abiStability", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerAbiStability;", "getAbiStability", "()Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerAbiStability;", "presentableString", "", "getPresentableString", "()Ljava/lang/String;", "getContainingFile", "Lorg/jetbrains/kotlin/descriptors/SourceFile;", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassName", "()Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "facadeClassName", "getFacadeClassName", "backend.jvm.entrypoint"})
public final class FacadeClassSourceShimForFragmentCompilation
implements DeserializedContainerSource,
FacadeClassSource {
    @NotNull
    private final PsiSourceFile containingFile;
    @NotNull
    private final JvmFileClassInfo fileClassInfo;

    public FacadeClassSourceShimForFragmentCompilation(@NotNull PsiSourceFile containingFile2) {
        Intrinsics.checkNotNullParameter((Object)containingFile2, (String)"containingFile");
        this.containingFile = containingFile2;
        PsiFile psiFile = this.containingFile.getPsiFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        this.fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)psiFile);
    }

    @Override
    @Nullable
    public IncompatibleVersionErrorData<?> getIncompatibility() {
        return null;
    }

    @Override
    public boolean isPreReleaseInvisible() {
        return false;
    }

    @Override
    @NotNull
    public DeserializedContainerAbiStability getAbiStability() {
        return DeserializedContainerAbiStability.STABLE;
    }

    @Override
    @NotNull
    public String getPresentableString() {
        return "Fragment for " + this.containingFile;
    }

    @Override
    @NotNull
    public SourceFile getContainingFile() {
        return this.containingFile;
    }

    @Override
    @NotNull
    public JvmClassName getClassName() {
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses(this.fileClassInfo.getFileClassFqName());
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byFqNameWithoutInnerClasses(...)");
        return jvmClassName;
    }

    @Override
    @Nullable
    public JvmClassName getFacadeClassName() {
        return this.fileClassInfo.getWithJvmMultifileClass() ? JvmClassName.byFqNameWithoutInnerClasses(this.fileClassInfo.getFacadeClassFqName()) : null;
    }
}

