/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockUtils {
    public static PsiStatement addBefore(PsiStatement anchor, PsiStatement ... newStatements) {
        PsiCodeBlock codeBlock;
        PsiJavaToken brace;
        if (newStatements.length == 0) {
            throw new IllegalArgumentException();
        }
        if (anchor instanceof PsiBlockStatement && (brace = (codeBlock = ((PsiBlockStatement)anchor).getCodeBlock()).getLBrace()) != null) {
            PsiElement result2 = brace;
            for (PsiStatement statement : newStatements) {
                result2 = codeBlock.addAfter(statement, result2);
            }
            return (PsiStatement)result2;
        }
        PsiStatement oldStatement = anchor;
        PsiElement parent2 = oldStatement.getParent();
        while (parent2 instanceof PsiLabeledStatement) {
            oldStatement = (PsiStatement)parent2;
            parent2 = oldStatement.getParent();
        }
        if (newStatements.length == 1 && oldStatement instanceof PsiEmptyStatement) {
            return (PsiStatement)oldStatement.replace(newStatements[0]);
        }
        if (!(parent2 instanceof PsiCodeBlock)) {
            oldStatement = BlockUtils.expandSingleStatementToBlockStatement(oldStatement);
            parent2 = oldStatement.getParent();
        }
        PsiElement result3 = null;
        for (PsiStatement statement : newStatements) {
            result3 = parent2.addBefore(statement, oldStatement);
        }
        return (PsiStatement)result3;
    }

    public static PsiStatement addAfter(PsiStatement anchor, PsiStatement newStatement) {
        PsiStatement oldStatement = anchor;
        PsiElement parent2 = oldStatement.getParent();
        while (parent2 instanceof PsiLabeledStatement) {
            oldStatement = (PsiStatement)parent2;
            parent2 = oldStatement.getParent();
        }
        if (!(parent2 instanceof PsiCodeBlock)) {
            oldStatement = BlockUtils.expandSingleStatementToBlockStatement(oldStatement);
            parent2 = oldStatement.getParent();
        }
        return (PsiStatement)parent2.addAfter(newStatement, oldStatement);
    }

    public static <T extends PsiStatement> T expandSingleStatementToBlockStatement(@NotNull T statement) {
        if (statement == null) {
            BlockUtils.$$$reportNull$$$0(0);
        }
        if (statement instanceof PsiBlockStatement) {
            return statement;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory(statement.getProject()).createStatementFromText("{\n}", statement);
        blockStatement.getCodeBlock().add(statement);
        PsiBlockStatement result2 = (PsiBlockStatement)statement.replace(blockStatement);
        PsiElement sibling = result2.getNextSibling();
        if (sibling instanceof PsiWhiteSpace && PsiUtil.isJavaToken(sibling.getNextSibling(), JavaTokenType.ELSE_KEYWORD)) {
            sibling.delete();
        }
        return (T)result2.getCodeBlock().getStatements()[0];
    }

    @Nullable
    public static PsiElement getBody(PsiElement element2) {
        if (element2 instanceof PsiLoopStatement) {
            PsiStatement loopBody = ((PsiLoopStatement)element2).getBody();
            return loopBody instanceof PsiBlockStatement ? ((PsiBlockStatement)loopBody).getCodeBlock() : loopBody;
        }
        if (element2 instanceof PsiParameterListOwner) {
            return ((PsiParameterListOwner)element2).getBody();
        }
        if (element2 instanceof PsiSynchronizedStatement) {
            return ((PsiSynchronizedStatement)element2).getBody();
        }
        if (element2 instanceof PsiSwitchStatement) {
            return ((PsiSwitchStatement)element2).getBody();
        }
        if (element2 instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)element2).getBody();
        }
        if (element2 instanceof PsiCatchSection) {
            return ((PsiCatchSection)element2).getCatchBlock();
        }
        throw new AssertionError((Object)("can't get body from " + element2));
    }

    public static void unwrapTryBlock(PsiTryStatement tryStatement) {
        PsiElement last;
        PsiUtilCore.ensureValid(tryStatement);
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        PsiElement parent2 = tryStatement.getParent();
        boolean singleStatement = false;
        if (parent2 instanceof PsiStatement) {
            PsiStatement[] statements = tryBlock.getStatements();
            if (statements.length == 1 && !(statements[0] instanceof PsiDeclarationStatement)) {
                singleStatement = true;
            } else {
                tryStatement = BlockUtils.expandSingleStatementToBlockStatement(tryStatement);
            }
        } else if (parent2 instanceof PsiCodeBlock) {
            if (BlockUtils.containsConflictingDeclarations(tryBlock, (PsiCodeBlock)parent2)) {
                tryStatement = BlockUtils.expandSingleStatementToBlockStatement(tryStatement);
            }
        } else {
            return;
        }
        tryBlock = tryStatement.getTryBlock();
        assert (tryBlock != null);
        PsiElement first = singleStatement ? BlockUtils.skip(tryBlock.getFirstBodyElement(), true) : tryBlock.getFirstBodyElement();
        PsiElement psiElement = last = singleStatement ? BlockUtils.skip(tryBlock.getLastBodyElement(), false) : tryBlock.getLastBodyElement();
        assert (first != null && last != null);
        tryStatement.getParent().addRangeBefore(first, last, tryStatement);
        tryStatement.delete();
    }

    private static PsiElement skip(PsiElement element2, boolean forward) {
        if (!(element2 instanceof PsiWhiteSpace)) {
            return element2;
        }
        return forward ? element2.getNextSibling() : element2.getPrevSibling();
    }

    public static boolean containsConflictingDeclarations(@NotNull PsiCodeBlock block, @NotNull PsiCodeBlock parentBlock) {
        PsiStatement[] statements;
        if (block == null) {
            BlockUtils.$$$reportNull$$$0(1);
        }
        if (parentBlock == null) {
            BlockUtils.$$$reportNull$$$0(2);
        }
        if ((statements = block.getStatements()).length == 0) {
            return false;
        }
        int endOffset = block.getTextRange().getEndOffset();
        List affectedBlocks = SyntaxTraverser.psiTraverser(parentBlock).filter(PsiCodeBlock.class).filter(cb -> cb.getTextRange().getEndOffset() > endOffset).addAllTo(new SmartList());
        Project project = block.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        for (PsiStatement statement : statements) {
            PsiElement[] variables2;
            if (!(statement instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)statement;
            for (PsiElement variable : variables2 = declaration2.getDeclaredElements()) {
                if (!(variable instanceof PsiLocalVariable)) continue;
                PsiLocalVariable localVariable = (PsiLocalVariable)variable;
                String variableName = localVariable.getName();
                for (PsiCodeBlock codeBlock : affectedBlocks) {
                    PsiVariable target = resolveHelper.resolveAccessibleReferencedVariable(variableName, codeBlock);
                    if (target instanceof PsiLocalVariable) {
                        return true;
                    }
                    if (!(target instanceof PsiField)) continue;
                    for (PsiCodeBlock affectedBlock : affectedBlocks) {
                        if (SyntaxTraverser.psiTraverser(affectedBlock).filter(PsiReferenceExpression.class).filter(ref -> ref.resolve() == target).isEmpty()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Nullable
    public static PsiElement inlineCodeBlock(@NotNull PsiStatement statement, @NotNull PsiCodeBlock codeBlock) {
        if (statement == null) {
            BlockUtils.$$$reportNull$$$0(3);
        }
        if (codeBlock == null) {
            BlockUtils.$$$reportNull$$$0(4);
        }
        PsiJavaToken lBrace = codeBlock.getLBrace();
        PsiJavaToken rBrace = codeBlock.getRBrace();
        if (lBrace == null || rBrace == null) {
            return null;
        }
        PsiElement first = PsiTreeUtil.skipWhitespacesForward(lBrace);
        PsiElement added = null;
        if (first != rBrace) {
            assert (first != null);
            added = statement.getParent().addRangeBefore(first, rBrace.getPrevSibling(), statement);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(statement.getManager());
            codeStyleManager.reformat(added);
        }
        statement.delete();
        return added;
    }

    public static PsiBlockStatement createBlockStatement(Project project) {
        return (PsiBlockStatement)JavaPsiFacade.getElementFactory(project).createStatementFromText("{}", null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/BlockUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "expandSingleStatementToBlockStatement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsConflictingDeclarations";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineCodeBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

