/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"isInlineClassThatRequiresMangling", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isDontMangleClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmFieldApplicabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmFieldApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityCheckerKt\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,144:1\n59#2:145\n53#2,4:146\n*S KotlinDebug\n*F\n+ 1 FirJvmFieldApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityCheckerKt\n*L\n138#1:145\n138#1:146,4\n*E\n"})
public final class FirJvmFieldApplicabilityCheckerKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineClassThatRequiresMangling(@NotNull FirTypeRef $this$isInlineClassThatRequiresMangling, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClassThatRequiresMangling, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType($this$isInlineClassThatRequiresMangling), session);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol symbol = firRegularClassSymbol;
        FirClassLikeSymbol $this$isInlineOrValue$iv = symbol;
        boolean $i$f$isInlineOrValue = false;
        FirClassLikeSymbol $this$isInline$iv$iv = $this$isInlineOrValue$iv;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv$iv.getRawStatus().isInline()) {
            FirClassLikeSymbol $this$isValue$iv$iv = $this$isInlineOrValue$iv;
            boolean $i$f$isValue = false;
            if (!$this$isValue$iv$iv.getRawStatus().isValue()) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        if (FirJvmFieldApplicabilityCheckerKt.isDontMangleClass(symbol)) return false;
        return true;
    }

    private static final boolean isDontMangleClass(FirRegularClassSymbol $this$isDontMangleClass) {
        return Intrinsics.areEqual((Object)$this$isDontMangleClass.getClassId(), (Object)StandardClassIds.INSTANCE.getResult());
    }
}

