/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.StandardTypes;
import org.jetbrains.kotlin.fir.analysis.checkers.ClassSymbolAndProjections;
import org.jetbrains.kotlin.fir.analysis.checkers.FE10LikeConeSubstitutor;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aD\u0010\u0000\u001a\u00020\u00012\u001a\u0010\u0002\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u001a8\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u001a\u0010\u0002\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"checkInconsistentTypeParameters", "", "firTypeRefClasses", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "isValues", "", "buildDeepSubstitutionMultimap", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ClassSymbolAndProjections;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInconsistentTypeParameterHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInconsistentTypeParameterHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirInconsistentTypeParameterHelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,112:1\n1563#2:113\n1634#2,3:114\n2746#2,3:124\n382#3,7:117\n*S KotlinDebug\n*F\n+ 1 FirInconsistentTypeParameterHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirInconsistentTypeParameterHelpersKt\n*L\n41#1:113\n41#1:114,3\n77#1:124,3\n72#1:117,7\n*E\n"})
public final class FirInconsistentTypeParameterHelpersKt {
    /*
     * WARNING - void declaration
     */
    public static final void checkInconsistentTypeParameters(@NotNull List<? extends Pair<? extends FirTypeRef, FirRegularClassSymbol>> firTypeRefClasses, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement source, boolean isValues) {
        Intrinsics.checkNotNullParameter(firTypeRefClasses, (String)"firTypeRefClasses");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Map<FirTypeParameterSymbol, ClassSymbolAndProjections> result2 = FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap(firTypeRefClasses, context2);
        for (Map.Entry<FirTypeParameterSymbol, ClassSymbolAndProjections> entry : result2.entrySet()) {
            Collection<ConeKotlinType> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FirTypeParameterSymbol typeParameterSymbol = entry.getKey();
            ClassSymbolAndProjections typeAndProjections = entry.getValue();
            List<ConeTypeProjection> projections = typeAndProjections.getProjections();
            if (projections.size() <= 1) continue;
            KtDiagnosticFactory3<FirTypeParameterSymbol, FirRegularClassSymbol, Collection<ConeKotlinType>> diagnosticFactory = isValues ? FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETER_VALUES() : FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETER_BOUNDS();
            Iterable iterable = projections;
            FirRegularClassSymbol firRegularClassSymbol = typeAndProjections.getClassSymbol();
            FirTypeParameterSymbol firTypeParameterSymbol = typeParameterSymbol;
            KtDiagnosticFactory3<FirTypeParameterSymbol, FirRegularClassSymbol, Collection<ConeKotlinType>> ktDiagnosticFactory3 = diagnosticFactory;
            AbstractKtSourceElement abstractKtSourceElement = source;
            DiagnosticReporter diagnosticReporter = reporter;
            boolean $i$f$map = false;
            void var14_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConeTypeProjection coneTypeProjection = (ConeTypeProjection)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)it);
                if (coneKotlinType == null) {
                    coneKotlinType = StandardTypes.INSTANCE.getNullableAny();
                }
                collection.add(coneKotlinType);
            }
            collection = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory3, (Object)firTypeParameterSymbol, (Object)firRegularClassSymbol, (Object)collection, (DiagnosticContext)context2, null, 64, null);
        }
    }

    private static final Map<FirTypeParameterSymbol, ClassSymbolAndProjections> buildDeepSubstitutionMultimap(List<? extends Pair<? extends FirTypeRef, FirRegularClassSymbol>> firTypeRefClasses, CheckerContext context2) {
        Map result2 = new LinkedHashMap();
        Map substitution = new LinkedHashMap();
        FirSession session = context2.getSession();
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(session);
        FE10LikeConeSubstitutor substitutor2 = new FE10LikeConeSubstitutor(substitution, session);
        Set visitedSupertypes = new LinkedHashSet();
        for (Pair<? extends FirTypeRef, FirRegularClassSymbol> pair : firTypeRefClasses) {
            FirTypeRef typeRef = (FirTypeRef)pair.component1();
            FirRegularClassSymbol regularClassSymbol = (FirRegularClassSymbol)pair.component2();
            Object object = typeRef;
            FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap$fillInDeepSubstitutor(substitutor2, substitution, result2, session, visitedSupertypes, typeContext2, object != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null && (object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)object, session, null, 2, null)) != null ? ((ConeKotlinType)object).getTypeArguments() : null, regularClassSymbol, context2);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildDeepSubstitutionMultimap$fillInDeepSubstitutor(FE10LikeConeSubstitutor substitutor2, Map<FirTypeParameterSymbol, ConeTypeProjection> substitution, Map<FirTypeParameterSymbol, ClassSymbolAndProjections> result2, FirSession session, Set<ConeKotlinType> visitedSupertypes, ConeInferenceContext typeContext2, ConeTypeProjection[] typeArguments2, FirRegularClassSymbol classSymbol, CheckerContext context2) {
        if (typeArguments2 != null) {
            List<FirTypeParameterSymbol> typeParameterSymbols = classSymbol.getTypeParameterSymbols();
            int count = Math.min(typeArguments2.length, typeParameterSymbols.size());
            for (int index2 = 0; index2 < count; ++index2) {
                boolean bl2;
                List<ConeTypeProjection> projections;
                ConeTypeProjection substitutedArgument;
                block11: {
                    Object object;
                    void $this$getOrPut$iv;
                    ConeTypeProjection typeArgument = typeArguments2[index2];
                    ConeTypeProjection coneTypeProjection = substitutor2.substituteArgument(typeArgument, index2);
                    if (coneTypeProjection == null) {
                        coneTypeProjection = typeArgument;
                    }
                    substitutedArgument = coneTypeProjection;
                    FirTypeParameterSymbol typeParameterSymbol = typeParameterSymbols.get(index2);
                    substitution.put(typeParameterSymbol, substitutedArgument);
                    Map<FirTypeParameterSymbol, ClassSymbolAndProjections> map = result2;
                    FirTypeParameterSymbol key$iv = typeParameterSymbol;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        ClassSymbolAndProjections answer$iv = new ClassSymbolAndProjections(classSymbol, new ArrayList());
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    projections = ((ClassSymbolAndProjections)object).getProjections();
                    ConeKotlinType substitutedArgumentType = ConeTypeProjectionKt.getType(substitutedArgument);
                    Iterable $this$none$iv = projections;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            boolean bl4;
                            ConeTypeProjection it = (ConeTypeProjection)element$iv;
                            boolean bl5 = false;
                            if (substitutedArgumentType == null || ConeTypeProjectionKt.getType(it) == null) {
                                bl4 = it == substitutedArgument;
                            } else {
                                TypeCheckerProviderContext typeCheckerProviderContext = typeContext2;
                                ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it);
                                Intrinsics.checkNotNull((Object)coneKotlinType);
                                bl4 = AbstractTypeChecker.equalTypes$default(AbstractTypeChecker.INSTANCE, typeCheckerProviderContext, coneKotlinType, substitutedArgumentType, false, false, 24, null);
                            }
                            if (!bl4) continue;
                            bl2 = false;
                            break block11;
                        }
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                projections.add(substitutedArgument);
            }
        }
        for (FirResolvedTypeRef superTypeRef : classSymbol.getResolvedSuperTypeRefs()) {
            ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default(superTypeRef.getConeType(), session, null, 2, null);
            if (!visitedSupertypes.add(fullyExpandedType2)) continue;
            FirRegularClassSymbol superClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(fullyExpandedType2, session);
            if (ConeBuiltinTypeUtilsKt.isEnum(fullyExpandedType2) || superClassSymbol == null) continue;
            FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap$fillInDeepSubstitutor(substitutor2, substitution, result2, session, visitedSupertypes, typeContext2, fullyExpandedType2.getTypeArguments(), superClassSymbol, context2);
        }
    }
}

