/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.projectStructure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaResolutionScope;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleProvider;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0011\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\f\u0010\u0018\u001a\u00020\r*\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/projectStructure/KaBaseResolutionScope;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KaResolutionScope;", "useSiteModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "analyzableModules", "", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lcom/intellij/psi/search/GlobalSearchScope;Ljava/util/Set;)V", "getProject", "Lcom/intellij/openapi/project/Project;", "isSearchInModuleContent", "", "aModule", "Lcom/intellij/openapi/module/Module;", "isSearchInLibraries", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "element", "Lcom/intellij/psi/PsiElement;", "isAccessibleDanglingFile", "virtualFile", "isAccessibleFromUseSiteModule", "toString", "", "analysis-api-impl-base"})
public final class KaBaseResolutionScope
extends KaResolutionScope {
    @NotNull
    private final KaModule useSiteModule;
    @NotNull
    private final GlobalSearchScope searchScope;
    @NotNull
    private final Set<KaModule> analyzableModules;

    public KaBaseResolutionScope(@NotNull KaModule useSiteModule, @NotNull GlobalSearchScope searchScope, @NotNull Set<? extends KaModule> analyzableModules) {
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Intrinsics.checkNotNullParameter(analyzableModules, (String)"analyzableModules");
        this.useSiteModule = useSiteModule;
        this.searchScope = searchScope;
        this.analyzableModules = analyzableModules;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.searchScope.getProject();
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
        return this.searchScope.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.searchScope.isSearchInLibraries();
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.searchScope.contains(file) || this.isAccessibleDanglingFile(file);
    }

    @Override
    public boolean contains(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        VirtualFile virtualFile = element2.getContainingFile().getVirtualFile();
        return virtualFile != null && this.searchScope.contains(virtualFile) || this.isAccessibleDanglingFile(element2);
    }

    private final boolean isAccessibleDanglingFile(PsiElement element2) {
        PsiFile psiFile = element2.getContainingFile();
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return false;
        }
        KtFile ktFile2 = ktFile;
        if (!DanglingFilesKt.isDangling(ktFile2)) {
            return false;
        }
        KaModule kaModule = DanglingFilesKt.getContextModule(ktFile2);
        if (kaModule == null) {
            kaModule = KaModuleProvider.Companion.getModule(this.useSiteModule.getProject(), ktFile2, this.useSiteModule);
        }
        KaModule module2 = kaModule;
        return this.isAccessibleFromUseSiteModule(module2);
    }

    private final boolean isAccessibleDanglingFile(VirtualFile virtualFile) {
        KaModule kaModule = ContextModuleKt.getAnalysisContextModule(virtualFile);
        return kaModule != null ? this.isAccessibleFromUseSiteModule(kaModule) : false;
    }

    private final boolean isAccessibleFromUseSiteModule(KaModule $this$isAccessibleFromUseSiteModule) {
        return this.analyzableModules.contains($this$isAccessibleFromUseSiteModule);
    }

    @NotNull
    public String toString() {
        return "Resolution scope for '" + this.useSiteModule + "'. Underlying search scope: '" + this.searchScope + '\'';
    }
}

