/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output.support;

import java.util.List;
import org.jdom.Content;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.output.support.AbstractFormattedWalker;
import org.jdom.output.support.FormatStack;

public class WalkerTRIM
extends AbstractFormattedWalker {
    public WalkerTRIM(List<? extends Content> content, FormatStack fstack, boolean escape) {
        super(content, fstack, escape);
    }

    @Override
    protected void analyzeMultiText(AbstractFormattedWalker.MultiText mtext, int offset, int len) {
        Content c2;
        while (len > 0 && (c2 = this.get(offset)) instanceof Text && Verifier.isAllXMLWhitespace(c2.getValue())) {
            ++offset;
            --len;
        }
        while (len > 0 && (c2 = this.get(offset + len - 1)) instanceof Text && Verifier.isAllXMLWhitespace(c2.getValue())) {
            --len;
        }
        block6: for (int i2 = 0; i2 < len; ++i2) {
            AbstractFormattedWalker.Trim trim = AbstractFormattedWalker.Trim.NONE;
            if (i2 + 1 == len) {
                trim = AbstractFormattedWalker.Trim.RIGHT;
            }
            if (i2 == 0) {
                trim = AbstractFormattedWalker.Trim.LEFT;
            }
            if (len == 1) {
                trim = AbstractFormattedWalker.Trim.BOTH;
            }
            Content c3 = this.get(offset + i2);
            switch (c3.getCType()) {
                case Text: {
                    mtext.appendText(trim, c3.getValue());
                    continue block6;
                }
                case CDATA: {
                    mtext.appendCDATA(trim, c3.getValue());
                    continue block6;
                }
                default: {
                    mtext.appendRaw(c3);
                }
            }
        }
    }
}

