/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFunctionDelegateMemberNameClashChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "functionDelegateName", "Lorg/jetbrains/kotlin/name/Name;", "getFunctionDelegateName", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmFunctionDelegateMemberNameClashChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmFunctionDelegateMemberNameClashChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFunctionDelegateMemberNameClashChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,38:1\n64#2:39\n*S KotlinDebug\n*F\n+ 1 FirJvmFunctionDelegateMemberNameClashChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFunctionDelegateMemberNameClashChecker\n*L\n28#1:39\n*E\n"})
public final class FirJvmFunctionDelegateMemberNameClashChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmFunctionDelegateMemberNameClashChecker INSTANCE = new FirJvmFunctionDelegateMemberNameClashChecker();
    @NotNull
    private static final Name functionDelegateName;
    @NotNull
    private static final Name getFunctionDelegateName;

    private FirJvmFunctionDelegateMemberNameClashChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (!(declaration2 instanceof FirCallableDeclaration)) {
                    return;
                }
                FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(declaration2);
                FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                if (firRegularClassSymbol == null) {
                    return;
                }
                FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
                FirClassLikeSymbol $this$isFun$iv = containingClassSymbol;
                boolean $i$f$isFun = false;
                if (!$this$isFun$iv.getRawStatus().isFun()) {
                    return;
                }
                if (FirCallableSymbolKt.isExtension(((FirCallableDeclaration)declaration2).getSymbol())) break block7;
                FirDeclaration firDeclaration = declaration2;
                Object object = firDeclaration instanceof FirFunction ? (FirFunction)firDeclaration : null;
                boolean bl2 = object != null && (object = ((FirFunction)object).getValueParameters()) != null ? !((Collection)object).isEmpty() : false;
                if (!bl2) break block8;
            }
            return;
        }
        if (declaration2 instanceof FirSimpleFunction && Intrinsics.areEqual((Object)((FirSimpleFunction)declaration2).getName(), (Object)getFunctionDelegateName) || declaration2 instanceof FirProperty && Intrinsics.areEqual((Object)((FirProperty)declaration2).getName(), (Object)functionDelegateName)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirCallableDeclaration)declaration2).getSource(), FirJvmErrors.INSTANCE.getFUNCTION_DELEGATE_MEMBER_NAME_CLASH(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    static {
        Name name2 = Name.identifier("functionDelegate");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        functionDelegateName = name2;
        Name name3 = Name.identifier("getFunctionDelegate");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        getFunctionDelegateName = name3;
    }
}

