/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.ConstantConditionEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/ApiVersionCallsPreprocessingMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "targetApiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "<init>", "(Lorg/jetbrains/kotlin/config/ApiVersion;)V", "constantConditionElimination", "Lorg/jetbrains/kotlin/codegen/optimization/ConstantConditionEliminationMethodTransformer;", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "isApiVersionIsAtLeastCall", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getIntConstValue", "", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)Ljava/lang/Integer;", "backend"})
@SourceDebugExtension(value={"SMAP\nApiVersionCallsPreprocessingMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiVersionCallsPreprocessingMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/ApiVersionCallsPreprocessingMethodTransformer\n+ 2 BoxingInterpreter.kt\norg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreterKt\n*L\n1#1,93:1\n233#2:94\n*S KotlinDebug\n*F\n+ 1 ApiVersionCallsPreprocessingMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/ApiVersionCallsPreprocessingMethodTransformer\n*L\n68#1:94\n*E\n"})
public final class ApiVersionCallsPreprocessingMethodTransformer
extends MethodTransformer {
    @NotNull
    private final ApiVersion targetApiVersion;
    @NotNull
    private final ConstantConditionEliminationMethodTransformer constantConditionElimination;

    public ApiVersionCallsPreprocessingMethodTransformer(@NotNull ApiVersion targetApiVersion) {
        Intrinsics.checkNotNullParameter((Object)targetApiVersion, (String)"targetApiVersion");
        this.targetApiVersion = targetApiVersion;
        this.constantConditionElimination = new ConstantConditionEliminationMethodTransformer();
    }

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        boolean hasFoldedCalls = false;
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])methodNode.instructions.toArray());
        while (iterator2.hasNext()) {
            AbstractInsnNode prev1;
            AbstractInsnNode prev2;
            AbstractInsnNode prev3;
            AbstractInsnNode insn = (AbstractInsnNode)iterator2.next();
            Intrinsics.checkNotNull((Object)insn);
            if (!this.isApiVersionIsAtLeastCall(insn) || insn.getPrevious() == null) continue;
            Integer n2 = this.getIntConstValue(prev3);
            if (n2 == null) {
                continue;
            }
            int minor = n2;
            if (prev3.getPrevious() == null) continue;
            Integer n3 = this.getIntConstValue(prev2);
            if (n3 == null) {
                continue;
            }
            int major = n3;
            if (prev2.getPrevious() == null) continue;
            Integer n4 = this.getIntConstValue(prev1);
            if (n4 == null) {
                continue;
            }
            int epic = n4;
            hasFoldedCalls = true;
            MavenComparableVersion atLeastVersion = new MavenComparableVersion("" + epic + '.' + major + '.' + minor);
            InsnNode replacementInsn = this.targetApiVersion.getVersion().compareTo(atLeastVersion) >= 0 ? new InsnNode(4) : new InsnNode(3);
            InsnList $this$transform_u24lambda_u240 = methodNode.instructions;
            boolean bl2 = false;
            $this$transform_u24lambda_u240.remove(prev1);
            $this$transform_u24lambda_u240.remove(prev2);
            $this$transform_u24lambda_u240.remove(prev3);
            $this$transform_u24lambda_u240.set(insn, replacementInsn);
        }
        if (hasFoldedCalls) {
            this.constantConditionElimination.transform(internalClassName, methodNode);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApiVersionIsAtLeastCall(AbstractInsnNode $this$isApiVersionIsAtLeastCall) {
        void $this$isMethodInsnWith$iv;
        AbstractInsnNode abstractInsnNode = $this$isApiVersionIsAtLeastCall;
        int opcode$iv = 184;
        boolean $i$f$isMethodInsnWith = false;
        if ($this$isMethodInsnWith$iv.getOpcode() != opcode$iv) return false;
        if (!($this$isMethodInsnWith$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $this$isApiVersionIsAtLeastCall_u24lambda_u241 = (MethodInsnNode)$this$isMethodInsnWith$iv;
        boolean bl2 = false;
        String string2 = $this$isApiVersionIsAtLeastCall_u24lambda_u241.owner;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"owner");
        if (!StringsKt.startsWith$default((String)string2, (String)"kotlin/internal", (boolean)false, (int)2, null)) return false;
        if (!Intrinsics.areEqual((Object)$this$isApiVersionIsAtLeastCall_u24lambda_u241.name, (Object)"apiVersionIsAtLeast")) return false;
        if (!Intrinsics.areEqual((Object)$this$isApiVersionIsAtLeastCall_u24lambda_u241.desc, (Object)"(III)Z")) return false;
        return true;
    }

    private final Integer getIntConstValue(AbstractInsnNode $this$getIntConstValue) {
        Integer n2;
        AbstractInsnNode abstractInsnNode = $this$getIntConstValue;
        if (abstractInsnNode instanceof InsnNode) {
            int n3 = ((InsnNode)$this$getIntConstValue).getOpcode();
            n2 = (2 <= n3 ? n3 < 9 : false) ? Integer.valueOf(((InsnNode)$this$getIntConstValue).getOpcode() - 3) : null;
        } else if (abstractInsnNode instanceof IntInsnNode) {
            switch (((IntInsnNode)$this$getIntConstValue).getOpcode()) {
                case 16: {
                    n2 = ((IntInsnNode)$this$getIntConstValue).operand;
                    break;
                }
                case 17: {
                    n2 = ((IntInsnNode)$this$getIntConstValue).operand;
                    break;
                }
                default: {
                    n2 = null;
                    break;
                }
            }
        } else {
            Object object;
            n2 = abstractInsnNode instanceof LdcInsnNode ? ((object = ((LdcInsnNode)$this$getIntConstValue).cst) instanceof Integer ? (Integer)object : null) : null;
        }
        return n2;
    }
}

