/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.IntKeyWeakValueHashMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.SoftValueHashMap;
import com.intellij.util.containers.WeakHashSet;
import com.intellij.util.containers.WeakKeyIntValueHashMap;
import com.intellij.util.containers.WeakValueHashMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public final class ContainerUtil {
    private static final int INSERTION_SORT_THRESHOLD = 10;

    @SafeVarargs
    @Contract(pure=true)
    public static <T> T @NotNull [] ar(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(1);
        }
        return elements;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(2);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(3);
        }
        HashMap<K, V> map = new HashMap<K, V>(entries.length + 1);
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull List<? extends K> keys, @NotNull List<? extends V> values2) {
        if (keys == null) {
            ContainerUtil.$$$reportNull$$$0(5);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(6);
        }
        if (keys.size() != values2.size()) {
            throw new IllegalArgumentException(keys + " must have same length as " + values2);
        }
        HashMap<K, V> map = new HashMap<K, V>(keys.size());
        for (int i2 = 0; i2 < keys.size(); ++i2) {
            map.put(keys.get(i2), values2.get(i2));
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(8);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(9);
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        LinkedHashMap<K, V> linkedHashMap = map;
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(10);
        }
        return linkedHashMap;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(11);
        }
        LinkedList list = new LinkedList();
        Collections.addAll(list, elements);
        LinkedList linkedList = list;
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(12);
        }
        return linkedList;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(13);
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <E> ArrayList<E> newArrayList(@NotNull Collection<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(14);
        }
        Logger.getInstance(ContainerUtil.class).error("Use `new ArrayList(Collection)` instead. " + iterable.getClass());
        return new ArrayList<E>(iterable);
    }

    @Contract(pure=true)
    @NotNull
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(15);
        }
        ArrayList<E> collection = new ArrayList<E>();
        for (E element2 : iterable) {
            collection.add(element2);
        }
        ArrayList<E> arrayList = collection;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        return new ArrayList(size);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> subArrayAsList(final T @NotNull [] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(17);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                if (index2 < 0 || index2 >= end - start) {
                    throw new IndexOutOfBoundsException("index:" + index2 + " size:" + (end - start));
                }
                return elements[start + index2];
            }

            @Override
            public int size() {
                return end - start;
            }
        };
    }

    @Deprecated
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> newUnmodifiableList(@NotNull List<? extends T> originalList) {
        int size;
        if (originalList == null) {
            ContainerUtil.$$$reportNull$$$0(18);
        }
        if ((size = originalList.size()) == 0) {
            return ContainerUtil.emptyList();
        }
        if (size == 1) {
            List<T> list = Collections.singletonList(originalList.get(0));
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(19);
            }
            return list;
        }
        List<? extends T> list = Collections.unmodifiableList(new ArrayList<T>(originalList));
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> unmodifiableOrEmptyList(@NotNull List<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(21);
        }
        if ((size = original.size()) == 0) {
            return ContainerUtil.emptyList();
        }
        List<? extends T> list = Collections.unmodifiableList(original);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> unmodifiableOrEmptySet(@NotNull Set<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(23);
        }
        if ((size = original.size()) == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(24);
            }
            return set;
        }
        Set<? extends T> set = Collections.unmodifiableSet(original);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(25);
        }
        return set;
    }

    @Contract(pure=true)
    public static <K, V> @Unmodifiable @NotNull Map<K, V> unmodifiableOrEmptyMap(@NotNull Map<? extends K, ? extends V> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(26);
        }
        if ((size = original.size()) == 0) {
            Map map = Collections.emptyMap();
            if (map == null) {
                ContainerUtil.$$$reportNull$$$0(27);
            }
            return map;
        }
        Map<? extends K, ? extends V> map = Collections.unmodifiableMap(original);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(28);
        }
        return map;
    }

    @Deprecated
    @NotNull
    public static <T> List<T> newSmartList() {
        return new SmartList();
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(29);
        }
        return new HashSet<T>(Arrays.asList(elements));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(30);
        }
        HashSet<T> set = new HashSet<T>();
        for (T t2 : iterable) {
            set.add(t2);
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(31);
        }
        return hashSet;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Collection<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(32);
        }
        Logger.getInstance(ContainerUtil.class).error("use HashSet#HashSet(Collection) instead");
        return new HashSet<T>(iterable);
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(33);
        }
        HashSet<T> set = new HashSet<T>();
        while (iterator2.hasNext()) {
            set.add(iterator2.next());
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(34);
        }
        return hashSet;
    }

    @Deprecated
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean isEmpty;
        boolean bl2 = isEmpty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        if (isEmpty) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(35);
            }
            return set;
        }
        return ContainerUtil.newHashSet(iterable);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(36);
        }
        LinkedHashSet<T> collection = new LinkedHashSet<T>();
        for (T element2 : elements) {
            collection.add(element2);
        }
        LinkedHashSet<T> linkedHashSet = collection;
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(37);
        }
        return linkedHashSet;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Collection<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(38);
        }
        Logger.getInstance(ContainerUtil.class).error("use LinkedHashSet#LinkedHashSet(Collection) instead");
        return new LinkedHashSet<T>(iterable);
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(39);
        }
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> newConcurrentSet() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        if (keySetView == null) {
            ContainerUtil.$$$reportNull$$$0(40);
        }
        return keySetView;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull List<E> reverse(final @NotNull List<? extends E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(41);
        }
        if (elements.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index2) {
                return elements.get(elements.size() - 1 - index2);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }

    @Contract(pure=true)
    public static <K, V> @Unmodifiable @NotNull Map<K, V> union(@NotNull Map<? extends K, ? extends V> map, @NotNull Map<? extends K, ? extends V> map2) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(42);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(43);
        }
        HashMap<K, V> result2 = new HashMap<K, V>(map.size() + map2.size());
        result2.putAll(map);
        result2.putAll(map2);
        HashMap<K, V> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(44);
        }
        return hashMap;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> union(@NotNull Set<? extends T> set, @NotNull Set<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(45);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(46);
        }
        return ContainerUtil.union(set, set2);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> union(@NotNull Collection<? extends T> set, @NotNull Collection<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(47);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(48);
        }
        HashSet<T> result2 = new HashSet<T>(set.size() + set2.size());
        result2.addAll(set);
        result2.addAll(set2);
        HashSet<T> hashSet = result2;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(49);
        }
        return hashSet;
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(50);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(51);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(52);
                }
                return set;
            }
        }
        Set<E> set = Collections.unmodifiableSet(new HashSet<E>(Arrays.asList(elements)));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(53);
        }
        return set;
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(54);
        }
        return new ImmutableListBackedByArray(array);
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    public static <E> @Unmodifiable @NotNull List<E> immutableList() {
        List list = Collections.emptyList();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(55);
        }
        return list;
    }

    @Deprecated
    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull List<E> immutableList(E element2) {
        List<E> list = Collections.singletonList(element2);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(56);
        }
        return list;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    public static <E> @Unmodifiable @NotNull ImmutableList<E> immutableSingletonList(E element2) {
        ImmutableList<E> immutableList = ImmutableList.singleton(element2);
        if (immutableList == null) {
            ContainerUtil.$$$reportNull$$$0(57);
        }
        return immutableList;
    }

    @Deprecated
    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull ImmutableList<E> immutableList(@NotNull List<? extends E> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(58);
        }
        return list instanceof ImmutableList ? (ImmutableList)list : new ImmutableListBackedByList(list);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        return new ImmutableMapBuilder();
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> MultiMap<K, V> groupBy(@NotNull Iterable<? extends V> collection, @NotNull NullableFunction<? super V, ? extends K> grouper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(59);
        }
        if (grouper == null) {
            ContainerUtil.$$$reportNull$$$0(60);
        }
        MultiMap<K, V> result2 = MultiMap.createLinked();
        for (V data : collection) {
            K key = grouper.fun(data);
            if (key == null) continue;
            result2.putValue(key, data);
        }
        if (!result2.isEmpty() && result2.keySet().iterator().next() instanceof Comparable) {
            return new KeyOrderedMultiMap(result2);
        }
        MultiMap<K, V> multiMap = result2;
        if (multiMap == null) {
            ContainerUtil.$$$reportNull$$$0(61);
        }
        return multiMap;
    }

    @Contract(pure=true)
    public static <T> T getOrElse(@NotNull List<? extends T> elements, int i2, T defaultValue) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(62);
        }
        return elements.size() > i2 ? elements.get(i2) : defaultValue;
    }

    @Contract(pure=true)
    public static <K, V> @Unmodifiable @NotNull Map<K, V> intersection(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(63);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(64);
        }
        if (map1.isEmpty() || map2.isEmpty()) {
            Map map = Collections.emptyMap();
            if (map == null) {
                ContainerUtil.$$$reportNull$$$0(65);
            }
            return map;
        }
        if (map2.size() < map1.size()) {
            Map<K, V> t2 = map1;
            map1 = map2;
            map2 = t2;
        }
        HashMap<K, V> res2 = new HashMap<K, V>(map1);
        for (Map.Entry<K, V> entry : map1.entrySet()) {
            V v2;
            K key = entry.getKey();
            V v1 = entry.getValue();
            if (Objects.equals(v1, v2 = map2.get(key))) continue;
            res2.remove(key);
        }
        HashMap<K, V> hashMap = res2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(66);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, Couple<V>> diff(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(67);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(68);
        }
        Set<K> keys = ContainerUtil.union(map1.keySet(), map2.keySet());
        HashMap<K, Couple<V>> res2 = new HashMap<K, Couple<V>>();
        for (K k2 : keys) {
            V v2;
            V v1 = map1.get(k2);
            if (Objects.equals(v1, v2 = map2.get(k2))) continue;
            res2.put(k2, Couple.of(v1, v2));
        }
        HashMap<K, Couple<V>> hashMap = res2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(69);
        }
        return hashMap;
    }

    public static <T> void processSortedListsInOrder(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems, @NotNull PairConsumer<? super T, ? super MergeResult> processor) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(70);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(71);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(72);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(73);
        }
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            T element2;
            T e2;
            if (index1 >= list1.size()) {
                e2 = list2.get(index2++);
                processor.consume((MergeResult)((Object)e2), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST2));
                continue;
            }
            if (index2 >= list2.size()) {
                e2 = list1.get(index1++);
                processor.consume((MergeResult)((Object)e2), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST1));
                continue;
            }
            T element1 = list1.get(index1);
            int c2 = comparator.compare(element1, element2 = list2.get(index2));
            if (c2 == 0) {
                ++index1;
                ++index2;
                if (mergeEqualItems) {
                    e2 = element1;
                    processor.consume((MergeResult)((Object)e2), (MergeResult)((MergeResult)MergeResult.MERGED_EQUAL_FROM_BOTH));
                    continue;
                }
                processor.consume((MergeResult)((Object)element1), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST1));
                e2 = element2;
                processor.consume((MergeResult)((Object)e2), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST2));
                continue;
            }
            if (c2 < 0) {
                e2 = element1;
                ++index1;
                processor.consume((MergeResult)((Object)e2), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST1));
                continue;
            }
            e2 = element2;
            ++index2;
            processor.consume((MergeResult)((Object)e2), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST2));
        }
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> mergeSortedLists(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(74);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(75);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(76);
        }
        ArrayList result2 = new ArrayList(list1.size() + list2.size());
        ContainerUtil.processSortedListsInOrder(list1, list2, comparator, mergeEqualItems, (t2, __) -> result2.add(t2));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(77);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> subList(@NotNull List<T> list, int from2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(78);
        }
        List<T> list2 = list.subList(from2, list.size());
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(79);
        }
        return list2;
    }

    @Contract(mutates="param1")
    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(80);
        }
        if (appendix == null) {
            ContainerUtil.$$$reportNull$$$0(81);
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    @Contract(mutates="param1")
    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> iterator2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(82);
        }
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(83);
        }
        while (iterator2.hasNext()) {
            T o2 = iterator2.next();
            collection.add(o2);
        }
    }

    @Contract(mutates="param1")
    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(84);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(85);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    @Contract(mutates="param1")
    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(86);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(87);
        }
        while (elements.hasNext()) {
            T o2 = elements.next();
            if (o2 == null) continue;
            collection.add(o2);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newMapFromKeys(@NotNull Iterator<? extends K> keys, @NotNull Convertor<? super K, ? extends V> valueConvertor) {
        if (keys == null) {
            ContainerUtil.$$$reportNull$$$0(88);
        }
        if (valueConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(89);
        }
        HashMap<K, V> map = new HashMap<K, V>();
        while (keys.hasNext()) {
            K key = keys.next();
            map.put(key, valueConvertor.convert(key));
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(90);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newMapFromValues(@NotNull Iterator<? extends V> values2, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(91);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(92);
        }
        HashMap map = new HashMap();
        ContainerUtil.fillMapWithValues(map, values2, keyConvertor);
        HashMap hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(93);
        }
        return hashMap;
    }

    @Contract(mutates="param1")
    public static <K, V> void fillMapWithValues(@NotNull Map<? super K, ? super V> map, @NotNull Iterator<? extends V> values2, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(94);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(95);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(96);
        }
        while (values2.hasNext()) {
            V value2 = values2.next();
            map.put(keyConvertor.convert(value2), value2);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, Set<V>> classify(@NotNull Iterator<? extends V> iterator2, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(97);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(98);
        }
        LinkedHashMap<Object, Set> hashMap = new LinkedHashMap<Object, Set>();
        while (iterator2.hasNext()) {
            V value2 = iterator2.next();
            K key = keyConvertor.convert(value2);
            Set set = hashMap.computeIfAbsent(key, __ -> new LinkedHashSet());
            set.add(value2);
        }
        LinkedHashMap<Object, Set> linkedHashMap = hashMap;
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(99);
        }
        return linkedHashMap;
    }

    @Contract(pure=true)
    public static <T> T find(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(100);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(101);
        }
        for (T element2 : array) {
            if (!condition.value(element2)) continue;
            return element2;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(102);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(103);
        }
        for (T t2 : iterable) {
            if (processor.process(t2)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list, @NotNull Processor<? super T> processor) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(105);
        }
        int size = list.size();
        for (int i2 = 0; i2 < size; ++i2) {
            T t2 = list.get(i2);
            if (processor.process(t2)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(T @NotNull [] iterable, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(106);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(107);
        }
        for (T t2 : iterable) {
            if (processor.process(t2)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull Iterator<? extends T> iterator2, @NotNull Processor<? super T> processor) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(108);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(109);
        }
        while (iterator2.hasNext()) {
            if (processor.process(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(110);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(111);
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull T equalTo) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(112);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(113);
        }
        return (T)ContainerUtil.find(iterable, object -> equalTo == object || equalTo.equals(object));
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T find(@NotNull Iterator<? extends T> iterator2, @NotNull T equalTo) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(114);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(115);
        }
        return (T)ContainerUtil.find(iterator2, (? super T object) -> equalTo == object || equalTo.equals(object));
    }

    @Nullable
    public static <T> T find(@NotNull Iterator<? extends T> iterator2, @NotNull Condition<? super T> condition) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(116);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(117);
        }
        while (iterator2.hasNext()) {
            T value2 = iterator2.next();
            if (!condition.value(value2)) continue;
            return value2;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T findLast(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        int index2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(118);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(119);
        }
        if ((index2 = ContainerUtil.lastIndexOf(list, condition)) < 0) {
            return null;
        }
        return list.get(index2);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2Map(T @NotNull [] collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(120);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(121);
        }
        HashMap set = new HashMap(collection.length);
        for (T t2 : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t2);
            set.put(pair.first, pair.second);
        }
        HashMap hashMap = set;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(122);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2Map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(123);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(124);
        }
        HashMap set = new HashMap(collection.size());
        for (T t2 : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t2);
            set.put(pair.first, pair.second);
        }
        HashMap hashMap = set;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(125);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2MapNotNull(T @NotNull [] collection, @NotNull Function<? super T, ? extends @Nullable Pair<? extends K, ? extends V>> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(126);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(127);
        }
        HashMap result2 = new HashMap(collection.length);
        for (T t2 : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t2);
            if (pair == null) continue;
            result2.put(pair.first, pair.second);
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(128);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2MapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends @Nullable Pair<? extends K, ? extends V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(129);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(130);
        }
        HashMap result2 = new HashMap(collection.size());
        for (T t2 : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t2);
            if (pair == null) continue;
            result2.put(pair.first, pair.second);
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(131);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> map2Map(@NotNull Collection<? extends Pair<? extends K, ? extends V>> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(132);
        }
        HashMap result2 = new HashMap(collection.size());
        for (Pair<K, V> pair : collection) {
            result2.put(pair.first, pair.second);
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(133);
        }
        return hashMap;
    }

    @Contract(pure=true)
    public static <T> Object @NotNull [] map2Array(T @NotNull [] array, @NotNull Function<? super T, Object> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(134);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(135);
        }
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    @Contract(pure=true)
    public static <T> Object @NotNull [] map2Array(@NotNull Collection<? extends T> array, @NotNull Function<? super T, Object> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(136);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(137);
        }
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map2Array(T @NotNull [] array, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(138);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(139);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(140);
        }
        V[] result2 = ArrayUtil.newArray(aClass, array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            result2[i2] = mapper.fun(array[i2]);
        }
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(141);
        }
        return result2;
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(142);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(143);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(144);
        }
        V[] result2 = ArrayUtil.newArray(aClass, collection.size());
        int i2 = 0;
        for (T t2 : collection) {
            result2[i2++] = mapper.fun(t2);
        }
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(145);
        }
        return result2;
    }

    @Contract(mutates="param2")
    public static <T, V> V @NotNull [] map2Array(@NotNull Collection<? extends T> collection, V @NotNull [] to, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(146);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(147);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(148);
        }
        V[] VArray = ContainerUtil.map(collection, mapper).toArray(to);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(149);
        }
        return VArray;
    }

    @Contract(mutates="param2")
    public static <T, V> V @NotNull [] map2Array(T @NotNull [] collection, V @NotNull [] to, @NotNull Function<? super T, ? extends V> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(150);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(151);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(152);
        }
        V[] VArray = ContainerUtil.map(collection, mapper).toArray(to);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(153);
        }
        return VArray;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> filter(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(154);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(155);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> filterIsInstance(@NotNull Collection<?> collection, @NotNull Class<? extends T> aClass) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(156);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(157);
        }
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> filterIsInstance(Object @NotNull [] collection, @NotNull Class<? extends T> aClass) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(158);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(159);
        }
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(160);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(161);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> filter(@NotNull Map<? extends K, ? extends V> map, @NotNull Condition<? super K> keyFilter) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(162);
        }
        if (keyFilter == null) {
            ContainerUtil.$$$reportNull$$$0(163);
        }
        HashMap<K, V> result2 = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!keyFilter.value(entry.getKey())) continue;
            result2.put(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(164);
        }
        return hashMap;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(165);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(166);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t2 : collection) {
            if (!condition.value(t2)) continue;
            result2.add(t2);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(167);
        }
        return smartList;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(168);
        }
        return ContainerUtil.findAll(collection, Conditions.notNull());
    }

    @Contract(pure=true)
    public static <T, V extends T> @Unmodifiable @NotNull List<V> findAll(T @NotNull [] array, @NotNull Class<V> instanceOf) {
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(169);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(170);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t2 : array) {
            if (!instanceOf.isInstance(t2)) continue;
            result2.add(t2);
        }
        List list = Collections.unmodifiableList(result2);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(171);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V extends T> V @NotNull [] findAllAsArray(T @NotNull [] collection, @NotNull Class<V> instanceOf) {
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(172);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(173);
        }
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        V[] array = ArrayUtil.newArray(instanceOf, list.size());
        V[] VArray = list.toArray(array);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(174);
        }
        return VArray;
    }

    @Contract(pure=true)
    public static <T, V extends T> V @NotNull [] findAllAsArray(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(175);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(176);
        }
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        V[] array = ArrayUtil.newArray(instanceOf, list.size());
        V[] VArray = list.toArray(array);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(177);
        }
        return VArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] findAllAsArray(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        List<T> list;
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(178);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(179);
        }
        if ((list = ContainerUtil.findAll(collection, condition)).size() == collection.length) {
            if (collection == null) {
                ContainerUtil.$$$reportNull$$$0(180);
            }
            return collection;
        }
        T[] array = ArrayUtil.newArray(ArrayUtil.getComponentType(collection), list.size());
        T[] TArray = list.toArray(array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(181);
        }
        return TArray;
    }

    @Contract(pure=true)
    public static <T, V extends T> @Unmodifiable @NotNull List<V> findAll(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(182);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(183);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t2 : collection) {
            if (!instanceOf.isInstance(t2)) continue;
            result2.add(t2);
        }
        List list = Collections.unmodifiableList(result2);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(184);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> findAll(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(185);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(186);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t2 : collection) {
            if (!condition.value(t2)) continue;
            result2.add(t2);
        }
        List list = Collections.unmodifiableList(result2);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(187);
        }
        return list;
    }

    public static <T> boolean all(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(188);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(189);
        }
        return ContainerUtil.and(array, condition);
    }

    public static <T> boolean all(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(190);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(191);
        }
        for (T t2 : collection) {
            if (condition.value(t2)) continue;
            return false;
        }
        return true;
    }

    @Contract(mutates="param1")
    public static void removeDuplicates(@NotNull Collection<?> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(192);
        }
        HashSet collected = new HashSet();
        collection.removeIf(t2 -> !collected.add(t2));
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static Map<String, String> stringMap(String ... keyValues) {
        if (keyValues == null) {
            ContainerUtil.$$$reportNull$$$0(193);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (int i2 = 0; i2 < keyValues.length - 1; i2 += 2) {
            result2.put(keyValues[i2], keyValues[i2 + 1]);
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(194);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> iterate(T @NotNull [] array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(195);
        }
        Iterator iterator2 = array.length == 0 ? Collections.emptyIterator() : Arrays.asList(array).iterator();
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(196);
        }
        return iterator2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> iterate(final @NotNull Enumeration<? extends T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(197);
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> iterateBackward(final @NotNull List<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(198);
        }
        Iterable iterable = () -> new Iterator<T>(){
            private final ListIterator<? extends T> it;
            {
                this.it = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasPrevious();
            }

            @Override
            public T next() {
                return this.it.previous();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(199);
        }
        return iterable;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, E> Iterable<Pair<T, E>> zip(final @NotNull Iterable<? extends T> iterable1, final @NotNull Iterable<? extends E> iterable2) {
        if (iterable1 == null) {
            ContainerUtil.$$$reportNull$$$0(200);
        }
        if (iterable2 == null) {
            ContainerUtil.$$$reportNull$$$0(201);
        }
        Iterable<Pair<T, E>> iterable = () -> new Iterator<Pair<T, E>>(){
            private final Iterator<? extends T> i1;
            private final Iterator<? extends E> i2;
            {
                this.i1 = iterable1.iterator();
                this.i2 = iterable2.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i1.hasNext() && this.i2.hasNext();
            }

            @Override
            public Pair<T, E> next() {
                return Pair.create(this.i1.next(), this.i2.next());
            }

            @Override
            public void remove() {
                this.i1.remove();
                this.i2.remove();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(202);
        }
        return iterable;
    }

    @Contract(mutates="param1")
    public static void swapElements(@NotNull List<?> list, int index1, int index2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(203);
        }
        Object e1 = list.get(index1);
        Object e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    public static <T> @Unmodifiable @NotNull List<T> collect(@NotNull Iterator<? extends T> iterator2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(204);
        }
        if (!iterator2.hasNext()) {
            return ContainerUtil.emptyList();
        }
        ArrayList list = new ArrayList();
        ContainerUtil.addAll(list, iterator2);
        ArrayList arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(205);
        }
        return arrayList;
    }

    public static <T> @Unmodifiable @NotNull List<T> collect(@NotNull Iterator<?> iterator2, @NotNull FilteringIterator.InstanceOf<T> instanceOf) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(206);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(207);
        }
        return ContainerUtil.collect(iterator2, (? super T t2) -> instanceOf.value(t2));
    }

    public static <T> @Unmodifiable @NotNull List<T> collect(@NotNull Iterator<? extends T> iterator2, @NotNull Predicate<? super T> predicate) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(208);
        }
        if (predicate == null) {
            ContainerUtil.$$$reportNull$$$0(209);
        }
        if (!iterator2.hasNext()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        while (iterator2.hasNext()) {
            T o2 = iterator2.next();
            if (!predicate.test(o2)) continue;
            list.add(o2);
        }
        return ContainerUtil.unmodifiableOrEmptyList(list);
    }

    @Contract(mutates="param1")
    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(210);
        }
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(211);
        }
        while (enumeration.hasMoreElements()) {
            T element2 = enumeration.nextElement();
            collection.add(element2);
        }
    }

    @SafeVarargs
    @Contract(mutates="param1")
    @NotNull
    public static <T, C extends Collection<? super T>> C addAll(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(212);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(213);
        }
        for (T element2 : elements) {
            collection.add(element2);
        }
        C c2 = collection;
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(214);
        }
        return c2;
    }

    @SafeVarargs
    @Contract(mutates="param1")
    @NotNull
    public static <T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(215);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(216);
        }
        for (T element2 : elements) {
            if (element2 == null) continue;
            collection.add(element2);
        }
        C c2 = collection;
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        return c2;
    }

    @SafeVarargs
    @Contract(mutates="param1")
    public static <T> boolean removeAll(@NotNull Collection<T> collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(218);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(219);
        }
        boolean modified = false;
        for (T element2 : elements) {
            modified |= collection.remove(element2);
        }
        return modified;
    }

    @Contract(mutates="param1")
    public static <T> boolean retainAll(@NotNull Collection<T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(220);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(221);
        }
        boolean modified = false;
        Iterator<T> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            T next = iterator2.next();
            if (condition.value(next)) continue;
            iterator2.remove();
            modified = true;
        }
        return modified;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<? extends T> iterable, @NotNull Class<? extends U> aClass) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(222);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(223);
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<? extends T> iterator2, @NotNull Class<? extends U> aClass) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(224);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(225);
        }
        return (U)ContainerUtil.find(iterator2, FilteringIterator.instanceOf(aClass));
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(T @NotNull [] array, @NotNull Class<? extends U> aClass) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(226);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(227);
        }
        return (U)ContainerUtil.find(array, FilteringIterator.instanceOf(aClass));
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<T> concat(V @NotNull [] array, @NotNull Function<? super V, ? extends Collection<? extends T>> listGenerator) {
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(228);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(229);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (V v2 : array) {
            result2.addAll(listGenerator.fun(v2));
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> concat(@NotNull Iterable<? extends Collection<? extends T>> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(231);
        }
        int totalSize = 0;
        for (Collection<T> ts : list) {
            totalSize += ts.size();
        }
        ArrayList result2 = new ArrayList(totalSize);
        for (Collection<T> collection : list) {
            result2.addAll(collection);
        }
        List list2 = result2.isEmpty() ? Collections.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(232);
        }
        return list2;
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> append(final @NotNull List<? extends T> list, final T ... values2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(233);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(234);
        }
        if (values2.length == 0) {
            List<? extends T> list2 = list;
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(235);
            }
            return list2;
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                return index2 < list.size() ? list.get(index2) : values2[index2 - list.size()];
            }

            @Override
            public int size() {
                return list.size() + values2.length;
            }
        };
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> prepend(final @NotNull List<? extends T> list, final T ... values2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(236);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(237);
        }
        if (values2.length == 0) {
            List<? extends T> list2 = list;
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(238);
            }
            return list2;
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                return index2 < values2.length ? values2[index2] : list.get(index2 - values2.length);
            }

            @Override
            public int size() {
                return list.size() + values2.length;
            }
        };
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(239);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(240);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(241);
            }
            return list;
        }
        if (list1.isEmpty()) {
            List<T> list = list2;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(242);
            }
            return list;
        }
        if (list2.isEmpty()) {
            List<T> list = list1;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(243);
            }
            return list;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                return index2 < size1 ? list1.get(index2) : list2.get(index2 - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(final @NotNull Iterable<? extends T> it1, final @NotNull Iterable<? extends T> it2) {
        if (it1 == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        if (it2 == null) {
            ContainerUtil.$$$reportNull$$$0(245);
        }
        return new Iterable<T>(){

            @Override
            public void forEach(Consumer<? super T> action) {
                it1.forEach(action);
                it2.forEach(action);
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> it;
                    boolean firstFinished;
                    {
                        this.it = it1.iterator();
                        this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.firstFinished || this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        Object value2 = this.it.next();
                        this.advance();
                        return value2;
                    }

                    private void advance() {
                        if (!this.firstFinished && !this.it.hasNext()) {
                            this.it = it2.iterator();
                            this.firstFinished = true;
                        }
                    }
                };
            }
        };
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            ContainerUtil.$$$reportNull$$$0(246);
        }
        if (iterables.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(247);
            }
            return list;
        }
        if (iterables.length == 1) {
            Iterable<? extends T> iterable = iterables[0];
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(248);
            }
            return iterable;
        }
        Iterable iterable = () -> {
            Iterator[] iterators = new Iterator[iterables.length];
            for (int i2 = 0; i2 < iterables.length; ++i2) {
                Iterable iterable = iterables[i2];
                iterators[i2] = iterable.iterator();
            }
            return ContainerUtil.concatIterators(iterators);
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(249);
        }
        return iterable;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> concatIterators(Iterator<? extends T> ... iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(250);
        }
        return new SequenceIterator<T>(iterators);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> concatIterators(@NotNull Collection<? extends Iterator<? extends T>> iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(251);
        }
        return new SequenceIterator(iterators);
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(T[] ... arrays) {
        Iterable iterable = () -> {
            Iterator[] iterators = new Iterator[arrays.length];
            for (int i2 = 0; i2 < arrays.length; ++i2) {
                iterators[i2] = ContainerUtil.iterate(arrays[i2]);
            }
            return ContainerUtil.concatIterators(iterators);
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(252);
        }
        return iterable;
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> concat(final List<? extends T> ... lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(253);
        }
        if (lists.length == 1) {
            List<? extends T> list = lists[0];
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(254);
            }
            return list;
        }
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        if (size == 0) {
            return ContainerUtil.emptyList();
        }
        final int finalSize = size;
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                if (index2 >= 0 && index2 < finalSize) {
                    int from2 = 0;
                    for (List each : lists) {
                        if (from2 <= index2 && index2 < from2 + each.size()) {
                            return each.get(index2 - from2);
                        }
                        from2 += each.size();
                    }
                    if (from2 != finalSize) {
                        throw new ConcurrentModificationException("The list has changed. Its size was " + finalSize + "; now it's " + from2);
                    }
                }
                throw new IndexOutOfBoundsException("index: " + index2 + "; size: " + this.size());
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> concat(@NotNull List<List<? extends T>> lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(255);
        }
        return ContainerUtil.concat(lists.toArray(new List[0]));
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> concat(@NotNull Iterable<? extends T> list, @NotNull Function<? super T, ? extends Collection<? extends V>> listGenerator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(256);
        }
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(257);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T v2 : list) {
            result2.addAll(listGenerator.fun(v2));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(258);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(259);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(260);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t2 : collection1) {
                if (!collection2.contains(t2)) continue;
                return true;
            }
        } else {
            for (T t3 : collection2) {
                if (!collection1.contains(t3)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(261);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(262);
        }
        if (collection1.isEmpty() || collection2.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t2 : collection1) {
            if (!collection2.contains(t2)) continue;
            result2.add(t2);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(263);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <E extends Enum<E>> EnumSet<E> intersection(@NotNull EnumSet<E> collection1, @NotNull EnumSet<E> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(264);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(265);
        }
        if (collection1.isEmpty()) {
            EnumSet<E> enumSet = collection1;
            if (enumSet == null) {
                ContainerUtil.$$$reportNull$$$0(266);
            }
            return enumSet;
        }
        if (collection2.isEmpty()) {
            EnumSet<E> enumSet = collection2;
            if (enumSet == null) {
                ContainerUtil.$$$reportNull$$$0(267);
            }
            return enumSet;
        }
        EnumSet<E> result2 = EnumSet.copyOf(collection1);
        result2.retainAll(collection2);
        EnumSet<E> enumSet = result2;
        if (enumSet == null) {
            ContainerUtil.$$$reportNull$$$0(268);
        }
        return enumSet;
    }

    @Contract(pure=true)
    public static <T> @UnknownNullability T getFirstItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Contract(pure=true)
    public static <T> @UnknownNullability T getFirstItem(@Nullable List<? extends T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @Contract(pure=true)
    public static <T> @UnknownNullability T getOnlyItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getOnlyItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.size() != 1 ? defaultResult : items.iterator().next();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> getFirstItems(@NotNull List<T> items, int maxItems) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(269);
        }
        if (maxItems < 0) {
            throw new IllegalArgumentException("Expected non-negative maxItems; got: " + maxItems);
        }
        List<T> list = maxItems >= items.size() ? items : items.subList(0, maxItems);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(270);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> T iterateAndGetLastItem(@NotNull Iterable<? extends T> items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(271);
        }
        Iterator<T> itr = items.iterator();
        T res2 = null;
        while (itr.hasNext()) {
            res2 = itr.next();
        }
        return res2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    public static <T> T iterateAndGetLastItem(@NotNull List<? extends T> items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(272);
        }
        Logger.getInstance(ContainerUtil.class).error("use getLastItem(List) instead");
        return ContainerUtil.getLastItem(items);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Function<? super T, ? extends U> mapper) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(273);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(274);
        }
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> filterIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Condition<? super T> filter) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(275);
        }
        if (filter == null) {
            ContainerUtil.$$$reportNull$$$0(276);
        }
        return new Iterator<T>(){
            T next;
            boolean hasNext;
            {
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private void findNext() {
                this.hasNext = false;
                while (iterator2.hasNext()) {
                    Object t2 = iterator2.next();
                    if (!filter.value(t2)) continue;
                    this.next = t2;
                    this.hasNext = true;
                    break;
                }
            }

            @Override
            public T next() {
                if (this.hasNext) {
                    Object result2 = this.next;
                    this.findNext();
                    return result2;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @Contract(pure=true)
    public static <T> T getLastItem(@Nullable List<? extends T> list, @Nullable T def) {
        return ContainerUtil.isEmpty(list) ? def : list.get(list.size() - 1);
    }

    @Contract(pure=true)
    public static <T> @UnknownNullability T getLastItem(@Nullable List<? extends T> list) {
        return ContainerUtil.getLastItem(list, null);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Collection<T> subtract(@NotNull Collection<? extends T> from2, @NotNull Collection<? extends T> what) {
        if (from2 == null) {
            ContainerUtil.$$$reportNull$$$0(277);
        }
        if (what == null) {
            ContainerUtil.$$$reportNull$$$0(278);
        }
        HashSet<T> set = new HashSet<T>(from2);
        set.removeAll(what);
        Collection<T> collection = set.isEmpty() ? ContainerUtil.emptyList() : set;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(279);
        }
        return collection;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toArray(@NotNull Collection<T> c2, @NotNull ArrayFactory<? extends T> factory2) {
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(280);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(281);
        }
        T[] a2 = factory2.create(c2.size());
        T[] TArray = c2.toArray(a2);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(282);
        }
        return TArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory2) {
        if (c1 == null) {
            ContainerUtil.$$$reportNull$$$0(283);
        }
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(284);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(285);
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory2);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(286);
        }
        return TArray;
    }

    @Contract(mutates="param1")
    public static <T extends Comparable<? super T>> void sort(@NotNull List<T> list) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(287);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list.get(0);
            if (t0.compareTo(t1 = (Comparable)list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j2 = 0; j2 < i2; ++j2) {
                    Comparable tj;
                    Comparable ti = (Comparable)list.get(i2);
                    if (ti.compareTo(tj = (Comparable)list.get(j2)) >= 0) continue;
                    list.set(i2, tj);
                    list.set(j2, ti);
                }
            }
        } else {
            Collections.sort(list);
        }
    }

    @Contract(mutates="param1")
    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(288);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(289);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j2 = 0; j2 < i2; ++j2) {
                    T tj;
                    T ti = list.get(i2);
                    if (comparator.compare(ti, tj = list.get(j2)) >= 0) continue;
                    list.set(i2, tj);
                    list.set(j2, ti);
                }
            }
        } else {
            list.sort(comparator);
        }
    }

    @Contract(mutates="param1")
    public static <T extends Comparable<? super T>> void sort(T @NotNull [] a2) {
        int size;
        if (a2 == null) {
            ContainerUtil.$$$reportNull$$$0(290);
        }
        if ((size = a2.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a2[0];
            T t1 = a2[1];
            if (t0.compareTo(t1) > 0) {
                a2[0] = t1;
                a2[1] = t0;
            }
        } else if (size < 10) {
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j2 = 0; j2 < i2; ++j2) {
                    T ti = a2[i2];
                    T tj = a2[j2];
                    if (ti.compareTo(tj) >= 0) continue;
                    a2[i2] = tj;
                    a2[j2] = ti;
                }
            }
        } else {
            Arrays.sort(a2);
        }
    }

    @Contract(pure=true)
    public static <T, TT extends T> @Unmodifiable @NotNull List<T> sorted(@NotNull Collection<TT> list, @NotNull Comparator<? super TT> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(291);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(292);
        }
        return ContainerUtil.sorted(list, comparator);
    }

    @Contract(pure=true)
    public static <T, TT extends T> @Unmodifiable @NotNull List<T> sorted(@NotNull Iterable<TT> list, @NotNull Comparator<? super TT> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(293);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(294);
        }
        ArrayList<TT> sorted = ContainerUtil.newArrayList(list);
        ContainerUtil.sort(sorted, comparator);
        List<TT> list2 = Collections.unmodifiableList(sorted);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(295);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T extends Comparable<? super T>> @Unmodifiable @NotNull List<T> sorted(@NotNull Collection<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(296);
        }
        ArrayList<T> result2 = new ArrayList<T>(list);
        result2.sort(null);
        List<? extends T> list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(297);
        }
        return list2;
    }

    @Contract(mutates="param1")
    public static <T> void sort(T @NotNull [] array, @NotNull Comparator<? super T> comparator) {
        int size;
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(298);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(299);
        }
        if ((size = array.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = array[0];
            T t1 = array[1];
            if (comparator.compare(t0, t1) > 0) {
                array[0] = t1;
                array[1] = t0;
            }
        } else if (size < 10) {
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j2 = 0; j2 < i2; ++j2) {
                    T ti = array[i2];
                    T tj = array[j2];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    array[i2] = tj;
                    array[j2] = ti;
                }
            }
        } else {
            Arrays.sort(array, comparator);
        }
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(300);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(301);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t2 : iterable) {
            result2.add(mapping.fun(t2));
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(302);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> map(@NotNull Iterator<? extends T> iterator2, @NotNull Function<? super T, ? extends V> mapping) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(303);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(304);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        while (iterator2.hasNext()) {
            result2.add(mapping.fun(iterator2.next()));
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(305);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(306);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(307);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t2 : collection) {
            list.add(mapping.fun(t2));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(308);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @Unmodifiable @NotNull List<@NotNull V> mapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(309);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(310);
        }
        if (array.length == 0) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t2 : array) {
            V o2 = mapping.fun(t2);
            if (o2 == null) continue;
            result2.add(o2);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(311);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull V @NotNull [] mapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends @Nullable V> mapping, V @NotNull [] emptyArray) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(312);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(313);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(314);
        }
        assert (emptyArray.length == 0) : "You must pass an empty array";
        ArrayList<V> result2 = new ArrayList<V>(array.length);
        for (T t2 : array) {
            V v2 = mapping.fun(t2);
            if (v2 == null) continue;
            result2.add(v2);
        }
        if (result2.isEmpty()) {
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(315);
            }
            return emptyArray;
        }
        V[] VArray = result2.toArray(emptyArray);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(316);
        }
        return VArray;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @Unmodifiable @NotNull List<@NotNull V> mapNotNull(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(317);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(318);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t2 : iterable) {
            V o2 = mapping.fun(t2);
            if (o2 == null) continue;
            result2.add(o2);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(319);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @Unmodifiable @NotNull List<@NotNull V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(320);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(321);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>(collection.size());
        for (T t2 : collection) {
            V o2 = mapping.fun(t2);
            if (o2 == null) continue;
            result2.add(o2);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(322);
        }
        return list;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> @Unmodifiable @NotNull List<@NotNull T> packNullables(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(323);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T element2 : elements) {
            ContainerUtil.addIfNotNull(list, element2);
        }
        List<T> list2 = list.isEmpty() ? ContainerUtil.emptyList() : list;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(324);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> map(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapping) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(325);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(326);
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t2 : array) {
            result2.add(mapping.fun(t2));
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(327);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map(T @NotNull [] arr, @NotNull Function<? super T, ? extends V> mapping, V @NotNull [] emptyArray) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(328);
        }
        if (arr == null) {
            ContainerUtil.$$$reportNull$$$0(329);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(330);
        }
        if (arr.length == 0) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(331);
            }
            return emptyArray;
        }
        V[] result2 = emptyArray.length < arr.length ? Arrays.copyOf(emptyArray, arr.length) : emptyArray;
        for (int i2 = 0; i2 < arr.length; ++i2) {
            result2[i2] = mapping.fun(arr[i2]);
        }
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(332);
        }
        return result2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> set() {
        Set set = Collections.emptySet();
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(333);
        }
        return set;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> set(T t2) {
        Set<T> set = Collections.singleton(t2);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(334);
        }
        return set;
    }

    @Deprecated
    @SafeVarargs
    public static <T> @Unmodifiable @NotNull Set<T> set(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(335);
        }
        return new HashSet<T>(Arrays.asList(items));
    }

    @Contract(mutates="param3")
    public static <K, V> void putIfNotNull(K key, @Nullable V value2, @NotNull Map<? super K, ? super V> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(336);
        }
        if (value2 != null) {
            result2.put(key, value2);
        }
    }

    @Contract(mutates="param3")
    public static <K, V> void putIfNotNull(K key, @Nullable Collection<? extends V> value2, @NotNull MultiMap<? super K, ? super V> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(337);
        }
        if (value2 != null) {
            result2.putValues(key, value2);
        }
    }

    @Contract(mutates="param3")
    public static <K, V> void putIfNotNull(K key, @Nullable V value2, @NotNull MultiMap<? super K, ? super V> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(338);
        }
        if (value2 != null) {
            result2.putValue(key, value2);
        }
    }

    @Contract(mutates="param2")
    public static <T> void add(T element2, @NotNull Collection<? super T> result2, @NotNull Disposable parentDisposable) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(339);
        }
        if (parentDisposable == null) {
            ContainerUtil.$$$reportNull$$$0(340);
        }
        if (result2.add(element2)) {
            Disposer.register(parentDisposable, () -> result2.remove(element2));
        }
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> createMaybeSingletonList(@Nullable T element2) {
        List list = element2 == null ? Collections.emptyList() : Collections.singletonList(element2);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(341);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> createMaybeSingletonSet(@Nullable T element2) {
        Set set = element2 == null ? Collections.emptySet() : Collections.singleton(element2);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(342);
        }
        return set;
    }

    @Deprecated
    @NotNull
    public static <T, V> V getOrCreate(@NotNull Map<T, V> result2, T key, @NotNull V defaultValue) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(343);
        }
        if (defaultValue == null) {
            ContainerUtil.$$$reportNull$$$0(344);
        }
        Object object = result2.computeIfAbsent(key, __ -> defaultValue);
        if (object == null) {
            ContainerUtil.$$$reportNull$$$0(345);
        }
        return (V)object;
    }

    @Deprecated
    public static <T, V> V getOrCreate(@NotNull Map<T, V> result2, T key, @NotNull Factory<? extends V> factory2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(346);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(347);
        }
        return (V)result2.computeIfAbsent(key, __ -> factory2.create());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    @NotNull
    public static <T, V> V getOrElse(@NotNull Map<? extends T, V> map, T key, @NotNull V defValue) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(348);
        }
        if (defValue == null) {
            ContainerUtil.$$$reportNull$$$0(349);
        }
        V v2 = map.getOrDefault(key, defValue);
        if (v2 == null) {
            ContainerUtil.$$$reportNull$$$0(350);
        }
        return v2;
    }

    @Contract(pure=true)
    public static <T> boolean and(T @NotNull [] iterable, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(351);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(352);
        }
        for (T t2 : iterable) {
            if (condition.value(t2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(353);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(354);
        }
        for (T t2 : iterable) {
            if (condition.value(t2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(355);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(356);
        }
        for (T t2 : array) {
            if (!condition.value(t2)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(357);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(358);
        }
        for (T t2 : iterable) {
            if (!condition.value(t2)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean or(T @NotNull [] iterable, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(359);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(360);
        }
        return ContainerUtil.exists(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(361);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(362);
        }
        return ContainerUtil.exists(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> int count(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(363);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(364);
        }
        int count = 0;
        for (T t2 : iterable) {
            if (!condition.value(t2)) continue;
            ++count;
        }
        return count;
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> list(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(365);
        }
        List<T> list = Arrays.asList(items);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(366);
        }
        return list;
    }

    @Contract(mutates="param1")
    public static <T> void quickSort(@NotNull List<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(367);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(368);
        }
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    @Contract(mutates="param1")
    private static <T> void quickSort(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c2;
        int a2;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(369);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(370);
        }
        if (len < 7) {
            for (int i2 = off; i2 < len + off; ++i2) {
                for (int j2 = i2; j2 > off && comparator.compare(x.get(j2), x.get(j2 - 1)) < 0; --j2) {
                    ContainerUtil.swapElements(x, j2, j2 - 1);
                }
            }
            return;
        }
        int m4 = off + (len >> 1);
        if (len > 7) {
            int l2 = off;
            int n2 = off + len - 1;
            if (len > 40) {
                int s2 = len / 8;
                l2 = ContainerUtil.med3(x, comparator, l2, l2 + s2, l2 + 2 * s2);
                m4 = ContainerUtil.med3(x, comparator, m4 - s2, m4, m4 + s2);
                n2 = ContainerUtil.med3(x, comparator, n2 - 2 * s2, n2 - s2, n2);
            }
            m4 = ContainerUtil.med3(x, comparator, l2, m4, n2);
        }
        T v2 = x.get(m4);
        int b2 = a2 = off;
        int d2 = c2 = off + len - 1;
        while (true) {
            if (b2 <= c2 && comparator.compare(x.get(b2), v2) <= 0) {
                if (comparator.compare(x.get(b2), v2) == 0) {
                    ContainerUtil.swapElements(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && comparator.compare(v2, x.get(c2)) <= 0) {
                if (comparator.compare(x.get(c2), v2) == 0) {
                    ContainerUtil.swapElements(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ContainerUtil.swapElements(x, b2++, c2--);
        }
        int s3 = Math.min(a2 - off, b2 - a2);
        ContainerUtil.vecSwap(x, off, b2 - s3, s3);
        int n3 = off + len;
        s3 = Math.min(d2 - c2, n3 - d2 - 1);
        ContainerUtil.vecSwap(x, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1) {
            ContainerUtil.quickSort(x, comparator, off, s3);
        }
        if ((s3 = d2 - c2) > 1) {
            ContainerUtil.quickSort(x, comparator, n3 - s3, s3);
        }
    }

    private static <T> int med3(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int a2, int b2, int c2) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(371);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(372);
        }
        return comparator.compare(x.get(a2), x.get(b2)) < 0 ? (comparator.compare(x.get(b2), x.get(c2)) < 0 ? b2 : (comparator.compare(x.get(a2), x.get(c2)) < 0 ? c2 : a2)) : (comparator.compare(x.get(c2), x.get(b2)) < 0 ? b2 : (comparator.compare(x.get(c2), x.get(a2)) < 0 ? c2 : a2));
    }

    @Contract(mutates="param1")
    private static <T> void vecSwap(List<T> x, int a2, int b2, int n2) {
        int i2 = 0;
        while (i2 < n2) {
            ContainerUtil.swapElements(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull List<E> flatten(Collection<E> @NotNull [] collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(373);
        }
        return ContainerUtil.flatten(Arrays.asList(collections));
    }

    public static <T> @Unmodifiable @NotNull List<? extends T> removeDuplicatesFromSorted(@NotNull List<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(374);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(375);
        }
        Object prev = null;
        ArrayList<T> result2 = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int cmp;
            T t2 = list.get(i2);
            if (t2 == null) {
                throw new IllegalArgumentException("get(" + i2 + ") = null");
            }
            int n2 = cmp = prev == null ? -1 : comparator.compare(prev, t2);
            if (cmp < 0) {
                if (result2 != null) {
                    result2.add(t2);
                }
            } else if (cmp == 0) {
                if (result2 == null) {
                    result2 = new ArrayList<T>(list.size());
                    result2.addAll(list.subList(0, i2));
                }
            } else {
                throw new IllegalArgumentException("List must be sorted but get(" + (i2 - 1) + ")=" + list.get(i2 - 1) + " > get(" + i2 + ")=" + t2);
            }
            prev = t2;
        }
        List<T> list2 = result2 == null ? list : Collections.unmodifiableList(result2);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(376);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull List<E> flatten(@NotNull Iterable<? extends Collection<? extends E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(377);
        }
        int totalSize = 0;
        for (Collection<E> list : collections) {
            totalSize += list.size();
        }
        ArrayList result2 = new ArrayList(totalSize);
        for (Collection<E> collection : collections) {
            result2.addAll(collection);
        }
        List list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(378);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> flatMap(@NotNull Iterable<? extends T> iterable, @NotNull @NotNull Function<? super T, ? extends @NotNull List<? extends V>> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(379);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(380);
        }
        List<V> result2 = null;
        boolean isOriginal = true;
        for (T each : iterable) {
            List<V> toAdd = mapping.fun(each);
            if (toAdd.isEmpty()) continue;
            if (result2 == null) {
                result2 = toAdd;
                continue;
            }
            if (isOriginal) {
                List<V> original = result2;
                result2 = new ArrayList<V>(Math.max(10, result2.size() + toAdd.size()));
                result2.addAll(original);
                isOriginal = false;
            }
            result2.addAll(toAdd);
        }
        List<T> list = result2 == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(result2);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(381);
        }
        return list;
    }

    @Contract(mutates="param2")
    public static <K, V> V @NotNull [] convert(K @NotNull [] from2, V @NotNull [] to, @NotNull Function<? super K, ? extends V> fun) {
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(382);
        }
        if (from2 == null) {
            ContainerUtil.$$$reportNull$$$0(383);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(384);
        }
        if (to.length < from2.length) {
            to = ArrayUtil.newArray(ArrayUtil.getComponentType(to), from2.length);
        }
        for (int i2 = 0; i2 < from2.length; ++i2) {
            to[i2] = fun.fun(from2[i2]);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(385);
        }
        return to;
    }

    @Contract(pure=true)
    public static <T> boolean containsIdentity(@NotNull Iterable<? extends T> list, T element2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(386);
        }
        for (T t2 : list) {
            if (t2 != element2) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int indexOfIdentity(@NotNull List<? extends T> list, T element2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(387);
        }
        int listSize = list.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            if (list.get(i2) != element2) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> boolean equalsIdentity(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(388);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(389);
        }
        int listSize = list1.size();
        if (list2.size() != listSize) {
            return false;
        }
        for (int i2 = 0; i2 < listSize; ++i2) {
            if (list1.get(i2) == list2.get(i2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(390);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(391);
        }
        int listSize = list.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            T t2 = list.get(i2);
            if (!condition.value(t2)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(392);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(393);
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            T t2 = list.get(i2);
            if (!condition.value(t2)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findLastInstance(@NotNull List<? extends T> list, @NotNull Class<? extends U> clazz) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(394);
        }
        if (clazz == null) {
            ContainerUtil.$$$reportNull$$$0(395);
        }
        int i2 = ContainerUtil.lastIndexOf(list, clazz::isInstance);
        return i2 < 0 ? null : (U)list.get(i2);
    }

    @Contract(pure=true)
    @NotNull
    public static <A, B> Map<B, A> reverseMap(@NotNull Map<? extends A, ? extends B> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(396);
        }
        HashMap<B, A> result2 = new HashMap<B, A>(map.size());
        for (Map.Entry<A, B> entry : map.entrySet()) {
            result2.put(entry.getValue(), entry.getKey());
        }
        HashMap<B, A> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(397);
        }
        return hashMap;
    }

    @Contract(value="null -> null; !null -> !null", mutates="param1")
    public static <T> List<T> trimToSize(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> emptyList() {
        List list = ContainerUtilRt.emptyList();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(398);
        }
        return list;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        return new CopyOnWriteArrayList<T>(ContainerUtil.emptyList());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList(@NotNull Collection<? extends T> c2) {
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(399);
        }
        return new LockFreeCopyOnWriteArrayList<T>(c2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectMap() {
        return new ConcurrentIntObjectHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(400);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftKeySoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors());
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(401);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(402);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(403);
        }
        return concurrentMap;
    }

    @ApiStatus.Internal
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(404);
        }
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeyWeakValueMap(strategy);
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(405);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(406);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(407);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(408);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> ConcurrentList<T> createConcurrentList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> ConcurrentList<T> createConcurrentList(@NotNull Collection<? extends T> c2) {
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(409);
        }
        return new LockFreeCopyOnWriteArrayList<T>(c2);
    }

    @Contract(mutates="param1")
    public static <T> void addIfNotNull(@NotNull Collection<? super T> result2, @Nullable T element2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(410);
        }
        if (element2 != null) {
            result2.add(element2);
        }
    }

    @Deprecated
    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(411);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(412);
        }
        return ContainerUtil.map(collection, mapper);
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull Set<V> map2Set(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(413);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(414);
        }
        if (array.length == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(415);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(array.length);
        for (T t2 : array) {
            set.add(mapper.fun(t2));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(416);
        }
        return hashSet;
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(417);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(418);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(419);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t2 : collection) {
            set.add(mapper.fun(t2));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(420);
        }
        return hashSet;
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull Set<V> map2LinkedSet(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(421);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(422);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(423);
            }
            return set;
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(collection.size());
        for (T t2 : collection) {
            set.add(mapper.fun(t2));
        }
        LinkedHashSet<V> linkedHashSet = set;
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(424);
        }
        return linkedHashSet;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @Unmodifiable @NotNull Set<@NotNull V> map2SetNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(425);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(426);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(427);
            }
            return set;
        }
        HashSet set = new HashSet(collection.size());
        for (T t2 : collection) {
            V value2 = mapper.fun(t2);
            if (value2 == null) continue;
            set.add(value2);
        }
        Set set2 = set.isEmpty() ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(428);
        }
        return set2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(mutates="param2")
    public static <T> T @NotNull [] toArray(@NotNull List<T> collection, T @NotNull [] array) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(429);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(430);
        }
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(431);
        }
        return TArray;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(mutates="param2")
    public static <T> T @NotNull [] toArray(@NotNull Collection<? extends T> c2, T @NotNull [] sample) {
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(432);
        }
        if (sample == null) {
            ContainerUtil.$$$reportNull$$$0(433);
        }
        T[] TArray = c2.toArray(sample);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(434);
        }
        return TArray;
    }

    @Contract(mutates="param1")
    public static <T> T @NotNull [] copyAndClear(@NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory2, boolean clear2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(435);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(436);
        }
        int size = collection.size();
        T[] a2 = factory2.create(size);
        if (size > 0) {
            a2 = collection.toArray(a2);
            if (clear2) {
                collection.clear();
            }
        }
        if (a2 == null) {
            ContainerUtil.$$$reportNull$$$0(437);
        }
        return a2;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> copyList(@NotNull List<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(438);
        }
        if (list == Collections.emptyList()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(439);
            }
            return list2;
        }
        if (list.size() == 1) {
            return new SmartList<T>(list.get(0));
        }
        if (list.isEmpty()) {
            return new SmartList();
        }
        return new ArrayList<T>(list);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> toCollection(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(440);
        }
        return iterable instanceof Collection ? (ArrayList<? extends T>)iterable : ContainerUtil.newArrayList(iterable);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> toCollection(@NotNull Collection<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(441);
        }
        Logger.getInstance(ContainerUtil.class).error("use the argument, Luke");
        Collection<? extends T> collection = iterable;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(442);
        }
        return collection;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> toList(@NotNull Enumeration<? extends T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(443);
        }
        if (!enumeration.hasMoreElements()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(444);
            }
            return list;
        }
        SmartList<T> result2 = new SmartList<T>();
        while (enumeration.hasMoreElements()) {
            result2.add(enumeration.nextElement());
        }
        List list = Collections.unmodifiableList(result2);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(445);
        }
        return list;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> notNullize(@Nullable List<T> list) {
        List<T> list2 = list == null ? ContainerUtil.emptyList() : list;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(446);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(447);
        }
        return set2;
    }

    @Contract(pure=true)
    public static <K, V> @Unmodifiable @NotNull Map<K, V> notNullize(@Nullable Map<K, V> map) {
        Map map2 = map == null ? Collections.emptyMap() : map;
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(448);
        }
        return map2;
    }

    @Contract(pure=true)
    public static <T> boolean startsWith(@NotNull List<? extends T> list, @NotNull List<? extends T> prefix) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(449);
        }
        if (prefix == null) {
            ContainerUtil.$$$reportNull$$$0(450);
        }
        return list.size() >= prefix.size() && list.subList(0, prefix.size()).equals(prefix);
    }

    @Contract(pure=true)
    @Nullable
    public static <C extends Collection<?>> C nullize(@Nullable C collection) {
        return ContainerUtil.isEmpty(collection) ? null : (C)collection;
    }

    @Contract(pure=true)
    public static <T extends Comparable<? super T>> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(451);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(452);
        }
        for (int i2 = 0; i2 < Math.min(o1.size(), o2.size()); ++i2) {
            int result2 = Comparing.compare((Comparable)o1.get(i2), (Comparable)o2.get(i2));
            if (result2 == 0) continue;
            return result2;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    @Contract(pure=true)
    public static <T> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2, @NotNull Comparator<? super T> comparator) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(453);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(454);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(455);
        }
        for (int i2 = 0; i2 < Math.min(o1.size(), o2.size()); ++i2) {
            int result2 = comparator.compare(o1.get(i2), o2.get(i2));
            if (result2 == 0) continue;
            return result2;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakKeySoftValueMap() {
        Map map = CollectionFactory.createWeakKeySoftValueMap();
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(456);
        }
        return map;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakKeyWeakValueMap() {
        Map map = CollectionFactory.createWeakKeyWeakValueMap();
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(457);
        }
        return map;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftKeySoftValueMap() {
        Map map = CollectionFactory.createSoftKeySoftValueMap();
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(458);
        }
        return map;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftValueMap() {
        return new SoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakValueMap() {
        return new WeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftMap() {
        Map map = CollectionFactory.createSoftMap();
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(459);
        }
        return map;
    }

    @Deprecated
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakMap() {
        return new WeakHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createWeakSet() {
        return new WeakHashSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> @NotNull IntObjectMap<@NotNull T> createIntKeyWeakValueMap() {
        return new IntKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> @NotNull ObjectIntMap<@NotNull T> createWeakKeyIntValueMap() {
        return new WeakKeyIntValueHashMap();
    }

    public static <T> T reduce(@NotNull List<? extends T> list, T identity, @NotNull BinaryOperator<T> accumulator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(460);
        }
        if (accumulator == null) {
            ContainerUtil.$$$reportNull$$$0(461);
        }
        Object result2 = identity;
        for (T t2 : list) {
            result2 = accumulator.apply(result2, t2);
        }
        return result2;
    }

    public static <T> Stream<List<? extends T>> splitListToChunks(@NotNull List<? extends T> list, int chunkSize) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(462);
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("invalid chunkSize: " + chunkSize);
        }
        int listSize = list.size();
        if (listSize == 0) {
            return Stream.empty();
        }
        int numberOfChunks = listSize / chunkSize;
        return IntStream.range(0, numberOfChunks * chunkSize == listSize ? numberOfChunks : numberOfChunks + 1).mapToObj(i2 -> list.subList(i2 * chunkSize, Math.min(listSize, i2 * chunkSize + chunkSize)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 77: 
            case 79: 
            case 90: 
            case 93: 
            case 99: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 164: 
            case 167: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 184: 
            case 187: 
            case 194: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 214: 
            case 217: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: 
            case 263: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 279: 
            case 282: 
            case 286: 
            case 295: 
            case 297: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: 
            case 324: 
            case 327: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 341: 
            case 342: 
            case 345: 
            case 350: 
            case 366: 
            case 376: 
            case 378: 
            case 381: 
            case 385: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 415: 
            case 416: 
            case 419: 
            case 420: 
            case 423: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 434: 
            case 437: 
            case 439: 
            case 442: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 77: 
            case 79: 
            case 90: 
            case 93: 
            case 99: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 164: 
            case 167: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 184: 
            case 187: 
            case 194: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 214: 
            case 217: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: 
            case 263: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 279: 
            case 282: 
            case 286: 
            case 295: 
            case 297: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: 
            case 324: 
            case 327: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 341: 
            case 342: 
            case 345: 
            case 350: 
            case 366: 
            case 376: 
            case 378: 
            case 381: 
            case 385: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 415: 
            case 416: 
            case 419: 
            case 420: 
            case 423: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 434: 
            case 437: 
            case 439: 
            case 442: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 77: 
            case 79: 
            case 90: 
            case 93: 
            case 99: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 164: 
            case 167: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 184: 
            case 187: 
            case 194: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 214: 
            case 217: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: 
            case 263: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 279: 
            case 282: 
            case 286: 
            case 295: 
            case 297: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: 
            case 324: 
            case 327: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 341: 
            case 342: 
            case 345: 
            case 350: 
            case 366: 
            case 376: 
            case 378: 
            case 381: 
            case 385: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 415: 
            case 416: 
            case 419: 
            case 420: 
            case 423: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 434: 
            case 437: 
            case 439: 
            case 442: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 5: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 6: 
            case 91: 
            case 95: 
            case 234: 
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 13: 
            case 54: 
            case 101: 
            case 135: 
            case 136: 
            case 140: 
            case 170: 
            case 189: 
            case 195: 
            case 227: 
            case 229: 
            case 299: 
            case 310: 
            case 313: 
            case 326: 
            case 356: 
            case 414: 
            case 430: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 14: 
            case 15: 
            case 30: 
            case 32: 
            case 38: 
            case 102: 
            case 107: 
            case 110: 
            case 112: 
            case 222: 
            case 300: 
            case 317: 
            case 352: 
            case 353: 
            case 357: 
            case 360: 
            case 361: 
            case 363: 
            case 379: 
            case 440: 
            case 441: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalList";
                break;
            }
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 33: 
            case 83: 
            case 97: 
            case 108: 
            case 114: 
            case 116: 
            case 204: 
            case 206: 
            case 208: 
            case 224: 
            case 273: 
            case 275: 
            case 303: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 42: 
            case 94: 
            case 162: 
            case 348: 
            case 396: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 43: 
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 58: 
            case 78: 
            case 104: 
            case 118: 
            case 198: 
            case 203: 
            case 231: 
            case 233: 
            case 236: 
            case 256: 
            case 287: 
            case 288: 
            case 291: 
            case 293: 
            case 296: 
            case 367: 
            case 374: 
            case 386: 
            case 387: 
            case 390: 
            case 392: 
            case 394: 
            case 438: 
            case 449: 
            case 460: 
            case 462: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 59: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 121: 
            case 123: 
            case 127: 
            case 129: 
            case 132: 
            case 142: 
            case 146: 
            case 151: 
            case 155: 
            case 156: 
            case 159: 
            case 160: 
            case 165: 
            case 168: 
            case 173: 
            case 175: 
            case 179: 
            case 182: 
            case 186: 
            case 190: 
            case 192: 
            case 210: 
            case 212: 
            case 215: 
            case 218: 
            case 220: 
            case 306: 
            case 320: 
            case 411: 
            case 417: 
            case 421: 
            case 425: 
            case 429: 
            case 435: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 70: 
            case 74: 
            case 239: 
            case 388: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 71: 
            case 75: 
            case 240: 
            case 389: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 72: 
            case 76: 
            case 289: 
            case 292: 
            case 294: 
            case 298: 
            case 368: 
            case 370: 
            case 372: 
            case 375: 
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 73: 
            case 103: 
            case 105: 
            case 106: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 92: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 100: 
            case 111: 
            case 117: 
            case 119: 
            case 154: 
            case 161: 
            case 166: 
            case 178: 
            case 185: 
            case 188: 
            case 191: 
            case 221: 
            case 351: 
            case 354: 
            case 355: 
            case 358: 
            case 359: 
            case 362: 
            case 364: 
            case 391: 
            case 393: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 120: 
            case 124: 
            case 126: 
            case 130: 
            case 134: 
            case 137: 
            case 139: 
            case 144: 
            case 147: 
            case 150: 
            case 274: 
            case 412: 
            case 413: 
            case 418: 
            case 422: 
            case 426: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 138: 
            case 143: 
            case 157: 
            case 158: 
            case 223: 
            case 225: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 148: 
            case 152: 
            case 384: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 169: 
            case 172: 
            case 176: 
            case 183: 
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValues";
                break;
            }
            case 197: 
            case 211: 
            case 443: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 209: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 228: 
            case 257: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 250: 
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 253: 
            case 255: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 259: 
            case 261: 
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 260: 
            case 262: 
            case 265: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 269: 
            case 271: 
            case 272: 
            case 335: 
            case 365: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 276: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 277: 
            case 383: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 278: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 280: 
            case 399: 
            case 409: 
            case 432: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 281: 
            case 285: 
            case 347: 
            case 436: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 283: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 290: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 301: 
            case 304: 
            case 307: 
            case 309: 
            case 312: 
            case 318: 
            case 321: 
            case 325: 
            case 328: 
            case 380: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 314: 
            case 330: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 329: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 343: 
            case 346: 
            case 410: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 340: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 344: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 349: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 369: 
            case 371: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 373: 
            case 377: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 382: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 395: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 404: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 433: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 450: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 451: 
            case 453: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 452: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 461: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyList";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptySet";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyMap";
                break;
            }
            case 31: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 44: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableList";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSingletonList";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 65: 
            case 66: 
            case 263: 
            case 266: 
            case 267: 
            case 268: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromKeys";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromValues";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 122: 
            case 125: 
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Map";
                break;
            }
            case 128: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 141: 
            case 145: 
            case 149: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 167: 
            case 171: 
            case 184: 
            case 187: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 174: 
            case 177: 
            case 180: 
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "stringMap";
                break;
            }
            case 196: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 202: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 205: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 214: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 217: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 230: 
            case 232: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 235: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 238: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 279: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 282: 
            case 286: 
            case 431: 
            case 434: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 295: 
            case 297: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 302: 
            case 305: 
            case 308: 
            case 327: 
            case 331: 
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 324: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 333: 
            case 334: {
                objectArray = objectArray2;
                objectArray2[1] = "set";
                break;
            }
            case 341: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 345: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 350: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrElse";
                break;
            }
            case 366: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 376: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 378: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 381: {
                objectArray = objectArray2;
                objectArray2[1] = "flatMap";
                break;
            }
            case 385: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 397: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 398: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 400: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakValueMap";
                break;
            }
            case 401: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 402: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 403: 
            case 405: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 406: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftValueMap";
                break;
            }
            case 407: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftMap";
                break;
            }
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakMap";
                break;
            }
            case 415: 
            case 416: 
            case 419: 
            case 420: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 423: 
            case 424: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 427: 
            case 428: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 437: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 439: {
                objectArray = objectArray2;
                objectArray2[1] = "copyList";
                break;
            }
            case 442: {
                objectArray = objectArray2;
                objectArray2[1] = "toCollection";
                break;
            }
            case 444: 
            case 445: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 446: 
            case 447: 
            case 448: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 456: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeySoftValueMap";
                break;
            }
            case 457: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyWeakValueMap";
                break;
            }
            case 458: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftKeySoftValueMap";
                break;
            }
            case 459: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftMap";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 77: 
            case 79: 
            case 90: 
            case 93: 
            case 99: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 164: 
            case 167: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 184: 
            case 187: 
            case 194: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 214: 
            case 217: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: 
            case 263: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 279: 
            case 282: 
            case 286: 
            case 295: 
            case 297: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: 
            case 324: 
            case 327: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 341: 
            case 342: 
            case 345: 
            case 350: 
            case 366: 
            case 376: 
            case 378: 
            case 381: 
            case 385: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 415: 
            case 416: 
            case 419: 
            case 420: 
            case 423: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 434: 
            case 437: 
            case 439: 
            case 442: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "subArrayAsList";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newUnmodifiableList";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyList";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptySet";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyMap";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 54: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 62: 
            case 348: 
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 63: 
            case 64: 
            case 261: 
            case 262: 
            case 264: 
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 210: 
            case 211: 
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 215: 
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 100: 
            case 101: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 126: 
            case 127: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 154: 
            case 155: 
            case 160: 
            case 161: 
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "filterIsInstance";
                break;
            }
            case 165: 
            case 166: 
            case 169: 
            case 170: 
            case 182: 
            case 183: 
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 172: 
            case 173: 
            case 175: 
            case 176: 
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "stringMap";
                break;
            }
            case 195: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 200: 
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 204: 
            case 206: 
            case 207: 
            case 208: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 220: 
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 228: 
            case 229: 
            case 231: 
            case 239: 
            case 240: 
            case 244: 
            case 245: 
            case 246: 
            case 253: 
            case 255: 
            case 256: 
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 233: 
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 236: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 273: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 275: 
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "filterIterator";
                break;
            }
            case 277: 
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 280: 
            case 281: 
            case 283: 
            case 284: 
            case 285: 
            case 429: 
            case 430: 
            case 432: 
            case 433: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 298: 
            case 299: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 306: 
            case 307: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 309: 
            case 310: 
            case 312: 
            case 313: 
            case 314: 
            case 317: 
            case 318: 
            case 320: 
            case 321: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 323: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 336: 
            case 337: 
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 339: 
            case 340: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 343: 
            case 344: 
            case 346: 
            case 347: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 351: 
            case 352: 
            case 353: 
            case 354: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 355: 
            case 356: 
            case 357: 
            case 358: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 359: 
            case 360: 
            case 361: 
            case 362: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 363: 
            case 364: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 365: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 367: 
            case 368: 
            case 369: 
            case 370: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 371: 
            case 372: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 373: 
            case 377: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 374: 
            case 375: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 379: 
            case 380: {
                objectArray = objectArray;
                objectArray[2] = "flatMap";
                break;
            }
            case 382: 
            case 383: 
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 387: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 388: 
            case 389: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 390: 
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 392: 
            case 393: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 394: 
            case 395: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 396: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 399: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 410: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 411: 
            case 412: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 413: 
            case 414: 
            case 417: 
            case 418: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 421: 
            case 422: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 425: 
            case 426: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 435: 
            case 436: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 438: {
                objectArray = objectArray;
                objectArray[2] = "copyList";
                break;
            }
            case 440: 
            case 441: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 443: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 449: 
            case 450: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 451: 
            case 452: 
            case 453: 
            case 454: 
            case 455: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 460: 
            case 461: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 462: {
                objectArray = objectArray;
                objectArray[2] = "splitListToChunks";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 77: 
            case 79: 
            case 90: 
            case 93: 
            case 99: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 164: 
            case 167: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 184: 
            case 187: 
            case 194: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 214: 
            case 217: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: 
            case 263: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 279: 
            case 282: 
            case 286: 
            case 295: 
            case 297: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: 
            case 324: 
            case 327: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 341: 
            case 342: 
            case 345: 
            case 350: 
            case 366: 
            case 376: 
            case 378: 
            case 381: 
            case 385: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 415: 
            case 416: 
            case 419: 
            case 420: 
            case 423: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 434: 
            case 437: 
            case 439: 
            case 442: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    @Unmodifiable
    private static final class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(E @NotNull [] array) {
            if (array == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(0);
            }
            this.myStore = array;
        }

        @Override
        public E get(int index2) {
            return this.myStore[index2];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        @Override
        public <T> T @NotNull [] toArray(T @NotNull [] a2) {
            int size;
            if (a2 == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(1);
            }
            T[] result2 = a2.length >= (size = this.size()) ? a2 : ArrayUtil.newArray(ArrayUtil.getComponentType(a2), size);
            System.arraycopy(this.myStore, 0, result2, 0, size);
            if (result2.length > size) {
                result2[size] = null;
            }
            if (result2 == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(2);
            }
            return result2;
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            int length = this.myStore.length;
            for (int i2 = 0; i2 < length; ++i2) {
                action.accept(this.myStore[i2]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Deprecated
    @Unmodifiable
    private static final class ImmutableListBackedByList<E>
    extends ImmutableList<E> {
        private final List<? extends E> myStore;

        private ImmutableListBackedByList(@NotNull List<? extends E> list) {
            if (list == null) {
                ImmutableListBackedByList.$$$reportNull$$$0(0);
            }
            this.myStore = list;
        }

        @Override
        public E get(int index2) {
            return this.myStore.get(index2);
        }

        @Override
        public int size() {
            return this.myStore.size();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.myStore.forEach(action);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByList", "<init>"));
        }
    }

    @Deprecated
    public static final class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new HashMap();

        @NotNull
        public ImmutableMapBuilder<K, V> put(K key, V value2) {
            this.myMap.put(key, value2);
            ImmutableMapBuilder immutableMapBuilder = this;
            if (immutableMapBuilder == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(0);
            }
            return immutableMapBuilder;
        }

        @NotNull
        public ImmutableMapBuilder<K, V> putAll(@NotNull Map<? extends K, ? extends V> fromMap) {
            if (fromMap == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(1);
            }
            this.myMap.putAll(fromMap);
            ImmutableMapBuilder immutableMapBuilder = this;
            if (immutableMapBuilder == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(2);
            }
            return immutableMapBuilder;
        }

        @Contract(pure=true)
        public @Unmodifiable @NotNull Map<K, V> build() {
            Map<K, V> map = Collections.unmodifiableMap(this.myMap);
            if (map == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(3);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$ImmutableMapBuilder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromMap";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "put";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$ImmutableMapBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "putAll";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "putAll";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class KeyOrderedMultiMap<K extends Comparable<? super K>, V>
    extends MultiMap<K, V> {
        public KeyOrderedMultiMap() {
            super(new TreeMap());
        }

        public KeyOrderedMultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
            if (toCopy == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(0);
            }
            super(new TreeMap());
            this.putAllValues(toCopy);
        }

        @NotNull
        public NavigableSet<K> navigableKeySet() {
            NavigableSet navigableSet = ((TreeMap)this.myMap).navigableKeySet();
            if (navigableSet == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(1);
            }
            return navigableSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toCopy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "navigableKeySet";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum MergeResult {
        COPIED_FROM_LIST1,
        MERGED_EQUAL_FROM_BOTH,
        COPIED_FROM_LIST2;

    }
}

