/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.reflect.Field;
import javax.swing.RepaintManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InvocationUtil {
    @NotNull
    public static final Class<? extends Runnable> REPAINT_PROCESSING_CLASS = InvocationUtil.findProcessingClass();
    @NotNull
    private static final Field INVOCATION_EVENT_RUNNABLE_FIELD = InvocationUtil.findRunnableField();

    public static boolean isFlushNow(@NotNull Runnable runnable) {
        if (runnable == null) {
            InvocationUtil.$$$reportNull$$$0(0);
        }
        return LaterInvocator.isFlushNow(runnable);
    }

    private InvocationUtil() {
    }

    @Nullable
    public static Runnable extractRunnable(@NotNull AWTEvent event) {
        if (event == null) {
            InvocationUtil.$$$reportNull$$$0(1);
        }
        if (event instanceof InvocationEvent) {
            try {
                return (Runnable)INVOCATION_EVENT_RUNNABLE_FIELD.get(event);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    private static Class<? extends Runnable> findProcessingClass() {
        Class<Runnable> clazz;
        try {
            clazz = Class.forName("javax.swing.RepaintManager$ProcessingRunnable", false, InvocationUtil.class.getClassLoader()).asSubclass(Runnable.class);
        }
        catch (ClassNotFoundException e2) {
            throw new InternalAPIChangedException(RepaintManager.class, e2);
        }
        if (clazz == null) {
            InvocationUtil.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    @NotNull
    private static Field findRunnableField() {
        for (Class aClass = InvocationEvent.class; aClass != null; aClass = aClass.getSuperclass()) {
            Field field;
            try {
                Field result2 = aClass.getDeclaredField("runnable");
                result2.setAccessible(true);
                field = result2;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            if (field == null) {
                InvocationUtil.$$$reportNull$$$0(3);
            }
            return field;
        }
        throw new InternalAPIChangedException(InvocationEvent.class, new NoSuchFieldException("Class: " + InvocationEvent.class + " fieldName: runnable fieldType: " + Runnable.class));
    }

    public static boolean priorityEventPending() {
        AWTEvent event;
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (app != null) {
            app.flushNativeEventQueue();
        }
        return (event = Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent()) != null && event.getClass().getName().equals("sun.awt.PeerEvent");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/InvocationUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/InvocationUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findProcessingClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findRunnableField";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFlushNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractRunnable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class InternalAPIChangedException
    extends RuntimeException {
        InternalAPIChangedException(@NotNull Class<?> targetClass, @Nullable ReflectiveOperationException cause) {
            if (targetClass == null) {
                InternalAPIChangedException.$$$reportNull$$$0(0);
            }
            super(targetClass + " class internal API has been changed", cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/openapi/application/impl/InvocationUtil$InternalAPIChangedException", "<init>"));
        }
    }
}

