/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DurableDataEnumerator;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import com.intellij.util.io.StorageLockContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class PersistentEnumerator<Data>
implements DurableDataEnumerator<Data>,
ScannableDataEnumeratorEx<Data> {
    @NotNull
    protected final PersistentEnumeratorBase<Data> myEnumerator;

    public PersistentEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        if (file2 == null) {
            PersistentEnumerator.$$$reportNull$$$0(0);
        }
        if (dataDescriptor == null) {
            PersistentEnumerator.$$$reportNull$$$0(1);
        }
        this(file2, dataDescriptor, initialSize, null);
    }

    public PersistentEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext) throws IOException {
        if (file2 == null) {
            PersistentEnumerator.$$$reportNull$$$0(2);
        }
        if (dataDescriptor == null) {
            PersistentEnumerator.$$$reportNull$$$0(3);
        }
        this.myEnumerator = new PersistentBTreeEnumerator<Data>(file2, dataDescriptor, initialSize, lockContext);
    }

    public PersistentEnumerator(@NotNull File file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version) throws IOException {
        if (file2 == null) {
            PersistentEnumerator.$$$reportNull$$$0(4);
        }
        if (dataDescriptor == null) {
            PersistentEnumerator.$$$reportNull$$$0(5);
        }
        this(file2.toPath(), dataDescriptor, initialSize, lockContext, version);
    }

    public PersistentEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version) throws IOException {
        if (file2 == null) {
            PersistentEnumerator.$$$reportNull$$$0(6);
        }
        if (dataDescriptor == null) {
            PersistentEnumerator.$$$reportNull$$$0(7);
        }
        this.myEnumerator = PersistentEnumerator.createDefaultEnumerator(file2, dataDescriptor, initialSize, lockContext, version, true);
    }

    @NotNull
    static <Data> PersistentEnumeratorBase<Data> createDefaultEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version, boolean registerForStats) throws IOException {
        if (file2 == null) {
            PersistentEnumerator.$$$reportNull$$$0(8);
        }
        if (dataDescriptor == null) {
            PersistentEnumerator.$$$reportNull$$$0(9);
        }
        return new PersistentBTreeEnumerator<Data>(file2, dataDescriptor, initialSize, lockContext, version, false, registerForStats);
    }

    @ApiStatus.Internal
    public static int getVersion() {
        return PersistentBTreeEnumerator.baseVersion();
    }

    @Override
    public void close() throws IOException {
        PersistentEnumeratorBase<Data> enumerator = this.myEnumerator;
        if (enumerator != null) {
            enumerator.close();
        }
    }

    public boolean isClosed() {
        return this.myEnumerator.isClosed();
    }

    @Override
    public boolean isDirty() {
        return this.myEnumerator.isDirty();
    }

    public final void markDirty() throws IOException {
        Lock lock = this.myEnumerator.getWriteLock();
        lock.lock();
        try {
            this.myEnumerator.markDirty(true);
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isCorrupted() {
        return this.myEnumerator.isCorrupted();
    }

    public void markCorrupted() {
        this.myEnumerator.markCorrupted();
    }

    @Override
    public void force() {
        this.myEnumerator.force();
    }

    @Override
    public Data valueOf(@Range(from=1L, to=0x7FFFFFFFL) int id) throws IOException {
        return this.myEnumerator.valueOf(id);
    }

    @Override
    public @Range(from=1L, to=0x7FFFFFFFL) int enumerate(Data name2) throws IOException {
        return this.myEnumerator.enumerate(name2);
    }

    @Override
    public int tryEnumerate(Data name2) throws IOException {
        return this.myEnumerator.tryEnumerate(name2);
    }

    @ApiStatus.Internal
    public Collection<Data> getAllDataObjects(@Nullable PersistentEnumeratorBase.DataFilter filter) throws IOException {
        return this.myEnumerator.getAllDataObjects(filter);
    }

    @Override
    public boolean forEach(@NotNull ScannableDataEnumeratorEx.ValueReader<? super Data> reader) throws IOException {
        if (reader == null) {
            PersistentEnumerator.$$$reportNull$$$0(10);
        }
        return this.myEnumerator.forEach(reader);
    }

    @Override
    public int recordsCount() throws IOException {
        return this.myEnumerator.recordsCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/PersistentEnumerator";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefaultEnumerator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "forEach";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

