/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class PsiFileImplUtil {
    private static final Key<Consumer<PsiFile>> NON_PHYSICAL_FILE_DELETE_HANDLER = Key.create("NonPhysicalFileDeleteHandler");

    private PsiFileImplUtil() {
    }

    @ApiStatus.Internal
    public static void saveDocumentIfFileWillBecomeBinary(VirtualFile vFile, @NotNull String newName) {
        FileDocumentManager fdm;
        Document doc;
        FileType newFileType;
        if (newName == null) {
            PsiFileImplUtil.$$$reportNull$$$0(0);
        }
        if ((UnknownFileType.INSTANCE.equals(newFileType = FileTypeRegistry.getInstance().getFileTypeByFileName(newName)) || newFileType.isBinary()) && (doc = (fdm = FileDocumentManager.getInstance()).getCachedDocument(vFile)) != null) {
            fdm.saveDocumentAsIs(doc);
        }
    }

    @ApiStatus.Experimental
    public static void setNonPhysicalFileDeleteHandler(@NotNull PsiFile file2, @NotNull @NotNull Consumer<@NotNull PsiFile> handler2) {
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(1);
        }
        if (handler2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(2);
        }
        if (file2.isPhysical()) {
            throw new IllegalArgumentException();
        }
        file2.putUserData(NON_PHYSICAL_FILE_DELETE_HANDLER, handler2);
    }

    public static boolean canDeleteNonPhysicalFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(3);
        }
        return !file2.isPhysical() && file2.getUserData(NON_PHYSICAL_FILE_DELETE_HANDLER) != null;
    }

    public static PsiFile setName(@NotNull PsiFile file2, @NotNull String newName) throws IncorrectOperationException {
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            PsiFileImplUtil.$$$reportNull$$$0(5);
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        try {
            PsiFileImplUtil.saveDocumentIfFileWillBecomeBinary(vFile, newName);
            vFile.rename(manager, newName);
        }
        catch (IOException e2) {
            throw new IncorrectOperationException(e2);
        }
        return file2.getViewProvider().isPhysical() ? manager.findFile(vFile) : file2;
    }

    public static void checkSetName(@NotNull PsiFile file2, @NotNull String name2) throws IncorrectOperationException {
        VirtualFile vFile;
        VirtualFile parentFile;
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(7);
        }
        if ((parentFile = (vFile = file2.getVirtualFile()).getParent()) == null) {
            return;
        }
        VirtualFile child = parentFile.findChild(name2);
        if (child != null && !child.equals(vFile)) {
            throw new IncorrectOperationException("File " + child.getPresentableUrl() + " already exists.");
        }
    }

    public static void doDelete(@NotNull PsiFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(8);
        }
        if (!file2.isPhysical()) {
            Consumer<PsiFile> handler2 = file2.getUserData(NON_PHYSICAL_FILE_DELETE_HANDLER);
            if (handler2 == null) {
                throw new IncorrectOperationException();
            }
            handler2.accept(file2);
            return;
        }
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        VirtualFile vFile = file2.getVirtualFile();
        try {
            vFile.delete(manager);
        }
        catch (IOException e2) {
            throw new IncorrectOperationException(e2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/file/PsiFileImplUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveDocumentIfFileWillBecomeBinary";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setNonPhysicalFileDeleteHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteNonPhysicalFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSetName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doDelete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

