/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsOnDeclarationBodyChecker;", "", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkLocalVariable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "checkFunction", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkPropertyAccessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkNullabilityAssertion", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "declarationType", "Lorg/jetbrains/kotlin/types/KotlinType;", "canContainNull", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nRuntimeAssertions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeAssertions.kt\norg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsOnDeclarationBodyChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1734#2,3:249\n*S KotlinDebug\n*F\n+ 1 RuntimeAssertions.kt\norg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsOnDeclarationBodyChecker\n*L\n244#1:249,3\n*E\n"})
public final class RuntimeAssertionsOnDeclarationBodyChecker {
    @NotNull
    public static final RuntimeAssertionsOnDeclarationBodyChecker INSTANCE = new RuntimeAssertionsOnDeclarationBodyChecker();

    private RuntimeAssertionsOnDeclarationBodyChecker() {
    }

    @JvmStatic
    public static final void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace bindingTrace, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (!languageVersionSettings.supportsFeature(LanguageFeature.StrictJavaNullabilityAssertions)) {
            return;
        }
        if (declaration2 instanceof KtProperty && descriptor2 instanceof VariableDescriptor) {
            INSTANCE.checkLocalVariable((KtProperty)declaration2, (VariableDescriptor)descriptor2, bindingTrace);
        } else if (declaration2 instanceof KtFunction && descriptor2 instanceof FunctionDescriptor) {
            INSTANCE.checkFunction((KtFunction)declaration2, (FunctionDescriptor)descriptor2, bindingTrace);
        } else if (declaration2 instanceof KtProperty && descriptor2 instanceof PropertyDescriptor) {
            INSTANCE.checkProperty((KtProperty)declaration2, (PropertyDescriptor)descriptor2, bindingTrace);
        } else if (declaration2 instanceof KtPropertyAccessor && descriptor2 instanceof PropertyAccessorDescriptor) {
            INSTANCE.checkPropertyAccessor((KtPropertyAccessor)declaration2, (PropertyAccessorDescriptor)descriptor2, bindingTrace);
        }
    }

    private final void checkLocalVariable(KtProperty declaration2, VariableDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration2.getTypeReference() != null) {
            return;
        }
        KtExpression ktExpression = declaration2.getInitializer();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkFunction(KtFunction declaration2, FunctionDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration2.getTypeReference() != null || declaration2.hasBlockBody()) {
            return;
        }
        KtExpression ktExpression = declaration2.getBodyExpression();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return;
        }
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkProperty(KtProperty declaration2, PropertyDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration2.getTypeReference() != null) {
            return;
        }
        if (declaration2.hasDelegateExpression()) {
            return;
        }
        KtExpression ktExpression = declaration2.getInitializer();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkPropertyAccessor(KtPropertyAccessor declaration2, PropertyAccessorDescriptor descriptor2, BindingTrace bindingTrace) {
        if (declaration2.getProperty().getTypeReference() != null || declaration2.hasBlockBody()) {
            return;
        }
        KtExpression ktExpression = declaration2.getBodyExpression();
        if (ktExpression == null) {
            return;
        }
        KotlinType kotlinType = descriptor2.getCorrespondingProperty().getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        this.checkNullabilityAssertion(ktExpression, kotlinType, bindingTrace);
    }

    private final void checkNullabilityAssertion(KtExpression expression2, KotlinType declarationType, BindingTrace bindingTrace) {
        if (this.canContainNull(declarationType.unwrap())) {
            return;
        }
        KotlinType kotlinType = bindingTrace.getType(expression2);
        if (kotlinType == null) {
            return;
        }
        KotlinType expressionType = kotlinType;
        if (KotlinTypeKt.isError(expressionType)) {
            return;
        }
        if (!TypeEnhancementKt.hasEnhancedNullability(expressionType)) {
            return;
        }
        bindingTrace.record(JvmBindingContextSlices.BODY_RUNTIME_ASSERTION_INFO, expression2, new RuntimeAssertionInfo(true, RuntimeAssertionsKt.access$getTextForRuntimeAssertionInfo(expression2)));
    }

    private final boolean canContainNull(UnwrappedType $this$canContainNull) {
        boolean bl;
        block7: {
            SimpleType upper = FlexibleTypesKt.upperIfFlexible($this$canContainNull);
            if (upper.isMarkedNullable()) {
                bl = true;
            } else if (NewKotlinTypeCheckerKt.isClassType(upper)) {
                bl = false;
            } else {
                Iterable $this$all$iv = TypeUtilsKt.immediateSupertypes(upper);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (INSTANCE.canContainNull(it.unwrap())) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }
}

