/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnknownLambdaParameterTypeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/TypeVariableTypeRemovingSubstitutor;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "typeContext", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;)V", "substituteType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "convertTypeVariableType", "Lorg/jetbrains/kotlin/fir/types/ConeTypeVariableType;", "toString", "", "semantics"})
final class TypeVariableTypeRemovingSubstitutor
extends AbstractConeSubstitutor {
    public TypeVariableTypeRemovingSubstitutor(@NotNull ConeTypeContext typeContext2) {
        Intrinsics.checkNotNullParameter((Object)typeContext2, (String)"typeContext");
        super(typeContext2);
    }

    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return type2 instanceof ConeTypeVariableType ? this.convertTypeVariableType((ConeTypeVariableType)type2) : null;
    }

    private final ConeKotlinType convertTypeVariableType(ConeTypeVariableType type2) {
        TypeParameterMarker originalTypeParameter = type2.getTypeConstructor().getOriginalTypeParameter();
        if (originalTypeParameter != null) {
            if (!(originalTypeParameter instanceof ConeTypeParameterLookupTag)) {
                throw new IllegalStateException("Check failed.");
            }
            return new ConeTypeParameterTypeImpl((ConeTypeParameterLookupTag)originalTypeParameter, type2.isMarkedNullable(), type2.getAttributes());
        }
        return new ConeErrorType(new ConeUnknownLambdaParameterTypeDiagnostic(), false, null, null, null, 30, null);
    }

    @NotNull
    public String toString() {
        return "{<Type variable> -> <Error type>}";
    }
}

