/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.java.JavaSymbolProvider;
import org.jetbrains.kotlin.fir.java.JavaSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmConflictsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassLikeChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmConflictsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmConflictsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmConflictsChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,42:1\n34#2:43\n33#2:44\n*S KotlinDebug\n*F\n+ 1 FirJvmConflictsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmConflictsChecker\n*L\n28#1:43\n31#1:44\n*E\n"})
public final class FirJvmConflictsChecker
extends FirDeclarationChecker<FirClassLikeDeclaration> {
    @NotNull
    public static final FirJvmConflictsChecker INSTANCE = new FirJvmConflictsChecker();

    private FirJvmConflictsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirClassLikeDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirClassLikeDeclaration firClassLikeDeclaration = declaration2;
        if (firClassLikeDeclaration instanceof FirAnonymousObject) {
            bl = false;
        } else if (firClassLikeDeclaration instanceof FirRegularClass) {
            FirMemberDeclaration $this$isExpect$iv = declaration2;
            boolean $i$f$isExpect = false;
            bl = !$this$isExpect$iv.getStatus().isExpect();
        } else if (firClassLikeDeclaration instanceof FirTypeAlias) {
            FirMemberDeclaration $this$isActual$iv = declaration2;
            boolean $i$f$isActual = false;
            bl = $this$isActual$iv.getStatus().isActual();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean checkRedeclaration = bl;
        if (!checkRedeclaration) {
            return;
        }
        Object object = JavaSymbolProviderKt.getJavaSymbolProvider(context2.getSession());
        if (object == null || (object = ((JavaSymbolProvider)object).getClassLikeSymbolByClassId(FirDeclarationUtilKt.getClassId(declaration2))) == null) {
            return;
        }
        Object javaSymbol = object;
        Object[] objectArray = new FirClassLikeSymbol[]{declaration2.getSymbol(), javaSymbol};
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getCLASSIFIER_REDECLARATION(), (Object)CollectionsKt.listOf((Object[])objectArray), (DiagnosticContext)context2, null, 16, null);
    }
}

