/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002\u0017\u0018B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u0082\u0001\u0002\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isBuiltinFunctionalTypeOrSubtype", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isSuspendFunctionTypeOrSubtype", "findFakeMethodOverridingExternalWithOptionalParams", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "Regular", "ForExpectClass", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsInheritanceClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n827#2:105\n855#2,2:106\n1611#2,9:108\n1863#2:117\n1864#2:119\n1620#2:120\n1755#2,3:121\n1755#2,3:124\n808#2,11:128\n774#2:139\n865#2,2:140\n295#2,2:142\n1#3:118\n1#3:127\n*S KotlinDebug\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker\n*L\n52#1:105\n52#1:106,2\n53#1:108,9\n53#1:117\n53#1:119\n53#1:120\n55#1:121,3\n73#1:124,3\n93#1:128,11\n94#1:139\n94#1:140,2\n99#1:142,2\n53#1:118\n*E\n"})
public abstract class FirJsInheritanceClassChecker
extends FirDeclarationChecker<FirClass> {
    private FirJsInheritanceClassChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirNamedFunctionSymbol fakeOverriddenMethod;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSession session = context2.getSession();
        boolean isEffectivelyExternal = FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)declaration2.getSymbol(), session);
        if (isEffectivelyExternal && declaration2.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            boolean bl;
            block13: {
                Iterator $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                Iterable iterable = FirDeclarationUtilKt.getSuperConeTypes(declaration2);
                boolean $i$f$filterNot = false;
                void var9_10 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl2 = false;
                    if (ConeBuiltinTypeUtilsKt.isAnyOrNullableAny(it) || ConeBuiltinTypeUtilsKt.isThrowableOrNullableThrowable(it) || ConeBuiltinTypeUtilsKt.isEnum(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FirRegularClassSymbol it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl4 = false;
                    FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(it, session);
                    if ((firClassLikeSymbol != null ? DeclarationUtilsKt.fullyExpandedClass(firClassLikeSymbol, session) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List superTypes2 = (List)destination$iv$iv;
                Iterable $this$any$iv = superTypes2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl6 = false;
                        if (!(!FirWebCommonHelpersKt.isEffectivelyExternal(it, session))) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        if (!isEffectivelyExternal && (fakeOverriddenMethod = this.findFakeMethodOverridingExternalWithOptionalParams(declaration2, context2)) != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getOVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS_WITH_FAKE(), (Object)fakeOverriddenMethod, (DiagnosticContext)context2, null, 16, null);
        }
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowImplementingFunctionInterface)) {
            boolean bl;
            block14: {
                Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes(declaration2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeClassLikeType it = (ConeClassLikeType)element$iv;
                        boolean bl7 = false;
                        if (!(this.isBuiltinFunctionalTypeOrSubtype(it, session) && !this.isSuspendFunctionTypeOrSubtype(it, session))) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getIMPLEMENTING_FUNCTION_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final boolean isBuiltinFunctionalTypeOrSubtype(ConeClassLikeType $this$isBuiltinFunctionalTypeOrSubtype, FirSession session) {
        ConeInferenceContext $this$isBuiltinFunctionalTypeOrSubtype_u24lambda_u244 = TypeComponentsKt.getTypeContext(session);
        boolean bl = false;
        return $this$isBuiltinFunctionalTypeOrSubtype_u24lambda_u244.isBuiltinFunctionTypeOrSubtype($this$isBuiltinFunctionalTypeOrSubtype);
    }

    private final boolean isSuspendFunctionTypeOrSubtype(ConeClassLikeType $this$isSuspendFunctionTypeOrSubtype, FirSession session) {
        ConeInferenceContext $this$isSuspendFunctionTypeOrSubtype_u24lambda_u246 = TypeComponentsKt.getTypeContext(session);
        boolean bl = false;
        return $this$isSuspendFunctionTypeOrSubtype_u24lambda_u246.isTypeOrSubtypeOf($this$isSuspendFunctionTypeOrSubtype, (Function1<? super ConeKotlinType, Boolean>)((Function1)arg_0 -> FirJsInheritanceClassChecker.isSuspendFunctionTypeOrSubtype$lambda$6$lambda$5(session, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final FirNamedFunctionSymbol findFakeMethodOverridingExternalWithOptionalParams(FirClass $this$findFakeMethodOverridingExternalWithOptionalParams, CheckerContext context2) {
        Object v0;
        block3: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            FirTypeScope scope = FirHelpersKt.unsubstitutedScope($this$findFakeMethodOverridingExternalWithOptionalParams.getSymbol(), context2);
            Iterable iterable = FirContainingNamesAwareScopeKt.collectAllFunctions(scope);
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirIntersectionOverrideFunctionSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirIntersectionOverrideFunctionSymbol it = (FirIntersectionOverrideFunctionSymbol)element$iv$iv;
                boolean bl = false;
                FirClassLikeSymbol<?> container = FirHelpersKt.getContainingClassSymbol(it);
                if (!(Intrinsics.areEqual(container, $this$findFakeMethodOverridingExternalWithOptionalParams.getSymbol()) && !it.getIntersections().isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List members = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = members;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirIntersectionOverrideFunctionSymbol it = (FirIntersectionOverrideFunctionSymbol)element$iv;
                boolean bl = false;
                if (!FirJsHelpersKt.isOverridingExternalWithOptionalParams(it, context2)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    private static final boolean isSuspendFunctionTypeOrSubtype$lambda$6$lambda$5(FirSession $session, ConeKotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(it, $session);
    }

    public /* synthetic */ FirJsInheritanceClassChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
    @SourceDebugExtension(value={"SMAP\nFirJsInheritanceClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,104:1\n34#2:105\n*S KotlinDebug\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass\n*L\n41#1:105\n*E\n"})
    public static final class ForExpectClass
    extends FirJsInheritanceClassChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration2;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration2, context2, reporter);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
    @SourceDebugExtension(value={"SMAP\nFirJsInheritanceClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,104:1\n34#2:105\n*S KotlinDebug\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular\n*L\n34#1:105\n*E\n"})
    public static final class Regular
    extends FirJsInheritanceClassChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration2;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration2, context2, reporter);
        }
    }
}

