/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnderscoredTypeArgumentSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "isApplicable", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkPsi", "", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkLightTree", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnderscoredTypeArgumentSyntaxChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnderscoredTypeArgumentSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnderscoredTypeArgumentSyntaxChecker\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,69:1\n813#2,5:70\n*S KotlinDebug\n*F\n+ 1 FirUnderscoredTypeArgumentSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnderscoredTypeArgumentSyntaxChecker\n*L\n40#1:70,5\n*E\n"})
public final class FirUnderscoredTypeArgumentSyntaxChecker
extends FirExpressionSyntaxChecker<FirFunctionCall, PsiElement> {
    @NotNull
    public static final FirUnderscoredTypeArgumentSyntaxChecker INSTANCE = new FirUnderscoredTypeArgumentSyntaxChecker();

    private FirUnderscoredTypeArgumentSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirFunctionCall element2, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return !((Collection)element2.getTypeArguments()).isEmpty();
    }

    @Override
    public void checkPsi(@NotNull FirFunctionCall element2, @NotNull KtPsiSourceElement source, @NotNull PsiElement psi, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeProjection typeProjection : element2.getTypeArguments()) {
            KtTypeReference typeReference;
            KtTypeProjection psiTypeArgument;
            KtSourceElement ktSourceElement = typeProjection.getSource();
            PsiElement psiElement = ktSourceElement != null ? KtSourceElementKt.getPsi(ktSourceElement) : null;
            KtTypeProjection ktTypeProjection = psiElement instanceof KtTypeProjection ? (KtTypeProjection)psiElement : null;
            if (ktTypeProjection == null || (psiTypeArgument = ktTypeProjection).getTypeReference() == null || !typeReference.isPlaceholder()) continue;
            for (KtAnnotationEntry annotation : typeReference.getAnnotationEntries()) {
                KtPsiSourceElement ktPsiSourceElement;
                PsiElement $this$toKtPsiSourceElement_u24default$iv = annotation;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                boolean $i$f$toKtPsiSourceElement = false;
                KtSourceElementKind ktSourceElementKind = kind$iv;
                if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                    ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktPsiSourceElement, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"annotations on an underscored type argument", (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    @Override
    public void checkLightTree(@NotNull FirFunctionCall element2, @NotNull KtLightSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeProjection typeProjection : element2.getTypeArguments()) {
            List<LighterASTNode> annotations2;
            Object object = typeProjection.getSource();
            if (object == null || (object = ((KtSourceElement)object).getLighterASTNode()) == null) continue;
            Object lightTreeTypeArgument = object;
            if (!FirUnderscoreHelpersKt.isUnderscore(String.valueOf(LightTreePositioningStrategiesKt.userType(source.getTreeStructure(), (LighterASTNode)lightTreeTypeArgument))) || LightTreePositioningStrategiesKt.annotations(source.getTreeStructure(), (LighterASTNode)lightTreeTypeArgument) == null) continue;
            for (LighterASTNode annotation : annotations2) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)FirSourceUtilsKt.buildChildSourceElement(source, annotation), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"annotations on an underscored type argument", (DiagnosticContext)context2, null, 16, null);
            }
        }
    }
}

