/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u001a*\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002J\u001c\u0010 \u001a\u0004\u0018\u00010\u001a*\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002J \u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\bH\u0002J \u0010&\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirPrefixAndSuffixSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "<init>", "()V", "literalConstants", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "isApplicable", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkPsi", "", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkLightTree", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "getLeaf", "Lcom/intellij/lang/LighterASTNode;", "direction", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirPrefixAndSuffixSyntaxChecker$Direction;", "treeStructure", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "prevLeaf", "nextLeaf", "checkLiteralPrefixOrSuffix", "prefixOrSuffix", "Lcom/intellij/psi/PsiElement;", "illegalLiteralPrefixOrSuffix", "elementType", "report", "Direction", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPrefixAndSuffixSyntaxChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPrefixAndSuffixSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirPrefixAndSuffixSyntaxChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,125:1\n1#2:126\n813#3,5:127\n819#3,7:132\n*S KotlinDebug\n*F\n+ 1 FirPrefixAndSuffixSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirPrefixAndSuffixSyntaxChecker\n*L\n101#1:127,5\n113#1:132,7\n*E\n"})
public final class FirPrefixAndSuffixSyntaxChecker
extends FirExpressionSyntaxChecker<FirStatement, KtExpression> {
    @NotNull
    public static final FirPrefixAndSuffixSyntaxChecker INSTANCE = new FirPrefixAndSuffixSyntaxChecker();
    @NotNull
    private static final List<IElementType> literalConstants;

    private FirPrefixAndSuffixSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirStatement element2, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return !(source.getKind() instanceof KtFakeSourceElementKind) && (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.STRING_TEMPLATE) || literalConstants.contains(source.getElementType()));
    }

    @Override
    public void checkPsi(@NotNull FirStatement element2, @NotNull KtPsiSourceElement source, @NotNull KtExpression psi, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block1: {
            PsiElement it;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            PsiElement psiElement = PsiUtilsKt.prevLeaf$default(psi, false, 1, null);
            if (psiElement != null) {
                it = psiElement;
                boolean bl = false;
                INSTANCE.checkLiteralPrefixOrSuffix(it, context2, reporter);
            }
            PsiElement psiElement2 = PsiUtilsKt.nextLeaf$default(psi, false, 1, null);
            if (psiElement2 == null) break block1;
            it = psiElement2;
            boolean bl = false;
            INSTANCE.checkLiteralPrefixOrSuffix(it, context2, reporter);
        }
    }

    @Override
    public void checkLightTree(@NotNull FirStatement element2, @NotNull KtLightSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block1: {
            LighterASTNode it;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            LighterASTNode lighterASTNode = this.prevLeaf(source.getLighterASTNode(), source.getTreeStructure());
            if (lighterASTNode != null) {
                it = lighterASTNode;
                boolean bl = false;
                INSTANCE.checkLiteralPrefixOrSuffix(it, source, context2, reporter);
            }
            lighterASTNode = this.nextLeaf(source.getLighterASTNode(), source.getTreeStructure());
            if (lighterASTNode == null) break block1;
            it = lighterASTNode;
            boolean bl = false;
            INSTANCE.checkLiteralPrefixOrSuffix(it, source, context2, reporter);
        }
    }

    private final LighterASTNode getLeaf(LighterASTNode $this$getLeaf, Direction direction, FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
        LighterASTNode lighterASTNode;
        LighterASTNode lighterASTNode2 = treeStructure.getParent($this$getLeaf);
        if (lighterASTNode2 == null) {
            return null;
        }
        LighterASTNode parent2 = lighterASTNode2;
        List<LighterASTNode> children2 = LightTreeUtilsKt.getChildren(parent2, treeStructure);
        int index2 = children2.indexOf($this$getLeaf);
        LighterASTNode leaf = (LighterASTNode)CollectionsKt.getOrNull(children2, (int)(index2 - direction.getOffset()));
        if (leaf == null && Intrinsics.areEqual((Object)parent2.getTokenType(), (Object)KtNodeTypes.BINARY_EXPRESSION)) {
            lighterASTNode = this.getLeaf(parent2, direction, treeStructure);
        } else {
            if (leaf == null) {
                return null;
            }
            LighterASTNode result2 = leaf;
            List<LighterASTNode> resultChildren = LightTreeUtilsKt.getChildren(leaf, treeStructure);
            while (!((Collection)resultChildren).isEmpty()) {
                result2 = direction == Direction.PREVIOUS ? (LighterASTNode)CollectionsKt.first(resultChildren) : (LighterASTNode)CollectionsKt.last(resultChildren);
                resultChildren = LightTreeUtilsKt.getChildren(result2, treeStructure);
            }
            lighterASTNode = result2;
        }
        return lighterASTNode;
    }

    private final LighterASTNode prevLeaf(LighterASTNode $this$prevLeaf, FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
        return this.getLeaf($this$prevLeaf, Direction.PREVIOUS, treeStructure);
    }

    private final LighterASTNode nextLeaf(LighterASTNode $this$nextLeaf, FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
        return this.getLeaf($this$nextLeaf, Direction.NEXT, treeStructure);
    }

    private final void checkLiteralPrefixOrSuffix(PsiElement prefixOrSuffix, CheckerContext context2, DiagnosticReporter reporter) {
        IElementType iElementType = prefixOrSuffix.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        if (this.illegalLiteralPrefixOrSuffix(iElementType)) {
            KtPsiSourceElement ktPsiSourceElement;
            PsiElement $this$toKtPsiSourceElement_u24default$iv = prefixOrSuffix;
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            boolean $i$f$toKtPsiSourceElement = false;
            KtSourceElementKind ktSourceElementKind = kind$iv;
            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
            } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.report(ktPsiSourceElement, context2, reporter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkLiteralPrefixOrSuffix(LighterASTNode prefixOrSuffix, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        IElementType iElementType = prefixOrSuffix.getTokenType();
        if (iElementType == null) {
            return;
        }
        IElementType elementType = iElementType;
        if (this.illegalLiteralPrefixOrSuffix(elementType)) {
            void $this$toKtLightSourceElement_u24default$iv;
            LighterASTNode lighterASTNode = prefixOrSuffix;
            FlyweightCapableTreeStructure<LighterASTNode> tree$iv = source.getTreeStructure();
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
            int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
            boolean $i$f$toKtLightSourceElement = false;
            this.report(new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv, kind$iv), context2, reporter);
        }
    }

    private final boolean illegalLiteralPrefixOrSuffix(IElementType elementType) {
        return elementType == KtTokens.IDENTIFIER || elementType == KtTokens.INTEGER_LITERAL || elementType == KtTokens.FLOAT_LITERAL || elementType instanceof KtKeywordToken;
    }

    private final void report(KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"literal prefixes and suffixes", (DiagnosticContext)context2, null, 16, null);
    }

    static {
        Object[] objectArray = new IElementType[]{KtNodeTypes.CHARACTER_CONSTANT, KtNodeTypes.FLOAT_CONSTANT, KtNodeTypes.INTEGER_CONSTANT};
        literalConstants = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirPrefixAndSuffixSyntaxChecker$Direction;", "", "offset", "", "<init>", "(Ljava/lang/String;II)V", "getOffset", "()I", "PREVIOUS", "NEXT", "checkers"})
    private static final class Direction
    extends Enum<Direction> {
        private final int offset;
        public static final /* enum */ Direction PREVIOUS = new Direction(-1);
        public static final /* enum */ Direction NEXT = new Direction(1);
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Direction(int offset) {
            this.offset = offset;
        }

        public final int getOffset() {
            return this.offset;
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value2) {
            return Enum.valueOf(Direction.class, value2);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.PREVIOUS, Direction.NEXT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

