/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.types.FirPlaceholderProjection;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirProjectionsOnNonClassTypeArgumentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirProjectionsOnNonClassTypeArgumentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProjectionsOnNonClassTypeArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirProjectionsOnNonClassTypeArgumentChecker\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,40:1\n81#2,7:41\n76#2,2:48\n57#2:50\n78#2:51\n*S KotlinDebug\n*F\n+ 1 FirProjectionsOnNonClassTypeArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirProjectionsOnNonClassTypeArgumentChecker\n*L\n33#1:41,7\n33#1:48,2\n33#1:50\n33#1:51\n*E\n"})
public final class FirProjectionsOnNonClassTypeArgumentChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirProjectionsOnNonClassTypeArgumentChecker INSTANCE = new FirProjectionsOnNonClassTypeArgumentChecker();

    private FirProjectionsOnNonClassTypeArgumentChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeProjection it : expression2.getTypeArguments()) {
            FirTypeProjection firTypeProjection = it;
            if (firTypeProjection instanceof FirStarProjection) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirStarProjection)it).getSource(), FirErrors.INSTANCE.getPROJECTION_ON_NON_CLASS_TYPE_ARGUMENT(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (firTypeProjection instanceof FirTypeProjectionWithVariance) {
                if (((FirTypeProjectionWithVariance)it).getVariance() == Variance.INVARIANT) continue;
                Object object = FirKeywordUtilsKt.getModifierList(((FirTypeProjectionWithVariance)it).getSource());
                KtSourceElement modifierSource = object != null && (object = ((FirModifierList)object).getModifiers()) != null && (object = (FirModifier)CollectionsKt.firstOrNull((List)object)) != null ? ((FirModifier)object).getSource() : null;
                KtSourceElement ktSourceElement = modifierSource;
                if (ktSourceElement == null) {
                    ktSourceElement = ((FirTypeProjectionWithVariance)it).getSource();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getPROJECTION_ON_NON_CLASS_TYPE_ARGUMENT(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (firTypeProjection instanceof FirPlaceholderProjection) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                String message$iv = "Placeholder projection shouldn't exist during checker phase.";
                Throwable cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string2 = attachmentName$iv;
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
                boolean bl = false;
                void $this$check_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl2 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$check_u24lambda_u240, "expression", expression2);
                kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            throw new NoWhenBranchMatchedException();
        }
    }
}

