/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 !2\u00020\u0001:\u0004\u001e\u001f !B#\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u0015\u001a\u00020\u0005H\u0086\u0002J\t\u0010\u0016\u001a\u00020\u0007H\u0086\u0002J\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "shouldGenerateCode", "", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Z)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getShouldGenerateCode", "()Z", "equals", "other", "hashCode", "", "component1", "component2", "component3", "error", "", "getError", "()Ljava/lang/Throwable;", "isError", "throwIfError", "", "CompilationError", "InternalError", "RetryWithAdditionalRoots", "Companion", "frontend"})
public class AnalysisResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    private final boolean shouldGenerateCode;
    @NotNull
    private static final AnalysisResult EMPTY;

    protected AnalysisResult(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, boolean shouldGenerateCode) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        this.bindingContext = bindingContext;
        this.moduleDescriptor = moduleDescriptor;
        this.shouldGenerateCode = shouldGenerateCode;
    }

    public /* synthetic */ AnalysisResult(BindingContext bindingContext, ModuleDescriptor moduleDescriptor, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(bindingContext, moduleDescriptor, bl);
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public final boolean getShouldGenerateCode() {
        return this.shouldGenerateCode;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AnalysisResult && Intrinsics.areEqual((Object)this.bindingContext, (Object)((AnalysisResult)other).bindingContext) && Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)((AnalysisResult)other).moduleDescriptor) && this.shouldGenerateCode == ((AnalysisResult)other).shouldGenerateCode;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 29 * result2 + this.bindingContext.hashCode();
        result2 = 29 * result2 + this.moduleDescriptor.hashCode();
        result2 = 29 * result2 + Boolean.hashCode(this.shouldGenerateCode);
        return result2;
    }

    @NotNull
    public final BindingContext component1() {
        return this.bindingContext;
    }

    @NotNull
    public final ModuleDescriptor component2() {
        return this.moduleDescriptor;
    }

    public final boolean component3() {
        return this.shouldGenerateCode;
    }

    @NotNull
    public final Throwable getError() {
        if (!(this instanceof InternalError)) {
            throw new IllegalStateException("Should only be called for error analysis result");
        }
        return ((InternalError)this).getException();
    }

    public final boolean isError() {
        return this instanceof InternalError || this instanceof CompilationError;
    }

    public final void throwIfError() {
        AnalysisResult analysisResult = this;
        if (analysisResult instanceof InternalError) {
            throw new IllegalStateException("failed to analyze: " + this.getError(), this.getError());
        }
        if (analysisResult instanceof CompilationError) {
            throw new CompilationErrorException();
        }
    }

    @JvmStatic
    @NotNull
    public static final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2) {
        return Companion.success(bindingContext, module2);
    }

    @JvmStatic
    @NotNull
    public static final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2, boolean shouldGenerateCode) {
        return Companion.success(bindingContext, module2, shouldGenerateCode);
    }

    @JvmStatic
    @NotNull
    public static final AnalysisResult internalError(@NotNull BindingContext bindingContext, @NotNull Throwable error) {
        return Companion.internalError(bindingContext, error);
    }

    @JvmStatic
    @NotNull
    public static final AnalysisResult compilationError(@NotNull BindingContext bindingContext) {
        return Companion.compilationError(bindingContext);
    }

    static {
        BindingContext bindingContext = BindingContext.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"EMPTY");
        EMPTY = Companion.success(bindingContext, ErrorUtils.INSTANCE.getErrorModule());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "getEMPTY", "()Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "success", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "shouldGenerateCode", "", "internalError", "error", "", "compilationError", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnalysisResult getEMPTY() {
            return EMPTY;
        }

        @JvmStatic
        @NotNull
        public final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            return new AnalysisResult(bindingContext, module2, true);
        }

        @JvmStatic
        @NotNull
        public final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2, boolean shouldGenerateCode) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            return new AnalysisResult(bindingContext, module2, shouldGenerateCode);
        }

        @JvmStatic
        @NotNull
        public final AnalysisResult internalError(@NotNull BindingContext bindingContext, @NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new InternalError(bindingContext, error);
        }

        @JvmStatic
        @NotNull
        public final AnalysisResult compilationError(@NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return new CompilationError(bindingContext);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult$CompilationError;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "frontend"})
    private static final class CompilationError
    extends AnalysisResult {
        public CompilationError(@NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            super(bindingContext, ErrorUtils.INSTANCE.getErrorModule(), false, 4, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult$InternalError;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "exception", "", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "frontend"})
    private static final class InternalError
    extends AnalysisResult {
        @NotNull
        private final Throwable exception;

        public InternalError(@NotNull BindingContext bindingContext, @NotNull Throwable exception) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            super(bindingContext, ErrorUtils.INSTANCE.getErrorModule(), false, 4, null);
            this.exception = exception;
        }

        @NotNull
        public final Throwable getException() {
            return this.exception;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult$RetryWithAdditionalRoots;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "additionalJavaRoots", "", "Ljava/io/File;", "additionalKotlinRoots", "additionalClassPathRoots", "addToEnvironment", "", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;Ljava/util/List;Ljava/util/List;Z)V", "getAdditionalJavaRoots", "()Ljava/util/List;", "getAdditionalKotlinRoots", "getAdditionalClassPathRoots", "getAddToEnvironment", "()Z", "frontend"})
    public static final class RetryWithAdditionalRoots
    extends AnalysisResult {
        @NotNull
        private final List<File> additionalJavaRoots;
        @NotNull
        private final List<File> additionalKotlinRoots;
        @NotNull
        private final List<File> additionalClassPathRoots;
        private final boolean addToEnvironment;

        public RetryWithAdditionalRoots(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends File> additionalJavaRoots, @NotNull List<? extends File> additionalKotlinRoots, @NotNull List<? extends File> additionalClassPathRoots, boolean addToEnvironment) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter(additionalJavaRoots, (String)"additionalJavaRoots");
            Intrinsics.checkNotNullParameter(additionalKotlinRoots, (String)"additionalKotlinRoots");
            Intrinsics.checkNotNullParameter(additionalClassPathRoots, (String)"additionalClassPathRoots");
            super(bindingContext, moduleDescriptor, false, 4, null);
            this.additionalJavaRoots = additionalJavaRoots;
            this.additionalKotlinRoots = additionalKotlinRoots;
            this.additionalClassPathRoots = additionalClassPathRoots;
            this.addToEnvironment = addToEnvironment;
        }

        public /* synthetic */ RetryWithAdditionalRoots(BindingContext bindingContext, ModuleDescriptor moduleDescriptor, List list, List list2, List list3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            if ((n & 0x20) != 0) {
                bl = true;
            }
            this(bindingContext, moduleDescriptor, list, list2, list3, bl);
        }

        @NotNull
        public final List<File> getAdditionalJavaRoots() {
            return this.additionalJavaRoots;
        }

        @NotNull
        public final List<File> getAdditionalKotlinRoots() {
            return this.additionalKotlinRoots;
        }

        @NotNull
        public final List<File> getAdditionalClassPathRoots() {
            return this.additionalClassPathRoots;
        }

        public final boolean getAddToEnvironment() {
            return this.addToEnvironment;
        }
    }
}

