/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.compile;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.analysis.api.compile.CodeFragmentCapturedValue;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compile.CodeFragmentCapturedId;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compile.CodeFragmentCapturedSymbol;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compile.CodeFragmentScopeProviderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitorVoid;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\fH\u0002J\u0014\u0010&\u001a\u00020\u001d2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001c\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CodeFragmentCapturedValueVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitorVoid;", "resolveSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "selfSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;Ljava/util/Set;)V", "collectedMappings", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CodeFragmentCapturedId;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CodeFragmentCapturedSymbol;", "collectedFiles", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/psi/KtFile;", "assignmentLhs", "", "values", "", "getValues", "()Ljava/util/List;", "files", "getFiles", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "processElement", "processCall", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "register", "mapping", "registerFile", "isCrossingInlineBounds", "", "findCommonParentContextAware", "Lcom/intellij/psi/PsiElement;", "callSite", "declarationSite", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentCapturedValueAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentCapturedValueAnalyzer.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CodeFragmentCapturedValueVisitor\n+ 2 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,301:1\n49#2:302\n82#3:303\n62#3:304\n28#3:305\n*S KotlinDebug\n*F\n+ 1 CodeFragmentCapturedValueAnalyzer.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CodeFragmentCapturedValueVisitor\n*L\n136#1:302\n218#1:303\n253#1:304\n281#1:305\n*E\n"})
final class CodeFragmentCapturedValueVisitor
extends FirDefaultVisitorVoid {
    @NotNull
    private final LLFirResolveSession resolveSession;
    @NotNull
    private final Set<FirBasedSymbol<?>> selfSymbols;
    @NotNull
    private final LinkedHashMap<CodeFragmentCapturedId, CodeFragmentCapturedSymbol> collectedMappings;
    @NotNull
    private final LinkedHashSet<KtFile> collectedFiles;
    @NotNull
    private final List<FirBasedSymbol<?>> assignmentLhs;

    public CodeFragmentCapturedValueVisitor(@NotNull LLFirResolveSession resolveSession, @NotNull Set<? extends FirBasedSymbol<?>> selfSymbols) {
        Intrinsics.checkNotNullParameter((Object)resolveSession, (String)"resolveSession");
        Intrinsics.checkNotNullParameter(selfSymbols, (String)"selfSymbols");
        this.resolveSession = resolveSession;
        this.selfSymbols = selfSymbols;
        this.collectedMappings = new LinkedHashMap();
        this.collectedFiles = new LinkedHashSet();
        this.assignmentLhs = new ArrayList();
    }

    @NotNull
    public final List<CodeFragmentCapturedSymbol> getValues() {
        Collection<CodeFragmentCapturedSymbol> collection = this.collectedMappings.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @NotNull
    public final List<KtFile> getFiles() {
        return CollectionsKt.toList((Iterable)this.collectedFiles);
    }

    private final FirSession getSession() {
        return this.resolveSession.getUseSiteFirSession();
    }

    @Override
    public void visitElement(@NotNull FirElement element2) {
        FirCallableSymbol<?> lhs;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.processElement(element2);
        FirPureAbstractElement firPureAbstractElement = element2 instanceof FirVariableAssignment ? (FirVariableAssignment)element2 : null;
        FirCallableSymbol<?> firCallableSymbol = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getLValue()) != null ? ReferenceUtilsKt.toResolvedCallableSymbol((FirExpression)firPureAbstractElement, this.getSession()) : (lhs = null);
        if (lhs != null) {
            this.assignmentLhs.add(lhs);
        }
        element2.acceptChildren(this);
        if (lhs != null && !Intrinsics.areEqual((Object)CollectionsKt.removeLast(this.assignmentLhs), lhs)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    private final void processElement(FirElement element2) {
        FirCallableSymbol symbol;
        FirElement firElement;
        FirClassifierSymbol<?> symbol2;
        if (element2 instanceof FirExpression && (symbol2 = ToSymbolUtilsKt.toSymbol(FirTypeUtilsKt.getResolvedType((FirExpression)element2), this.getSession())) != null) {
            this.registerFile((FirBasedSymbol)symbol2);
        }
        if ((firElement = element2) instanceof FirSuperReference) {
            FirRegularClassSymbol symbol3;
            FirTypeRef firTypeRef = ((FirSuperReference)element2).getSuperTypeRef();
            FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            FirRegularClassSymbol firRegularClassSymbol = symbol3 = firResolvedTypeRef != null ? FirHelpersKt.toRegularClassSymbol(firResolvedTypeRef, this.getSession()) : null;
            if (symbol3 != null && !this.selfSymbols.contains(symbol3)) {
                boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element2, symbol3);
                CodeFragmentCapturedValue.SuperClass capturedValue = new CodeFragmentCapturedValue.SuperClass(symbol3.getClassId(), isCrossingInlineBounds);
                this.register(new CodeFragmentCapturedSymbol(capturedValue, symbol3, ((FirSuperReference)element2).getSuperTypeRef()));
            }
        } else if (firElement instanceof FirThisReference) {
            int contextReceiverNumber = ((FirThisReference)element2).getContextReceiverNumber();
            FirBasedSymbol<?> symbol4 = ((FirThisReference)element2).getBoundSymbol();
            if (symbol4 != null && !this.selfSymbols.contains(symbol4)) {
                FirBasedSymbol<?> firBasedSymbol = symbol4;
                if (firBasedSymbol instanceof FirClassSymbol) {
                    if (((FirClassSymbol)symbol4).getClassKind() != ClassKind.OBJECT) {
                        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
                        boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element2, symbol4);
                        CodeFragmentCapturedValue.ContainingClass capturedValue = new CodeFragmentCapturedValue.ContainingClass(((FirClassSymbol)symbol4).getClassId(), isCrossingInlineBounds);
                        boolean $i$f$buildResolvedTypeRef = false;
                        FirResolvedTypeRefBuilder $this$processElement_u24lambda_u240 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                        boolean bl = false;
                        $this$processElement_u24lambda_u240.setConeType(ScopeUtilsKt.defaultType((FirClassSymbol)symbol4));
                        FirResolvedTypeRef typeRef = firResolvedTypeRefBuilder.build();
                        this.register(new CodeFragmentCapturedSymbol(capturedValue, symbol4, typeRef));
                    }
                } else if (firBasedSymbol instanceof FirFunctionSymbol || firBasedSymbol instanceof FirPropertySymbol) {
                    if (!(symbol4 instanceof FirCallableSymbol)) {
                        String capturedValue = "Failed requirement.";
                        throw new IllegalArgumentException(capturedValue.toString());
                    }
                    if (contextReceiverNumber >= 0) {
                        FirContextReceiver contextReceiver = ((FirCallableSymbol)symbol4).getResolvedContextReceivers().get(contextReceiverNumber);
                        Name labelName = UtilsKt.getLabelName(contextReceiver);
                        if (labelName != null) {
                            boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element2, symbol4);
                            CodeFragmentCapturedValue.ContextReceiver capturedValue = new CodeFragmentCapturedValue.ContextReceiver(contextReceiverNumber, labelName, isCrossingInlineBounds);
                            this.register(new CodeFragmentCapturedSymbol(capturedValue, contextReceiver.getSymbol(), contextReceiver.getTypeRef()));
                        }
                    } else {
                        FirBasedSymbol<?> firBasedSymbol2;
                        Object object;
                        String string2 = ((FirThisReference)element2).getLabelName();
                        if (string2 == null && ((object = (firBasedSymbol2 = symbol4) instanceof FirAnonymousFunctionSymbol ? (FirAnonymousFunctionSymbol)firBasedSymbol2 : null) != null && (object = ((FirAnonymousFunctionSymbol)object).getLabel()) != null ? ((FirLabel)object).getName() : (string2 = null)) == null) {
                            String string3 = ((FirCallableSymbol)symbol4).getName().asString();
                            string2 = string3;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                        }
                        String labelName = string2;
                        FirReceiverParameter firReceiverParameter = ((FirCallableSymbol)symbol4).getReceiverParameter();
                        if (firReceiverParameter == null) {
                            throw new IllegalStateException("Receiver parameter not found".toString());
                        }
                        FirReceiverParameter receiverParameter = firReceiverParameter;
                        FirTypeRef typeRef = receiverParameter.getTypeRef();
                        boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element2, symbol4);
                        CodeFragmentCapturedValue.ExtensionReceiver capturedValue = new CodeFragmentCapturedValue.ExtensionReceiver(labelName, isCrossingInlineBounds);
                        this.register(new CodeFragmentCapturedSymbol(capturedValue, receiverParameter.getSymbol(), typeRef));
                    }
                }
            }
        } else if (firElement instanceof FirResolvable && (symbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirResolvable)element2).getCalleeReference(), false, 1, null)) != null && !this.selfSymbols.contains(symbol)) {
            this.processCall(element2, symbol);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void processCall(FirElement element, FirCallableSymbol<?> symbol) {
        if (Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(this.assignmentLhs), symbol)) ** GOTO lbl-1000
        v0 = element.getSource();
        if ((v0 != null ? v0.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        isMutated = v1;
        var4_4 = symbol;
        if (var4_4 instanceof FirValueParameterSymbol) {
            isCrossingInlineBounds = this.isCrossingInlineBounds(element, (FirBasedSymbol)symbol);
            capturedValue = new CodeFragmentCapturedValue.Local(((FirValueParameterSymbol)symbol).getName(), isMutated, isCrossingInlineBounds);
            this.register(new CodeFragmentCapturedSymbol(capturedValue, (FirBasedSymbol)symbol, ((FirValueParameterSymbol)symbol).getResolvedReturnTypeRef()));
        } else if (var4_4 instanceof FirPropertySymbol) {
            if (((FirPropertySymbol)symbol).isLocal()) {
                isCrossingInlineBounds = this.isCrossingInlineBounds(element, (FirBasedSymbol)symbol);
                capturedValue = CodeFragmentScopeProviderKt.isForeignValue((FirPropertySymbol)symbol) != false ? (CodeFragmentCapturedValue)new CodeFragmentCapturedValue.ForeignValue(((FirPropertySymbol)symbol).getName(), isCrossingInlineBounds) : (((FirPropertySymbol)symbol).getHasDelegate() != false ? (CodeFragmentCapturedValue)new CodeFragmentCapturedValue.LocalDelegate(((FirPropertySymbol)symbol).getName(), isMutated, isCrossingInlineBounds) : (CodeFragmentCapturedValue)new CodeFragmentCapturedValue.Local(((FirPropertySymbol)symbol).getName(), isMutated, isCrossingInlineBounds));
                this.register(new CodeFragmentCapturedSymbol(capturedValue, (FirBasedSymbol)symbol, ((FirPropertySymbol)symbol).getResolvedReturnTypeRef()));
            } else {
                FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)symbol, FirResolvePhase.BODY_RESOLVE);
            }
        } else if (var4_4 instanceof FirBackingFieldSymbol) {
            propertyName = ((FirBackingFieldSymbol)symbol).getPropertySymbol().getName();
            isCrossingInlineBounds = this.isCrossingInlineBounds(element, (FirBasedSymbol)symbol);
            capturedValue = new CodeFragmentCapturedValue.BackingField(propertyName, isMutated, isCrossingInlineBounds);
            this.register(new CodeFragmentCapturedSymbol(capturedValue, (FirBasedSymbol)symbol, ((FirBackingFieldSymbol)symbol).getResolvedReturnTypeRef()));
        } else if (var4_4 instanceof FirNamedFunctionSymbol) {
            $this$isLocal$iv = (FirNamedFunctionSymbol)symbol;
            $i$f$isLocal = false;
            if (Intrinsics.areEqual((Object)$this$isLocal$iv.getRawStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) {
                this.registerFile((FirBasedSymbol)symbol);
            }
        }
        if (Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)StandardClassIds.Callables.INSTANCE.getCoroutineContext())) {
            isCrossingInlineBounds = this.isCrossingInlineBounds(element, (FirBasedSymbol)symbol);
            capturedValue = new CodeFragmentCapturedValue.CoroutineContext(isCrossingInlineBounds);
            this.register(new CodeFragmentCapturedSymbol(capturedValue, (FirBasedSymbol)symbol, symbol.getResolvedReturnTypeRef()));
        }
    }

    private final void register(CodeFragmentCapturedSymbol mapping) {
        CodeFragmentCapturedId id = new CodeFragmentCapturedId(mapping.getSymbol());
        CodeFragmentCapturedSymbol previousMapping = this.collectedMappings.get(id);
        if (previousMapping != null) {
            CodeFragmentCapturedValue previousValue = previousMapping.getValue();
            CodeFragmentCapturedValue newValue = mapping.getValue();
            if (!Intrinsics.areEqual(previousValue.getClass(), newValue.getClass())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (previousValue.isMutated() || !newValue.isMutated()) {
                return;
            }
        }
        ((Map)this.collectedMappings).put(id, mapping);
        this.registerFile(mapping.getSymbol());
    }

    private final void registerFile(FirBasedSymbol<?> symbol) {
        boolean needsRegistration;
        boolean bl;
        FirBasedSymbol<?> firBasedSymbol = symbol;
        if (firBasedSymbol instanceof FirRegularClassSymbol) {
            FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)symbol;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getClassId().isLocal();
        } else {
            bl = firBasedSymbol instanceof FirAnonymousObjectSymbol ? true : (needsRegistration = firBasedSymbol instanceof FirNamedFunctionSymbol ? ((FirNamedFunctionSymbol)symbol).getCallableId().isLocal() : false);
        }
        if (!needsRegistration) {
            return;
        }
        KtFile ktFile = org.jetbrains.kotlin.analysis.low.level.api.fir.util.UtilsKt.getContainingKtFileIfAny(symbol.getFir());
        if (ktFile == null) {
            return;
        }
        KtFile file2 = ktFile;
        if (!file2.isCompiled()) {
            this.collectedFiles.add(file2);
        }
    }

    private final boolean isCrossingInlineBounds(FirElement element2, FirBasedSymbol<?> symbol) {
        PsiElement elementInBetween;
        Object object = element2.getSource();
        if (object == null || (object = KtSourceElementKt.getPsi((AbstractKtSourceElement)object)) == null) {
            return false;
        }
        Object callSite = object;
        Object object2 = ((FirDeclaration)symbol.getFir()).getSource();
        if (object2 == null || (object2 = KtSourceElementKt.getPsi((AbstractKtSourceElement)object2)) == null) {
            return false;
        }
        Object declarationSite = object2;
        PsiElement psiElement = this.findCommonParentContextAware((PsiElement)callSite, (PsiElement)declarationSite);
        if (psiElement == null) {
            return false;
        }
        PsiElement commonParent = psiElement;
        Iterator iterator2 = DeclarationUtilsKt.getParentsCodeFragmentAware((PsiElement)callSite).iterator();
        while (iterator2.hasNext() && (elementInBetween = (PsiElement)iterator2.next()) != commonParent) {
            FirBasedSymbol symbolInBetween;
            if (!(elementInBetween instanceof KtFunction) || !((symbolInBetween = LowLevelFirApiFacadeKt.resolveToFirSymbol$default((KtDeclaration)elementInBetween, this.resolveSession, null, 2, null)) instanceof FirCallableSymbol)) continue;
            FirCallableSymbol $this$isInline$iv = (FirCallableSymbol)symbolInBetween;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getRawStatus().isInline()) continue;
            return true;
        }
        return false;
    }

    private final PsiElement findCommonParentContextAware(PsiElement callSite, PsiElement declarationSite) {
        PsiElement directParent = PsiTreeUtil.findCommonParent(callSite, declarationSite);
        if (directParent != null) {
            return directParent;
        }
        PsiFile psiFile = callSite.getContainingFile();
        KtCodeFragment ktCodeFragment = psiFile instanceof KtCodeFragment ? (KtCodeFragment)psiFile : null;
        if (ktCodeFragment == null) {
            return null;
        }
        KtCodeFragment codeFragment = ktCodeFragment;
        PsiElement psiElement = codeFragment.getContext();
        if (psiElement == null) {
            return null;
        }
        PsiElement codeFragmentContext = psiElement;
        return PsiTreeUtil.findCommonParent(codeFragmentContext, declarationSite);
    }
}

