/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.NativeStandardInteropNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCActionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCActionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCActionChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCActionChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n34#2:71\n1869#3,2:72\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCActionChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCActionChecker\n*L\n65#1:71\n45#1:72,2\n*E\n"})
public final class FirNativeObjCActionChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCActionChecker INSTANCE = new FirNativeObjCActionChecker();

    private FirNativeObjCActionChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSession session = context2.getSession();
        FirMemberDeclaration $this$isExpect$iv = declaration2;
        boolean $i$f$isExpect = false;
        if (!$this$isExpect$iv.getStatus().isExpect() && FirObjCInteropKt.isKotlinObjCClass(declaration2.getSymbol(), context2.getSession())) {
            FirNativeObjCActionChecker.check$checkKotlinObjCClass(context2, session, reporter, declaration2);
        }
    }

    private static final void check$checkCanGenerateFunctionImp(DiagnosticReporter $reporter, CheckerContext $context, FirNamedFunctionSymbol function2) {
        if (function2.getValueParameterSymbols().size() > 2) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)function2.getSource(), FirNativeErrors.INSTANCE.getTWO_OR_LESS_PARAMETERS_ARE_SUPPORTED_HERE(), (DiagnosticContext)$context, null, 8, null);
        }
    }

    private static final void check$checkCanGenerateActionImp(DiagnosticReporter $reporter, CheckerContext $context, FirSession session, FirNamedFunctionSymbol function2) {
        String action = '@' + NativeStandardInteropNames.INSTANCE.getObjCActionClassId().asFqNameString();
        FirReceiverParameterSymbol firReceiverParameterSymbol = function2.getReceiverParameterSymbol();
        if (firReceiverParameterSymbol != null) {
            FirReceiverParameterSymbol it = firReceiverParameterSymbol;
            boolean bl2 = false;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getMUST_NOT_HAVE_EXTENSION_RECEIVER(), (Object)(action + " method"), (DiagnosticContext)$context, null, 16, null);
        }
        Iterable $this$forEach$iv = function2.getValueParameterSymbols();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
            boolean bl3 = false;
            FirResolvedTypeRef kotlinType = it.getResolvedReturnTypeRef();
            if (FirObjCInteropKt.isObjCObjectType(kotlinType, session)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getMUST_BE_OBJC_OBJECT_TYPE(), (Object)(action + " method parameter type"), (Object)kotlinType.getConeType(), (DiagnosticContext)$context, null, 32, null);
        }
        FirResolvedTypeRef returnType2 = function2.getResolvedReturnTypeRef();
        if (!FirTypeUtilsKt.isUnit(returnType2)) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)function2.getSource(), FirNativeErrors.INSTANCE.getMUST_BE_UNIT_TYPE(), (Object)(action + " method return type"), (Object)returnType2.getConeType(), (DiagnosticContext)$context, null, 32, null);
        }
        FirNativeObjCActionChecker.check$checkCanGenerateFunctionImp($reporter, $context, function2);
    }

    private static final Unit check$checkKotlinObjCClass$lambda$2(FirSession $session, DiagnosticReporter $reporter, CheckerContext $context, FirCallableSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (symbol instanceof FirNamedFunctionSymbol && FirAnnotationUtilsKt.hasAnnotation(symbol, NativeStandardInteropNames.INSTANCE.getObjCActionClassId(), $session)) {
            FirNativeObjCActionChecker.check$checkCanGenerateActionImp($reporter, $context, $session, (FirNamedFunctionSymbol)symbol);
        }
        return Unit.INSTANCE;
    }

    private static final void check$checkKotlinObjCClass(CheckerContext $context, FirSession session, DiagnosticReporter $reporter, FirClass firClass) {
        DeclarationUtilsKt.processAllDeclaredCallables$default(firClass.getSymbol(), $context.getSession(), null, arg_0 -> FirNativeObjCActionChecker.check$checkKotlinObjCClass$lambda$2(session, $reporter, $context, arg_0), 2, null);
    }
}

