/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\r\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/plugins/ExpiredPluginsState;", "Lcom/intellij/ide/plugins/PluginEnabler;", "()V", "disable", "", "descriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "disableById", "pluginIds", "", "Lcom/intellij/openapi/extensions/PluginId;", "enable", "enableById", "isDisabled", "pluginId", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class ExpiredPluginsState
implements PluginEnabler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String EXPIRED_PLUGINS_FILENAME = "expired_plugins.txt";
    @Nullable
    private static Set<PluginId> expiredPluginIds_;

    public ExpiredPluginsState() {
        ExpiredPluginsState.Companion.getLogger().info(IdeaPluginDescriptorImplKt.joinedPluginIds((Iterable<PluginId>)Companion.getExpiredPluginIds(), "skip"));
    }

    @Override
    public boolean isDisabled(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return Companion.isExpired(pluginId);
    }

    @Override
    public boolean enableById(@NotNull Set<PluginId> pluginIds) {
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        return Companion.setExpiredState(pluginIds, true);
    }

    @Override
    public boolean disableById(@NotNull Set<PluginId> pluginIds) {
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        return Companion.setExpiredState(pluginIds, false);
    }

    @Override
    public boolean enable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        return this.enableById(IdeaPluginDescriptorImplKt.toPluginIdSet((Iterable<? extends IdeaPluginDescriptor>)descriptors));
    }

    @Override
    public boolean disable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        return this.disableById(IdeaPluginDescriptorImplKt.toPluginIdSet((Iterable<? extends IdeaPluginDescriptor>)descriptors));
    }

    @JvmStatic
    @NotNull
    public static final ExpiredPluginsState getInstance() {
        return Companion.getInstance();
    }

    @NotNull
    public static final Set<PluginId> getExpiredPluginIds() {
        return Companion.getExpiredPluginIds();
    }

    @JvmStatic
    public static final boolean isExpired(@NotNull PluginId pluginId) {
        return Companion.isExpired(pluginId);
    }

    @JvmStatic
    public static final boolean setExpiredState(@NotNull Set<PluginId> pluginIds, boolean expired) {
        return Companion.setExpiredState(pluginIds, expired);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0007J\u001e\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001e\u001a\u00020\u001aH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/plugins/ExpiredPluginsState$Companion;", "", "()V", "EXPIRED_PLUGINS_FILENAME", "", "Lorg/jetbrains/annotations/NonNls;", "defaultFilePath", "Ljava/nio/file/Path;", "getDefaultFilePath", "()Ljava/nio/file/Path;", "expiredPluginIds", "", "Lcom/intellij/openapi/extensions/PluginId;", "getExpiredPluginIds$annotations", "getExpiredPluginIds", "()Ljava/util/Set;", "expiredPluginIds_", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/ide/plugins/ExpiredPluginsState;", "isExpired", "", "pluginId", "setExpiredState", "pluginIds", "expired", "intellij.platform.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getDefaultFilePath() {
            Path path = PathManager.getConfigDir().resolve(ExpiredPluginsState.EXPIRED_PLUGINS_FILENAME);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private final Logger getLogger() {
            Logger logger2 = Logger.getInstance(ExpiredPluginsState.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            return logger2;
        }

        @JvmStatic
        @NotNull
        public final ExpiredPluginsState getInstance() {
            ExpiredPluginsState expiredPluginsState = ApplicationManager.getApplication().getService(ExpiredPluginsState.class);
            Intrinsics.checkNotNullExpressionValue((Object)expiredPluginsState, (String)"getService(...)");
            return expiredPluginsState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Set<PluginId> getExpiredPluginIds() {
            Set set = expiredPluginIds_;
            if (set != null) {
                Set it = set;
                boolean bl2 = false;
                return it;
            }
            Class<ExpiredPluginsState> clazz = ExpiredPluginsState.class;
            synchronized (clazz) {
                void var3_5;
                boolean bl3 = false;
                Set result2 = expiredPluginIds_;
                if (result2 == null) {
                    result2 = new LinkedHashSet(PluginManagerCoreKt.tryReadPluginIdsFromFile(Companion.getDefaultFilePath(), Companion.getLogger()));
                    expiredPluginIds_ = result2;
                }
                void var4_7 = var3_5;
                return var4_7;
            }
        }

        @JvmStatic
        public static /* synthetic */ void getExpiredPluginIds$annotations() {
        }

        @JvmStatic
        public final boolean isExpired(@NotNull PluginId pluginId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            return this.getExpiredPluginIds().contains(pluginId);
        }

        @JvmStatic
        public final boolean setExpiredState(@NotNull Set<PluginId> pluginIds, boolean expired) {
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            this.getLogger().info(IdeaPluginDescriptorImplKt.joinedPluginIds((Iterable<PluginId>)pluginIds, "expire"));
            Set<PluginId> set = this.getExpiredPluginIds();
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<com.intellij.openapi.extensions.PluginId>");
            Set expiredPluginIds = TypeIntrinsics.asMutableSet(set);
            return (expired ? expiredPluginIds.addAll((Collection)pluginIds) : expiredPluginIds.removeAll((Collection)pluginIds)) && PluginManagerCore.tryWritePluginIdsToFile$default(PluginManagerCore.INSTANCE, this.getDefaultFilePath(), expiredPluginIds, this.getLogger(), null, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

