/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiCapturedWildcardType
extends PsiType.Stub {
    @NotNull
    private final PsiWildcardType myExistential;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private final PsiTypeParameter myParameter;
    private PsiType myUpperBound;
    private static final RecursionGuard<Object> guard = RecursionManager.createGuard("captureGuard");

    @NotNull
    public static PsiCapturedWildcardType create(@NotNull PsiWildcardType existential, @NotNull PsiElement context2) {
        if (existential == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(1);
        }
        return PsiCapturedWildcardType.create(existential, context2, null);
    }

    @NotNull
    public static PsiCapturedWildcardType create(@NotNull PsiWildcardType existential, @NotNull PsiElement context2, @Nullable PsiTypeParameter parameter2) {
        if (existential == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(3);
        }
        return new PsiCapturedWildcardType(existential, context2, parameter2);
    }

    private PsiCapturedWildcardType(@NotNull PsiWildcardType existential, @NotNull PsiElement context2, @Nullable PsiTypeParameter parameter2) {
        if (existential == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(5);
        }
        super(TypeAnnotationProvider.EMPTY);
        this.myExistential = existential;
        this.myContext = context2;
        this.myParameter = parameter2;
        this.myUpperBound = PsiType.getJavaLangObject(this.myContext.getManager(), this.getResolveScope());
    }

    public static boolean isCapture() {
        return guard.currentStack().isEmpty();
    }

    @Nullable
    public static PsiType captureUpperBound(@NotNull PsiTypeParameter typeParameter, @NotNull PsiWildcardType wildcardType, @NotNull PsiSubstitutor captureSubstitutor) {
        PsiType originalBound;
        if (typeParameter == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(6);
        }
        if (wildcardType == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(7);
        }
        if (captureSubstitutor == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(8);
        }
        PsiClassType[] boundTypes = typeParameter.getExtendsListTypes();
        PsiType glb = originalBound = !wildcardType.isSuper() ? wildcardType.getBound() : null;
        for (PsiClassType boundType : boundTypes) {
            PsiType capturedWildcard;
            PsiType substitutedBoundType = captureSubstitutor.substitute(boundType);
            if (originalBound instanceof PsiArrayType && substitutedBoundType instanceof PsiArrayType && !originalBound.isAssignableFrom(substitutedBoundType) && !substitutedBoundType.isAssignableFrom(originalBound)) continue;
            if (substitutedBoundType instanceof PsiCapturedWildcardType && (capturedWildcard = captureSubstitutor.substitute(typeParameter)) instanceof PsiCapturedWildcardType) {
                PsiType captureUpperBound = substitutedBoundType;
                while (captureUpperBound instanceof PsiCapturedWildcardType) {
                    if (captureUpperBound == capturedWildcard) {
                        return null;
                    }
                    captureUpperBound = ((PsiCapturedWildcardType)captureUpperBound).getUpperBound();
                }
            }
            glb = glb == null ? substitutedBoundType : PsiCapturedWildcardType.getGreatestLowerBound(glb, substitutedBoundType, wildcardType);
        }
        return glb;
    }

    private static PsiType getGreatestLowerBound(PsiType glb, PsiType bound, PsiWildcardType guardObject) {
        return guard.doPreventingRecursion(guardObject, true, () -> GenericsUtil.getGreatestLowerBound(glb, bound));
    }

    public boolean equals(Object o2) {
        Boolean sameUpperBounds;
        if (!(o2 instanceof PsiCapturedWildcardType)) {
            return false;
        }
        PsiCapturedWildcardType captured = (PsiCapturedWildcardType)o2;
        PsiManager manager = this.myContext.getManager();
        if (!manager.areElementsEquivalent(this.myContext, captured.myContext)) {
            return false;
        }
        if ((this.myExistential.isSuper() || captured.myExistential.isSuper()) && !this.myExistential.equals(captured.myExistential)) {
            return false;
        }
        if (!(this.myContext instanceof PsiTypeParameter) && !manager.areElementsEquivalent(this.myParameter, captured.myParameter)) {
            return false;
        }
        if (this.myParameter != null && ((sameUpperBounds = guard.doPreventingRecursion(this.myContext, true, () -> Comparing.equal(this.myUpperBound, captured.myUpperBound))) == null || sameUpperBounds.booleanValue())) {
            return true;
        }
        return this.myExistential.equals(captured.myExistential);
    }

    public int hashCode() {
        return this.myUpperBound.hashCode() + 31 * this.myContext.hashCode();
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string2 = "capture of " + this.myExistential.getPresentableText(annotated);
        if (string2 == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string2 = this.myExistential.getCanonicalText(annotated);
        if (string2 == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string2 = "capture<" + this.myExistential.getInternalCanonicalText() + '>';
        if (string2 == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Override
    public boolean isValid() {
        return this.myExistential.isValid() && this.myContext.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(13);
        }
        return visitor2.visitCapturedWildcardType(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myExistential.getResolveScope();
        if (globalSearchScope == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType[] psiTypeArray = this.myExistential.getSuperTypes();
        if (psiTypeArray == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(15);
        }
        return psiTypeArray;
    }

    public PsiType getLowerBound() {
        return this.myExistential.isSuper() ? this.myExistential.getBound() : (PsiPrimitiveType)PsiTypes.nullType();
    }

    @NotNull
    public PsiType getUpperBound() {
        PsiType psiType = this.getUpperBound(true);
        if (psiType == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(16);
        }
        return psiType;
    }

    @NotNull
    public PsiType getUpperBound(boolean capture) {
        PsiType bound = this.myExistential.getBound();
        if (this.myExistential.isExtends() && this.myParameter == null) {
            assert (bound != null) : this.myExistential.getCanonicalText();
            PsiType psiType = bound;
            if (psiType == null) {
                PsiCapturedWildcardType.$$$reportNull$$$0(17);
            }
            return psiType;
        }
        PsiType psiType = PsiCapturedWildcardType.isCapture() && capture ? PsiUtil.captureToplevelWildcards(this.myUpperBound, this.myContext) : this.myUpperBound;
        if (psiType == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(18);
        }
        return psiType;
    }

    public void setUpperBound(@NotNull PsiType upperBound) {
        if (upperBound == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(19);
        }
        this.myUpperBound = upperBound;
    }

    @NotNull
    public PsiWildcardType getWildcard() {
        PsiWildcardType psiWildcardType = this.myExistential;
        if (psiWildcardType == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(20);
        }
        return psiWildcardType;
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            PsiCapturedWildcardType.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    public PsiTypeParameter getTypeParameter() {
        return this.myParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existential";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wildcardType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureSubstitutor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiCapturedWildcardType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBound";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiCapturedWildcardType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpperBound";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getWildcard";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "captureUpperBound";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setUpperBound";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

