/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoHandler;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/ReversedHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoHandler;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "visitor", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;)V", "progressionClassesTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "matchIterable", "", "expression", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "data", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nReversedHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReversedHandler.kt\norg/jetbrains/kotlin/backend/common/lower/loops/handlers/ReversedHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1557#2:35\n1628#2,3:36\n*S KotlinDebug\n*F\n+ 1 ReversedHandler.kt\norg/jetbrains/kotlin/backend/common/lower/loops/handlers/ReversedHandler\n*L\n20#1:35\n20#1:36,3\n*E\n"})
public final class ReversedHandler
implements HeaderInfoHandler {
    @NotNull
    private final HeaderInfoBuilder visitor;
    @NotNull
    private final Set<IrType> progressionClassesTypes;

    /*
     * WARNING - void declaration
     */
    public ReversedHandler(@NotNull CommonBackendContext context2, @NotNull HeaderInfoBuilder visitor2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        this.visitor = visitor2;
        Iterable iterable = context2.getIr().getSymbols().getProgressionClasses();
        ReversedHandler reversedHandler = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrClassSymbol irClassSymbol = (IrClassSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IrTypesKt.getDefaultType((IrClassifierSymbol)it));
        }
        reversedHandler.progressionClassesTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchIterable(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!callee.getValueParameters().isEmpty()) return false;
        IrValueParameter irValueParameter = callee.getExtensionReceiverParameter();
        if (!CollectionsKt.contains((Iterable)this.progressionClassesTypes, (Object)(irValueParameter != null ? irValueParameter.getType() : null))) return false;
        if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getKotlinFqName(callee), (Object)new FqName("kotlin.ranges.reversed"))) return false;
        return true;
    }

    @Nullable
    public HeaderInfo build(@NotNull IrCall expression2, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        IrExpression irExpression = expression2.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        HeaderInfo headerInfo = (HeaderInfo)irExpression.accept(this.visitor, null);
        return headerInfo != null ? headerInfo.asReversed() : null;
    }
}

