/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.sessions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinResolutionScopeProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.DependenciesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;

@KaImplementationDetail
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0011\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0004R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaGlobalSearchScope;", "Lcom/intellij/psi/search/GlobalSearchScope;", "shadowedScope", "useSiteModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "<init>", "(Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)V", "getShadowedScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "baseScope", "getBaseScope", "getProject", "Lcom/intellij/openapi/project/Project;", "isSearchInModuleContent", "", "aModule", "Lcom/intellij/openapi/module/Module;", "isSearchInLibraries", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "toString", "", "isFromGeneratedModule", "analysis-api-impl-base"})
public final class KaGlobalSearchScope
extends GlobalSearchScope {
    @NotNull
    private final GlobalSearchScope shadowedScope;
    @NotNull
    private final KaModule useSiteModule;
    @NotNull
    private final GlobalSearchScope baseScope;

    public KaGlobalSearchScope(@NotNull GlobalSearchScope shadowedScope, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)shadowedScope, (String)"shadowedScope");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        this.shadowedScope = shadowedScope;
        this.useSiteModule = useSiteModule;
        this.baseScope = KotlinResolutionScopeProvider.Companion.getInstance(this.useSiteModule.getProject()).getResolutionScope(this.useSiteModule);
    }

    @NotNull
    public final GlobalSearchScope getShadowedScope() {
        return this.shadowedScope;
    }

    @NotNull
    public final GlobalSearchScope getBaseScope() {
        return this.baseScope;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.baseScope.getProject();
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
        return this.baseScope.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.baseScope.isSearchInLibraries();
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.baseScope.contains(file2) && !this.shadowedScope.contains(file2) || this.isFromGeneratedModule(file2, this.useSiteModule);
    }

    @NotNull
    public String toString() {
        return "Analysis scope for " + this.useSiteModule + " (base: " + this.baseScope + ", shadowed: " + this.shadowedScope + ')';
    }

    public final boolean isFromGeneratedModule(@NotNull VirtualFile file2, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        KaModule kaModule = ContextModuleKt.getAnalysisContextModule(file2);
        if (kaModule == null) {
            return false;
        }
        KaModule analysisContextModule = kaModule;
        if (Intrinsics.areEqual((Object)analysisContextModule, (Object)useSiteModule)) {
            return true;
        }
        return SequencesKt.contains(DependenciesKt.allDirectDependencies(useSiteModule), (Object)analysisContextModule);
    }
}

