/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsReferenceParameterListImpl
extends ClsElementImpl
implements PsiReferenceParameterList {
    @NonNls
    private static final Pattern EXTENDS_PREFIX = Pattern.compile("^(\\?\\s*extends\\s*)(.*)");
    @NonNls
    private static final Pattern SUPER_PREFIX = Pattern.compile("^(\\?\\s*super\\s*)(.*)");
    @NotNull
    private final PsiElement myParent;
    private final ClsTypeElementImpl[] myTypeParameters;
    private volatile PsiType[] myTypeParametersCachedTypes;

    ClsReferenceParameterListImpl(@NotNull PsiElement parent2, @NotNull @NotNull String @NotNull [] classParameters, @NotNull TypeAnnotationContainer annotations2) {
        if (parent2 == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(0);
        }
        if (annotations2 == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(1);
        }
        if (classParameters == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(2);
        }
        this.myParent = parent2;
        int length = classParameters.length;
        this.myTypeParameters = new ClsTypeElementImpl[length];
        for (int i = 0; i < length; ++i) {
            String s = classParameters[length - i - 1];
            char variance2 = '\u0000';
            Matcher extendsMatcher = EXTENDS_PREFIX.matcher(s);
            if (extendsMatcher.find()) {
                variance2 = '+';
                s = extendsMatcher.group(2);
            } else {
                Matcher superMatcher = SUPER_PREFIX.matcher(s);
                if (superMatcher.find()) {
                    variance2 = '-';
                    s = superMatcher.group(2);
                } else if (StringUtil.startsWithChar(s, '?')) {
                    variance2 = '*';
                    s = s.substring(1);
                }
            }
            this.myTypeParameters[i] = new ClsTypeElementImpl(this, s, variance2, annotations2.forTypeArgument(length - i - 1));
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(3);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceParameterList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(4);
        }
    }

    @Override
    protected void setMirror(@NotNull TreeElement element2) throws ClsElementImpl.InvalidMirrorException {
        if (element2 == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(5);
        }
    }

    @Override
    public PsiTypeElement @NotNull [] getTypeParameterElements() {
        if (this.myTypeParameters == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(6);
        }
        return this.myTypeParameters;
    }

    @Override
    public PsiType @NotNull [] getTypeArguments() {
        PsiType[] cachedTypes = this.myTypeParametersCachedTypes;
        if (cachedTypes == null) {
            cachedTypes = PsiType.createArray(this.myTypeParameters.length);
            for (int i = 0; i < cachedTypes.length; ++i) {
                cachedTypes[cachedTypes.length - i - 1] = this.myTypeParameters[i].getType();
            }
            this.myTypeParametersCachedTypes = cachedTypes;
        }
        if (cachedTypes == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(7);
        }
        return cachedTypes;
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        if (this.myTypeParameters == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(8);
        }
        return this.myTypeParameters;
    }

    @Override
    @NotNull
    public PsiElement getParent() {
        PsiElement psiElement = this.myParent;
        if (psiElement == null) {
            ClsReferenceParameterListImpl.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

