/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;

@PhaseDescription(name="SharedVariables")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "SharedVariablesTransformer", "ir.backend.common"})
public final class SharedVariablesLowering
implements BodyLoweringPass {
    @NotNull
    private final BackendContext context;

    public SharedVariablesLowering(@NotNull BackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        new SharedVariablesTransformer(irBody, container).lowerSharedVariables();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering$SharedVariablesTransformer;", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "irDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;Lorg/jetbrains/kotlin/ir/expressions/IrBody;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getIrBody", "()Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "getIrDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "sharedVariables", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/collections/HashSet;", "lowerSharedVariables", "", "collectSharedVariables", "rewriteSharedVariables", "ir.backend.common"})
    private final class SharedVariablesTransformer {
        @NotNull
        private final IrBody irBody;
        @NotNull
        private final IrDeclaration irDeclaration;
        @NotNull
        private final HashSet<IrVariable> sharedVariables;

        public SharedVariablesTransformer(@NotNull IrBody irBody, IrDeclaration irDeclaration2) {
            Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
            Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"irDeclaration");
            this.irBody = irBody;
            this.irDeclaration = irDeclaration2;
            this.sharedVariables = new HashSet();
        }

        @NotNull
        public final IrBody getIrBody() {
            return this.irBody;
        }

        @NotNull
        public final IrDeclaration getIrDeclaration() {
            return this.irDeclaration;
        }

        public final void lowerSharedVariables() {
            this.collectSharedVariables();
            if (this.sharedVariables.isEmpty()) {
                return;
            }
            this.rewriteSharedVariables();
        }

        private final void collectSharedVariables() {
            Map skippedFunctionsParents = new LinkedHashMap();
            IrElementVisitor irElementVisitor = new IrElementVisitor<Unit, IrDeclarationParent>((Map<IrFunction, IrDeclarationParent>)skippedFunctionsParents, this){
                private final HashSet<IrVariable> relevantVars;
                private final HashSet<IrVariable> relevantVals;
                final /* synthetic */ Map<IrFunction, IrDeclarationParent> $skippedFunctionsParents;
                final /* synthetic */ SharedVariablesTransformer this$0;
                {
                    this.$skippedFunctionsParents = $skippedFunctionsParents;
                    this.this$0 = $receiver;
                    this.relevantVars = new HashSet<E>();
                    this.relevantVals = new HashSet<E>();
                }

                public final HashSet<IrVariable> getRelevantVars() {
                    return this.relevantVars;
                }

                public final HashSet<IrVariable> getRelevantVals() {
                    return this.relevantVals;
                }

                public void visitElement(IrElement element2, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                    element2.acceptChildren(this, data);
                }

                public void visitCall(IrCall expression2, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                    if (!callee.isInline()) {
                        IrElementVisitor.DefaultImpls.visitCall(this, expression2, data);
                        return;
                    }
                    IrExpression irExpression = expression2.getDispatchReceiver();
                    if (irExpression != null) {
                        irExpression.accept(this, data);
                    }
                    IrExpression irExpression2 = expression2.getExtensionReceiver();
                    if (irExpression2 != null) {
                        irExpression2.accept(this, data);
                    }
                    for (IrValueParameter param : callee.getValueParameters()) {
                        IrExpression arg;
                        if (expression2.getValueArgument(param.getIndex()) == null) continue;
                        if (IrInlineUtilsKt.isInlineParameter$default(param, null, 1, null) && !param.isCrossinline() && arg instanceof IrFunctionExpression) {
                            IrSimpleFunction irSimpleFunction = ((IrFunctionExpression)arg).getFunction();
                            IrDeclarationParent irDeclarationParent = data;
                            Intrinsics.checkNotNull((Object)irDeclarationParent);
                            this.$skippedFunctionsParents.put(irSimpleFunction, irDeclarationParent);
                            ((IrFunctionExpression)arg).getFunction().acceptChildren(this, data);
                            this.$skippedFunctionsParents.remove(((IrFunctionExpression)arg).getFunction());
                            continue;
                        }
                        arg.accept(this, data);
                    }
                }

                public void visitDeclaration(IrDeclarationBase declaration2, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrDeclarationParent irDeclarationParent = declaration2 instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)declaration2) : null;
                    if (irDeclarationParent == null) {
                        irDeclarationParent = data;
                    }
                    IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration2, irDeclarationParent);
                }

                public void visitVariable(IrVariable declaration2, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    declaration2.acceptChildren(this, data);
                    if (declaration2.isVar()) {
                        this.relevantVars.add(declaration2);
                    } else if (declaration2.getInitializer() == null) {
                        this.relevantVals.add(declaration2);
                    }
                }

                public void visitValueAccess(IrValueAccessExpression expression2, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    expression2.acceptChildren(this, data);
                    IrValueDeclaration value2 = expression2.getSymbol().getOwner();
                    if (CollectionsKt.contains((Iterable)this.relevantVars, (Object)value2)) {
                        Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                        if (!Intrinsics.areEqual((Object)this.getRealParent((IrVariable)value2), (Object)data)) {
                            SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).add(value2);
                        }
                    }
                }

                public void visitSetValue(IrSetValue expression2, IrDeclarationParent data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data);
                    IrValueDeclaration variable = expression2.getSymbol().getOwner();
                    if (variable instanceof IrVariable && ((IrVariable)variable).getInitializer() == null && !Intrinsics.areEqual((Object)this.getRealParent((IrVariable)variable), (Object)data) && this.relevantVals.contains(variable)) {
                        SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).add(variable);
                    }
                }

                private final IrDeclarationParent getRealParent(IrVariable variable) {
                    IrDeclarationParent irDeclarationParent = variable.getParent();
                    Map<IrFunction, IrDeclarationParent> map = this.$skippedFunctionsParents;
                    IrDeclarationParent it = irDeclarationParent;
                    boolean bl = false;
                    IrDeclarationParent irDeclarationParent2 = map.get(it);
                    if (irDeclarationParent2 == null) {
                        irDeclarationParent2 = it;
                    }
                    return irDeclarationParent2;
                }

                public void visitValueParameter(IrValueParameter declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration2, data);
                }

                public void visitClass(IrClass declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitClass(this, declaration2, data);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
                }

                public void visitTypeParameter(IrTypeParameter declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration2, data);
                }

                public void visitFunction(IrFunction declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFunction(this, declaration2, data);
                }

                public void visitConstructor(IrConstructor declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitConstructor(this, declaration2, data);
                }

                public void visitEnumEntry(IrEnumEntry declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration2, data);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
                }

                public void visitField(IrField declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitField(this, declaration2, data);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
                }

                public void visitModuleFragment(IrModuleFragment declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration2, data);
                }

                public void visitProperty(IrProperty declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitProperty(this, declaration2, data);
                }

                public void visitScript(IrScript declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitScript(this, declaration2, data);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration2, data);
                }

                public void visitTypeAlias(IrTypeAlias declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration2, data);
                }

                public void visitPackageFragment(IrPackageFragment declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration2, data);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
                }

                public void visitFile(IrFile declaration2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFile(this, declaration2, data);
                }

                public void visitExpression(IrExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data);
                }

                public void visitBody(IrBody body2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBody(this, body2, data);
                }

                public void visitExpressionBody(IrExpressionBody body2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data);
                }

                public void visitBlockBody(IrBlockBody body2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data);
                }

                public void visitDeclarationReference(IrDeclarationReference expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data);
                }

                public void visitConstructorCall(IrConstructorCall expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data);
                }

                public void visitSingletonReference(IrGetSingletonValue expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data);
                }

                public void visitGetObjectValue(IrGetObjectValue expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data);
                }

                public void visitGetEnumValue(IrGetEnumValue expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data);
                }

                public void visitContainerExpression(IrContainerExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data);
                }

                public void visitBlock(IrBlock expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data);
                }

                public void visitComposite(IrComposite expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data);
                }

                public void visitReturnableBlock(IrReturnableBlock expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitReturnableBlock(this, expression2, data);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
                }

                public void visitSyntheticBody(IrSyntheticBody body2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data);
                }

                public void visitBreakContinue(IrBreakContinue jump, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitBreak(IrBreak jump, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitContinue(IrContinue jump, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitCallableReference(IrCallableReference<?> expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data);
                }

                public void visitFunctionReference(IrFunctionReference expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data);
                }

                public void visitPropertyReference(IrPropertyReference expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                }

                public void visitClassReference(IrClassReference expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data);
                }

                public void visitConst(IrConst expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitConst(this, expression2, data);
                }

                public void visitConstantValue(IrConstantValue expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitConstantValue(this, expression2, data);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitConstantPrimitive(this, expression2, data);
                }

                public void visitConstantObject(IrConstantObject expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitConstantObject(this, expression2, data);
                }

                public void visitConstantArray(IrConstantArray expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitConstantArray(this, expression2, data);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                }

                public void visitDynamicExpression(IrDynamicExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                }

                public void visitErrorExpression(IrErrorExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data);
                }

                public void visitGetField(IrGetField expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data);
                }

                public void visitSetField(IrSetField expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data);
                }

                public void visitFunctionExpression(IrFunctionExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data);
                }

                public void visitGetClass(IrGetClass expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                }

                public void visitLoop(IrLoop loop, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitLoop(this, loop, data);
                }

                public void visitWhileLoop(IrWhileLoop loop, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop, data);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop, data);
                }

                public void visitReturn(IrReturn expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data);
                }

                public void visitStringConcatenation(IrStringConcatenation expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                }

                public void visitThrow(IrThrow expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data);
                }

                public void visitTry(IrTry aTry, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitCatch(IrCatch aCatch, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data);
                }

                public void visitGetValue(IrGetValue expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data);
                }

                public void visitVararg(IrVararg expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data);
                }

                public void visitSpreadElement(IrSpreadElement spread, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitWhen(IrWhen expression2, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data);
                }

                public void visitBranch(IrBranch branch, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitElseBranch(IrElseBranch branch, IrDeclarationParent data) {
                    IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
                }
            };
            IrDeclaration irDeclaration2 = this.irDeclaration;
            IrDeclarationParent irDeclarationParent = irDeclaration2 instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)irDeclaration2) : null;
            if (irDeclarationParent == null) {
                irDeclarationParent = this.irDeclaration.getParent();
            }
            this.irBody.accept(irElementVisitor, irDeclarationParent);
        }

        private final void rewriteSharedVariables() {
            HashMap<IrValueSymbol, IrVariableSymbol> transformedSymbols = new HashMap<IrValueSymbol, IrVariableSymbol>();
            IrElementTransformerVoidKt.transformChildrenVoid(this.irBody, new IrElementTransformerVoid(this, SharedVariablesLowering.this, transformedSymbols){
                final /* synthetic */ SharedVariablesTransformer this$0;
                final /* synthetic */ SharedVariablesLowering this$1;
                final /* synthetic */ HashMap<IrValueSymbol, IrVariableSymbol> $transformedSymbols;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$transformedSymbols = $transformedSymbols;
                }

                public IrStatement visitVariable(IrVariable declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
                    if (!SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).contains(declaration2)) {
                        return declaration2;
                    }
                    IrVariable newDeclaration = this.this$1.getContext().getSharedVariablesManager().declareSharedVariable(declaration2);
                    newDeclaration.setParent(declaration2.getParent());
                    ((Map)this.$transformedSymbols).put(declaration2.getSymbol(), newDeclaration.getSymbol());
                    return this.this$1.getContext().getSharedVariablesManager().defineSharedValue(declaration2, newDeclaration);
                }
            });
            IrElementTransformerVoidKt.transformChildrenVoid(this.irBody, new IrElementTransformerVoid(SharedVariablesLowering.this, transformedSymbols, this){
                final /* synthetic */ SharedVariablesLowering this$0;
                final /* synthetic */ HashMap<IrValueSymbol, IrVariableSymbol> $transformedSymbols;
                final /* synthetic */ SharedVariablesTransformer this$1;
                {
                    this.this$0 = $receiver;
                    this.$transformedSymbols = $transformedSymbols;
                    this.this$1 = $receiver2;
                }

                public IrExpression visitGetValue(IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.getContext().getSharedVariablesManager().getSharedValue(newDeclaration, expression2);
                }

                public IrExpression visitSetValue(IrSetValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.getContext().getSharedVariablesManager().setSharedValue(newDeclaration, expression2);
                }

                private final IrVariableSymbol getTransformedSymbol(IrValueSymbol oldSymbol) {
                    Map map = this.$transformedSymbols;
                    SharedVariablesTransformer sharedVariablesTransformer = this.this$1;
                    V v = map.get(oldSymbol);
                    if (v == null) {
                        boolean bl;
                        boolean bl2 = false;
                        boolean bl3 = bl = !CollectionsKt.contains((Iterable)SharedVariablesTransformer.access$getSharedVariables$p(sharedVariablesTransformer), (Object)oldSymbol.getOwner());
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl4 = false;
                            String string2 = "Shared variable is not transformed: " + DumpIrTreeKt.dump$default(oldSymbol.getOwner(), null, 1, null);
                            throw new AssertionError((Object)string2);
                        }
                        v = null;
                    }
                    return (IrVariableSymbol)v;
                }
            });
        }

        public static final /* synthetic */ HashSet access$getSharedVariables$p(SharedVariablesTransformer $this) {
            return $this.sharedVariables;
        }
    }
}

