/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.calls.ContextReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitDispatchReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.util.PersistentSetMultimap;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001BK\b\u0002\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0006\u0012\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rB\t\b\u0016\u00a2\u0006\u0004\b\f\u0010\u000eJ\u0018\u0010\u0012\u001a\u00020\u00002\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00002\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0014J(\u0010\u0017\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00022\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0007JB\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0006*\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\u0012\u0010\u001c\u001a\u00020\u00002\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0016J\u001d\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001fH\u0086\u0002J\b\u0010 \u001a\u0004\u0018\u00010!J \u0010 \u001a\u0004\u0018\u00010!2\u0016\u0010\"\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020$0#J\u0010\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0014J\u0013\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020'H\u0096\u0002J\u001a\u0010(\u001a\u00020)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020$R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "stack", "Lkotlinx/collections/immutable/PersistentList;", "receiversPerLabel", "Lorg/jetbrains/kotlin/fir/util/PersistentSetMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "indexesPerSymbol", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "", "<init>", "(Lkotlinx/collections/immutable/PersistentList;Lorg/jetbrains/kotlin/fir/util/PersistentSetMultimap;Lkotlinx/collections/immutable/PersistentMap;)V", "()V", "size", "getSize", "()I", "addAll", "receivers", "", "addAllContextReceivers", "Lorg/jetbrains/kotlin/fir/resolve/calls/ContextReceiverValue;", "add", "name", "value", "aliasLabel", "putIfNameIsNotNull", "addContextReceiver", "get", "", "", "lastDispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitDispatchReceiverValue;", "lookupCondition", "Lkotlin/Function1;", "", "receiversAsReversed", "iterator", "", "replaceReceiverType", "", "symbol", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "createSnapshot", "keepMutable", "semantics"})
@SourceDebugExtension(value={"SMAP\nImplicitReceiverStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImplicitReceiverStack.kt\norg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1797#2,3:130\n1797#2,3:133\n808#2,11:137\n808#2,11:148\n543#2,6:159\n1557#2:165\n1628#2,3:166\n1#3:136\n*S KotlinDebug\n*F\n+ 1 ImplicitReceiverStack.kt\norg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack\n*L\n35#1:130,3\n39#1:133,3\n78#1:137,11\n82#1:148,11\n82#1:159,6\n101#1:165\n101#1:166,3\n*E\n"})
public final class ImplicitReceiverStack
implements Iterable<ImplicitReceiverValue<?>>,
KMappedMarker {
    @NotNull
    private final PersistentList<ImplicitReceiverValue<?>> stack;
    @NotNull
    private final PersistentSetMultimap<Name, ImplicitReceiverValue<?>> receiversPerLabel;
    @NotNull
    private final PersistentMap<FirBasedSymbol<?>, Integer> indexesPerSymbol;

    private ImplicitReceiverStack(PersistentList<? extends ImplicitReceiverValue<?>> stack, PersistentSetMultimap<Name, ImplicitReceiverValue<?>> receiversPerLabel, PersistentMap<FirBasedSymbol<?>, Integer> indexesPerSymbol) {
        this.stack = stack;
        this.receiversPerLabel = receiversPerLabel;
        this.indexesPerSymbol = indexesPerSymbol;
    }

    public final int getSize() {
        return this.stack.size();
    }

    public ImplicitReceiverStack() {
        this(ExtensionsKt.persistentListOf(), new PersistentSetMultimap(), ExtensionsKt.persistentMapOf());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ImplicitReceiverStack addAll(@NotNull List<? extends ImplicitReceiverValue<?>> receivers) {
        Intrinsics.checkNotNullParameter(receivers, (String)"receivers");
        Iterable $this$fold$iv = receivers;
        boolean $i$f$fold = false;
        ImplicitReceiverStack accumulator$iv = this;
        for (Object element$iv : $this$fold$iv) {
            void value2;
            ImplicitReceiverValue implicitReceiverValue = (ImplicitReceiverValue)element$iv;
            ImplicitReceiverStack acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = ImplicitReceiverStack.add$default(acc, null, (ImplicitReceiverValue)value2, null, 4, null);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ImplicitReceiverStack addAllContextReceivers(@NotNull List<? extends ContextReceiverValue<?>> receivers) {
        Intrinsics.checkNotNullParameter(receivers, (String)"receivers");
        Iterable $this$fold$iv = receivers;
        boolean $i$f$fold = false;
        ImplicitReceiverStack accumulator$iv = this;
        for (Object element$iv : $this$fold$iv) {
            void value2;
            ContextReceiverValue contextReceiverValue = (ContextReceiverValue)element$iv;
            ImplicitReceiverStack acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.addContextReceiver((ContextReceiverValue<?>)value2);
        }
        return accumulator$iv;
    }

    @NotNull
    public final ImplicitReceiverStack add(@Nullable Name name2, @NotNull ImplicitReceiverValue<?> value2, @Nullable Name aliasLabel) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        PersistentList<ImplicitReceiverValue<?>> stack = this.stack.add(value2);
        int index2 = stack.size() - 1;
        PersistentSetMultimap<Name, ImplicitReceiverValue<?>> receiversPerLabel = this.putIfNameIsNotNull(this.putIfNameIsNotNull(this.receiversPerLabel, name2, value2), aliasLabel, value2);
        PersistentMap<FirBasedSymbol<?>, Integer> indexesPerSymbol = this.indexesPerSymbol.put((FirBasedSymbol<?>)value2.getBoundSymbol(), index2);
        return new ImplicitReceiverStack(stack, receiversPerLabel, indexesPerSymbol);
    }

    public static /* synthetic */ ImplicitReceiverStack add$default(ImplicitReceiverStack implicitReceiverStack, Name name2, ImplicitReceiverValue implicitReceiverValue, Name name3, int n, Object object) {
        if ((n & 4) != 0) {
            name3 = null;
        }
        return implicitReceiverStack.add(name2, implicitReceiverValue, name3);
    }

    private final PersistentSetMultimap<Name, ImplicitReceiverValue<?>> putIfNameIsNotNull(PersistentSetMultimap<Name, ImplicitReceiverValue<?>> $this$putIfNameIsNotNull, Name name2, ImplicitReceiverValue<?> value2) {
        return name2 != null ? $this$putIfNameIsNotNull.put(name2, value2) : $this$putIfNameIsNotNull;
    }

    @NotNull
    public final ImplicitReceiverStack addContextReceiver(@NotNull ContextReceiverValue<?> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Name name2 = value2.getLabelName();
        if (name2 == null) {
            return this;
        }
        Name labelName = name2;
        PersistentSetMultimap<Name, ImplicitReceiverValue<?>> receiversPerLabel = this.receiversPerLabel.put(labelName, value2);
        return new ImplicitReceiverStack(this.stack, receiversPerLabel, this.indexesPerSymbol);
    }

    @NotNull
    public final Set<ImplicitReceiverValue<?>> get(@Nullable String name2) {
        if (name2 == null) {
            Set set;
            Set set2;
            ImplicitReceiverValue implicitReceiverValue = (ImplicitReceiverValue)CollectionsKt.lastOrNull((List)this.stack);
            if (implicitReceiverValue != null) {
                ImplicitReceiverValue p0 = implicitReceiverValue;
                boolean bl = false;
                set2 = SetsKt.setOf((Object)p0);
            } else {
                set2 = set = null;
            }
            if (set2 == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }
        Name name3 = Name.identifier(name2);
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        return this.receiversPerLabel.get(name3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ImplicitDispatchReceiverValue lastDispatchReceiver() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.stack;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ImplicitDispatchReceiverValue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (ImplicitDispatchReceiverValue)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ImplicitDispatchReceiverValue lastDispatchReceiver(@NotNull Function1<? super ImplicitReceiverValue<?>, Boolean> lookupCondition) {
        Object v0;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(lookupCondition, (String)"lookupCondition");
            Iterable $this$filterIsInstance$iv = this.stack;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ImplicitDispatchReceiverValue)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List $this$lastOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                if (!((Boolean)lookupCondition.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final List<ImplicitReceiverValue<?>> receiversAsReversed() {
        return CollectionsKt.asReversed((List)this.stack);
    }

    @Override
    @NotNull
    public Iterator<ImplicitReceiverValue<?>> iterator() {
        return this.stack.iterator();
    }

    public final void replaceReceiverType(@NotNull FirBasedSymbol<?> symbol, @NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Integer n = (Integer)this.indexesPerSymbol.get(symbol);
        if (n == null) {
            return;
        }
        int index2 = n;
        ((ImplicitReceiverValue)this.stack.get(index2)).updateTypeFromSmartcast(type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ImplicitReceiverStack createSnapshot(boolean keepMutable) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.stack;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ImplicitReceiverValue implicitReceiverValue = (ImplicitReceiverValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createSnapshot(keepMutable));
        }
        PersistentMap<FirBasedSymbol<?>, Integer> persistentMap = this.indexesPerSymbol;
        PersistentSetMultimap<Name, ImplicitReceiverValue<?>> persistentSetMultimap = this.receiversPerLabel;
        PersistentList persistentList = ExtensionsKt.toPersistentList((List)destination$iv$iv);
        return new ImplicitReceiverStack(persistentList, persistentSetMultimap, persistentMap);
    }
}

