/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirInaccessibleReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReceiverAccessBeforeSuperCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirInaccessibleReceiverExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirInaccessibleReceiverChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirReceiverAccessBeforeSuperCallChecker
extends FirExpressionChecker<FirInaccessibleReceiverExpression> {
    @NotNull
    public static final FirReceiverAccessBeforeSuperCallChecker INSTANCE = new FirReceiverAccessBeforeSuperCallChecker();

    private FirReceiverAccessBeforeSuperCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirInaccessibleReceiverExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirQualifiedAccessExpression containingCall;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Object object = CollectionsKt.last(context2.getCallsOrAssignments());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression");
        FirQualifiedAccessExpression $this$check_u24lambda_u240 = containingCall = (FirQualifiedAccessExpression)object;
        boolean bl = false;
        if (!(Intrinsics.areEqual((Object)expression2, (Object)$this$check_u24lambda_u240.getDispatchReceiver()) || Intrinsics.areEqual((Object)expression2, (Object)$this$check_u24lambda_u240.getExtensionReceiver()) || $this$check_u24lambda_u240.getContextReceiverArguments().contains(expression2))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingCall.getCalleeReference().getSource(), FirErrors.INSTANCE.getINSTANCE_ACCESS_BEFORE_SUPER_CALL(), (Object)"<this>", (DiagnosticContext)context2, null, 16, null);
    }
}

